/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.BooleanClassDescription;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BooleanClassDescriptionImpl
extends OntClassImpl
implements BooleanClassDescription {
    public BooleanClassDescriptionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    public void setOperands(RDFList operands) {
        this.setPropertyValue(this.operator(), this.getOperatorName(), operands);
    }

    public void addOperand(Resource cls) {
        this.addListPropertyValue(this.operator(), this.getOperatorName(), cls);
    }

    public void addOperands(Iterator classes) {
        while (classes.hasNext()) {
            this.addOperand((Resource)classes.next());
        }
    }

    public RDFList getOperands() {
        return (RDFList)this.objectAs(this.operator(), this.getOperatorName(), RDFList.class);
    }

    public ExtendedIterator listOperands() {
        return this.getOperands().iterator().mapWith(new OntResourceImpl.AsMapper(OntClass.class));
    }

    public boolean hasOperand(Resource cls) {
        return this.getOperands().contains(cls);
    }

    public void removeOperand(Resource res) {
        this.setOperands(this.getOperands().remove(res));
    }

    public abstract Property operator();

    protected abstract String getOperatorName();
}

