/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BadArgumentException;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class XmlDoctype
extends StandardObject {
    public String name;
    public KeyValueList entityTable;
    public KeyValueList parameterEntityTable;

    public static XmlDoctype newXmlDoctype() {
        XmlDoctype self = null;
        self = new XmlDoctype();
        self.parameterEntityTable = KeyValueList.newKeyValueList();
        self.entityTable = KeyValueList.newKeyValueList();
        self.name = null;
        return self;
    }

    public static String normalizeAttributeValue(XmlDoctype doctype, String input, boolean peReferenceAllowedP) {
        return XmlDoctype.decodeXmlString(doctype, input, peReferenceAllowedP);
    }

    public static String decodeXmlString(XmlDoctype doctype, String input, boolean peReferenceAllowedP) {
        int inputEnd = peReferenceAllowedP ? input.length() - 1 : Integer.MIN_VALUE;
        int referenceStart = peReferenceAllowedP ? Stella.findReferenceStart(input, 0, inputEnd) : Native.string_position(input, '&', 0);
        String substitution = null;
        if (referenceStart == Integer.MIN_VALUE) {
            return input;
        }
        OutputStringStream buffer = OutputStringStream.newOutputStringStream();
        int referenceEnd = 0;
        if (!peReferenceAllowedP) {
            inputEnd = input.length() - 1;
        }
        while (referenceStart != Integer.MIN_VALUE) {
            buffer.nativeStream.print(Native.string_subsequence(input, referenceEnd, referenceStart));
            referenceEnd = Native.string_position(input, ';', referenceStart);
            if (referenceEnd == Integer.MIN_VALUE) {
                System.err.print("Safety violation: Unterminated XML reference");
            }
            if ((substitution = XmlDoctype.decodeXmlReference(doctype, Native.string_subsequence(input, referenceStart, ++referenceEnd), peReferenceAllowedP)) == null) {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("Unrecognized entity reference: `" + Native.string_subsequence(input, referenceStart, referenceEnd) + "'");
                throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream000.theStringReader()).fillInStackTrace();
            }
            buffer.nativeStream.print(substitution);
            referenceStart = peReferenceAllowedP ? Stella.findReferenceStart(input, referenceEnd, inputEnd) : Native.string_position(input, '&', referenceEnd);
        }
        if (referenceEnd != inputEnd) {
            buffer.nativeStream.print(Native.string_subsequence(input, referenceEnd, Integer.MIN_VALUE));
        }
        return buffer.theStringReader();
    }

    public static String decodeXmlReference(XmlDoctype doctype, String reference, boolean peReferenceAllowedP) {
        if (reference.charAt(0) == '&') {
            if (reference.charAt(1) == '#') {
                return Stella.decodeXmlCharRef(reference);
            }
            return XmlDoctype.decodeXmlEntityRef(doctype, Native.string_subsequence(reference, 1, reference.length() - 1), peReferenceAllowedP);
        }
        return XmlDoctype.decodeXmlParameterEntityRef(doctype, Native.string_subsequence(reference, 1, reference.length() - 1), peReferenceAllowedP);
    }

    public static String decodeXmlParameterEntityRef(XmlDoctype doctype, String name, boolean peReferenceAllowedP) {
        if (!peReferenceAllowedP) {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("Illegal XML Parameter Entity Reference: `" + name + "'");
            throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream000.theStringReader()).fillInStackTrace();
        }
        if (doctype == null) {
            OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
            stream001.nativeStream.print("Parameter Entity References need a Doctype object: `" + name + "'");
            throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream001.theStringReader()).fillInStackTrace();
        }
        String value = ((StringWrapper)doctype.entityTable.lookup((Stella_Object)StringWrapper.wrapString((String)name))).wrapperValue;
        if (value != null) {
            return XmlDoctype.decodeXmlString(doctype, value, peReferenceAllowedP);
        }
        OutputStringStream stream002 = OutputStringStream.newOutputStringStream();
        stream002.nativeStream.print("No Parameter Entity found to match `" + name + "'");
        throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream002.theStringReader()).fillInStackTrace();
    }

    public static String decodeXmlEntityRef(XmlDoctype doctype, String name, boolean peReferenceAllowedP) {
        String value = null;
        if (doctype != null) {
            value = ((StringWrapper)doctype.entityTable.lookup((Stella_Object)StringWrapper.wrapString((String)name))).wrapperValue;
        }
        if (value == null) {
            value = ((StringWrapper)Stella.$XML_BASE_ENTITY_TABLE$.lookup((Stella_Object)StringWrapper.wrapString((String)name))).wrapperValue;
        }
        if (value == null) {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("Couldn't find entity reference for `" + name + "'");
            throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream000.theStringReader()).fillInStackTrace();
        }
        return XmlDoctype.decodeXmlString(doctype, value, peReferenceAllowedP);
    }

    public void printObject(PrintStream stream) {
        XmlDoctype self = this;
        stream.print("<!DOCTYPE " + self.name + ">");
    }

    public static Stella_Object accessXmlDoctypeSlotValue(XmlDoctype self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_NAME) {
            if (setvalueP) {
                self.name = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.name);
            }
        } else if (slotname == Stella.SYM_STELLA_ENTITY_TABLE) {
            if (setvalueP) {
                self.entityTable = (KeyValueList)value;
            } else {
                value = self.entityTable;
            }
        } else if (slotname == Stella.SYM_STELLA_PARAMETER_ENTITY_TABLE) {
            if (setvalueP) {
                self.parameterEntityTable = (KeyValueList)value;
            } else {
                value = self.parameterEntityTable;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        XmlDoctype self = this;
        return Stella.SGT_STELLA_XML_DOCTYPE;
    }
}

