/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.Dictionary;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.TokenizerTable;
import edu.isi.stella.TokenizerToken;

public class TokenizerStreamState
extends StandardObject {
    public byte[] buffer;
    public int bufferSize;
    public int cursor;
    public int end;
    public int state;
    public TokenizerTable table;
    public Dictionary stateDictionary;
    public TokenizerToken tokenList;

    public static TokenizerStreamState newTokenizerStreamState() {
        TokenizerStreamState self = null;
        self = new TokenizerStreamState();
        self.tokenList = null;
        self.stateDictionary = null;
        self.table = null;
        self.state = 1;
        self.end = Stella.$TOKENIZER_INITIAL_BUFFER_SIZE$;
        self.cursor = Stella.$TOKENIZER_INITIAL_BUFFER_SIZE$;
        self.bufferSize = Stella.$TOKENIZER_INITIAL_BUFFER_SIZE$;
        self.buffer = new byte[Stella.$TOKENIZER_INITIAL_BUFFER_SIZE$];
        return self;
    }

    public int getSavedState(TokenizerTable table) {
        TokenizerStreamState stateObject = this;
        if (stateObject.table == null) {
            stateObject.table = table;
            return stateObject.state;
        }
        if (stateObject.table == table) {
            return stateObject.state;
        }
        if (stateObject.stateDictionary == null) {
            stateObject.stateDictionary = KeyValueList.newKeyValueList();
        }
        stateObject.stateDictionary.insertAt(stateObject.table, IntegerWrapper.wrapInteger(stateObject.state));
        IntegerWrapper savedState = (IntegerWrapper)stateObject.stateDictionary.lookup(table);
        if (savedState != null) {
            return savedState.wrapperValue;
        }
        return 1;
    }

    public static Stella_Object accessTokenizerStreamStateSlotValue(TokenizerStreamState self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_BUFFER_SIZE) {
            if (setvalueP) {
                self.bufferSize = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.bufferSize);
            }
        } else if (slotname == Stella.SYM_STELLA_CURSOR) {
            if (setvalueP) {
                self.cursor = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.cursor);
            }
        } else if (slotname == Stella.SYM_STELLA_END) {
            if (setvalueP) {
                self.end = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.end);
            }
        } else if (slotname == Stella.SYM_STELLA_STATE) {
            if (setvalueP) {
                self.state = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.state);
            }
        } else if (slotname == Stella.SYM_STELLA_TABLE) {
            if (setvalueP) {
                self.table = (TokenizerTable)value;
            } else {
                value = self.table;
            }
        } else if (slotname == Stella.SYM_STELLA_STATE_DICTIONARY) {
            if (setvalueP) {
                self.stateDictionary = (Dictionary)value;
            } else {
                value = self.stateDictionary;
            }
        } else if (slotname == Stella.SYM_STELLA_TOKEN_LIST) {
            if (setvalueP) {
                self.tokenList = (TokenizerToken)value;
            } else {
                value = self.tokenList;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        TokenizerStreamState self = this;
        return Stella.SGT_STELLA_TOKENIZER_STREAM_STATE;
    }

    public static void ensureTokenizerBufferSize(TokenizerStreamState state, int currenttokenstart, int requiredspace) {
        byte[] buffer;
        int size;
        int newsize = size = state.bufferSize;
        int end = state.end % size;
        int freespace = currenttokenstart == -1 ? size : (end <= currenttokenstart ? currenttokenstart - end : currenttokenstart + (size - end));
        byte[] newbuffer = buffer = state.buffer;
        while (freespace < requiredspace) {
            freespace += newsize;
            newsize *= 2;
        }
        if (newsize > size) {
            newbuffer = new byte[newsize];
            if (currenttokenstart < 0) {
                state.cursor = 0;
                state.end = newsize;
            } else if (end > currenttokenstart) {
                int i = Integer.MIN_VALUE;
                int iter000 = currenttokenstart;
                int upperBound000 = end - 1;
                while (iter000 <= upperBound000) {
                    i = iter000++;
                    newbuffer[i] = (byte)(0xFF & buffer[i]);
                }
            } else {
                int i = Integer.MIN_VALUE;
                int iter001 = currenttokenstart;
                int upperBound001 = size - 1;
                while (iter001 <= upperBound001) {
                    i = iter001++;
                    newbuffer[i] = (byte)(0xFF & buffer[i]);
                }
                i = Integer.MIN_VALUE;
                int iter002 = 0;
                int upperBound002 = end - 1;
                int j = Integer.MIN_VALUE;
                int iter003 = size;
                while (iter002 <= upperBound002) {
                    i = iter002++;
                    j = iter003++;
                    newbuffer[j] = (byte)(0xFF & buffer[i]);
                }
                state.cursor = state.end = size + end;
            }
            state.buffer = newbuffer;
            state.bufferSize = newsize;
        }
    }
}

