/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.CharacterWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Keyword;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.ReadException;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.TokenizerToken;
import edu.isi.stella.javalib.Native;

public class StellaToken
extends TokenizerToken {
    public Keyword logicalTokenType;
    public String module;
    public Keyword escapeMode;

    public static StellaToken newStellaToken() {
        StellaToken self = null;
        self = new StellaToken();
        self.content = null;
        self.type = null;
        self.next = null;
        self.escapeMode = null;
        self.module = null;
        self.logicalTokenType = null;
        return self;
    }

    public static void expandQuoteMacroToken(StellaToken quotedlist) {
        String quotestring = quotedlist.content;
        StellaToken self000 = StellaToken.newStellaToken();
        self000.type = Stella.KWD_SYMBOL;
        self000.logicalTokenType = Stella.KWD_SYMBOL;
        self000.content = Stella.stringEqlP(quotestring, "'") ? "QUOTE" : "BQUOTE";
        self000.module = "/STELLA";
        self000.next = (StellaToken)quotedlist.next;
        StellaToken token = self000;
        Keyword tokentype = null;
        int balance = 0;
        quotedlist.type = Stella.KWD_OPEN_PAREN;
        quotedlist.logicalTokenType = Stella.KWD_OPEN_PAREN;
        quotedlist.content = "(";
        quotedlist.next = token;
        quotedlist = (StellaToken)token.next;
        while ((tokentype = quotedlist.logicalTokenType) != null) {
            if (tokentype == Stella.KWD_OPEN_PAREN) {
                ++balance;
            } else if (tokentype == Stella.KWD_CLOSE_PAREN) {
                if (--balance == 0) break;
                if (balance < 0) {
                    OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                    stream000.nativeStream.print("Illegal `" + quotestring + "' syntax");
                    throw (ReadException)ReadException.newReadException(stream000.theStringReader()).fillInStackTrace();
                }
            } else if (balance == 0) break;
            quotedlist = (StellaToken)quotedlist.next;
        }
        if (tokentype == null) {
            OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
            stream001.nativeStream.print("EOF encountered while parsing `" + quotestring + "' syntax");
            throw (ReadException)ReadException.newReadException(stream001.theStringReader()).fillInStackTrace();
        }
        StellaToken self005 = StellaToken.newStellaToken();
        self005.type = Stella.KWD_CLOSE_PAREN;
        self005.logicalTokenType = Stella.KWD_CLOSE_PAREN;
        self005.content = ")";
        self005.next = (StellaToken)quotedlist.next;
        token = self005;
        quotedlist.next = token;
    }

    public static Stella_Object stellaTokenListToSExpression(StellaToken tokenlist) {
        Cons parsedtree = null;
        Cons parsedtreestack = Stella.NIL;
        Stella_Object parsedtoken = null;
        Cons conscell = null;
        Keyword tokentype = null;
        while (true) {
            if ((tokentype = tokenlist.logicalTokenType) == Stella.KWD_OPEN_PAREN) {
                if (parsedtree != null) {
                    parsedtreestack = Stella_Object.cons(parsedtree, parsedtreestack);
                }
                parsedtree = Stella.NIL;
                tokenlist = (StellaToken)tokenlist.next;
                continue;
            }
            if (tokentype == Stella.KWD_CLOSE_PAREN) {
                if (parsedtreestack == Stella.NIL) {
                    parsedtree = parsedtree.reverse();
                    break;
                }
                Cons parenttree = parsedtreestack;
                Cons head000 = (Cons)parsedtreestack.value;
                parsedtreestack = parsedtreestack.rest;
                parenttree.rest = (Cons)parenttree.value;
                parenttree.firstSetter(parsedtree.reverse());
                parsedtree = parenttree;
                tokenlist = (StellaToken)tokenlist.next;
                continue;
            }
            if (tokentype == Stella.KWD_SYMBOL || tokentype == Stella.KWD_SURROGATE) {
                Module module;
                String modulename = tokenlist.module;
                String name = tokenlist.content;
                Module module2 = module = modulename != null ? Stella.getStellaModule(modulename, false) : (Module)Stella.$MODULE$.get();
                if (module == null) {
                    OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                    stream000.nativeStream.print("Module `" + modulename + "' does not exist; current token=`" + name + "'");
                    throw (ReadException)ReadException.newReadException(stream000.theStringReader()).fillInStackTrace();
                }
                parsedtoken = tokentype == Stella.KWD_SURROGATE ? Stella.internSurrogateInModule(name, module, false) : ((Boolean)Stella.$TRANSIENTOBJECTSp$.get() != false && modulename == null ? Stella.internTransientSymbol(name) : Stella.internSymbolInModule(name, module, false));
            } else if (tokentype == Stella.KWD_KEYWORD) {
                parsedtoken = Stella.internRigidSymbolWrtModule(tokenlist.content, null, 2);
            } else if (tokentype == Stella.KWD_STRING) {
                parsedtoken = new StringWrapper();
                ((StringWrapper)parsedtoken).wrapperValue = tokenlist.content;
            } else if (tokentype == Stella.KWD_INTEGER) {
                parsedtoken = new IntegerWrapper();
                ((IntegerWrapper)parsedtoken).wrapperValue = Native.stringToInteger(tokenlist.content);
            } else if (tokentype == Stella.KWD_FLOAT) {
                parsedtoken = new FloatWrapper();
                ((FloatWrapper)parsedtoken).wrapperValue = Native.stringToFloat(tokenlist.content);
            } else if (tokentype == Stella.KWD_CHARACTER) {
                parsedtoken = new CharacterWrapper();
                ((CharacterWrapper)parsedtoken).wrapperValue = Stella.stringToCharacter(tokenlist.content);
            } else if (tokentype == Stella.KWD_COMMA) {
                parsedtoken = Stella.SYM_STELLA_a;
            } else if (tokentype == Stella.KWD_COMMA_SPLICE) {
                parsedtoken = Stella.SYM_STELLA_aa;
            } else {
                if (tokentype == Stella.KWD_SINGLE_QUOTE || tokentype == Stella.KWD_BACK_QUOTE) {
                    StellaToken.expandQuoteMacroToken(tokenlist);
                    continue;
                }
                OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
                stream001.nativeStream.print("Illegal read syntax: `" + tokenlist.content + "' of type `" + tokentype + "'");
                throw (ReadException)ReadException.newReadException(stream001.theStringReader()).fillInStackTrace();
            }
            if (parsedtree == null) break;
            conscell = new Cons();
            conscell.value = parsedtoken;
            conscell.rest = parsedtree;
            parsedtree = conscell;
            tokenlist = (StellaToken)tokenlist.next;
        }
        if (parsedtree == null) {
            return parsedtoken;
        }
        return parsedtree;
    }

    public static Stella_Object accessStellaTokenSlotValue(StellaToken self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_LOGICAL_TOKEN_TYPE) {
            if (setvalueP) {
                self.logicalTokenType = (Keyword)value;
            } else {
                value = self.logicalTokenType;
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE) {
            if (setvalueP) {
                self.module = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.module);
            }
        } else if (slotname == Stella.SYM_STELLA_ESCAPE_MODE) {
            if (setvalueP) {
                self.escapeMode = (Keyword)value;
            } else {
                value = self.escapeMode;
            }
        } else if (slotname == Stella.SYM_STELLA_NEXT) {
            if (setvalueP) {
                self.next = (StellaToken)value;
            } else {
                value = (StellaToken)self.next;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        StellaToken self = this;
        return Stella.SGT_STELLA_STELLA_TOKEN;
    }
}

