/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.DictionaryIterator;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.KvCons;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;

public class StellaHashTableIterator
extends DictionaryIterator {
    public int size;
    public KvCons[] bucketTable;
    public int bucketIndex;
    public KvCons bucketCursor;

    public static StellaHashTableIterator newStellaHashTableIterator() {
        StellaHashTableIterator self = null;
        self = new StellaHashTableIterator();
        self.firstIterationP = true;
        self.value = null;
        self.key = null;
        self.bucketCursor = null;
        self.bucketIndex = 0;
        self.size = Integer.MIN_VALUE;
        return self;
    }

    public Stella_Object keySetter(Stella_Object key) {
        StellaHashTableIterator self = this;
        throw (StellaException)StellaException.newStellaException("Cannot change the key of a STELLA-HASH-TABLE item").fillInStackTrace();
    }

    public Stella_Object valueSetter(Stella_Object value) {
        StellaHashTableIterator self = this;
        KvCons cursor = self.bucketCursor;
        if (cursor != null) {
            cursor.value = value;
        }
        self.value = value;
        return value;
    }

    public boolean nextP() {
        StellaHashTableIterator self = this;
        KvCons cursor = self.bucketCursor;
        if (self.firstIterationP) {
            self.firstIterationP = false;
        } else if (cursor != null) {
            cursor = cursor.rest;
        }
        if (cursor == null) {
            int index;
            KvCons[] table = self.bucketTable;
            int size = self.size;
            if (table == null) {
                return false;
            }
            for (index = self.bucketIndex; cursor == null && index < size; ++index) {
                cursor = table[index];
            }
            self.bucketIndex = index;
            self.bucketCursor = cursor;
        }
        if (cursor != null) {
            self.key = cursor.key;
            self.value = cursor.value;
            self.bucketCursor = cursor;
            return true;
        }
        return false;
    }

    public static Stella_Object accessStellaHashTableIteratorSlotValue(StellaHashTableIterator self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_SIZE) {
            if (setvalueP) {
                self.size = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.size);
            }
        } else if (slotname == Stella.SYM_STELLA_BUCKET_INDEX) {
            if (setvalueP) {
                self.bucketIndex = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.bucketIndex);
            }
        } else if (slotname == Stella.SYM_STELLA_BUCKET_CURSOR) {
            if (setvalueP) {
                self.bucketCursor = (KvCons)value;
            } else {
                value = self.bucketCursor;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        StellaHashTableIterator self = this;
        return Stella.SGT_STELLA_STELLA_HASH_TABLE_ITERATOR;
    }
}

