/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.AbstractHashTable;
import edu.isi.stella.AbstractIterator;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.KvCons;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.StellaHashTableIterator;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;

public class StellaHashTable
extends AbstractHashTable {
    public KvCons[] theTable;
    public int size;
    public int initialSize;
    public int freeElements;
    public boolean equalTestP;

    public static StellaHashTable newStellaHashTable() {
        StellaHashTable self = null;
        self = new StellaHashTable();
        self.theStellaHashTable = null;
        self.theHashTable = null;
        self.equalTestP = false;
        self.freeElements = Integer.MIN_VALUE;
        self.initialSize = 50;
        self.size = Integer.MIN_VALUE;
        self.initializeHashTable();
        return self;
    }

    public AbstractIterator allocateIterator() {
        StellaHashTable self = this;
        StellaHashTableIterator self000 = StellaHashTableIterator.newStellaHashTableIterator();
        self000.size = self.size;
        self000.bucketTable = self.theTable;
        self000.bucketIndex = 0;
        self000.bucketCursor = null;
        StellaHashTableIterator value000 = self000;
        return value000;
    }

    public int equalHashCode() {
        StellaHashTable self = this;
        int code = 36273463;
        Stella_Object key = null;
        Stella_Object value = null;
        StellaHashTableIterator iter000 = (StellaHashTableIterator)self.allocateIterator();
        while (iter000.nextP()) {
            key = iter000.key;
            value = iter000.value;
            code ^= key.equalHashCode();
            code ^= value.equalHashCode();
        }
        return code;
    }

    public boolean objectEqualP(Stella_Object y) {
        StellaHashTable x = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(y), Stella.SGT_STELLA_STELLA_HASH_TABLE)) {
            StellaHashTable y000 = (StellaHashTable)y;
            if (x.length() == y000.length()) {
                Stella_Object key = null;
                Stella_Object value = null;
                StellaHashTableIterator iter000 = (StellaHashTableIterator)x.allocateIterator();
                while (iter000.nextP()) {
                    value = iter000.value;
                    key = iter000.key;
                    if (Stella_Object.equalP(value, y000.lookup(key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Cons consify() {
        StellaHashTable self = this;
        Cons result = Stella.NIL;
        Stella_Object key = null;
        Stella_Object value = null;
        StellaHashTableIterator iter000 = (StellaHashTableIterator)self.allocateIterator();
        Cons collect000 = null;
        while (iter000.nextP()) {
            key = iter000.key;
            value = iter000.value;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(Stella_Object.cons(key, Stella_Object.cons(value, Stella.NIL)), Stella.NIL);
                if (result == Stella.NIL) {
                    result = collect000;
                    continue;
                }
                Cons.addConsToEndOfConsList(result, collect000);
                continue;
            }
            collect000 = collect000.rest = Stella_Object.cons(Stella_Object.cons(key, Stella_Object.cons(value, Stella.NIL)), Stella.NIL);
        }
        return result;
    }

    public void clear() {
        StellaHashTable self = this;
        self.theTable = null;
        self.size = Integer.MIN_VALUE;
        self.freeElements = Integer.MIN_VALUE;
    }

    public StellaHashTable copy() {
        KvCons[] table;
        StellaHashTable self = this;
        int size = self.size;
        StellaHashTable self000 = StellaHashTable.newStellaHashTable();
        self000.size = size;
        self000.initialSize = self.initialSize;
        self000.freeElements = self.freeElements;
        self000.equalTestP = self.equalTestP;
        StellaHashTable copy = self000;
        KvCons[] tablecopy = table = self.theTable;
        KvCons bucket = null;
        if (table != null) {
            copy.theTable = tablecopy = new KvCons[size];
            int i = Integer.MIN_VALUE;
            int upperBound000 = size - 1;
            for (int iter000 = 0; iter000 <= upperBound000; ++iter000) {
                i = iter000;
                bucket = table[i];
                tablecopy[i] = bucket != null ? KvCons.copyKvConsList(bucket) : null;
            }
        }
        return copy;
    }

    public boolean nonEmptyP() {
        StellaHashTable self = this;
        return self.length() > 0;
    }

    public boolean emptyP() {
        StellaHashTable self = this;
        return self.length() == 0;
    }

    public int length() {
        StellaHashTable self = this;
        if (self.theTable == null) {
            return 0;
        }
        return self.size - self.freeElements;
    }

    public void removeAt(Stella_Object key) {
        StellaHashTable self = this;
        StellaHashTable.stellaHashTableRemoveAt(self, key);
    }

    public void insertAt(Stella_Object key, Stella_Object value) {
        StellaHashTable self = this;
        StellaHashTable.stellaHashTableInsertAt(self, key, value);
    }

    public Stella_Object lookup(Stella_Object key) {
        StellaHashTable self = this;
        return StellaHashTable.stellaHashTableLookup(self, key);
    }

    public static Stella_Object stellaStringHashTableLookup(StellaHashTable self, String key) {
        KvCons[] table = self.theTable;
        KvCons bucket = null;
        if (table == null) {
            return null;
        }
        bucket = table[(key.hashCode() & Integer.MAX_VALUE) % self.size];
        while (bucket != null) {
            if (Stella.stringEqlP(((StringWrapper)bucket.key).wrapperValue, key)) {
                return bucket.value;
            }
            bucket = bucket.rest;
        }
        return null;
    }

    public static Stella_Object stellaHashTableLookup(StellaHashTable self, Stella_Object key) {
        KvCons[] table = self.theTable;
        KvCons bucket = null;
        if (table == null) {
            return null;
        }
        if (self.equalTestP) {
            bucket = table[(key.equalHashCode() & Integer.MAX_VALUE) % self.size];
            while (bucket != null) {
                if (Stella_Object.equalP(bucket.key, key)) {
                    return bucket.value;
                }
                bucket = bucket.rest;
            }
        } else {
            bucket = table[(key.hashCode_() & Integer.MAX_VALUE) % self.size];
            while (bucket != null) {
                if (Stella_Object.eqlP(bucket.key, key)) {
                    return bucket.value;
                }
                bucket = bucket.rest;
            }
        }
        return null;
    }

    public static void stellaHashTableRemoveAt(StellaHashTable self, Stella_Object key) {
        KvCons[] table = self.theTable;
        int bucketindex = 0;
        KvCons bucket = null;
        boolean equaltestP = self.equalTestP;
        if (table == null) {
            return;
        }
        bucketindex = equaltestP ? (key.equalHashCode() & Integer.MAX_VALUE) % self.size : (key.hashCode_() & Integer.MAX_VALUE) % self.size;
        bucket = table[bucketindex];
        if (bucket == null) {
            return;
        }
        if (!equaltestP && Stella_Object.eqlP(bucket.key, key)) {
            table[bucketindex] = bucket.rest;
            ++self.freeElements;
            return;
        }
        if (equaltestP && Stella_Object.equalP(bucket.key, key)) {
            table[bucketindex] = bucket.rest;
            ++self.freeElements;
            return;
        }
        KvCons trailer = bucket;
        bucket = bucket.rest;
        while (bucket != null) {
            if (!equaltestP && Stella_Object.eqlP(bucket.key, key)) {
                trailer.rest = bucket.rest;
                ++self.freeElements;
                return;
            }
            if (equaltestP && Stella_Object.equalP(bucket.key, key)) {
                trailer.rest = bucket.rest;
                ++self.freeElements;
                return;
            }
            trailer = bucket;
            bucket = bucket.rest;
        }
    }

    public static void stellaHashTableInsertAt(StellaHashTable self, Stella_Object key, Stella_Object value) {
        KvCons[] table = self.theTable;
        int free = self.freeElements;
        int bucketindex = 0;
        KvCons bucket = null;
        boolean equaltestP = self.equalTestP;
        if (table == null) {
            StellaHashTable.initializeStellaHashTable(self);
            table = self.theTable;
            free = self.freeElements;
        }
        if (free == 0) {
            StellaHashTable.rehashStellaHashTable(self, Stella.pickHashTableSizePrime(self.size + 1));
            table = self.theTable;
            free = self.freeElements;
        }
        if ((bucket = table[bucketindex = equaltestP ? (key.equalHashCode() & Integer.MAX_VALUE) % self.size : (key.hashCode_() & Integer.MAX_VALUE) % self.size]) == null) {
            KvCons self000 = KvCons.newKvCons();
            self000.key = key;
            self000.value = value;
            table[bucketindex] = self000;
            self.freeElements = free - 1;
        } else {
            KvCons cursor = bucket;
            if (equaltestP) {
                while (cursor != null && !Stella_Object.equalP(cursor.key, key)) {
                    cursor = cursor.rest;
                }
            } else {
                while (cursor != null && !Stella_Object.eqlP(cursor.key, key)) {
                    cursor = cursor.rest;
                }
            }
            if (cursor != null) {
                cursor.value = value;
            } else {
                KvCons self001 = KvCons.newKvCons();
                self001.key = key;
                self001.value = value;
                self001.rest = bucket.rest;
                bucket.rest = self001;
                self.freeElements = free - 1;
            }
        }
    }

    public static void rehashStellaHashTable(StellaHashTable self, int newsize) {
        if (self.theTable == null) {
            StellaHashTable.initializeStellaHashTable(self);
            return;
        }
        int size = self.size;
        KvCons[] table = self.theTable;
        KvCons[] newtable = new KvCons[newsize];
        int newbucketindex = 0;
        KvCons newbucket = null;
        KvCons cursor = null;
        KvCons current = null;
        boolean equaltestP = self.equalTestP;
        int i = Integer.MIN_VALUE;
        int iter000 = 0;
        int upperBound000 = newsize - 1;
        while (iter000 <= upperBound000) {
            i = iter000++;
            newtable[i] = null;
        }
        i = Integer.MIN_VALUE;
        int upperBound001 = size - 1;
        for (int iter001 = 0; iter001 <= upperBound001; ++iter001) {
            i = iter001;
            cursor = table[i];
            while (cursor != null) {
                newbucketindex = equaltestP ? (cursor.key.equalHashCode() & Integer.MAX_VALUE) % newsize : (cursor.key.hashCode_() & Integer.MAX_VALUE) % newsize;
                newbucket = newtable[newbucketindex];
                current = cursor;
                cursor = cursor.rest;
                if (newbucket != null) {
                    current.rest = newbucket.rest;
                    newbucket.rest = current;
                    continue;
                }
                newtable[newbucketindex] = current;
                current.rest = null;
            }
        }
        self.theTable = newtable;
        self.size = newsize;
        self.freeElements = Stella.max(self.freeElements + Native.floor((double)(newsize - size) * Stella.$STELLA_HASH_TABLE_AVG_BUCKET_LENGTH$), 0);
    }

    public void initializeHashTable() {
        StellaHashTable stellaHashTable = this;
    }

    public static void initializeStellaHashTable(StellaHashTable self) {
        int size = Stella.pickHashTableSizePrime(Native.floor((double)self.initialSize / Stella.$STELLA_HASH_TABLE_AVG_BUCKET_LENGTH$));
        KvCons[] table = new KvCons[size];
        int i = Integer.MIN_VALUE;
        int iter000 = 0;
        int upperBound000 = size - 1;
        while (iter000 <= upperBound000) {
            i = iter000++;
            table[i] = null;
        }
        self.theTable = table;
        self.size = size;
        self.freeElements = Native.floor((double)size * Stella.$STELLA_HASH_TABLE_AVG_BUCKET_LENGTH$);
    }

    public static Stella_Object accessStellaHashTableSlotValue(StellaHashTable self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_SIZE) {
            if (setvalueP) {
                self.size = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.size);
            }
        } else if (slotname == Stella.SYM_STELLA_INITIAL_SIZE) {
            if (setvalueP) {
                self.initialSize = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.initialSize);
            }
        } else if (slotname == Stella.SYM_STELLA_FREE_ELEMENTS) {
            if (setvalueP) {
                self.freeElements = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.freeElements);
            }
        } else if (slotname == Stella.SYM_STELLA_EQUAL_TESTp) {
            if (setvalueP) {
                self.equalTestP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.equalTestP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        StellaHashTable self = this;
        return Stella.SGT_STELLA_STELLA_HASH_TABLE;
    }
}

