/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.Cons;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.List;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Sequence;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Class;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StorageSlot;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class RecycleList
extends Sequence {
    public Surrogate recycleListOf;
    public Stella_Object recycledItems;
    public List listOfRecycledItems;
    public Stella_Object allItems;
    public Stella_Object unusedItems;
    public int currentLength;
    public int itemSize;

    public static RecycleList newRecycleList() {
        RecycleList self = null;
        self = new RecycleList();
        self.itemSize = Integer.MIN_VALUE;
        self.currentLength = 0;
        self.unusedItems = null;
        self.allItems = null;
        self.listOfRecycledItems = Stella.makeNonRecycledList();
        self.recycledItems = null;
        self.recycleListOf = null;
        return self;
    }

    public static void reduceRecycleListSize(RecycleList list, double fraction) {
        int i;
        int length = list.currentLength;
        int reducedlength = Native.floor((double)length * fraction);
        Surrogate itemtype = list.recycleListOf;
        Stella_Object cursor = null;
        Stella_Object trailingcursor = null;
        Stella_Object unused = null;
        StorageSlot nextslot = null;
        if (!(list.allItems == null && list.recycledItems == null || Surrogate.subtypeOfP(itemtype, Stella.SGT_STELLA_STANDARD_OBJECT))) {
            RecycleList.clearRecycleList(list);
            return;
        }
        Native.setBooleanSpecial(Stella.$RECYCLING_ENABLEDp$, false);
        if (list.allItems != null) {
            cursor = list.allItems;
            unused = list.unusedItems;
            nextslot = (StorageSlot)Stella_Class.lookupSlot((Stella_Class)itemtype.surrogateValue, Stella.SYM_STELLA_NEXT_SWEEP_LIST_OBJECT);
            i = Integer.MIN_VALUE;
            int upperBound000 = length - reducedlength;
            for (int iter000 = 1; iter000 <= upperBound000; ++iter000) {
                i = iter000;
                if (cursor == unused) {
                    list.unusedItems = list.allItems;
                }
                trailingcursor = cursor;
                cursor = StandardObject.readSlotValue((StandardObject)cursor, nextslot);
                StandardObject.putSlotValue((StandardObject)trailingcursor, nextslot, null);
            }
            if (Stella_Object.eqlP(list.unusedItems, list.allItems)) {
                list.unusedItems = cursor;
            }
            list.allItems = cursor;
        }
        if (list.listOfRecycledItems.nonEmptyP()) {
            cursor = list.listOfRecycledItems.theConsList.nthRest(reducedlength);
            if (cursor != null) {
                ((Cons)cursor).rest = Stella.NIL;
            }
        } else if (list.recycledItems != null) {
            if (list.allItems != null) {
                list.recycledItems = null;
            } else {
                boolean unboundedP000;
                cursor = list.recycledItems;
                nextslot = Stella_Class.recycleSlot((Stella_Class)itemtype.surrogateValue);
                i = Integer.MIN_VALUE;
                int iter001 = 2;
                int upperBound001 = reducedlength;
                boolean bl = unboundedP000 = upperBound001 == Integer.MIN_VALUE;
                while (unboundedP000 || iter001 <= upperBound001) {
                    i = iter001++;
                    if ((cursor = StandardObject.readSlotValue((StandardObject)cursor, nextslot)) == null) break;
                }
                if (cursor != null) {
                    StandardObject.putSlotValue((StandardObject)cursor, nextslot, null);
                }
            }
        }
        list.currentLength = reducedlength;
        Native.setBooleanSpecial(Stella.$RECYCLING_ENABLEDp$, true);
    }

    public static boolean recycleListSizeL(RecycleList list1, RecycleList list2) {
        return list1.itemSize * list1.currentLength < list2.itemSize * list2.currentLength;
    }

    public static int recycleListSize(RecycleList list) {
        return list.itemSize * list.currentLength;
    }

    public boolean deletedPSetter(boolean value) {
        RecycleList self = this;
        if (value) {
            self.recycleListOf = null;
        } else if (self.recycleListOf == null) {
            self.recycleListOf = Stella.SGT_STELLA_UNKNOWN;
        }
        return value;
    }

    public boolean deletedP() {
        RecycleList self = this;
        return self.recycleListOf == null;
    }

    public static void clearRecycleList(RecycleList list) {
        list.allItems = null;
        list.unusedItems = null;
        list.recycledItems = null;
        list.listOfRecycledItems.theConsList = Stella.NIL;
        list.currentLength = 0;
    }

    public void printObject(PrintStream stream) {
        RecycleList self = this;
        if (self.recycleListOf != null) {
            stream.print("|i|[RECYCLE-LIST OF " + self.currentLength + " " + self.recycleListOf + "'s]");
        } else {
            stream.print("|i|@RECYCLE-LIST");
        }
    }

    public static Stella_Object accessRecycleListSlotValue(RecycleList self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_RECYCLE_LIST_OF) {
            if (setvalueP) {
                self.recycleListOf = (Surrogate)value;
            } else {
                value = self.recycleListOf;
            }
        } else if (slotname == Stella.SYM_STELLA_RECYCLED_ITEMS) {
            if (setvalueP) {
                self.recycledItems = value;
            } else {
                value = self.recycledItems;
            }
        } else if (slotname == Stella.SYM_STELLA_LIST_OF_RECYCLED_ITEMS) {
            if (setvalueP) {
                self.listOfRecycledItems = (List)value;
            } else {
                value = self.listOfRecycledItems;
            }
        } else if (slotname == Stella.SYM_STELLA_ALL_ITEMS) {
            if (setvalueP) {
                self.allItems = value;
            } else {
                value = self.allItems;
            }
        } else if (slotname == Stella.SYM_STELLA_UNUSED_ITEMS) {
            if (setvalueP) {
                self.unusedItems = value;
            } else {
                value = self.unusedItems;
            }
        } else if (slotname == Stella.SYM_STELLA_CURRENT_LENGTH) {
            if (setvalueP) {
                self.currentLength = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.currentLength);
            }
        } else if (slotname == Stella.SYM_STELLA_ITEM_SIZE) {
            if (setvalueP) {
                self.itemSize = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.itemSize);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        RecycleList self = this;
        return Stella.SGT_STELLA_RECYCLE_LIST;
    }
}

