/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BadArgumentException;
import edu.isi.stella.InputOutputException;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class OutputFileStream
extends OutputStream {
    public String filename;
    public Keyword ifExistsAction;
    public Keyword ifNotExistsAction;

    public static OutputFileStream newOutputFileStream(String filename) {
        OutputFileStream self = null;
        self = new OutputFileStream();
        self.filename = filename;
        self.state = null;
        self.nativeStream = null;
        self.ifNotExistsAction = Stella.KWD_CREATE;
        self.ifExistsAction = Stella.KWD_SUPERSEDE;
        OutputFileStream.initializeFileOutputStream(self);
        return self;
    }

    public static boolean terminateFileOutputStreamP(OutputFileStream self) {
        PrintStream nativeStream = self.nativeStream;
        if (nativeStream != null) {
            nativeStream.close();
        }
        self.nativeStream = null;
        self.state = Stella.KWD_CLOSED;
        Stella.$OPEN_FILE_STREAMS$.remove(self);
        return true;
    }

    public static void initializeFileOutputStream(OutputFileStream self) {
        Keyword testValue001;
        if (self.filename == null) {
            return;
        }
        String filename = Stella.translateLogicalPathname(self.filename);
        boolean append = false;
        Keyword testValue000 = self.ifNotExistsAction;
        if (testValue000 != Stella.KWD_CREATE) {
            if (testValue000 == Stella.KWD_ABORT || testValue000 == Stella.KWD_PROBE) {
                if (!Native.probeFileP(filename)) {
                    return;
                }
            } else if (testValue000 == Stella.KWD_ERROR) {
                Stella.ensureFileExists(filename, "initialize-file-output-stream");
            } else {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("initialize-file-output-stream: illegal :if-not-exists action: `" + self.ifNotExistsAction + "'");
                throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream000.theStringReader()).fillInStackTrace();
            }
        }
        if ((testValue001 = self.ifExistsAction) != Stella.KWD_SUPERSEDE) {
            if (testValue001 == Stella.KWD_APPEND) {
                append = true;
            } else if (testValue001 == Stella.KWD_ABORT || testValue001 == Stella.KWD_PROBE) {
                if (Native.probeFileP(filename)) {
                    return;
                }
            } else if (testValue001 == Stella.KWD_ERROR) {
                Stella.ensureFileDoesNotExist(filename, "initialize-file-output-stream");
            } else {
                OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
                stream001.nativeStream.print("initialize-file-output-stream: illegal :if-exists action: `" + self.ifExistsAction + "'");
                throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream001.theStringReader()).fillInStackTrace();
            }
        }
        self.nativeStream = new PrintStream(Native.openOutputFileStream(filename, append));
        if (self.nativeStream == null) {
            OutputStringStream stream002 = OutputStringStream.newOutputStringStream();
            stream002.nativeStream.print("initialize-file-output-stream: Could not open `" + self + "'");
            throw (InputOutputException)InputOutputException.newInputOutputException(stream002.theStringReader()).fillInStackTrace();
        }
        self.state = Stella.KWD_OPEN;
        Stella.$OPEN_FILE_STREAMS$.push(self);
    }

    public void printObject(PrintStream stream) {
        OutputFileStream self = this;
        stream.print("|FOS|'" + self.filename + "'");
    }

    public static Stella_Object accessOutputFileStreamSlotValue(OutputFileStream self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_FILENAME) {
            if (setvalueP) {
                self.filename = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.filename);
            }
        } else if (slotname == Stella.SYM_STELLA_IF_EXISTS_ACTION) {
            if (setvalueP) {
                self.ifExistsAction = (Keyword)value;
            } else {
                value = self.ifExistsAction;
            }
        } else if (slotname == Stella.SYM_STELLA_IF_NOT_EXISTS_ACTION) {
            if (setvalueP) {
                self.ifNotExistsAction = (Keyword)value;
            } else {
                value = self.ifNotExistsAction;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        OutputFileStream self = this;
        return Stella.SGT_STELLA_OUTPUT_FILE_STREAM;
    }

    public void free() {
        OutputFileStream self = this;
        if (OutputFileStream.terminateFileOutputStreamP(self)) {
            Stella_Object.unmake(self);
        }
    }
}

