/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BadArgumentException;
import edu.isi.stella.InputOutputException;
import edu.isi.stella.InputStream;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;

public class InputFileStream
extends InputStream {
    public String filename;
    public Keyword ifNotExistsAction;

    public static InputFileStream newInputFileStream(String filename) {
        InputFileStream self = null;
        self = new InputFileStream();
        self.filename = filename;
        self.state = null;
        self.tokenizerState = null;
        self.echoStream = null;
        self.nativeStream = null;
        self.bufferingScheme = Stella.KWD_BLOCK;
        self.ifNotExistsAction = Stella.KWD_ERROR;
        InputFileStream.initializeFileInputStream(self);
        return self;
    }

    public static boolean terminateFileInputStreamP(InputFileStream self) {
        PushbackInputStream nativeStream = self.nativeStream;
        if (nativeStream != null) {
            try {
                nativeStream.close();
            }
            catch (IOException e) {
                throw (InputOutputException)InputOutputException.newInputOutputException("terminateFileInputStreamP: " + e.getMessage()).fillInStackTrace();
            }
        }
        self.nativeStream = null;
        self.state = Stella.KWD_CLOSED;
        Stella.$OPEN_FILE_STREAMS$.remove(self);
        return true;
    }

    public static void initializeFileInputStream(InputFileStream self) {
        if (self.filename == null) {
            return;
        }
        String filename = Stella.translateLogicalPathname(self.filename);
        Keyword testValue000 = self.ifNotExistsAction;
        if (testValue000 == Stella.KWD_ABORT || testValue000 == Stella.KWD_PROBE) {
            if (!Native.probeFileP(filename)) {
                return;
            }
        } else if (testValue000 == Stella.KWD_ERROR) {
            Stella.ensureFileExists(filename, "initialize-file-input-stream");
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("initialize-file-input-stream: illegal :if-not-exists action: `" + self.ifNotExistsAction + "'");
            throw (BadArgumentException)BadArgumentException.newBadArgumentException(stream000.theStringReader()).fillInStackTrace();
        }
        self.nativeStream = new PushbackInputStream(Native.openInputFileStream(filename));
        if (self.nativeStream == null) {
            OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
            stream001.nativeStream.print("initialize-file-input-stream: Could not open `" + self + "'");
            throw (InputOutputException)InputOutputException.newInputOutputException(stream001.theStringReader()).fillInStackTrace();
        }
        self.state = Stella.KWD_OPEN;
        Stella.$OPEN_FILE_STREAMS$.push(self);
    }

    public void printObject(PrintStream stream) {
        InputFileStream self = this;
        stream.print("|FIS|'" + self.filename + "'");
    }

    public static Stella_Object accessInputFileStreamSlotValue(InputFileStream self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_FILENAME) {
            if (setvalueP) {
                self.filename = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.filename);
            }
        } else if (slotname == Stella.SYM_STELLA_IF_NOT_EXISTS_ACTION) {
            if (setvalueP) {
                self.ifNotExistsAction = (Keyword)value;
            } else {
                value = self.ifNotExistsAction;
            }
        } else if (slotname == Stella.SYM_STELLA_BUFFERING_SCHEME) {
            if (setvalueP) {
                self.bufferingScheme = (Keyword)value;
            } else {
                value = self.bufferingScheme;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        InputFileStream self = this;
        return Stella.SGT_STELLA_INPUT_FILE_STREAM;
    }

    public void free() {
        InputFileStream self = this;
        if (InputFileStream.terminateFileInputStreamP(self)) {
            Stella_Object.unmake(self);
        }
    }
}

