/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.ExtensibleVector;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;

public class ExtensibleSymbolArray
extends ExtensibleVector {
    public int topSymbolOffset;
    public int potentialFreeSymbolOffset;

    public static ExtensibleSymbolArray newExtensibleSymbolArray(int arraySize) {
        ExtensibleSymbolArray self = null;
        self = new ExtensibleSymbolArray();
        self.arraySize = arraySize;
        self.theArray = null;
        self.potentialFreeSymbolOffset = 0;
        self.topSymbolOffset = -1;
        self.initializeVector();
        return self;
    }

    public static GeneralizedSymbol getGeneralizedSymbolFromOffset(ExtensibleSymbolArray symbolarray, int offset) {
        return (GeneralizedSymbol)symbolarray.theArray[offset];
    }

    public static boolean legalSymbolArrayOffsetP(ExtensibleSymbolArray array, int offset) {
        return offset <= array.topSymbolOffset;
    }

    public static int addToSymbolArray(ExtensibleSymbolArray array, GeneralizedSymbol symbol) {
        int offset = ExtensibleSymbolArray.nextFreeOffset(array);
        ExtensibleSymbolArray.addToSymbolArrayAt(array, offset, symbol);
        return offset;
    }

    public static void addToSymbolArrayAt(ExtensibleSymbolArray array, int offset, GeneralizedSymbol symbol) {
        array.insertAt(offset, symbol);
        symbol.symbolId = offset;
    }

    public static void freeSymbolOffset(ExtensibleSymbolArray self, int offset) {
        self.theArray[offset] = null;
        if (offset < self.potentialFreeSymbolOffset) {
            self.potentialFreeSymbolOffset = offset;
        }
    }

    public static int nextFreeOffset(ExtensibleSymbolArray self) {
        boolean unboundedP000;
        int topoffset = self.topSymbolOffset;
        int freeoffset = topoffset + 1;
        int i = Integer.MIN_VALUE;
        int iter000 = self.potentialFreeSymbolOffset;
        int upperBound000 = topoffset;
        boolean bl = unboundedP000 = upperBound000 == Integer.MIN_VALUE;
        while (unboundedP000 || iter000 <= upperBound000) {
            if (self.theArray[i = iter000++] != null) continue;
            freeoffset = i;
            break;
        }
        self.potentialFreeSymbolOffset = freeoffset + 1;
        return freeoffset;
    }

    public void insertAt(int offset, Stella_Object value) {
        ExtensibleSymbolArray self = this;
        if (offset >= self.arraySize) {
            int size;
            for (size = self.arraySize; offset >= size; size = 2 * size) {
            }
            Vector.resizeVector(self, size);
        }
        self.theArray[offset] = value;
        if (offset > self.topSymbolOffset) {
            self.topSymbolOffset = offset;
        }
    }

    public static Stella_Object accessExtensibleSymbolArraySlotValue(ExtensibleSymbolArray self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_TOP_SYMBOL_OFFSET) {
            if (setvalueP) {
                self.topSymbolOffset = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.topSymbolOffset);
            }
        } else if (slotname == Stella.SYM_STELLA_POTENTIAL_FREE_SYMBOL_OFFSET) {
            if (setvalueP) {
                self.potentialFreeSymbolOffset = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.potentialFreeSymbolOffset);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        ExtensibleSymbolArray self = this;
        return Stella.SGT_STELLA_EXTENSIBLE_SYMBOL_ARRAY;
    }
}

