/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.CalendarDate;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;

public class DecodedDateTime
extends StandardObject {
    public double dateTimeMillis;
    public int dateTimeSecond;
    public int dateTimeMinute;
    public int dateTimeHour;
    public int dateTimeDay;
    public int dateTimeMonth;
    public int dateTimeYear;
    public double dateTimeZone;
    public Keyword dateTimeDow;

    public static DecodedDateTime stringToDecodedDateTime(String input) {
        return DecodedDateTime.parseDateTimeInTimeZone(input, Double.NEGATIVE_INFINITY, 0, Integer.MIN_VALUE, false);
    }

    public static DecodedDateTime parseDateTime(String dateTimeString, int start, int end, boolean errorOnMismatchP) {
        return DecodedDateTime.parseDateTimeInTimeZone(dateTimeString, Double.NEGATIVE_INFINITY, start, end, errorOnMismatchP);
    }

    public static DecodedDateTime parseDateTimeInTimeZone(String dateTimeString, double timeZone, int start, int end, boolean errorOnMismatchP) {
        DecodedDateTime defaultValues = CalendarDate.makeCurrentDateTime().decodeCalendarDate(timeZone == Double.NEGATIVE_INFINITY ? Stella.getLocalTimeZone() : timeZone);
        defaultValues.dateTimeMillis = 0.0;
        defaultValues.dateTimeSecond = 0;
        defaultValues.dateTimeMinute = 0;
        defaultValues.dateTimeHour = 0;
        defaultValues.dateTimeZone = timeZone;
        return DecodedDateTime.helpParseDateTimeRelativeToBase(dateTimeString, defaultValues, start, end, errorOnMismatchP, true);
    }

    public static DecodedDateTime parseDateTimeRelativeToBase(String dateTimeString, DecodedDateTime baseDateTime, int start, int end, boolean errorOnMismatchP, boolean mergeNullFieldsP) {
        return DecodedDateTime.helpParseDateTimeRelativeToBase(dateTimeString, baseDateTime, start, end, errorOnMismatchP, mergeNullFieldsP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DecodedDateTime helpParseDateTimeRelativeToBase(String dateTimeString, DecodedDateTime baseDateTime, int start, int end, boolean errorOnMismatchP, boolean mergeNullFieldsP) {
        Object old$ErrorOnMismatch$000 = Stella.$ERROR_ON_MISMATCH$.get();
        try {
            Native.setBooleanSpecial(Stella.$ERROR_ON_MISMATCH$, errorOnMismatchP);
            Cons stringForm = Stella.matchDateTimePatterns(dateTimeString, start, end, errorOnMismatchP);
            DecodedDateTime self000 = DecodedDateTime.newDecodedDateTime();
            self000.dateTimeMillis = Double.NEGATIVE_INFINITY;
            self000.dateTimeSecond = Integer.MIN_VALUE;
            self000.dateTimeMinute = Integer.MIN_VALUE;
            self000.dateTimeHour = Integer.MIN_VALUE;
            self000.dateTimeDay = Integer.MIN_VALUE;
            self000.dateTimeMonth = Integer.MIN_VALUE;
            self000.dateTimeYear = Integer.MIN_VALUE;
            self000.dateTimeZone = Double.NEGATIVE_INFINITY;
            self000.dateTimeDow = null;
            DecodedDateTime parsedValues = self000;
            if (stringForm == null) {
                DecodedDateTime decodedDateTime = null;
                return decodedDateTime;
            }
            Cons.setTimeValues(stringForm, parsedValues, baseDateTime);
            if (parsedValues.dateTimeZone == Double.NEGATIVE_INFINITY) {
                parsedValues.dateTimeZone = baseDateTime.dateTimeZone;
                if (parsedValues.dateTimeZone == Double.NEGATIVE_INFINITY) {
                    parsedValues.dateTimeZone = Stella.getLocalTimeZoneForDate(baseDateTime.dateTimeYear, baseDateTime.dateTimeMonth, baseDateTime.dateTimeDay, baseDateTime.dateTimeHour, baseDateTime.dateTimeMinute, baseDateTime.dateTimeSecond);
                }
            }
            if (mergeNullFieldsP) {
                parsedValues.mergeNullFields(baseDateTime);
            }
            DecodedDateTime decodedDateTime = parsedValues;
            return decodedDateTime;
        }
        finally {
            Stella.$ERROR_ON_MISMATCH$.set(old$ErrorOnMismatch$000);
        }
    }

    public static DecodedDateTime newDecodedDateTime() {
        DecodedDateTime self = null;
        self = new DecodedDateTime();
        self.dateTimeDow = Stella.KWD_SUNDAY;
        self.dateTimeZone = 0.0;
        self.dateTimeYear = 1900;
        self.dateTimeMonth = 1;
        self.dateTimeDay = 1;
        self.dateTimeHour = 0;
        self.dateTimeMinute = 0;
        self.dateTimeSecond = 0;
        self.dateTimeMillis = 0.0;
        return self;
    }

    public static void now(DecodedDateTime parsedValues, DecodedDateTime defaultValues) {
        double timeZone = parsedValues.dateTimeZone;
        if (timeZone == Double.NEGATIVE_INFINITY && (timeZone = defaultValues.dateTimeZone) == Double.NEGATIVE_INFINITY) {
            timeZone = Stella.getLocalTimeZone();
        }
        int hour = Integer.MIN_VALUE;
        int minute = Integer.MIN_VALUE;
        int second = Integer.MIN_VALUE;
        int millis = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[3];
        hour = CalendarDate.makeCurrentDateTime().getTime(timeZone, caller_MV_returnarray);
        minute = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        second = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        millis = ((IntegerWrapper)caller_MV_returnarray[2]).wrapperValue;
        parsedValues.dateTimeMillis = millis;
        parsedValues.dateTimeSecond = second;
        parsedValues.dateTimeMinute = minute;
        parsedValues.dateTimeHour = hour;
    }

    public static void tomorrow(DecodedDateTime parsedValues, DecodedDateTime defaultValues) {
        DecodedDateTime.today(parsedValues, defaultValues);
        if (parsedValues.dateTimeYear != Integer.MIN_VALUE && parsedValues.dateTimeMonth != Integer.MIN_VALUE && parsedValues.dateTimeDay != Integer.MIN_VALUE) {
            int jd = Stella.computeJulianDay(parsedValues.dateTimeYear, parsedValues.dateTimeMonth, parsedValues.dateTimeDay);
            int year = Integer.MIN_VALUE;
            int month = Integer.MIN_VALUE;
            int day = Integer.MIN_VALUE;
            Keyword dow = null;
            Object[] caller_MV_returnarray = new Object[3];
            year = Stella.computeCalendarDate(jd + 1, caller_MV_returnarray);
            month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
            day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
            dow = (Keyword)caller_MV_returnarray[2];
            parsedValues.dateTimeDay = day;
            parsedValues.dateTimeMonth = month;
            parsedValues.dateTimeYear = year;
            parsedValues.dateTimeDow = dow;
        }
    }

    public static void today(DecodedDateTime parsedValues, DecodedDateTime defaultValues) {
        parsedValues.dateTimeDay = defaultValues.dateTimeDay;
        if (parsedValues.dateTimeMonth == Integer.MIN_VALUE) {
            parsedValues.dateTimeMonth = defaultValues.dateTimeMonth;
        }
        if (parsedValues.dateTimeYear == Integer.MIN_VALUE) {
            parsedValues.dateTimeYear = defaultValues.dateTimeYear;
        }
        parsedValues.setConsistentDow();
    }

    public static void yesterday(DecodedDateTime parsedValues, DecodedDateTime defaultValues) {
        DecodedDateTime.today(parsedValues, defaultValues);
        if (parsedValues.dateTimeYear != Integer.MIN_VALUE && parsedValues.dateTimeMonth != Integer.MIN_VALUE && parsedValues.dateTimeDay != Integer.MIN_VALUE) {
            int jd = Stella.computeJulianDay(parsedValues.dateTimeYear, parsedValues.dateTimeMonth, parsedValues.dateTimeDay);
            int year = Integer.MIN_VALUE;
            int month = Integer.MIN_VALUE;
            int day = Integer.MIN_VALUE;
            Keyword dow = null;
            Object[] caller_MV_returnarray = new Object[3];
            year = Stella.computeCalendarDate(jd - 1, caller_MV_returnarray);
            month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
            day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
            dow = (Keyword)caller_MV_returnarray[2];
            parsedValues.dateTimeDay = day;
            parsedValues.dateTimeMonth = month;
            parsedValues.dateTimeYear = year;
            parsedValues.dateTimeDow = dow;
        }
    }

    public CalendarDate encodeCalendarDate() {
        DecodedDateTime timeStructure = this;
        return CalendarDate.makeDateTime(timeStructure.dateTimeYear != Integer.MIN_VALUE ? timeStructure.dateTimeYear : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeYear, timeStructure.dateTimeMonth != Integer.MIN_VALUE ? timeStructure.dateTimeMonth : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeMonth, timeStructure.dateTimeDay != Integer.MIN_VALUE ? timeStructure.dateTimeDay : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeDay, timeStructure.dateTimeHour != Integer.MIN_VALUE ? timeStructure.dateTimeHour : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeHour, timeStructure.dateTimeMinute != Integer.MIN_VALUE ? timeStructure.dateTimeMinute : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeMinute, timeStructure.dateTimeSecond != Integer.MIN_VALUE ? timeStructure.dateTimeSecond : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeSecond, timeStructure.dateTimeMillis != Double.NEGATIVE_INFINITY ? Native.round(timeStructure.dateTimeMillis) : Native.round(Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeMillis), timeStructure.dateTimeZone != Double.NEGATIVE_INFINITY ? timeStructure.dateTimeZone : Stella.$DEFAULT_DECODED_DATE_TIME$.dateTimeZone);
    }

    public void mergeSuperiorNullFields(DecodedDateTime renamed_Default) {
        DecodedDateTime self = this;
        if (self.dateTimeMillis != Double.NEGATIVE_INFINITY) {
            self.helpMergeNullFields(renamed_Default, 6);
        } else if (self.dateTimeSecond != Integer.MIN_VALUE) {
            self.helpMergeNullFields(renamed_Default, 5);
        } else if (self.dateTimeMinute != Integer.MIN_VALUE) {
            self.helpMergeNullFields(renamed_Default, 4);
        } else if (self.dateTimeHour != Integer.MIN_VALUE) {
            self.helpMergeNullFields(renamed_Default, 3);
        } else if (self.dateTimeDay != Integer.MIN_VALUE) {
            self.helpMergeNullFields(renamed_Default, 2);
        } else if (self.dateTimeMonth != Integer.MIN_VALUE) {
            self.helpMergeNullFields(renamed_Default, 1);
        } else {
            self.helpMergeNullFields(renamed_Default, 0);
        }
    }

    public void mergeNullFields(DecodedDateTime renamed_Default) {
        DecodedDateTime self = this;
        self.helpMergeNullFields(renamed_Default, 6);
    }

    void helpMergeNullFields(DecodedDateTime renamed_Default, int index) {
        DecodedDateTime self = this;
        if (self.dateTimeYear == Integer.MIN_VALUE && index >= 0) {
            self.dateTimeYear = renamed_Default.dateTimeYear;
        }
        if (self.dateTimeMonth == Integer.MIN_VALUE && index >= 1) {
            self.dateTimeMonth = renamed_Default.dateTimeMonth;
        }
        if (self.dateTimeDay == Integer.MIN_VALUE && index >= 2) {
            self.dateTimeDay = renamed_Default.dateTimeDay;
        }
        if (self.dateTimeHour == Integer.MIN_VALUE && index >= 3) {
            self.dateTimeHour = renamed_Default.dateTimeHour;
        }
        if (self.dateTimeMinute == Integer.MIN_VALUE && index >= 4) {
            self.dateTimeMinute = renamed_Default.dateTimeMinute;
        }
        if (self.dateTimeSecond == Integer.MIN_VALUE && index >= 5) {
            self.dateTimeSecond = renamed_Default.dateTimeSecond;
        }
        if (self.dateTimeMillis == Double.NEGATIVE_INFINITY && index >= 6) {
            self.dateTimeMillis = renamed_Default.dateTimeMillis;
        }
        if (self.dateTimeZone == Double.NEGATIVE_INFINITY) {
            self.dateTimeZone = renamed_Default.dateTimeZone;
        }
        self.setConsistentDow();
    }

    void setConsistentDow() {
        DecodedDateTime self = this;
        if (self.dateTimeYear != Integer.MIN_VALUE && self.dateTimeMonth != Integer.MIN_VALUE && self.dateTimeDay != Integer.MIN_VALUE) {
            self.dateTimeDow = Stella.computeDayOfWeek(self.dateTimeYear, self.dateTimeMonth, self.dateTimeDay);
        }
    }

    public String decodedDateTimeToIso8601String() {
        DecodedDateTime date = this;
        StringBuffer buffer = Stella.makeRawMutableString(25);
        int index = 0;
        if (date.dateTimeYear != Integer.MIN_VALUE) {
            index = Stella.insertString(Native.integerToString(date.dateTimeYear), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
            if (date.dateTimeMonth != Integer.MIN_VALUE) {
                index = Stella.insertString("-", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                index = Stella.insertString(Stella.formatWithPadding(Native.integerToString(date.dateTimeMonth), 2, '0', Stella.KWD_RIGHT, false), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                if (date.dateTimeDay != Integer.MIN_VALUE) {
                    index = Stella.insertString("-", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                    index = Stella.insertString(Stella.formatWithPadding(Native.integerToString(date.dateTimeDay), 2, '0', Stella.KWD_RIGHT, false), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                    if (date.dateTimeHour != Integer.MIN_VALUE) {
                        index = Stella.insertString("T", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                        index = Stella.insertString(Stella.formatWithPadding(Native.integerToString(date.dateTimeHour), 2, '0', Stella.KWD_RIGHT, false), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                        if (date.dateTimeMinute != Integer.MIN_VALUE) {
                            index = Stella.insertString(":", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                            index = Stella.insertString(Stella.formatWithPadding(Native.integerToString(date.dateTimeMinute), 2, '0', Stella.KWD_RIGHT, false), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                            if (date.dateTimeSecond != Integer.MIN_VALUE) {
                                index = Stella.insertString(":", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                                index = Stella.insertString(Stella.formatWithPadding(Native.integerToString(date.dateTimeSecond), 2, '0', Stella.KWD_RIGHT, false), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                            }
                        }
                        if (date.dateTimeZone != Double.NEGATIVE_INFINITY) {
                            index = date.dateTimeZone == 0.0 ? Stella.insertString("Z", 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE) : Stella.insertString(Stella.timeZoneFormat60(date.dateTimeZone), 0, Integer.MIN_VALUE, buffer, index, Stella.KWD_PRESERVE);
                        }
                    }
                }
            }
        }
        return Native.mutableString_subsequence(buffer, 0, index);
    }

    public void setCurrentDateTime() {
        DecodedDateTime valuesStructure = this;
        int year = Integer.MIN_VALUE;
        int mon = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        int hour = Integer.MIN_VALUE;
        int min = Integer.MIN_VALUE;
        int sec = Integer.MIN_VALUE;
        int millis = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[7];
        year = Stella.getCurrentDateTime(caller_MV_returnarray);
        mon = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        hour = ((IntegerWrapper)caller_MV_returnarray[3]).wrapperValue;
        min = ((IntegerWrapper)caller_MV_returnarray[4]).wrapperValue;
        sec = ((IntegerWrapper)caller_MV_returnarray[5]).wrapperValue;
        millis = ((IntegerWrapper)caller_MV_returnarray[6]).wrapperValue;
        valuesStructure.dateTimeMillis = millis;
        valuesStructure.dateTimeSecond = sec;
        valuesStructure.dateTimeMinute = min;
        valuesStructure.dateTimeHour = hour;
        valuesStructure.dateTimeDow = dow;
        valuesStructure.dateTimeDay = day;
        valuesStructure.dateTimeMonth = mon;
        valuesStructure.dateTimeYear = year;
    }

    public void setCurrentDate() {
        DecodedDateTime valuesStructure = this;
        int year = Integer.MIN_VALUE;
        int mon = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        int hour = Integer.MIN_VALUE;
        int min = Integer.MIN_VALUE;
        int sec = Integer.MIN_VALUE;
        int millis = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[7];
        year = Stella.getCurrentDateTime(caller_MV_returnarray);
        mon = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        hour = ((IntegerWrapper)caller_MV_returnarray[3]).wrapperValue;
        min = ((IntegerWrapper)caller_MV_returnarray[4]).wrapperValue;
        sec = ((IntegerWrapper)caller_MV_returnarray[5]).wrapperValue;
        millis = ((IntegerWrapper)caller_MV_returnarray[6]).wrapperValue;
        valuesStructure.dateTimeDow = dow;
        valuesStructure.dateTimeDay = day;
        valuesStructure.dateTimeMonth = mon;
        valuesStructure.dateTimeYear = year;
    }

    public void setCurrentTime() {
        DecodedDateTime valuesStructure = this;
        int year = Integer.MIN_VALUE;
        int mon = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        int hour = Integer.MIN_VALUE;
        int min = Integer.MIN_VALUE;
        int sec = Integer.MIN_VALUE;
        int millis = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[7];
        year = Stella.getCurrentDateTime(caller_MV_returnarray);
        mon = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        hour = ((IntegerWrapper)caller_MV_returnarray[3]).wrapperValue;
        min = ((IntegerWrapper)caller_MV_returnarray[4]).wrapperValue;
        sec = ((IntegerWrapper)caller_MV_returnarray[5]).wrapperValue;
        millis = ((IntegerWrapper)caller_MV_returnarray[6]).wrapperValue;
        valuesStructure.dateTimeMillis = millis;
        valuesStructure.dateTimeSecond = sec;
        valuesStructure.dateTimeMinute = min;
        valuesStructure.dateTimeHour = hour;
    }

    public int hashCode_() {
        DecodedDateTime self = this;
        return (self.dateTimeYear << 9 | self.dateTimeMonth << 5 | self.dateTimeDay) ^ (self.dateTimeHour << 12 | self.dateTimeMinute << 6 | self.dateTimeSecond);
    }

    public static Stella_Object accessDecodedDateTimeSlotValue(DecodedDateTime self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_DATE_TIME_MILLIS) {
            if (setvalueP) {
                self.dateTimeMillis = ((FloatWrapper)value).wrapperValue;
            } else {
                value = FloatWrapper.wrapFloat(self.dateTimeMillis);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_SECOND) {
            if (setvalueP) {
                self.dateTimeSecond = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeSecond);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_MINUTE) {
            if (setvalueP) {
                self.dateTimeMinute = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeMinute);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_HOUR) {
            if (setvalueP) {
                self.dateTimeHour = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeHour);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_DAY) {
            if (setvalueP) {
                self.dateTimeDay = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeDay);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_MONTH) {
            if (setvalueP) {
                self.dateTimeMonth = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeMonth);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_YEAR) {
            if (setvalueP) {
                self.dateTimeYear = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.dateTimeYear);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_ZONE) {
            if (setvalueP) {
                self.dateTimeZone = ((FloatWrapper)value).wrapperValue;
            } else {
                value = FloatWrapper.wrapFloat(self.dateTimeZone);
            }
        } else if (slotname == Stella.SYM_STELLA_DATE_TIME_DOW) {
            if (setvalueP) {
                self.dateTimeDow = (Keyword)value;
            } else {
                value = self.dateTimeDow;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        DecodedDateTime self = this;
        return Stella.SGT_STELLA_DECODED_DATE_TIME;
    }
}

