/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.AllPurposeIterator;
import edu.isi.stella.Cons;
import edu.isi.stella.GlobalVariable;
import edu.isi.stella.HookList;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.ListIterator;
import edu.isi.stella.MethodSlot;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Class;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Thing;
import edu.isi.stella.World;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public abstract class Context
extends Thing {
    public List childContexts;
    public Module baseModule;
    public Cons allSuperContexts;
    public int contextNumber;

    public void helpPrintOutline(OutputStream stream, int currentDepth, int depth, boolean namedP) {
        Context top = this;
        if (namedP) {
            return;
        }
        Stella.indentOutline(currentDepth, stream);
        stream.nativeStream.println(top);
        if (depth == Integer.MIN_VALUE || depth < 0 || currentDepth < depth) {
            ++currentDepth;
            Context c = null;
            Cons iter000 = top.childContexts.theConsList;
            while (iter000 != Stella.NIL) {
                c = (Context)iter000.value;
                c.helpPrintOutline(stream, currentDepth, depth, namedP);
                iter000 = iter000.rest;
            }
        }
    }

    public static void printContextTree(Context root) {
        if (root == null) {
            root = Stella.$ROOT_MODULE$;
        }
        List toplist = Stella.list(Stella_Object.cons(root, Stella.NIL));
        List.helpPrintContextTree(toplist, 0);
        toplist.free();
    }

    public static void printContext(Context self, PrintStream stream) {
        String typestring = null;
        String name = null;
        int number = self.contextNumber;
        if (!Stella.$CLASS_HIERARCHY_BOOTEDp$) {
            stream.print("|MDL|" + ((Module)self).moduleName);
            return;
        }
        Surrogate testValue000 = Stella_Object.safePrimaryType(self);
        if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_MODULE)) {
            Module self000 = (Module)self;
            name = self000.moduleFullName;
            typestring = self000.contextNumber % 2 == 1 ? "|DeLeTeD MDL|" : "|MDL|";
        } else if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_WORLD)) {
            World self000 = (World)self;
            name = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self000.dynamicSlots, (Symbol)Stella.SYM_STELLA_WORLD_NAME, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
            typestring = self000.contextNumber % 2 == 1 ? "|DeLeTeD WLD|" : "|WLD|";
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        if (self.contextNumber % 2 == 1) {
            ++number;
        }
        if (((Boolean)Stella.$PRINTREADABLYp$.get()).booleanValue()) {
            if (name != null) {
                stream.print(name);
            } else {
                stream.print("#<" + typestring + number + ">");
            }
        } else if (name != null) {
            stream.print(typestring + name);
        } else {
            stream.print(typestring + number);
        }
    }

    public static Context changeContextSlowly(Context self) {
        if (self != null) {
            return self.changeContext();
        }
        return (Context)Stella.$CONTEXT$.get();
    }

    public boolean deletedP() {
        Context context = this;
        return context.contextNumber % 2 == 1;
    }

    public static boolean discardedContextP(Context context) {
        return context.contextNumber % 2 == 1;
    }

    public static boolean subcontextP(Context subcontext, Context supercontext) {
        return subcontext == supercontext || subcontext.allSuperContexts.membP(supercontext);
    }

    public static void clearContext(Context self) {
        Context.helpClearContext(self);
        Stella.finalizeClassesAndSlots();
    }

    public static void helpClearContext(Context self) {
        Context child = null;
        Cons iter000 = self.childContexts.theConsList;
        while (iter000 != Stella.NIL) {
            child = (Context)iter000.value;
            Context.helpClearContext(child);
            iter000 = iter000.rest;
        }
        Context.clearOneContext(self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOneContext(Context self) {
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(self), Stella.SGT_STELLA_MODULE)) {
            Module self000 = (Module)self;
            if (!self000.clearableP()) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: Module `" + self000.moduleFullName + "' cannot be cleared!");
                return;
            }
            HookList.runHooks(Stella.$CLEAR_MODULE_HOOKS$, self000);
            MethodSlot function = null;
            Iterator iter000 = Module.allFunctions(self000, true);
            while (iter000.nextP()) {
                function = (MethodSlot)iter000.value;
                MethodSlot.destroyFunction(function);
            }
            GlobalVariable variable = null;
            Iterator iter001 = Module.allVariables(self000, true);
            while (iter001.nextP()) {
                variable = (GlobalVariable)iter001.value;
                GlobalVariable.destroyVariable(variable);
            }
            Stella_Class renamed_Class = null;
            Iterator iter002 = Module.allClasses(self000, true);
            while (iter002.nextP()) {
                renamed_Class = (Stella_Class)iter002.value;
                renamed_Class.destroyClass();
            }
            Surrogate surrogate = null;
            Iterator iter003 = Module.allSurrogates(self000, true);
            while (iter003.nextP()) {
                surrogate = (Surrogate)iter003.value;
                if (self000.protectSurrogatesP()) {
                    surrogate.surrogateValue = null;
                    continue;
                }
                Surrogate.uninternSurrogate(surrogate);
            }
            if (!self000.protectSurrogatesP()) {
                Symbol symbol = null;
                Iterator iter004 = Module.allSymbols(self000, true);
                while (iter004.nextP()) {
                    symbol = (Symbol)iter004.value;
                    Symbol.uninternSymbol(symbol);
                }
            }
            Object old$Module$000 = Stella.$MODULE$.get();
            try {
                Native.setSpecial(Stella.$MODULE$, self000);
                ListIterator it = (ListIterator)self000.shadowedSurrogates().allocateIterator();
                while (it.nextP()) {
                    it.valueSetter(Stella.shadowSurrogate(((Surrogate)it.value).symbolName));
                }
            }
            finally {
                Stella.$MODULE$.set(old$Module$000);
            }
            Keyword.bumpMemoizationTimestamp(Stella.KWD_MODULE_UPDATE);
        }
    }

    public static boolean visibleFromP(Context viewedcontext, Context fromcontext) {
        boolean testValue000 = false;
        if (viewedcontext == fromcontext) {
            testValue000 = true;
        } else if (fromcontext.allSuperContexts.membP(viewedcontext)) {
            testValue000 = true;
        } else {
            boolean foundP000 = false;
            Module usesmodule = null;
            Cons iter000 = (Stella_Object.isaP((Stella_Object)fromcontext, (Surrogate)Stella.SGT_STELLA_MODULE) ? ((Module)fromcontext).uses : fromcontext.baseModule.uses).theConsList;
            while (iter000 != Stella.NIL) {
                usesmodule = (Module)iter000.value;
                if (viewedcontext == usesmodule || usesmodule.allSuperContexts.membP(viewedcontext)) {
                    foundP000 = true;
                    break;
                }
                iter000 = iter000.rest;
            }
            testValue000 = foundP000;
        }
        boolean value000 = testValue000;
        return value000;
    }

    public static AllPurposeIterator allSubcontexts(Context context, Keyword traversal) {
        AllPurposeIterator contextsiterator = AllPurposeIterator.newAllPurposeIterator();
        Cons subcontexts = Stella.NIL;
        Context child = null;
        Cons iter000 = context.childContexts.theConsList;
        Cons collect000 = null;
        while (iter000 != Stella.NIL) {
            child = (Context)iter000.value;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(child, Stella.NIL);
                if (subcontexts == Stella.NIL) {
                    subcontexts = collect000;
                } else {
                    Cons.addConsToEndOfConsList(subcontexts, collect000);
                }
            } else {
                collect000 = collect000.rest = Stella_Object.cons(child, Stella.NIL);
            }
            iter000 = iter000.rest;
        }
        if (traversal == Stella.KWD_POSTORDER) {
            subcontexts = subcontexts.reverse();
        }
        contextsiterator.iteratorConsList = subcontexts;
        if (traversal == Stella.KWD_TOPDOWN) {
            contextsiterator.iteratorObject = context;
            contextsiterator.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allTopdownSubcontextsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        } else {
            contextsiterator.iteratorObject = traversal;
            contextsiterator.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allSubcontextsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        }
        return contextsiterator;
    }

    public static World createWorld(Context parentcontext, String name) {
        World world = World.newWorld();
        if (name != null) {
            KeyValueList.setDynamicSlotValue(world.dynamicSlots, Stella.SYM_STELLA_WORLD_NAME, StringWrapper.wrapString(name), Stella.NULL_STRING_WRAPPER);
            boolean foundP000 = false;
            Context sibling = null;
            Cons iter000 = parentcontext.childContexts.theConsList;
            while (iter000 != Stella.NIL) {
                sibling = (Context)iter000.value;
                if (Stella.stringEqlP(sibling.contextName(), name)) {
                    foundP000 = true;
                    break;
                }
                iter000 = iter000.rest;
            }
            if (foundP000) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: Can't create a world named `" + name + "' because a sibling already has that name.");
                return null;
            }
        }
        world.parentContext = parentcontext;
        parentcontext.childContexts.insert(world);
        world.baseModule = parentcontext.baseModule;
        World.finalizeWorld(world);
        return world;
    }

    public void destroyContext() {
        Context context = this;
    }

    public void uninheritSupercontexts() {
        Context context = this;
        context.allSuperContexts = Stella.NIL;
    }

    public void inheritSupercontexts() {
        Context context = this;
    }

    public boolean multipleParentsP() {
        Context self = this;
        return false;
    }

    public Context changeContext() {
        Context context = this;
        if (context == (Context)Stella.$CONTEXT$.get()) {
            return context;
        }
        return Context.changeCurrentContext(context);
    }

    public static Context changeCurrentContext(Context context) {
        if (context.baseModule != (Module)Stella.$MODULE$.get()) {
            Module.changeCurrentModule(context.baseModule);
        }
        Native.setSpecial(Stella.$CONTEXT$, context);
        return context;
    }

    public Iterator parentContexts() {
        Context self = this;
        return null;
    }

    public void printObject(PrintStream stream) {
        Context self = this;
        Context.printContext(self, stream);
    }

    public static Stella_Object accessContextSlotValue(Context self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_CHILD_CONTEXTS) {
            if (setvalueP) {
                self.childContexts = (List)value;
            } else {
                value = self.childContexts;
            }
        } else if (slotname == Stella.SYM_STELLA_BASE_MODULE) {
            if (setvalueP) {
                self.baseModule = (Module)value;
            } else {
                value = self.baseModule;
            }
        } else if (slotname == Stella.SYM_STELLA_ALL_SUPER_CONTEXTS) {
            if (setvalueP) {
                self.allSuperContexts = (Cons)value;
            } else {
                value = self.allSuperContexts;
            }
        } else if (slotname == Stella.SYM_STELLA_CONTEXT_NUMBER) {
            if (setvalueP) {
                self.contextNumber = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.contextNumber);
            }
        } else if (setvalueP) {
            KeyValueList.setDynamicSlotValue(self.dynamicSlots, slotname, value, null);
        } else {
            value = self.dynamicSlots.lookup(slotname);
        }
        return value;
    }

    public Module homeModule() {
        Context self = this;
        return self.baseModule;
    }

    public String contextName() {
        Context self = this;
        Context aux = self;
        Surrogate testValue000 = Stella_Object.safePrimaryType(aux);
        if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_MODULE)) {
            Module aux000 = (Module)aux;
            return aux000.moduleName;
        }
        if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_WORLD)) {
            World aux000 = (World)aux;
            return ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)aux000.dynamicSlots, (Symbol)Stella.SYM_STELLA_WORLD_NAME, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
    }
}

