/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import unbbayes.controller.FileController;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class MonteCarloIO {
    private byte[][] matrix;
    private File file = this.getFile();
    private PrintStream ps = new PrintStream(new FileOutputStream(this.file));

    public MonteCarloIO(byte[][] matrix) throws IOException {
        this.matrix = matrix;
    }

    public void makeFile(int[] positions, ProbabilisticNetwork pn) {
        this.makeFirstLine(pn);
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < pn.getNodeCount()) {
                Node node = pn.getNodeAt(j);
                this.ps.print(node.getStateAt(this.matrix[i][positions[j]]));
                if (j != pn.getNodeCount() - 1) {
                    this.ps.print('\t');
                } else {
                    this.ps.println();
                }
                ++j;
            }
            ++i;
        }
    }

    private void makeFirstLine(ProbabilisticNetwork pn) {
        int i = 0;
        while (i < pn.getNodeCount()) {
            Node node = pn.getNodeAt(i);
            this.ps.print(node.getName());
            if (i != pn.getNodeCount() - 1) {
                this.ps.print('\t');
            } else {
                this.ps.println();
            }
            ++i;
        }
    }

    private File getFile() {
        File file;
        String[] nets = new String[]{"net", "xml"};
        FileController fileController = FileController.getInstance();
        JFileChooser chooser = new JFileChooser(fileController.getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new SimpleFileFilter(nets, "txt"));
        int option = chooser.showSaveDialog(null);
        if (option == 0 && (file = chooser.getSelectedFile()) != null) {
            return file;
        }
        return null;
    }
}

