/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.simulation.montecarlo.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.io.BaseIO;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.simulation.montecarlo.gui.MCParametersPane;
import unbbayes.simulation.montecarlo.sampling.MonteCarloSampling;

public class MCMainController {
    private MCParametersPane tp;
    private BaseIO io;
    ProbabilisticNetwork redeProbabilistica;
    ActionListener okListener = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            int n = MCMainController.this.validaNatural(MCMainController.this.tp.getNumeroCasos());
            if (n >= 0) {
                new MonteCarloSampling(MCMainController.this.redeProbabilistica, n);
                MCMainController.this.tp.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "O numero de casos deve ser um natural", "ERROR", 0);
            }
        }
    };

    public MCMainController() {
        this.getNet();
        this.tp = new MCParametersPane();
        this.adicionarListeners();
    }

    private void getNet() {
        try {
            String[] nets = new String[]{"net", "xml"};
            JFileChooser chooser = new JFileChooser(".");
            chooser.setMultiSelectionEnabled(false);
            chooser.addChoosableFileFilter(new SimpleFileFilter(nets, "Carregar .net, .xml"));
            int option = chooser.showOpenDialog(null);
            if (option == 0 && chooser.getSelectedFile() != null) {
                String fileName = chooser.getSelectedFile().getName();
                this.io = fileName.endsWith(".net") ? new NetIO() : new XMLBIFIO();
                this.redeProbabilistica = this.io.load(chooser.getSelectedFile());
            }
        }
        catch (LoadException le) {
            le.printStackTrace();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        catch (JAXBException je) {
            je.printStackTrace();
        }
    }

    public void adicionarListeners() {
        this.tp.adicionaOKListener(this.okListener);
    }

    private int validaNatural(String n) {
        try {
            int numero = Integer.parseInt(n);
            if (numero >= 0) {
                return numero;
            }
            return -1;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }
}

