/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.oobn.impl;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.prs.Edge;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.prs.oobn.exception.OOBNException;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOOBNClass
extends ProbabilisticNetwork
implements IOOBNClass {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.oobn.resources.Resources");

    protected DefaultOOBNClass(String name) {
        super(name);
    }

    public static DefaultOOBNClass newInstance(String name) {
        return new DefaultOOBNClass(name);
    }

    @Override
    public Set<IOOBNNode> getAllNodes() {
        HashSet<IOOBNNode> ret = new HashSet<IOOBNNode>();
        try {
            for (Node node : this.getNodes()) {
                if (!(node instanceof OOBNNodeGraphicalWrapper)) continue;
                ret.add(((OOBNNodeGraphicalWrapper)node).getWrappedNode());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        try {
            return super.equals(obj) || this.getName().equals(((DefaultOOBNClass)obj).getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getClassName() {
        return this.getName();
    }

    @Override
    public void setClassName(String name) throws OOBNException {
        Debug.println(this.getClass(), "Name consistency check is not implemented yet.");
        if (name.contains("!")) {
            throw new OOBNException();
        }
        if (name.contains("-")) {
            throw new OOBNException();
        }
        if (name.contains(".")) {
            throw new OOBNException();
        }
        if (name.contains("'")) {
            throw new OOBNException();
        }
        this.setName(name);
    }

    @Override
    public Network getNetwork() {
        return this;
    }

    @Override
    public IOOBNClass getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            Debug.println(this.getClass(), "Returning " + this.getClassName() + " as transfer data");
            return this;
        }
        Debug.println(this.getClass(), "Flavor is not suported; " + flavor.toString());
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        try {
            DataFlavor[] ret = new DataFlavor[]{new DataFlavor("application/x-java-jvm-local-objectref", this.getClassName())};
            return ret;
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "It was not possible to initialize Transferable DataFlavor", e);
            return new DataFlavor[0];
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }

    @Override
    public Set<IOOBNNode> getInputNodes() {
        HashSet<IOOBNNode> ret = new HashSet<IOOBNNode>();
        for (IOOBNNode node : this.getAllNodes()) {
            if (node.getType() != 4) continue;
            ret.add(node);
        }
        return ret;
    }

    @Override
    public Set<IOOBNNode> getOutputNodes() {
        HashSet<IOOBNNode> ret = new HashSet<IOOBNNode>();
        for (IOOBNNode node : this.getAllNodes()) {
            if (node.getType() != 1) continue;
            ret.add(node);
        }
        return ret;
    }

    @Override
    public void removeNode(Node element) {
        OOBNNodeGraphicalWrapper oOBNNodeGraphicalWrapper;
        Debug.println(this.getClass(), "Removing node " + element.getName());
        IOOBNNode removingNode = null;
        if (element instanceof OOBNNodeGraphicalWrapper) {
            removingNode = ((OOBNNodeGraphicalWrapper)element).getWrappedNode();
        } else {
            Debug.println(this.getClass(), "Could not determine wrapped node to remove from " + element.toString());
            for (IOOBNNode iOOBNNode : this.getAllNodes()) {
                if (!element.equals(iOOBNNode)) continue;
                removingNode = iOOBNNode;
                break;
            }
        }
        if (removingNode != null) {
            for (IOOBNNode iOOBNNode : removingNode.getOOBNChildren()) {
                iOOBNNode.getOOBNParents().remove(removingNode);
                Debug.println(this.getClass(), "Removing parent " + removingNode.getName() + " from " + iOOBNNode.getName());
            }
            for (IOOBNNode iOOBNNode : removingNode.getOOBNParents()) {
                iOOBNNode.getOOBNChildren().remove(removingNode);
                Debug.println(this.getClass(), "Removing child " + removingNode.getName() + " from " + iOOBNNode.getName());
            }
        }
        if (element instanceof OOBNNodeGraphicalWrapper && (oOBNNodeGraphicalWrapper = (OOBNNodeGraphicalWrapper)element).getWrappedNode().getType() == 8) {
            for (OOBNNodeGraphicalWrapper inner : oOBNNodeGraphicalWrapper.getInnerNodes()) {
                this.removeNode(inner);
            }
        }
        super.removeNode(element);
    }

    @Override
    public void addEdge(Edge edge) throws InvalidParentException {
        edge.getDestinationNode().addParent(edge.getOriginNode());
        this.edgeList.add(edge);
        if (edge.getDestinationNode() instanceof ITabledVariable) {
            ITabledVariable v2 = (ITabledVariable)((Object)edge.getDestinationNode());
            PotentialTable auxTab = v2.getPotentialTable();
            auxTab.addVariable(edge.getOriginNode());
        }
    }

    @Override
    public boolean containsInstanceOf(IOOBNClass classToCheck) {
        if (this.equals(classToCheck)) {
            return true;
        }
        for (IOOBNNode node : this.getAllNodes()) {
            if (node.getType() != 8 || !node.getParentClass().containsInstanceOf(classToCheck)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addNode(Node node) {
        OOBNNodeGraphicalWrapper wrapper;
        if (node instanceof OOBNNodeGraphicalWrapper && ((wrapper = (OOBNNodeGraphicalWrapper)node).getWrappedNode().getType() & 8) != 0 && wrapper.getWrappedNode().getParentClass().containsInstanceOf(this)) {
            throw new IllegalArgumentException(resource.getString("ClassCycleFound"));
        }
        super.addNode(node);
        if (node instanceof OOBNNodeGraphicalWrapper && (wrapper = (OOBNNodeGraphicalWrapper)node).getWrappedNode().getType() == 8) {
            for (OOBNNodeGraphicalWrapper innerNode : wrapper.getInnerNodes()) {
                super.addNode(innerNode);
            }
        }
    }

    @Override
    public void addOOBNNode(IOOBNNode node) {
        this.addNode(OOBNNodeGraphicalWrapper.newInstance(node));
    }

    @Override
    public void removeEdge(Edge edge) {
        OOBNNodeGraphicalWrapper origin = (OOBNNodeGraphicalWrapper)edge.getOriginNode();
        OOBNNodeGraphicalWrapper destination = (OOBNNodeGraphicalWrapper)edge.getDestinationNode();
        origin.getWrappedNode().getOOBNChildren().remove(destination.getWrappedNode());
        destination.getWrappedNode().getOOBNParents().remove(origin.getWrappedNode());
        super.removeEdge(edge);
    }
}

