/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.msbn;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubNetwork
extends SingleEntityNetwork {
    private static final long serialVersionUID = 0L;
    private char[] visited;
    protected List<SubNetwork> adjacents = new ArrayList<SubNetwork>();
    protected SubNetwork parent;

    public SubNetwork(String id) {
        super(id);
    }

    public int getAdjacentsSize() {
        return this.adjacents.size();
    }

    public SubNetwork getAdjacentAt(int index) {
        return this.adjacents.get(index);
    }

    public void addAdjacent(SubNetwork net) {
        this.adjacents.add(net);
    }

    public void setParent(SubNetwork parent) {
        this.parent = parent;
    }

    protected void localMoralize() {
        super.moralize();
    }

    protected void compileJunctionTree() throws Exception {
        super.compileJT(new JunctionTree());
    }

    protected JunctionTree getJunctionTree() {
        return this.junctionTree;
    }

    protected void initTriangulation() {
        this.copiaNos = SetToolkit.clone(this.nodeList);
        this.oe = new ArrayList();
        this.oe.ensureCapacity(this.copiaNos.size());
    }

    @Override
    protected void verifyConsistency() throws Exception {
        super.verifyConsistency();
    }

    protected List makePath(SubNetwork net) {
        ArrayList<SubNetwork> path = new ArrayList<SubNetwork>();
        this.makePath(net, path);
        return path;
    }

    private boolean makePath(SubNetwork net, List<SubNetwork> path) {
        if (path.contains(this)) {
            return false;
        }
        path.add(this);
        if (this.equals(net)) {
            return true;
        }
        int i = this.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork netAux = this.adjacents.get(i);
            if (netAux.makePath(net, path)) {
                return true;
            }
            --i;
        }
        if (this.parent.makePath(net, path)) {
            return true;
        }
        path.remove(this);
        return false;
    }

    protected boolean elimine(SubNetwork adj) {
        System.out.println("Elimine");
        this.oe.clear();
        ArrayList<Node> inter = SetToolkit.intersection(this.copiaNos, adj.copiaNos);
        ArrayList<Node> auxNos = SetToolkit.clone(this.copiaNos);
        int sizeAnt = auxNos.size();
        auxNos.removeAll(inter);
        boolean inseriu = false;
        while (this.minimumWeightElimination(auxNos)) {
            inseriu = true;
        }
        while (this.minimumWeightElimination(inter)) {
            inseriu = true;
        }
        this.makeAdjacents();
        return inseriu;
    }

    protected void elimineProfundidade(SubNetwork caller) {
        System.out.println("Elimine profundidade");
        int i = this.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork ai = this.adjacents.get(i);
            if (this.elimine(ai)) {
                this.updateArcsAux(ai);
            }
            ai.elimineProfundidade(this);
            --i;
        }
        if (caller != null && this.elimine(caller)) {
            this.updateArcsAux(caller);
        }
    }

    protected void distributeArcs() {
        System.out.println("DistributeArcs");
        int i = this.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork net = this.adjacents.get(i);
            this.updateArcsBilateral(net);
            net.distributeArcs();
            --i;
        }
    }

    private void updateArcsAux(SubNetwork net) {
        ArrayList<Node> dsepset = SetToolkit.intersection(this.nodeList, net.nodeList);
        int i = this.arcosMarkov.size() - 1;
        while (i >= 0) {
            Edge e = (Edge)this.arcosMarkov.get(i);
            if (dsepset.contains(e.getOriginNode()) && dsepset.contains(e.getDestinationNode())) {
                Node a = net.getNode(e.getOriginNode().getName());
                Node b = net.getNode(e.getDestinationNode().getName());
                if (!a.getAdjacents().contains(b) && !b.getAdjacents().contains(a)) {
                    a.getAdjacents().add(b);
                    b.getAdjacents().add(a);
                    Edge newEdge = new Edge(a, b);
                    net.arcosMarkov.add(newEdge);
                    System.out.println(newEdge);
                }
            }
            --i;
        }
    }

    private void updateArcsBilateral(SubNetwork net) {
        System.out.println("updateArcs");
        this.updateArcsAux(net);
        net.updateArcsAux(this);
    }

    protected void initVisited() {
        this.visited = new char[this.nodeList.size()];
    }

    protected void distributedCycle() throws Exception {
        int i = this.nodeList.size() - 1;
        while (i >= 0) {
            this.dfsCycle(i, null);
            --i;
        }
    }

    private void dfsCycle(int nodeIndex, Node caller) throws Exception {
        int index;
        if (this.visited[nodeIndex] != '\u0000') {
            if (this.visited[nodeIndex] == '\u0001') {
                throw new Exception("CicleNetException");
            }
            return;
        }
        Node node = (Node)this.nodeList.get(nodeIndex);
        this.visited[nodeIndex] = '\u0001';
        int i = node.getChildren().size() - 1;
        while (i >= 0) {
            int newIndex = this.getNodeIndex(node.getChildren().get(i).getName());
            this.dfsCycle(newIndex, node);
            --i;
        }
        if (this.parent != null && (index = this.parent.getNodeIndex(node.getName())) != -1) {
            Node next = this.parent.getNodeAt(index);
            if (caller == null || caller != null && !next.equals(caller)) {
                this.parent.dfsCycle(index, node);
            }
        }
        i = this.adjacents.size() - 1;
        while (i >= 0) {
            SubNetwork net = this.adjacents.get(i);
            int index2 = net.getNodeIndex(node.getName());
            if (index2 != -1) {
                Node next = net.getNodeAt(index2);
                if (caller == null || caller != null && !next.equals(caller)) {
                    net.dfsCycle(index2, node);
                }
            }
            --i;
        }
        this.visited[nodeIndex] = 2;
    }

    @Override
    protected void updateMarginais() {
        super.updateMarginais();
    }
}

