/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn.util;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import unbbayes.io.XMLBIFIO;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;

public class PositionAdjustmentUtils {
    public static String fileTestLoad = "rede.xml";
    public static String fileTestSave = "novarede.xml";
    private static Point sizeSquare = new Point(100, 100);
    private static Point margin = new Point(100, 100);

    public static Dimension adjustPositionProbabilisticNetwork(ProbabilisticNetwork net) {
        InfoNetwork infoNetwork = new InfoNetwork();
        PositionAdjustmentUtils.createInfoNodesList(infoNetwork, net);
        return PositionAdjustmentUtils.adjustPositions(infoNetwork);
    }

    private static void createInfoNodesList(InfoNetwork infoNetwork, ProbabilisticNetwork net) {
        ArrayList<Node> nodes = net.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            if (nodes.get(i).getChildren().size() == 0) {
                PositionAdjustmentUtils.createInfoNode(infoNetwork, (ProbabilisticNode)nodes.get(i), 1);
            }
            ++i;
        }
    }

    private static void createInfoNode(InfoNetwork infoNetwork, ProbabilisticNode pn, int initialLevel) {
        InfoNode infoNode = new InfoNode(pn);
        infoNode.setLevel(initialLevel);
        infoNetwork.addInfoNode(infoNode);
        ++initialLevel;
        int i = 0;
        while (i < pn.getParents().size()) {
            PositionAdjustmentUtils.createInfoNode(infoNetwork, (ProbabilisticNode)pn.getParents().get(i), initialLevel);
            ++i;
        }
    }

    private static Dimension adjustPositions(InfoNetwork infoNetwork) {
        int numColunas = infoNetwork.getMaxNodesInLevel();
        int numLinhas = infoNetwork.getNumLevels();
        double width = (double)numColunas * sizeSquare.getX() + margin.getX() + sizeSquare.getX();
        double heigth = (double)numLinhas * sizeSquare.getY() + margin.getY() + sizeSquare.getY();
        InfoNode[][] map = new InfoNode[numColunas][numLinhas];
        int line = 0;
        int level = infoNetwork.getNumLevels();
        while (level >= 0) {
            List<InfoNode> nodesOfLevel = infoNetwork.getInfoNodesOfLevel(level);
            int coluna = 0;
            Iterator<InfoNode> iterator = nodesOfLevel.iterator();
            while (iterator.hasNext()) {
                InfoNode infoNode;
                map[coluna][line] = infoNode = iterator.next();
                ++coluna;
            }
            ++line;
            --level;
        }
        int coluna = 0;
        while (coluna < numColunas) {
            int linha = 0;
            while (linha < numLinhas) {
                if (map[coluna][linha] != null) {
                    double positionX = (double)coluna * sizeSquare.getX() + margin.getX();
                    double positionY = (double)linha * sizeSquare.getY() - (double)(numLinhas - infoNetwork.getNumLevels()) * sizeSquare.getY() + margin.getY();
                    map[coluna][linha].getPn().setPosition(positionX, positionY);
                }
                ++linha;
            }
            ++coluna;
        }
        return new Dimension((int)width, (int)heigth);
    }

    public static void main(String[] arguments) {
        System.out.println("Init");
        ProbabilisticNetwork net = null;
        XMLBIFIO io = new XMLBIFIO();
        try {
            net = io.load(new File(fileTestLoad));
        }
        catch (LoadException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        PositionAdjustmentUtils adjustment = new PositionAdjustmentUtils();
        if (net != null) {
            PositionAdjustmentUtils.adjustPositionProbabilisticNetwork(net);
            try {
                io.save(new File(fileTestSave), net);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        System.out.println("End");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InfoNetwork {
        private int numLevels = 0;
        private List<InfoNode> nodes;
        private Map<Integer, Integer> nodesAtLevel = new HashMap<Integer, Integer>();

        public InfoNetwork() {
            this.nodes = new ArrayList<InfoNode>();
        }

        public void addInfoNode(InfoNode n) {
            this.nodes.add(n);
            if (n.getLevel() > this.numLevels) {
                this.numLevels = n.getLevel();
            }
            if (this.nodesAtLevel.get(n.getLevel()) == null) {
                this.nodesAtLevel.put(n.getLevel(), 1);
            } else {
                this.nodesAtLevel.put(n.getLevel(), this.nodesAtLevel.get(n.getLevel()) + 1);
            }
        }

        public List<InfoNode> getInfoNodesOfLevel(int level) {
            ArrayList<InfoNode> ret = new ArrayList<InfoNode>();
            for (InfoNode node : this.nodes) {
                if (node.getLevel() != level) continue;
                ret.add(node);
            }
            return ret;
        }

        public int getNumLevels() {
            return this.numLevels;
        }

        public int getMaxNodesInLevel() {
            int max = 0;
            int i = 1;
            while (i <= this.numLevels) {
                Integer testValue = this.nodesAtLevel.get(i);
                if (testValue != null && testValue > max) {
                    max = testValue;
                }
                ++i;
            }
            return max;
        }

        public void setNumLevels(int numLevels) {
            this.numLevels = numLevels;
        }
    }

    private static class InfoNode {
        private int level;
        private ProbabilisticNode pn;

        public InfoNode(ProbabilisticNode pn) {
            this.pn = pn;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public ProbabilisticNode getPn() {
            return this.pn;
        }

        public void setPn(ProbabilisticNode pn) {
            this.pn = pn;
        }
    }
}

