/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SSBNNodeJacket {
    private final Integer ARGUMENTS_OF_INPUT_MFRAG = 0;
    private final Integer ARGUMENTS_OF_RESIDENT_MFRAG = 1;
    private SSBNNode ssbnNode;
    private List<OVInstance> ovInstancesOfInputMFrag;
    private List<OVInstance> ovInstancesOfResidentMFrag;
    private Integer typeAtualArguments;

    public SSBNNodeJacket(SSBNNode ssbnNode) {
        this.ssbnNode = ssbnNode;
        this.typeAtualArguments = -1;
        this.ovInstancesOfInputMFrag = new ArrayList<OVInstance>();
        this.ovInstancesOfResidentMFrag = new ArrayList<OVInstance>();
    }

    public SSBNNode getSsbnNode() {
        return this.ssbnNode;
    }

    public void setSsbnNode(SSBNNode ssbnNode) {
        this.ssbnNode = ssbnNode;
    }

    public List<OVInstance> getInputMFragOvInstances() {
        return this.ovInstancesOfInputMFrag;
    }

    public void addOVInstanceOfInputMFrag(OVInstance ovInstance) {
        this.ovInstancesOfInputMFrag.add(ovInstance);
    }

    public Collection<OVInstance> getResidentMFragOvInstances() {
        return this.ovInstancesOfResidentMFrag;
    }

    public void addOVInstanceOfResidentMFrag(OVInstance ovInstance) {
        this.ovInstancesOfResidentMFrag.add(ovInstance);
    }

    public void setInputMFragArguments() {
        if (this.typeAtualArguments != this.ARGUMENTS_OF_INPUT_MFRAG) {
            this.ssbnNode.removeAllArguments();
            this.ssbnNode.setArguments(this.ovInstancesOfInputMFrag);
            this.typeAtualArguments = this.ARGUMENTS_OF_INPUT_MFRAG;
        }
    }

    public void setResidentMFragArguments() {
        if (this.typeAtualArguments != this.ARGUMENTS_OF_RESIDENT_MFRAG) {
            this.ssbnNode.removeAllArguments();
            this.ssbnNode.setArguments(this.ovInstancesOfResidentMFrag);
            this.typeAtualArguments = this.ARGUMENTS_OF_RESIDENT_MFRAG;
        }
    }

    public Integer getTypeAtualArguments() {
        return this.typeAtualArguments;
    }

    public void setTypeAtualArguments(Integer typeAtualArguments) {
        this.typeAtualArguments = typeAtualArguments;
    }

    public String toString() {
        return String.valueOf(this.ssbnNode.toString()) + " Input[" + this.ovInstancesOfInputMFrag + "]" + " Resident[" + this.ovInstancesOfResidentMFrag + "]";
    }

    public void addArgument(ResidentNode residentNode, InputNode inputNode, OVInstance ovInstanceResidentMFrag) {
        OrdinaryVariable ovResidentMFrag = ovInstanceResidentMFrag.getOv();
        int index = residentNode.getOrdinaryVariableIndex(ovResidentMFrag);
        if (index > -1) {
            this.addOVInstanceOfResidentMFrag(ovInstanceResidentMFrag);
            OrdinaryVariable ovInputMFrag = inputNode.getOrdinaryVariableByIndex(index);
            this.addOVInstanceOfInputMFrag(OVInstance.getInstance(ovInputMFrag, ovInstanceResidentMFrag.getEntity()));
        }
    }

    protected void addArgument(InputNode inputNode, OVInstance ovInstanceInputMFrag) throws SSBNNodeGeneralException {
        ResidentNode residentNode = inputNode.getResidentNodePointer().getResidentNode();
        OrdinaryVariable ovInputMFrag = ovInstanceInputMFrag.getOv();
        int index = inputNode.getResidentNodePointer().getOrdinaryVariableIndex(ovInputMFrag);
        if (index > -1) {
            this.addOVInstanceOfInputMFrag(ovInstanceInputMFrag);
            OrdinaryVariable ovResidentMFrag = residentNode.getOrdinaryVariableList().get(index);
            this.addOVInstanceOfResidentMFrag(OVInstance.getInstance(ovResidentMFrag, ovInstanceInputMFrag.getEntity()));
        }
    }
}

