/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.compiler.Compiler;
import unbbayes.prs.mebn.compiler.ICompiler;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.ssbn.AbstractSSBNGenerator;
import unbbayes.prs.mebn.ssbn.ContextFatherSSBNNode;
import unbbayes.prs.mebn.ssbn.LiteralEntityInstance;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSBNNode {
    private static int count = 0;
    private int id;
    private EvaluationSSBNNodeState evaluationState = EvaluationSSBNNodeState.NOT_EVALUATED;
    private ResidentNode residentNode = null;
    private ProbabilisticNode probabilisticNode = null;
    private List<OVInstance> arguments = null;
    private boolean isRecursive = false;
    private List<OVInstance> argumentsResidentMFrag;
    private Map<MFrag, List<OVInstance>> argumentsForMFrag;
    private Collection<SSBNNode> parents = null;
    private Collection<SSBNNode> children = null;
    private Collection<Entity> actualValues = null;
    private Entity value = null;
    private boolean isUsingDefaultCPT = false;
    private String strongOVSeparator = ".";
    private boolean cptAlreadyGenerated = false;
    private ICompiler compiler = null;
    private ContextFatherSSBNNode contextFatherSSBNNode = null;
    private ProbabilisticNetwork probabilisticNetwork = null;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.ssbn.resources.Resources");
    private boolean permanent;

    private SSBNNode(ProbabilisticNetwork pnet, ResidentNode resident, ProbabilisticNode probNode) {
        this.id = count++;
        this.argumentsResidentMFrag = new ArrayList<OVInstance>();
        this.arguments = new ArrayList<OVInstance>();
        this.parents = new ArrayList<SSBNNode>();
        this.children = new ArrayList<SSBNNode>();
        this.residentNode = resident;
        this.argumentsForMFrag = new HashMap<MFrag, List<OVInstance>>();
        this.probabilisticNetwork = pnet == null ? new ProbabilisticNetwork(this.resource.getString("DefaultNetworkName")) : pnet;
        if (probNode == null) {
            this.setProbNode(new ProbabilisticNode());
        } else {
            this.setProbNode(probNode);
        }
        this.actualValues = this.residentNode.getPossibleValueListIncludingEntityInstances();
        this.setUsingDefaultCPT(false);
        this.setCompiler(new Compiler(resident, this));
    }

    public static SSBNNode getInstance(ProbabilisticNetwork probabilisticNetwork, ResidentNode resident, ProbabilisticNode probNode) {
        return new SSBNNode(probabilisticNetwork, resident, probNode);
    }

    public static SSBNNode getInstance(ProbabilisticNetwork net, ResidentNode resident) {
        return new SSBNNode(net, resident, null);
    }

    public static SSBNNode getInstance(ResidentNode resident) {
        return new SSBNNode(null, resident, null);
    }

    public String getUniqueName() {
        return SSBNNode.getUniqueNameFor(this.residentNode, this.getArguments());
    }

    public static String getUniqueNameFor(ResidentNode resident, Collection<OVInstance> list) {
        StringBuilder uniqueName = new StringBuilder();
        uniqueName.append(resident.getName());
        for (OrdinaryVariable ov : resident.getOrdinaryVariableList()) {
            OVInstance ovInstance = SSBNNode.getArgumentByOrdinaryVariable(list, ov);
            try {
                uniqueName.append("_" + ovInstance.getEntity().getInstanceName());
            }
            catch (RuntimeException er) {
                uniqueName.append("_?");
            }
        }
        return uniqueName.toString();
    }

    public Collection<OrdinaryVariable> getOVs() {
        HashSet<OrdinaryVariable> ovs = new HashSet<OrdinaryVariable>();
        for (OVInstance element : this.arguments) {
            ovs.add(element.getOv());
        }
        return ovs;
    }

    public boolean hasOV(OrdinaryVariable ov) {
        for (OVInstance element : this.getArguments()) {
            if (!element.getOv().equals(ov)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOV(String name, boolean isOVName) {
        if (isOVName) {
            for (OVInstance element : this.getArguments()) {
                if (!element.getOv().getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        } else {
            for (OVInstance element : this.getArguments()) {
                if (!element.getEntity().getInstanceName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAllOVs(Collection<OrdinaryVariable> ovs) {
        if (ovs == null) {
            return false;
        }
        if (ovs.size() <= 0) {
            return false;
        }
        for (OrdinaryVariable variable : ovs) {
            if (this.hasOV(variable)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllOVs(OrdinaryVariable ... ovs) {
        if (ovs == null) {
            return false;
        }
        if (ovs.length <= 0) {
            return false;
        }
        OrdinaryVariable[] ordinaryVariableArray = ovs;
        int n = ovs.length;
        int n2 = 0;
        while (n2 < n) {
            OrdinaryVariable variable = ordinaryVariableArray[n2];
            if (!this.hasOV(variable)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasAllOVs(boolean isOVName, String ... ovs) {
        if (ovs == null) {
            return false;
        }
        int i = 0;
        while (i < ovs.length) {
            if (!this.hasOV(ovs[i], isOVName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addArgument(OrdinaryVariable ov, String entityInstanceName) throws SSBNNodeGeneralException {
        if (entityInstanceName.length() <= 0) {
            return;
        }
        OVInstance ovInstance = OVInstance.getInstance(ov, LiteralEntityInstance.getInstance(entityInstanceName, ov.getValueType()));
        this.arguments.add(ovInstance);
        this.argumentsResidentMFrag.add(ovInstance);
    }

    public void addArgument(OVInstance ovInstance) {
        this.arguments.add(ovInstance);
        this.argumentsResidentMFrag.add(ovInstance);
    }

    public void addArgument(OrdinaryVariable ov, String entityInstanceName, int pos) throws SSBNNodeGeneralException {
        if (entityInstanceName.length() <= 0) {
            return;
        }
        OVInstance ovInstance = OVInstance.getInstance(ov, LiteralEntityInstance.getInstance(entityInstanceName, ov.getValueType()));
        this.arguments.add(pos, ovInstance);
        this.argumentsResidentMFrag.add(ovInstance);
    }

    public void removeAllArguments() {
        this.arguments.clear();
        this.argumentsResidentMFrag.clear();
    }

    public void setNodeAsFinding(Entity uniqueValue) {
        this.value = uniqueValue;
    }

    public boolean isFinding() {
        return this.value != null;
    }

    public void addTemporaryParent(SSBNNode parent, boolean isCheckingParentResident) throws SSBNNodeGeneralException {
    }

    public void addParent(SSBNNode parent, boolean isCheckingParentResident) throws SSBNNodeGeneralException {
        if (this.getParents().contains(parent)) {
            return;
        }
        if (parent.getResident() == null || parent.getProbNode() == null) {
            throw new SSBNNodeGeneralException(this.resource.getString("InternalError"));
        }
        if (isCheckingParentResident) {
            ArrayList<Node> expectedParents = this.getResident().getParents();
            boolean isConsistent = false;
            InputNode input = null;
            int i = 0;
            while (i < expectedParents.size()) {
                if (parent.getResident() == expectedParents.get(i)) {
                    isConsistent = true;
                    break;
                }
                if (expectedParents.get(i) instanceof InputNode && (input = (InputNode)expectedParents.get(i)).getResidentNodePointer().getResidentNode() == parent.getResident()) {
                    isConsistent = true;
                    break;
                }
                ++i;
            }
            if (!isConsistent) {
                throw new SSBNNodeGeneralException("InconsistencyError");
            }
            if (this.getProbNode() != null && parent.getProbNode() != null && this.getProbabilisticNetwork() != parent.getProbabilisticNetwork()) {
                throw new SSBNNodeGeneralException(this.resource.getString("IncompatibleNetworks"));
            }
        }
        this.getParents().add(parent);
        parent.getChildren().add(this);
        if (this.getProbNode() != null && parent.getProbNode() != null) {
            Edge edge = new Edge(parent.getProbNode(), this.getProbNode());
            if (this.getProbabilisticNetwork() != null) {
                try {
                    this.getProbabilisticNetwork().addEdge(edge);
                }
                catch (InvalidParentException e) {
                    throw new SSBNNodeGeneralException(e.getMessage());
                }
                AbstractSSBNGenerator.logManager.append("\n");
                AbstractSSBNGenerator.logManager.append(">>EDGE>> " + edge + " created");
            }
        }
    }

    public void removeAllParents() {
        ArrayList<SSBNNode> aux = new ArrayList<SSBNNode>();
        aux.addAll(this.getParents());
        for (SSBNNode node : aux) {
            this.removeParent(node);
            node.getChildren().remove(this);
        }
        this.removeContextFatherSSBNNode();
    }

    protected void removeParent(SSBNNode parent) {
        this.getParents().remove(parent);
        parent.getChildren().remove(this);
        if (this.getProbNode() != null) {
            this.getProbNode().getParents().remove(this.getProbNode());
            Edge edge = this.getProbabilisticNetwork().getEdge(parent.getProbNode(), this.getProbNode());
            this.getProbabilisticNetwork().removeEdge(edge);
        }
    }

    protected void removeParentByName(String name) {
        if (name == null) {
            return;
        }
        Collection<SSBNNode> parents = this.getParents();
        ArrayList<SSBNNode> removingNodes = new ArrayList<SSBNNode>();
        for (SSBNNode node : parents) {
            if (!node.getName().equalsIgnoreCase(name)) continue;
            removingNodes.add(node);
        }
        parents.removeAll(removingNodes);
        for (SSBNNode parent : removingNodes) {
            parent.getChildren().remove(this);
        }
    }

    public Collection<SSBNNode> getParentSetByStrongOV(boolean isExactMatch, String ... ovNames) {
        ArrayList<SSBNNode> parents = new ArrayList<SSBNNode>();
        if (ovNames == null) {
            return parents;
        }
        if (ovNames.length <= 0) {
            return parents;
        }
        for (SSBNNode parent : this.parents) {
            if (!parent.hasAllOVs(true, ovNames)) continue;
            if (isExactMatch) {
                if (parent.getOVs().size() != ovNames.length) continue;
                parents.add(parent);
                continue;
            }
            parents.add(parent);
        }
        return parents;
    }

    public Collection<SSBNNode> getParentSetByStrongOV(boolean isExactMatch, Collection<OrdinaryVariable> setOfOV) {
        ArrayList<SSBNNode> parents = new ArrayList<SSBNNode>();
        if (setOfOV == null) {
            return parents;
        }
        for (SSBNNode parent : this.parents) {
            if (!parent.hasAllOVs(setOfOV)) continue;
            if (isExactMatch) {
                if (parent.getOVs().size() != setOfOV.size()) continue;
                parents.add(parent);
                continue;
            }
            parents.add(parent);
        }
        return parents;
    }

    public Collection<SSBNNode> getParentSetByStrongOV(boolean isExactMatch, OrdinaryVariable ... setOfOV) {
        ArrayList<SSBNNode> parents = new ArrayList<SSBNNode>();
        if (setOfOV == null) {
            return parents;
        }
        if (setOfOV.length <= 0) {
            return parents;
        }
        for (SSBNNode parent : this.parents) {
            if (!parent.hasAllOVs(setOfOV)) continue;
            if (isExactMatch) {
                if (parent.getOVs().size() != setOfOV.length) continue;
                parents.add(parent);
                continue;
            }
            parents.add(parent);
        }
        return parents;
    }

    public List<SSBNNode> getParentSetByStrongOVWithWeakOVCheck(String ... strongOVs) {
        OrdinaryVariable ov;
        ArrayList<SSBNNode> ret = new ArrayList<SSBNNode>();
        if (strongOVs == null) {
            return ret;
        }
        if (strongOVs.length <= 0) {
            return ret;
        }
        if (strongOVs.length == 1 && (ov = this.getResident().getMFrag().getOrdinaryVariableByName(strongOVs[0])) != null && ov.getValueType().hasOrder()) {
            return new ArrayList<SSBNNode>(this.getParents());
        }
        ArrayList<String> strongOVList = new ArrayList<String>();
        String[] stringArray = strongOVs;
        int n = strongOVs.length;
        int n2 = 0;
        while (n2 < n) {
            String ovname = stringArray[n2];
            strongOVList.add(ovname);
            ++n2;
        }
        ArrayList<String> weakOVs = new ArrayList<String>();
        for (SSBNNode parent : this.getParents()) {
            for (OVInstance ovi : parent.getArguments()) {
                if (!ovi.getEntity().getType().hasOrder() || weakOVs.contains(ovi.getOv().getName())) continue;
                weakOVs.add(ovi.getOv().getName());
            }
        }
        strongOVList.removeAll(weakOVs);
        ret.addAll(this.getParentSetByStrongOV(true, strongOVList.toArray(new String[strongOVList.size()])));
        for (String weakov : weakOVs) {
            int i = weakOVs.indexOf(weakov);
            while (i < weakOVs.size()) {
                ArrayList aux = (ArrayList)strongOVList.clone();
                aux.add((String)weakOVs.get(i));
                ret.addAll(this.getParentSetByStrongOV(true, aux.toArray(new String[aux.size()])));
                ++i;
            }
            strongOVList.add(weakov);
        }
        return ret;
    }

    public String getName() {
        String name = new String(this.residentNode.getName());
        name = String.valueOf(name) + "(";
        for (OVInstance ovi : this.getArguments()) {
            if (name.charAt(name.length() - 1) != '(') {
                name = String.valueOf(name) + ",";
            }
            name = String.valueOf(name) + ovi.getEntity().getInstanceName();
        }
        name = String.valueOf(name) + ")";
        if (this.getProbNode() != null) {
            this.getProbNode().setName(name);
            this.getProbNode().setDescription(name);
        }
        return name;
    }

    public Collection<Entity> getActualValues() {
        if (this.getProbNode() == null) {
            ArrayList<Entity> ret = new ArrayList<Entity>();
            ret.add(this.actualValues.iterator().next());
            return ret;
        }
        return this.actualValues;
    }

    public void setActualValues(Collection<Entity> actualValues) {
        this.actualValues = actualValues;
    }

    public Collection<OVInstance> getArguments() {
        return this.arguments;
    }

    public List<OVInstance> getArgumentsAsList() {
        ArrayList<OVInstance> listArguments = new ArrayList<OVInstance>();
        listArguments.addAll(this.getArguments());
        return listArguments;
    }

    public OVInstance getArgumentByOrdinaryVariable(OrdinaryVariable ov) {
        for (OVInstance instance : this.getArguments()) {
            if (!instance.getOv().equals(ov)) continue;
            return instance;
        }
        return null;
    }

    public static OVInstance getArgumentByOrdinaryVariable(Collection<OVInstance> instances, OrdinaryVariable ov) {
        for (OVInstance instance : instances) {
            if (!instance.getOv().equals(ov)) continue;
            return instance;
        }
        return null;
    }

    public void delete() {
        this.probabilisticNetwork.removeNode(this.getProbNode());
    }

    public ContextFatherSSBNNode getContextFatherSSBNNode() {
        return this.contextFatherSSBNNode;
    }

    public void setContextFatherSSBNNode(ContextFatherSSBNNode contextFatherSSBNNode) throws InvalidParentException {
        this.contextFatherSSBNNode = contextFatherSSBNNode;
        if (this.getProbNode() != null && contextFatherSSBNNode.getProbNode() != null) {
            Edge edge = new Edge(contextFatherSSBNNode.getProbNode(), this.getProbNode());
            if (this.getProbabilisticNetwork() != null) {
                this.getProbabilisticNetwork().addEdge(edge);
            }
        }
    }

    public void removeContextFatherSSBNNode() {
        if (this.contextFatherSSBNNode != null && this.getProbNode() != null) {
            Edge edge = this.getProbabilisticNetwork().getEdge(this.contextFatherSSBNNode.getProbNode(), this.getProbNode());
            this.getProbabilisticNetwork().removeEdge(edge);
        }
    }

    public void setArguments(List<OVInstance> arguments) {
        this.arguments = arguments;
        this.argumentsResidentMFrag = arguments;
    }

    public boolean isUsingDefaultCPT() {
        return this.residentNode.getMFrag().isUsingDefaultCPT();
    }

    public void setUsingDefaultCPT(boolean isUsingDefaultCPT) {
        this.residentNode.getMFrag().setAsUsingDefaultCPT(isUsingDefaultCPT);
    }

    public Collection<SSBNNode> getParents() {
        return this.parents;
    }

    public void setParents(Collection<SSBNNode> parents) {
        this.parents = parents;
    }

    public ProbabilisticNode getProbNode() {
        return this.probabilisticNode;
    }

    public void setProbNode(ProbabilisticNode probNode) {
        if (this.probabilisticNode != null) {
            this.getProbabilisticNetwork().removeNode(this.probabilisticNode);
        }
        this.probabilisticNode = probNode;
        this.appendProbNodeState();
        if (this.probabilisticNode != null) {
            this.probabilisticNode.setName(this.getName());
            this.getProbNode().setDescription(this.getName());
            this.getProbabilisticNetwork().addNode(this.probabilisticNode);
        }
    }

    public ResidentNode getResident() {
        return this.residentNode;
    }

    protected void setResident(ResidentNode resident) {
        this.residentNode = resident;
        this.setProbNode(new ProbabilisticNode());
    }

    public String getStrongOVSeparator() {
        return this.strongOVSeparator;
    }

    public void setStrongOVSeparator(String strongOVSeparator) {
        this.strongOVSeparator = strongOVSeparator;
    }

    public ICompiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    public ProbabilisticNetwork getProbabilisticNetwork() {
        return this.probabilisticNetwork;
    }

    public void setProbabilisticNetwork(ProbabilisticNetwork probabilisticNetwork) throws SSBNNodeGeneralException {
        if (probabilisticNetwork == null) {
            throw new SSBNNodeGeneralException(this.resource.getString("NoNetworkDefined"));
        }
        this.probabilisticNetwork = probabilisticNetwork;
        if (this.getProbNode() != null) {
            this.probabilisticNetwork.addNode(this.getProbNode());
        }
    }

    public String toString() {
        String ret = this.residentNode.getName();
        ret = String.valueOf(ret) + "(";
        for (OVInstance instance : this.arguments) {
            ret = String.valueOf(ret) + instance.toString();
        }
        ret = String.valueOf(ret) + ")";
        if (this.value != null) {
            ret = String.valueOf(ret) + " [F] ";
        }
        ret = String.valueOf(ret) + " [id=" + this.id + "]P=" + this.permanent;
        return ret;
    }

    public boolean equals(Object obj) {
        SSBNNode node = (SSBNNode)obj;
        return this.getName().equals(node.getName());
    }

    public boolean isCptAlreadyGenerated() {
        return this.cptAlreadyGenerated;
    }

    public void setCptAlreadyGenerated(boolean cptAlreadyGenerated) {
        this.cptAlreadyGenerated = cptAlreadyGenerated;
    }

    public Collection<SSBNNode> getChildren() {
        return this.children;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public EvaluationSSBNNodeState getEvaluationState() {
        return this.evaluationState;
    }

    public void setEvaluationState(EvaluationSSBNNodeState evaluationState) {
        this.evaluationState = evaluationState;
    }

    public Entity getValue() {
        return this.value;
    }

    public void setValue(Entity value) {
        this.value = value;
    }

    public static int getCount() {
        return count;
    }

    public static void setCount(int count) {
        SSBNNode.count = count;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private String getNameByDots(String ... names) {
        String dotName = new String(names[0]);
        int i = 1;
        while (i < names.length) {
            dotName.concat("." + names[i]);
            ++i;
        }
        return dotName;
    }

    private String getNameByDots(Collection<OrdinaryVariable> ovs) {
        OrdinaryVariable[] ovArray = new OrdinaryVariable[ovs.size()];
        int i = 0;
        Iterator<OrdinaryVariable> iterator = ovs.iterator();
        while (iterator.hasNext()) {
            OrdinaryVariable variable;
            ovArray[i] = variable = iterator.next();
            ++i;
        }
        String dotName = new String(ovArray[0].getName());
        i = 1;
        while (i < ovArray.length) {
            dotName = String.valueOf(dotName) + "." + ovArray[i].getName();
            ++i;
        }
        return dotName;
    }

    private boolean isAllValuesBelow(int value, int[] vector) {
        int i = 0;
        while (i < vector.length) {
            if (vector[i] >= value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int factorial(int n) {
        int ret = 1;
        int i = 1;
        while (i <= n) {
            ret *= i;
            ++i;
        }
        return ret;
    }

    private int combination(int n, int by) {
        if (n < by) {
            return 1;
        }
        return this.factorial(n) / (this.factorial(by) * this.factorial(n - by));
    }

    private Collection<Collection<OrdinaryVariable>> getOVCombination(int byHowMany, OrdinaryVariable ... ovs) {
        ArrayList<Collection<OrdinaryVariable>> ret = new ArrayList<Collection<OrdinaryVariable>>();
        if (byHowMany <= 0) {
            return ret;
        }
        if (byHowMany > ovs.length) {
            return ret;
        }
        OrdinaryVariable[] ovArray = ovs;
        int[] indexes = new int[byHowMany];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = i;
            ++i;
        }
        ArrayList<OrdinaryVariable> tempOVs = null;
        int combination = this.combination(ovArray.length, byHowMany);
        int i2 = 0;
        while (i2 < combination) {
            tempOVs = new ArrayList<OrdinaryVariable>();
            int j = 0;
            while (j < indexes.length) {
                tempOVs.add(ovArray[indexes[j]]);
                ++j;
            }
            ret.add(tempOVs);
            int n = indexes.length - 1;
            indexes[n] = indexes[n] + 1;
            j = indexes.length - 2;
            while (j >= 0) {
                if (indexes[j + 1] > ovArray.length - (indexes.length - (j + 1)) && indexes[j] + 1 < indexes[j + 1]) {
                    int n2 = j;
                    indexes[n2] = indexes[n2] + 1;
                    int k = j + 1;
                    while (k < indexes.length) {
                        indexes[k] = indexes[k - 1] + 1;
                        ++k;
                    }
                }
                --j;
            }
            ++i2;
        }
        return ret;
    }

    private Collection<Collection<OrdinaryVariable>> getOVCombination(int byHowMany, Collection<OrdinaryVariable> ovs) {
        OrdinaryVariable[] array = new OrdinaryVariable[ovs.size()];
        int i = 0;
        Iterator<OrdinaryVariable> iterator = ovs.iterator();
        while (iterator.hasNext()) {
            OrdinaryVariable ov;
            array[i] = ov = iterator.next();
            ++i;
        }
        return this.getOVCombination(byHowMany, array);
    }

    private Collection<OrdinaryVariable> getAllParentsOV() {
        HashSet<OrdinaryVariable> ovs = new HashSet<OrdinaryVariable>();
        for (SSBNNode parent : this.getParents()) {
            ovs.addAll(parent.getOVs());
        }
        return ovs;
    }

    private void appendProbNodeState() {
        if (this.getProbNode() == null) {
            return;
        }
        if (this.getResident() != null) {
            for (Entity entity : this.residentNode.getPossibleValueListIncludingEntityInstances()) {
                this.getProbNode().appendState(entity.getName());
            }
        }
        if (this.getProbNode().getPotentialTable() != null) {
            this.getProbNode().getPotentialTable().addVariable(this.getProbNode());
        }
    }

    public void setChildren(Collection<SSBNNode> children) {
        this.children = children;
    }

    public void setRecursiveOVInstanceList(List<OVInstance> listOVInstanceInputNode) {
        this.isRecursive = true;
        this.argumentsForMFrag.put(this.getResident().getMFrag(), listOVInstanceInputNode);
    }

    public void addArgumentsForMFrag(MFrag mFrag, List<OVInstance> listArgumentsOfMFrag) {
        this.argumentsForMFrag.put(mFrag, listArgumentsOfMFrag);
    }

    public boolean turnArgumentsForMFrag(MFrag mFrag) {
        if (mFrag.equals(this.getResident().getMFrag())) {
            if (this.isRecursive) {
                this.arguments = this.argumentsForMFrag.get(mFrag);
                return true;
            }
            return true;
        }
        List<OVInstance> argumentsTemp = this.argumentsForMFrag.get(mFrag);
        if (argumentsTemp != null) {
            this.arguments = argumentsTemp;
            return true;
        }
        return false;
    }

    public void changeArgumentsToResidentMFrag() {
        this.arguments = this.argumentsResidentMFrag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EvaluationSSBNNodeState {
        NOT_EVALUATED,
        EVALUATED_BELOW,
        EVALUATED_COMPLETE,
        EVALUATING_BELOW,
        EVALUATING_UP;

    }
}

