/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ssbn.LiteralEntityInstance;
import unbbayes.prs.mebn.ssbn.exception.InvalidOperationException;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFatherSSBNNode {
    private ContextNode contextNode;
    private ProbabilisticNode probNode;
    private ProbabilisticNetwork pnet;
    private Collection<LiteralEntityInstance> possibleValues;
    private OrdinaryVariable ovProblematic;
    private boolean cptGenerated = false;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.ssbn.resources.Resources");

    public ContextFatherSSBNNode(ProbabilisticNetwork pnet, ContextNode contextNode, ProbabilisticNode probNode) {
        this.pnet = pnet;
        this.contextNode = contextNode;
        this.probNode = probNode;
        probNode.setName("context");
        probNode.setDescription("context");
        pnet.addNode(probNode);
        this.possibleValues = new ArrayList<LiteralEntityInstance>();
    }

    public ContextFatherSSBNNode(ProbabilisticNetwork pnet, ContextNode contextNode) {
        this(pnet, contextNode, new ProbabilisticNode());
    }

    public void generateCPT() throws InvalidOperationException {
        if (!this.isCptGenerated()) {
            PotentialTable cpt = this.probNode.getPotentialTable();
            cpt.addVariable(this.probNode);
            float probabilityOfEachState = 1.0f / (float)this.possibleValues.size();
            int i = 0;
            while (i < this.possibleValues.size()) {
                cpt.setValue(i, probabilityOfEachState);
                ++i;
            }
        } else {
            throw new InvalidOperationException();
        }
        this.cptGenerated = true;
    }

    public OrdinaryVariable getOvProblematic() {
        return this.ovProblematic;
    }

    public void setOvProblematic(OrdinaryVariable ovProblematic) {
        this.ovProblematic = ovProblematic;
    }

    public void addPossibleValue(LiteralEntityInstance e) {
        Debug.println("--> Acrescentado estado ao ssbn context node = " + e.toString());
        if (this.possibleValues != null) {
            this.possibleValues.add(e);
            this.probNode.appendState(e.getInstanceName());
        }
    }

    public Collection<LiteralEntityInstance> getPossibleValues() {
        return this.possibleValues;
    }

    public void setPossibleValues(Collection<LiteralEntityInstance> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public ContextNode getContextNode() {
        return this.contextNode;
    }

    public ProbabilisticNetwork getPnet() {
        return this.pnet;
    }

    public ProbabilisticNode getProbNode() {
        return this.probNode;
    }

    public boolean isCptGenerated() {
        return this.cptGenerated;
    }

    public String toString() {
        return "SSBNNode:" + this.contextNode.getLabel() + " " + this.ovProblematic + "[" + this.possibleValues + "]";
    }
}

