/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.kb.powerloom;

import edu.isi.powerloom.Environment;
import edu.isi.powerloom.PLI;
import edu.isi.powerloom.PlIterator;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.Module;
import edu.isi.stella.Stella_Object;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import unbbayes.io.exception.UBIOException;
import unbbayes.prs.mebn.Argument;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.RandomVariableFinding;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.builtInRV.BuiltInRVAnd;
import unbbayes.prs.mebn.builtInRV.BuiltInRVEqualTo;
import unbbayes.prs.mebn.builtInRV.BuiltInRVExists;
import unbbayes.prs.mebn.builtInRV.BuiltInRVForAll;
import unbbayes.prs.mebn.builtInRV.BuiltInRVIff;
import unbbayes.prs.mebn.builtInRV.BuiltInRVImplies;
import unbbayes.prs.mebn.builtInRV.BuiltInRVNot;
import unbbayes.prs.mebn.builtInRV.BuiltInRVOr;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.kb.KnowledgeBase;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.exception.OVInstanceFaultException;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerLoomKB
implements KnowledgeBase {
    public static final String FILE_SUFIX = "plm";
    private static int nextId = 1;
    public static String PLI_TOKEN_SEPARATOR = "() \n\t\r";
    private static final String POWER_LOOM_KERNEL_MODULE = "/PL-KERNEL/PL-USER/";
    private static final boolean CASE_SENSITIVE = false;
    private static final String GENERATIVE_MODULE_NAME = "GENERATIVE_MODULE";
    private static final String FINDING_MODULE_NAME = "FINDINGS_MODULE";
    private int idInstance;
    private String moduleGenerativeName;
    private String moduleFindingName;
    private Module moduleGenerative;
    private Module moduleFinding;
    private String moduleName;
    private Environment environment = null;
    private static final String POSSIBLE_STATE_SUFIX = "_state";

    private PowerLoomKB(int id) {
        PowerLoomKB.initialize();
        this.idInstance = id;
        this.moduleGenerativeName = "GENERATIVE_MODULE_" + this.idInstance;
        this.moduleFindingName = "FINDINGS_MODULE_" + this.idInstance;
        Module fatherModule = PLI.getModule((String)POWER_LOOM_KERNEL_MODULE, (Environment)this.environment);
        this.moduleGenerative = PLI.createModule((String)this.moduleGenerativeName, (Module)fatherModule, (boolean)false);
        this.moduleFinding = PLI.createModule((String)this.moduleFindingName, (Module)this.moduleGenerative, (boolean)false);
        Debug.println("Modules creating sucessfull:");
        Debug.println(this.moduleGenerative.moduleFullName);
        Debug.println(this.moduleFinding.moduleFullName);
        PLI.sChangeModule((String)this.moduleFindingName, (Environment)this.environment);
    }

    public static void initialize() {
        Debug.println("Initializing...");
        PLI.initialize();
        Debug.println("Done.");
    }

    public static synchronized PowerLoomKB getNewInstanceKB() {
        return new PowerLoomKB(nextId++);
    }

    @Override
    public void saveGenerativeMTheory(MultiEntityBayesianNetwork mebn, File file) {
        Debug.println("Saving generative module...");
        PLI.sSaveModule((String)this.moduleGenerativeName, (String)file.getAbsolutePath(), (String)"REPLACE", (Environment)this.environment);
        Debug.println("...File save sucefull");
    }

    @Override
    public void saveFindings(MultiEntityBayesianNetwork mebn, File file) {
        Debug.println("Saving finding module...");
        PLI.sSaveModule((String)this.moduleFindingName, (String)file.getAbsolutePath(), (String)"REPLACE", (Environment)this.environment);
        Debug.println("...File save sucefull");
    }

    @Override
    public synchronized void loadModule(File file, boolean findingModule) throws UBIOException {
        Debug.println("Loading module...");
        File tempFile = this.preLoad(file, findingModule);
        PLI.load((String)tempFile.getAbsolutePath(), (Environment)this.environment);
        tempFile.delete();
        Debug.println("File load sucefull");
    }

    @Override
    public void clearKnowledgeBase() {
        PLI.clearModule((Module)this.moduleFinding);
        PLI.clearModule((Module)this.moduleGenerative);
    }

    /*
     * Unable to fully structure code
     */
    private File preLoad(File file, boolean findingModule) throws UBIOException {
        continueReading = true;
        endOfFile = false;
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e1) {
            throw new UBIOException("CreationFileError", file.getName());
        }
        newFile = new File("Temp.plm");
        try {
            writer = new BufferedWriter(new FileWriter(newFile));
            if (true) ** GOTO lbl28
        }
        catch (IOException e) {
            throw new UBIOException("CreationFileError", newFile.getName());
        }
        {
            do {
                if ((line = reader.readLine()) == null) {
                    endOfFile = true;
                    break;
                }
                defModulePattern = Pattern.compile(".*ASSERT.*");
                matcher = defModulePattern.matcher(line);
                if (!matcher.matches()) continue;
                if (findingModule) {
                    this.writeModuleFindingDefinition(writer);
                } else {
                    this.writeModuleGenerativeDefinition(writer);
                }
                writer.write(line);
                writer.newLine();
                continueReading = false;
lbl28:
                // 3 sources

            } while (continueReading && !endOfFile);
            if (!endOfFile) {
                line = null;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            writer.flush();
            writer.close();
        }
        return newFile;
    }

    private void writeModuleFindingDefinition(BufferedWriter writer) throws IOException {
        writer.write("(CL:IN-PACKAGE \"STELLA\")");
        writer.newLine();
        writer.write("(DEFMODULE \"" + this.moduleFinding.moduleFullName + "\" :CASE-SENSITIVE? FALSE)");
        writer.newLine();
        writer.write("(IN-MODULE \"" + this.moduleFinding.moduleFullName + "\")");
        writer.newLine();
        writer.write("(IN-DIALECT :KIF)");
        writer.newLine();
    }

    private void writeModuleGenerativeDefinition(BufferedWriter writer) throws IOException {
        writer.write("(CL:IN-PACKAGE \"STELLA\")");
        writer.newLine();
        writer.write("(DEFMODULE \"" + this.moduleGenerative.moduleFullName + "\" :CASE-SENSITIVE? FALSE)");
        writer.newLine();
        writer.write("(IN-MODULE \"" + this.moduleGenerative.moduleFullName + "\")");
        writer.newLine();
        writer.write("(IN-DIALECT :KIF)");
        writer.newLine();
    }

    private void preSave() {
    }

    @Override
    public void createEntityDefinition(ObjectEntity entity) {
        LogicObject lo = PLI.sCreateConcept((String)entity.getType().toString(), null, (String)this.moduleGenerativeName, (Environment)this.environment);
        Debug.println(lo.toString());
    }

    @Override
    public void createRandomVariableDefinition(ResidentNode resident) {
        Stella_Object result;
        List<StateLink> links = resident.getPossibleValueLinkList();
        String range = "";
        switch (resident.getTypeOfStates()) {
            case 0: {
                if (resident.getPossibleValueLinkList().isEmpty()) break;
                String type = resident.getPossibleValueLinkList().get(0).getState().getType().getName();
                range = "(?range " + type + ")";
                break;
            }
            case 1: {
                String setofList = "";
                for (StateLink state : links) {
                    setofList = String.valueOf(setofList) + state.getState().getName() + " ";
                }
                String residentStateListName = String.valueOf(resident.getName()) + POSSIBLE_STATE_SUFIX;
                PLI.sEvaluate((String)("(defconcept " + residentStateListName + "(?z) :<=> (member-of ?z ( setof " + setofList + ")))"), (String)this.moduleGenerativeName, (Environment)this.environment);
                range = "(?range " + residentStateListName + ")";
            }
        }
        String arguments = "";
        List<OrdinaryVariable> listVariables = resident.getOrdinaryVariableList();
        int i = 0;
        for (OrdinaryVariable variable : listVariables) {
            arguments = String.valueOf(arguments) + "(";
            arguments = String.valueOf(arguments) + "?arg_" + i + " " + variable.getValueType();
            arguments = String.valueOf(arguments) + ")";
            ++i;
        }
        if (resident.getTypeOfStates() == 2) {
            result = PLI.sEvaluate((String)("(defrelation " + resident.getName() + " (" + arguments + "))"), (String)this.moduleGenerativeName, null);
            if (result != null) {
                Debug.println(result.toString());
            }
        } else {
            result = PLI.sEvaluate((String)("(deffunction " + resident.getName() + " (" + arguments + range + "))"), (String)this.moduleGenerativeName, null);
            Debug.println(result.toString());
        }
    }

    @Override
    public void createGenerativeKnowledgeBase(MultiEntityBayesianNetwork mebn) {
        for (ObjectEntity entity : mebn.getObjectEntityContainer().getListEntity()) {
            this.createEntityDefinition(entity);
        }
        for (MFrag mfrag : mebn.getDomainMFragList()) {
            for (ResidentNode resident : mfrag.getResidentNodeList()) {
                this.createRandomVariableDefinition(resident);
            }
        }
    }

    @Override
    public void insertEntityInstance(ObjectEntityInstance entityInstance) {
        Debug.println("Entity finding: " + entityInstance.getName());
        String assertCommand = "(";
        assertCommand = String.valueOf(assertCommand) + entityInstance.getInstanceOf().getType().toString() + " ";
        assertCommand = String.valueOf(assertCommand) + entityInstance.getName();
        assertCommand = String.valueOf(assertCommand) + ")";
        PlIterator iterator = PLI.sAssertProposition((String)assertCommand, (String)this.moduleFindingName, null);
        while (iterator.nextP()) {
            Debug.println(iterator.value.toString());
        }
    }

    @Override
    public void insertRandomVariableFinding(RandomVariableFinding randonVariableFinding) {
        ObjectEntityInstance argument;
        int n;
        int n2;
        ObjectEntityInstance[] objectEntityInstanceArray;
        boolean isFirst;
        String finding = "";
        if (randonVariableFinding.getNode().getTypeOfStates() == 2) {
            finding = String.valueOf(finding) + "(";
            if (randonVariableFinding.getState().getName().equals("false")) {
                finding = String.valueOf(finding) + "NOT";
                finding = String.valueOf(finding) + "(";
            }
            finding = String.valueOf(finding) + randonVariableFinding.getNode().getName();
            finding = String.valueOf(finding) + " ";
            isFirst = true;
            objectEntityInstanceArray = randonVariableFinding.getArguments();
            n2 = objectEntityInstanceArray.length;
            n = 0;
            while (n < n2) {
                argument = objectEntityInstanceArray[n];
                if (isFirst) {
                    isFirst = false;
                } else {
                    finding = String.valueOf(finding) + " ";
                }
                finding = String.valueOf(finding) + argument.getName();
                ++n;
            }
            if (randonVariableFinding.getState().getName().equals("false")) {
                finding = String.valueOf(finding) + ") ";
            }
            finding = String.valueOf(finding) + ")";
        } else {
            finding = String.valueOf(finding) + "(=";
            finding = String.valueOf(finding) + "(";
            finding = String.valueOf(finding) + randonVariableFinding.getNode().getName();
            finding = String.valueOf(finding) + " ";
            isFirst = true;
            objectEntityInstanceArray = randonVariableFinding.getArguments();
            n2 = objectEntityInstanceArray.length;
            n = 0;
            while (n < n2) {
                argument = objectEntityInstanceArray[n];
                if (isFirst) {
                    isFirst = false;
                } else {
                    finding = String.valueOf(finding) + " ";
                }
                finding = String.valueOf(finding) + argument.getName();
                ++n;
            }
            finding = String.valueOf(finding) + ") ";
            finding = String.valueOf(finding) + randonVariableFinding.getState().getName();
            finding = String.valueOf(finding) + ")";
        }
        PlIterator iterator = PLI.sAssertProposition((String)finding, (String)this.moduleFindingName, null);
        while (iterator.nextP()) {
            Debug.println(iterator.value.toString());
        }
    }

    @Override
    public Boolean evaluateContextNodeFormula(ContextNode context, List<OVInstance> ovInstances) {
        String formula = "";
        NodeFormulaTree formulaTree = context.getFormulaTree();
        formula = String.valueOf(formula) + "(";
        formula = formulaTree.getTypeNode() == EnumType.OPERAND && formulaTree.getSubTypeNode() == EnumSubType.NODE ? String.valueOf(formula) + this.makeOperandString(formulaTree, ovInstances) : String.valueOf(formula) + this.makeOperatorString(formulaTree, ovInstances);
        formula = String.valueOf(formula) + ")";
        Debug.println("Original formula: " + context.getLabel());
        Debug.println("PowerLoom formula: " + formula);
        TruthValue answer = PLI.sAsk((String)formula, (String)this.moduleFindingName, null);
        if (PLI.isTrue((TruthValue)answer)) {
            Debug.println("Result: true");
            return true;
        }
        if (PLI.isFalse((TruthValue)answer)) {
            Debug.println("Result: false");
            return false;
        }
        if (PLI.isUnknown((TruthValue)answer)) {
            Debug.println("Result: unknown");
            return false;
        }
        return false;
    }

    @Override
    public Map<OrdinaryVariable, List<String>> evaluateMultipleSearchContextNodeFormula(List<ContextNode> contextList, List<OVInstance> ovInstances) {
        Debug.setDebug(true);
        HashMap<OrdinaryVariable, List<String>> values = new HashMap<OrdinaryVariable, List<String>>();
        ArrayList<OrdinaryVariable> ovFaultList = new ArrayList<OrdinaryVariable>();
        String formula = "";
        Iterator<ContextNode> iterator = contextList.iterator();
        if (iterator.hasNext()) {
            ContextNode contextNode = iterator.next();
            for (OrdinaryVariable ov : contextNode.getOVFaultForOVInstanceSet(ovInstances)) {
                if (ovFaultList.contains(ov)) continue;
                ovFaultList.add(ov);
                Debug.println("OVFault = " + ov);
            }
        }
        if (ovFaultList.size() == 0) {
            return null;
        }
        formula = String.valueOf(formula) + " all ";
        formula = String.valueOf(formula) + "(";
        for (OrdinaryVariable ov : ovFaultList) {
            formula = String.valueOf(formula) + " ?" + ov.getName();
            values.put(ov, new ArrayList());
        }
        Debug.println("Formula = " + formula);
        formula = String.valueOf(formula) + ")";
        formula = String.valueOf(formula) + "(";
        formula = String.valueOf(formula) + " AND ";
        for (OrdinaryVariable ov : ovFaultList) {
            formula = String.valueOf(formula) + "(";
            formula = String.valueOf(formula) + ov.getValueType().getName() + " ";
            formula = String.valueOf(formula) + " ?" + ov.getName();
            formula = String.valueOf(formula) + ")";
        }
        for (ContextNode context : contextList) {
            Debug.println("Context = " + context);
            Debug.println("Formula = " + formula);
            formula = String.valueOf(formula) + "(";
            NodeFormulaTree formulaTree = context.getFormulaTree();
            formula = String.valueOf(formula) + this.makeOperatorString(formulaTree, ovInstances);
            formula = String.valueOf(formula) + ")";
        }
        formula = String.valueOf(formula) + ")";
        Debug.println("PowerLoom Formula: " + formula);
        PlIterator iterator2 = PLI.sRetrieve((String)formula, (String)this.moduleFindingName, null);
        iterator2.length();
        while (iterator2.nextP()) {
            int i = 0;
            while (i < ovFaultList.size()) {
                values.get(ovFaultList.get(0)).add(PLI.getNthString((Stella_Object)iterator2, (int)i, (Module)this.moduleFinding, (Environment)this.environment));
                ++i;
            }
        }
        return values;
    }

    @Override
    public List<String> evaluateSearchContextNodeFormula(ContextNode context, List<OVInstance> ovInstances) throws OVInstanceFaultException {
        Debug.setDebug(true);
        String formula = "";
        NodeFormulaTree formulaTree = context.getFormulaTree();
        List<OrdinaryVariable> ovFaultList = context.getOVFaultForOVInstanceSet(ovInstances);
        if (ovFaultList.size() > 1) {
            Debug.println("--> OV Fault list grater than 1!");
            throw new OVInstanceFaultException(ovFaultList);
        }
        if (ovFaultList.size() == 0) {
            return null;
        }
        OrdinaryVariable ovFault = ovFaultList.get(0);
        formula = String.valueOf(formula) + " all ";
        formula = String.valueOf(formula) + "(?" + ovFault.getName() + " " + ovFault.getValueType() + ")";
        formula = String.valueOf(formula) + "(";
        formula = String.valueOf(formula) + this.makeOperatorString(formulaTree, ovInstances);
        formula = String.valueOf(formula) + ")";
        Debug.println("Original formula: " + context.getLabel());
        Debug.println("PowerLoom Formula: " + formula);
        PlIterator iterator = PLI.sRetrieve((String)formula, (String)this.moduleFindingName, null);
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.nextP()) {
            result.add(PLI.getNameInModule((Stella_Object)iterator.value, (Module)this.moduleFinding, (Environment)this.environment));
        }
        return result;
    }

    public Map<OrdinaryVariable, List<String>> evaluateSearchContextNodeWithMultipleOVFaultFormula(ContextNode context, List<OVInstance> ovInstances) throws OVInstanceFaultException {
        Map<OrdinaryVariable, List<String>> mapResult = null;
        String formula = "";
        NodeFormulaTree formulaTree = context.getFormulaTree();
        List<OrdinaryVariable> ovFaultList = context.getOVFaultForOVInstanceSet(ovInstances);
        if (ovFaultList.size() == 0) {
            return null;
        }
        return mapResult;
    }

    @Override
    public boolean existEntity(String name) {
        Stella_Object so = PLI.sGetObject((String)name, (String)this.moduleFindingName, (Environment)this.environment);
        return so != null;
    }

    @Override
    public StateLink searchFinding(ResidentNode randomVariable, Collection<OVInstance> listArguments) {
        String finding = "";
        if (randomVariable.getTypeOfStates() == 2) {
            finding = String.valueOf(finding) + randomVariable.getName() + " ";
            for (OVInstance argument : listArguments) {
                finding = String.valueOf(finding) + " " + argument.getEntity().getInstanceName();
            }
            TruthValue value = PLI.sAsk((String)finding, (String)this.moduleFindingName, (Environment)this.environment);
            StateLink exactValue = null;
            if (PLI.isTrue((TruthValue)value)) {
                exactValue = randomVariable.getPossibleValueByName("true");
            } else if (PLI.isFalse((TruthValue)value)) {
                exactValue = randomVariable.getPossibleValueByName("false");
            } else if (PLI.isUnknown((TruthValue)value)) {
                exactValue = null;
            }
            return exactValue;
        }
        finding = String.valueOf(finding) + "all ?x";
        finding = String.valueOf(finding) + "(";
        finding = String.valueOf(finding) + randomVariable.getName();
        for (OVInstance argument : listArguments) {
            finding = String.valueOf(finding) + " " + argument.getEntity().getInstanceName();
        }
        finding = String.valueOf(finding) + " ?x";
        PlIterator iterator = PLI.sRetrieve((String)(finding = String.valueOf(finding) + ")"), (String)this.moduleFindingName, (Environment)this.environment);
        if (iterator.nextP()) {
            String state = PLI.getNthString((Stella_Object)iterator, (int)0, (Module)this.moduleFinding, (Environment)this.environment);
            return randomVariable.getPossibleValueByName(state);
        }
        return null;
    }

    @Override
    public List<String> getEntityByType(String type) {
        ArrayList<String> list = new ArrayList<String>();
        PlIterator iterator = PLI.sGetConceptInstances((String)type, (String)this.moduleFindingName, (Environment)this.environment);
        while (iterator.nextP()) {
            list.add(PLI.getNthString((Stella_Object)iterator, (int)0, (Module)this.moduleFinding, (Environment)this.environment));
        }
        return list;
    }

    private String makeOperatorString(NodeFormulaTree operatorNode, List<OVInstance> ovInstances) {
        String operator = "";
        switch (operatorNode.getTypeNode()) {
            case SIMPLE_OPERATOR: {
                BuiltInRV builtIn = (BuiltInRV)operatorNode.getNodeVariable();
                if (builtIn instanceof BuiltInRVAnd) {
                    operator = String.valueOf(operator) + this.makeBynaryStatement(operatorNode, "AND", ovInstances);
                    break;
                }
                if (builtIn instanceof BuiltInRVOr) {
                    operator = String.valueOf(operator) + this.makeBynaryStatement(operatorNode, "OR", ovInstances);
                    break;
                }
                if (builtIn instanceof BuiltInRVEqualTo) {
                    operator = String.valueOf(operator) + this.makeEqualStatement(operatorNode, " = ", ovInstances);
                    break;
                }
                if (builtIn instanceof BuiltInRVIff) {
                    operator = String.valueOf(operator) + this.makeBynaryStatement(operatorNode, "<=>", ovInstances);
                    break;
                }
                if (builtIn instanceof BuiltInRVImplies) {
                    operator = String.valueOf(operator) + this.makeBynaryStatement(operatorNode, "=>", ovInstances);
                    break;
                }
                if (!(builtIn instanceof BuiltInRVNot)) break;
                operator = String.valueOf(operator) + this.makeUnaryStatement(operatorNode, "NOT", ovInstances);
                break;
            }
            case QUANTIFIER_OPERATOR: {
                BuiltInRV builtIn = (BuiltInRV)operatorNode.getNodeVariable();
                if (builtIn instanceof BuiltInRVExists) {
                    operator = String.valueOf(operator) + this.makeQuantifier(operatorNode, "EXISTS", ovInstances);
                    break;
                }
                if (!(builtIn instanceof BuiltInRVForAll)) break;
                operator = String.valueOf(operator) + this.makeQuantifier(operatorNode, "FORALL", ovInstances);
                break;
            }
            case OPERAND: {
                if (operatorNode.getSubTypeNode() != EnumSubType.NODE) break;
                operator = String.valueOf(operator) + this.makeNodeOperandCase(operatorNode, ovInstances);
                break;
            }
            default: {
                Debug.println("ERROR! type of operator don't found");
            }
        }
        return operator;
    }

    private String makeNodeOperandCase(NodeFormulaTree operatorNode, List<OVInstance> ovInstances) {
        String operator = "";
        ResidentNodePointer node = (ResidentNodePointer)operatorNode.getNodeVariable();
        operator = String.valueOf(operator) + node.getResidentNode().getName();
        for (OrdinaryVariable ordVariable : node.getOrdinaryVariableList()) {
            operator = String.valueOf(operator) + " ";
            OVInstance ovInstance = this.getOVInstanceForOV(ordVariable, ovInstances);
            operator = ovInstance != null ? String.valueOf(operator) + ovInstance.getEntity().getInstanceName() : String.valueOf(operator) + "?" + ordVariable.getName();
        }
        return operator;
    }

    private String makeOperandString(NodeFormulaTree operator, List<OVInstance> ovInstances) {
        String operand;
        block12: {
            operand = "";
            block0 : switch (operator.getTypeNode()) {
                case SIMPLE_OPERATOR: {
                    operand = String.valueOf(operand) + this.makeOperatorString(operator, ovInstances);
                    break;
                }
                case QUANTIFIER_OPERATOR: {
                    operand = String.valueOf(operand) + this.makeOperatorString(operator, ovInstances);
                    break;
                }
                case OPERAND: {
                    switch (operator.getSubTypeNode()) {
                        case OVARIABLE: {
                            OrdinaryVariable ov = (OrdinaryVariable)operator.getNodeVariable();
                            OVInstance ovInstance = this.getOVInstanceForOV(ov, ovInstances);
                            if (ovInstance != null) {
                                operand = String.valueOf(operand) + ovInstance.getEntity().getInstanceName();
                                break block0;
                            }
                            operand = String.valueOf(operand) + "?" + ov.getName();
                            break block0;
                        }
                        case NODE: {
                            ResidentNodePointer node = (ResidentNodePointer)operator.getNodeVariable();
                            operand = String.valueOf(operand) + node.getResidentNode().getName();
                            operand = String.valueOf(operand) + " ";
                            for (OrdinaryVariable ordVariable : node.getOrdinaryVariableList()) {
                                OVInstance ovInstance = this.getOVInstanceForOV(ordVariable, ovInstances);
                                operand = ovInstance != null ? String.valueOf(operand) + ovInstance.getEntity().getInstanceName() : String.valueOf(operand) + "?" + ordVariable.getName();
                                operand = String.valueOf(operand) + " ";
                            }
                            break block12;
                        }
                        case ENTITY: {
                            Entity entity = (Entity)operator.getNodeVariable();
                            operand = String.valueOf(operand) + entity.getName();
                        }
                    }
                }
            }
        }
        return operand;
    }

    private String makeBynaryStatement(NodeFormulaTree node, String conectiveName, List<OVInstance> ovInstances) {
        String retorno = "";
        retorno = String.valueOf(retorno) + conectiveName;
        ArrayList listChildren = (ArrayList)node.getChildren();
        NodeFormulaTree leftOperando = (NodeFormulaTree)listChildren.get(0);
        retorno = String.valueOf(retorno) + "( ";
        retorno = String.valueOf(retorno) + this.makeOperandString(leftOperando, ovInstances);
        retorno = String.valueOf(retorno) + " ) ";
        retorno = String.valueOf(retorno) + "( ";
        NodeFormulaTree rightOperando = (NodeFormulaTree)listChildren.get(1);
        retorno = String.valueOf(retorno) + this.makeOperandString(rightOperando, ovInstances);
        retorno = String.valueOf(retorno) + " ) ";
        return retorno;
    }

    private String makeEqualStatement(NodeFormulaTree node, String conectiveName, List<OVInstance> ovInstances) {
        String retorno = "";
        retorno = String.valueOf(retorno) + conectiveName;
        ArrayList listChildren = (ArrayList)node.getChildren();
        NodeFormulaTree leftOperand = (NodeFormulaTree)listChildren.get(0);
        if (leftOperand.getTypeNode() == EnumType.OPERAND && leftOperand.getSubTypeNode() == EnumSubType.OVARIABLE) {
            retorno = String.valueOf(retorno) + " ";
            retorno = String.valueOf(retorno) + this.makeOperandString(leftOperand, ovInstances);
            retorno = String.valueOf(retorno) + " ";
        } else {
            retorno = String.valueOf(retorno) + " ( ";
            retorno = String.valueOf(retorno) + this.makeOperandString(leftOperand, ovInstances);
            retorno = String.valueOf(retorno) + " ) ";
        }
        NodeFormulaTree rightOperand = (NodeFormulaTree)listChildren.get(1);
        retorno = String.valueOf(retorno) + this.makeOperandString(rightOperand, ovInstances);
        return retorno;
    }

    private String makeUnaryStatement(NodeFormulaTree node, String conectiveName, List<OVInstance> ovInstances) {
        String retorno = "";
        retorno = String.valueOf(retorno) + conectiveName;
        ArrayList listChildren = (ArrayList)node.getChildren();
        retorno = String.valueOf(retorno) + "( ";
        retorno = String.valueOf(retorno) + this.makeOperandString((NodeFormulaTree)listChildren.get(0), ovInstances);
        retorno = String.valueOf(retorno) + " ) ";
        return retorno;
    }

    private String makeQuantifier(NodeFormulaTree node, String name, List<OVInstance> ovInstances) {
        String retorno = "";
        retorno = String.valueOf(retorno) + name;
        List<NodeFormulaTree> listChildren = node.getChildren();
        NodeFormulaTree listExemplares = listChildren.get(0);
        retorno = String.valueOf(retorno) + "(";
        for (NodeFormulaTree exemplar : listExemplares.getChildren()) {
            OrdinaryVariable ov = (OrdinaryVariable)exemplar.getNodeVariable();
            retorno = String.valueOf(retorno) + "?" + ov.getName() + ",";
        }
        if (listExemplares.getChildren().size() > 0) {
            retorno = retorno.substring(0, retorno.length() - 2);
        }
        retorno = String.valueOf(retorno) + ")";
        NodeFormulaTree formula = listChildren.get(1);
        retorno = String.valueOf(retorno) + "(";
        retorno = String.valueOf(retorno) + this.makeOperatorString(formula, ovInstances);
        retorno = String.valueOf(retorno) + ")";
        return retorno;
    }

    private OVInstance getOVInstanceForOV(OrdinaryVariable ov, List<OVInstance> list) {
        for (OVInstance ovi : list) {
            if (!ovi.getOv().equals(ov)) continue;
            return ovi;
        }
        return null;
    }

    private void saveDefinitionsFile(String name) {
        PLI.sSaveModule((String)this.moduleGenerativeName, (String)name, (String)"REPLACE", (Environment)this.environment);
    }

    private void loadDefinitionsFile(String name) {
        PLI.load((String)name, (Environment)this.environment);
    }

    public String executeCommand(String command) {
        return PLI.sEvaluate((String)command, (String)this.moduleFindingName, null).toString();
    }

    @Override
    public void fillFindings(ResidentNode resident) {
        boolean NONBOOLEAN = false;
        boolean ISBOOLEAN = true;
        boolean booleanValue = false;
        String queryString = "";
        int argcount = 0;
        if (resident.getTypeOfStates() != 2) {
            queryString = "( retrieve all ( = ( " + resident.getName().toUpperCase();
            ArrayList argumentList = new ArrayList();
            for (Argument argument : resident.getArgumentList()) {
                queryString = String.valueOf(queryString) + " ?x" + argcount;
                ++argcount;
            }
            queryString = String.valueOf(queryString) + " ) ?x" + argcount + ") ) ";
            Debug.println(this.getClass(), "Quering to PLI: " + queryString);
            Stella_Object sobj = PLI.sEvaluate((String)queryString, (String)this.moduleFindingName, (Environment)this.environment);
            String result = PLI.getNthString((Stella_Object)sobj, (int)0, (Module)this.moduleFinding, (Environment)this.environment);
            Debug.println(this.getClass(), "result..." + result + "...count = " + ++argcount);
            this.parsePLIStringAndFillBooleanFinding(resident, result, false, false);
        } else {
            booleanValue = false;
            queryString = "( retrieve all ( not ( " + resident.getName();
            ArrayList argumentList = new ArrayList();
            for (Argument argument : resident.getArgumentList()) {
                queryString = String.valueOf(queryString) + " ?x" + argcount++;
            }
            queryString = String.valueOf(queryString) + " ) ) ) ";
            Stella_Object sobj = null;
            Object result = null;
            try {
                sobj = PLI.sEvaluate((String)queryString, (String)this.moduleFindingName, (Environment)this.environment);
                if (!sobj.deletedP()) {
                    result = PLI.getNthString((Stella_Object)sobj, (int)0, (Module)this.moduleFinding, (Environment)this.environment);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Debug.println(this.getClass(), "result..." + result + "...count = " + argcount);
            this.parsePLIStringAndFillBooleanFinding(resident, (String)result, true, booleanValue);
            booleanValue = true;
            queryString = "( retrieve all ( " + resident.getName();
            argumentList = new ArrayList();
            for (Argument argument : resident.getArgumentList()) {
                queryString = String.valueOf(queryString) + " ?x" + argcount++;
            }
            queryString = String.valueOf(queryString) + " ) ) ";
            try {
                sobj = PLI.sEvaluate((String)queryString, (String)this.moduleFindingName, (Environment)this.environment);
                if (!sobj.deletedP()) {
                    result = PLI.getNthString((Stella_Object)sobj, (int)0, (Module)this.moduleFinding, (Environment)this.environment);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Debug.println(this.getClass(), "result..." + (String)result + "...count = " + argcount);
            this.parsePLIStringAndFillBooleanFinding(resident, (String)result, true, booleanValue);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<RandomVariableFinding> parsePLIStringAndFillBooleanFinding(ResidentNode resident, String strPLI, boolean isBool, boolean boolValue) {
        tokenizer = new StringTokenizer(strPLI, PowerLoomKB.PLI_TOKEN_SEPARATOR);
        argumentInstances = null;
        arguments = resident.getArgumentList();
        Debug.println(this.getClass(), "input: " + strPLI);
        if (!strPLI.equalsIgnoreCase(PowerLoomKB.PLI_TOKEN_SEPARATOR)) ** GOTO lbl38
        return null;
lbl-1000:
        // 1 sources

        {
            argumentInstances = new ArrayList<ObjectEntityInstance>();
            token = null;
            Debug.println("Arguments:");
            i = 0;
            while (i < arguments.size()) {
                token = tokenizer.nextToken();
                try {
                    instance = resident.getMFrag().getMultiEntityBayesianNetwork().getObjectEntityContainer().getEntityInstanceByName(token);
                    Debug.print(" | " + token);
                    argumentInstances.add(instance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            Debug.println("");
            finding = null;
            possibleValue = null;
            if (!isBool) {
                possibleValue = tokenizer.nextToken();
                Debug.println(this.getClass(), "Possible Value = " + possibleValue);
            }
            try {
                finding = isBool ? new RandomVariableFinding(resident, argumentInstances.toArray(new ObjectEntityInstance[argumentInstances.size()]), resident.getPossibleValueByName(String.valueOf(boolValue)).getState(), resident.getMFrag().getMultiEntityBayesianNetwork()) : new RandomVariableFinding(resident, argumentInstances.toArray(new ObjectEntityInstance[argumentInstances.size()]), resident.getPossibleValueByName(possibleValue).getState(), resident.getMFrag().getMultiEntityBayesianNetwork());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error: " + strPLI + " at " + token);
                continue;
            }
            Debug.println("Finding = " + finding.toString());
            resident.addRandomVariableFinding(finding);
lbl38:
            // 3 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl39:
        // 1 sources

        return resident.getRandomVariableFindingList();
    }
}

