/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.entity;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.prs.mebn.entity.exception.EntityInstanceAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEntityConteiner {
    private List<ObjectEntity> listEntity;
    private List<ObjectEntityInstance> listEntityInstances;
    private TypeContainer typeContainer;
    private int entityNum;

    public ObjectEntityConteiner(TypeContainer _typeConteiner) {
        this.typeContainer = _typeConteiner;
        this.entityNum = 1;
        this.listEntity = new ArrayList<ObjectEntity>();
        this.listEntityInstances = new ArrayList<ObjectEntityInstance>();
    }

    public ObjectEntity createObjectEntity(String name) throws TypeException {
        ObjectEntity objEntity = new ObjectEntity(name, this.typeContainer);
        objEntity.getType().addUserObject(objEntity);
        this.addEntity(objEntity);
        this.plusEntityNum();
        return objEntity;
    }

    private void addEntity(ObjectEntity entity) {
        this.listEntity.add(entity);
    }

    public void removeEntity(ObjectEntity entity) throws Exception {
        entity.delete();
        this.listEntity.remove(entity);
    }

    public List<ObjectEntity> getListEntity() {
        return this.listEntity;
    }

    public ObjectEntity getObjectEntityByName(String name) {
        for (ObjectEntity oe : this.listEntity) {
            if (!oe.getName().equals(name)) continue;
            return oe;
        }
        return null;
    }

    public ObjectEntity getObjectEntityByType(Type type) {
        for (ObjectEntity oe : this.listEntity) {
            if (oe.getType() != type) continue;
            return oe;
        }
        return null;
    }

    public int getEntityNum() {
        return this.entityNum;
    }

    public void setEntityNum(int _entityNum) {
        this.entityNum = _entityNum;
    }

    public void plusEntityNum() {
        ++this.entityNum;
    }

    public List<ObjectEntityInstance> getListEntityInstances() {
        return this.listEntityInstances;
    }

    public void addEntityInstance(ObjectEntityInstance entityInstance) throws EntityInstanceAlreadyExistsException {
        if (this.listEntityInstances.contains(entityInstance)) {
            throw new EntityInstanceAlreadyExistsException();
        }
        this.listEntityInstances.add(entityInstance);
    }

    public void removeEntityInstance(ObjectEntityInstance entityInstance) {
        ObjectEntity object = entityInstance.getInstanceOf();
        object.removeInstance(entityInstance);
        this.listEntityInstances.remove(entityInstance);
    }

    public void clearAllInstances(ObjectEntity entity) {
        this.listEntityInstances.removeAll(entity.getInstanceList());
        entity.removeAllInstances();
    }

    public ObjectEntityInstance getEntityInstanceByName(String name) {
        for (ObjectEntityInstance entity : this.listEntityInstances) {
            if (!entity.getName().equalsIgnoreCase(name)) continue;
            return entity;
        }
        return null;
    }
}

