/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.util.Vector;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.exception.OVDontIsOfTypeExpected;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidentNodePointer {
    private ResidentNode residentNode;
    private OrdinaryVariable[] ordinaryVariableList;
    private Type[] typesOfOrdinaryVariableList;
    private final int numberArguments;
    private Node node;

    public ResidentNodePointer(ResidentNode _residentNode, Node _node) {
        this.residentNode = _residentNode;
        this.node = _node;
        this.residentNode.addResidentNodePointer(this);
        this.numberArguments = this.residentNode.getOrdinaryVariableList().size();
        this.typesOfOrdinaryVariableList = new Type[this.numberArguments];
        this.ordinaryVariableList = new OrdinaryVariable[this.numberArguments];
        this.buildTypeOfOVList();
    }

    public void delete() {
        this.residentNode.removeResidentNodePointer(this);
    }

    private void buildTypeOfOVList() {
        int index = 0;
        for (OrdinaryVariable ov : this.residentNode.getOrdinaryVariableList()) {
            Type type;
            this.typesOfOrdinaryVariableList[index] = type = ov.getValueType();
            type.addUserObject(this);
            ++index;
        }
    }

    public void addOrdinaryVariable(OrdinaryVariable ov, int index) throws OVDontIsOfTypeExpected {
        if (!this.typesOfOrdinaryVariableList[index].equals(ov.getValueType())) {
            throw new OVDontIsOfTypeExpected(this.typesOfOrdinaryVariableList[index].toString());
        }
        this.ordinaryVariableList[index] = ov;
        ov.addIsArgumentOfList(this);
    }

    public void removeOrdinaryVariable(int index) {
        if (this.ordinaryVariableList[index] != null) {
            this.ordinaryVariableList[index].removeIsArgumentOfList(this);
        }
        this.ordinaryVariableList[index] = null;
    }

    public void removeOrdinaryVariable(OrdinaryVariable ov) {
        int i = 0;
        while (i < this.ordinaryVariableList.length) {
            if (this.ordinaryVariableList[i] != null && this.ordinaryVariableList[i].equals(ov)) {
                this.ordinaryVariableList[i] = null;
            }
            ++i;
        }
        if (this.node instanceof InputNode) {
            ((InputNode)this.node).updateLabel();
        } else if (this.node instanceof ContextNode) {
            ((ContextNode)this.node).updateLabel();
        }
    }

    public ResidentNode getResidentNode() {
        return this.residentNode;
    }

    public int getNumberArguments() {
        return this.numberArguments;
    }

    public Vector<OrdinaryVariable> getOrdinaryVariableList() {
        Vector<OrdinaryVariable> vetor = new Vector<OrdinaryVariable>();
        int i = 0;
        while (i < this.ordinaryVariableList.length) {
            vetor.add(i, this.ordinaryVariableList[i]);
            ++i;
        }
        return vetor;
    }

    public int getOrdinaryVariableIndex(OrdinaryVariable ov) {
        int i = 0;
        while (i < this.ordinaryVariableList.length) {
            if (this.ordinaryVariableList[i].equals(ov)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public OrdinaryVariable[] getOrdinaryVariableArray() {
        return this.ordinaryVariableList;
    }

    public Type getTypeOfArgument(int index) {
        return this.typesOfOrdinaryVariableList[index];
    }

    public OrdinaryVariable getArgument(int index) {
        return this.ordinaryVariableList[index];
    }

    public Vector<Type> getTypesOfOrdinaryVariableList() {
        Vector<Type> vetor = new Vector<Type>();
        int i = 0;
        while (i < this.typesOfOrdinaryVariableList.length) {
            vetor.add(i, this.typesOfOrdinaryVariableList[i]);
            ++i;
        }
        return vetor;
    }

    public void setResidentNode(ResidentNode residentNode) {
        this.residentNode = residentNode;
    }
}

