/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import unbbayes.draw.DrawRoundedRectangle;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.mebn.Argument;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.RandomVariableFinding;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityConteiner;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.exception.ArgumentNodeAlreadySetException;
import unbbayes.prs.mebn.exception.OVariableAlreadyExistsInArgumentList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidentNode
extends MultiEntityNode
implements ITabledVariable {
    private static final long serialVersionUID = 1L;
    private List<OrdinaryVariable> ordinaryVariableList;
    private List<ResidentNodePointer> listPointers;
    private List<InputNode> inputInstanceFromList;
    private List<InputNode> inputNodeFatherList;
    private List<ResidentNode> residentNodeFatherList;
    private List<ResidentNode> residentNodeChildList;
    private List<RandomVariableFinding> randomVariableFindingList;
    private MFrag mFrag;
    private String tableFunction;
    private List<StateLink> possibleValueList;
    private DrawRoundedRectangle drawResidentNode;
    private static Color color = new Color(254, 250, 158);
    public static final int OBJECT_ENTITY = 0;
    public static final int CATEGORY_RV_STATES = 1;
    public static final int BOOLEAN_RV_STATES = 2;
    private int typeOfStates = 1;

    public ResidentNode() {
    }

    public ResidentNode(String name, MFrag mFrag) {
        this.listPointers = new ArrayList<ResidentNodePointer>();
        this.ordinaryVariableList = new ArrayList<OrdinaryVariable>();
        this.mFrag = mFrag;
        this.inputInstanceFromList = new ArrayList<InputNode>();
        this.inputNodeFatherList = new ArrayList<InputNode>();
        this.residentNodeFatherList = new ArrayList<ResidentNode>();
        this.residentNodeChildList = new ArrayList<ResidentNode>();
        this.randomVariableFindingList = new ArrayList<RandomVariableFinding>();
        this.possibleValueList = new ArrayList<StateLink>();
        this.setName(name);
        this.updateLabel();
        this.drawResidentNode = new DrawRoundedRectangle(this.position, size);
        this.drawElement.add(this.drawResidentNode);
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    @Override
    public void setSelected(boolean b) {
        this.drawResidentNode.setSelected(b);
        super.setSelected(b);
    }

    public void updateLabel() {
        List<OrdinaryVariable> ordinaryVariableList = this.getOrdinaryVariableList();
        String newLabel = String.valueOf(this.name) + "(";
        for (OrdinaryVariable ov : ordinaryVariableList) {
            newLabel = String.valueOf(newLabel) + ov.getName() + ", ";
        }
        if (ordinaryVariableList.size() > 0) {
            newLabel = newLabel.substring(0, newLabel.length() - 2);
        }
        newLabel = String.valueOf(newLabel) + ")";
        this.setLabel(newLabel);
        for (InputNode inputNode : this.inputInstanceFromList) {
            inputNode.updateLabel();
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.drawResidentNode.setFillColor(ResidentNode.getColor());
        super.paint(graphics);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.updateLabel();
    }

    @Override
    public PotentialTable getPotentialTable() {
        return null;
    }

    @Override
    public MFrag getMFrag() {
        return this.mFrag;
    }

    public String getTableFunction() {
        return this.tableFunction;
    }

    public void setTableFunction(String table) {
        this.tableFunction = table;
    }

    public void addResidentNodePointer(ResidentNodePointer pointer) {
        this.listPointers.add(pointer);
    }

    public void removeResidentNodePointer(ResidentNodePointer pointer) {
        this.listPointers.remove(pointer);
    }

    public void addResidentNodeChild(ResidentNode node) {
        this.residentNodeChildList.add(node);
        node.addResidentNodeFather(this);
    }

    private void addResidentNodeFather(ResidentNode father) {
        this.residentNodeFatherList.add(father);
    }

    protected void addInputNodeFather(InputNode father) {
        this.inputNodeFatherList.add(father);
    }

    protected void addInputInstanceFromList(InputNode instance) {
        this.inputInstanceFromList.add(instance);
    }

    public List<ResidentNode> getResidentNodeFatherList() {
        return this.residentNodeFatherList;
    }

    public List<InputNode> getInputNodeFatherList() {
        return this.inputNodeFatherList;
    }

    public List<ResidentNode> getResidentNodeChildList() {
        return this.residentNodeChildList;
    }

    public List<InputNode> getInputInstanceFromList() {
        return this.inputInstanceFromList;
    }

    private void removeResidentNodeFather(ResidentNode node) {
        this.residentNodeFatherList.remove(node);
    }

    protected void removeInputNodeFatherList(InputNode node) {
        this.inputNodeFatherList.remove(node);
    }

    public void removeResidentNodeChildList(ResidentNode node) {
        this.residentNodeChildList.remove(node);
        node.removeResidentNodeFather(this);
    }

    public void removeInputInstanceFromList(InputNode node) {
        this.inputInstanceFromList.remove(node);
        try {
            node.setInputInstanceOf((ResidentNode)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRandomVariableFinding(RandomVariableFinding finding) {
        this.randomVariableFindingList.add(finding);
    }

    public void removeRandomVariableFinding(RandomVariableFinding finding) {
        this.randomVariableFindingList.remove(finding);
    }

    public boolean containsRandomVariableFinding(RandomVariableFinding finding) {
        return this.randomVariableFindingList.contains(finding);
    }

    public void cleanRandomVariableFindingList() {
        this.randomVariableFindingList.clear();
    }

    public List<RandomVariableFinding> getRandomVariableFindingList() {
        return this.randomVariableFindingList;
    }

    public void addArgument(OrdinaryVariable ov, boolean addArgument) throws ArgumentNodeAlreadySetException, OVariableAlreadyExistsInArgumentList {
        if (this.ordinaryVariableList.contains(ov)) {
            throw new OVariableAlreadyExistsInArgumentList();
        }
        int position = this.ordinaryVariableList.size();
        this.ordinaryVariableList.add(ov);
        ov.addIsOVariableOfList(this);
        if (addArgument) {
            Argument argument = new Argument("", this);
            argument.setArgNumber(position + 1);
            argument.setOVariable(ov);
            this.addArgument(argument);
        }
        for (InputNode inputNode : this.inputInstanceFromList) {
            inputNode.updateResidentNodePointer();
        }
        this.updateLabel();
    }

    public void removeArgument(OrdinaryVariable ov) {
        this.ordinaryVariableList.remove(ov);
        int indexOfArgumentRemoved = 0;
        for (Argument argument : super.getArgumentList()) {
            if (argument.getOVariable() != ov) continue;
            indexOfArgumentRemoved = argument.getArgNumber();
            super.removeArgument(argument);
            break;
        }
        for (Argument argument : super.getArgumentList()) {
            if (argument.getArgNumber() <= indexOfArgumentRemoved) continue;
            argument.setArgNumber(argument.getArgNumber() - 1);
        }
        this.updateLabel();
    }

    public boolean containsArgument(OrdinaryVariable ov) {
        return this.ordinaryVariableList.contains(ov);
    }

    public List<OrdinaryVariable> getOrdinaryVariableList() {
        return this.ordinaryVariableList;
    }

    public OrdinaryVariable getOrdinaryVariableByName(String name) {
        for (OrdinaryVariable ov : this.ordinaryVariableList) {
            if (!ov.getName().equals(name)) continue;
            return ov;
        }
        return null;
    }

    public int getOrdinaryVariableIndex(OrdinaryVariable ov) {
        int i = 0;
        while (i < this.ordinaryVariableList.size()) {
            if (this.ordinaryVariableList.get(i).equals(ov)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<OrdinaryVariable> getOrdinaryVariablesOrdereables() {
        ArrayList<OrdinaryVariable> ovOrdereableList = new ArrayList<OrdinaryVariable>();
        ObjectEntityConteiner oeConteiner = this.getMFrag().getMultiEntityBayesianNetwork().getObjectEntityContainer();
        for (OrdinaryVariable ov : this.getOrdinaryVariableList()) {
            ObjectEntity oe = oeConteiner.getObjectEntityByType(ov.getValueType());
            if (!oe.isOrdereable()) continue;
            ovOrdereableList.add(ov);
        }
        return ovOrdereableList;
    }

    public int getTypeOfStates() {
        return this.typeOfStates;
    }

    public void setTypeOfStates(int typeOfStates) {
        this.typeOfStates = typeOfStates;
    }

    public StateLink addPossibleValueLink(Entity possibleValue) {
        StateLink value = new StateLink(possibleValue);
        this.possibleValueList.add(value);
        return value;
    }

    @Override
    public void removePossibleValueByName(String possibleValue) {
        for (StateLink value : this.possibleValueList) {
            if (!value.getState().getName().equals(possibleValue)) continue;
            this.possibleValueList.remove(value);
            return;
        }
    }

    @Override
    public void removeAllPossibleValues() {
        this.possibleValueList.clear();
    }

    @Override
    public boolean existsPossibleValueByName(String possibleValue) {
        for (StateLink value : this.possibleValueList) {
            if (!value.getState().getName().equals(possibleValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPossibleValue(Entity entity) {
        for (StateLink value : this.possibleValueList) {
            if (value.getState() != entity) continue;
            return true;
        }
        return false;
    }

    public StateLink getPossibleValueByName(String possibleValue) {
        for (Entity value : this.getPossibleValueListIncludingEntityInstances()) {
            if (!value.getName().equalsIgnoreCase(possibleValue)) continue;
            return new StateLink(value);
        }
        return null;
    }

    public List<StateLink> getPossibleValueLinkList() {
        return this.possibleValueList;
    }

    @Override
    public List<Entity> getPossibleValueList() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (StateLink link : this.possibleValueList) {
            ret.add(link.getState());
        }
        return ret;
    }

    @Override
    public int getPossibleValueIndex(String stateName) {
        int index = 0;
        for (Entity entity : this.getPossibleValueListIncludingEntityInstances()) {
            if (entity.getName().equalsIgnoreCase(stateName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<Entity> getPossibleValueListIncludingEntityInstances() {
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (StateLink link : this.possibleValueList) {
            if (link.getState() instanceof ObjectEntity) {
                for (ObjectEntityInstance instance : ((ObjectEntity)link.getState()).getInstanceList()) {
                    ret.add(instance);
                }
                continue;
            }
            ret.add(link.getState());
        }
        return ret;
    }

    public void delete() {
        while (!this.ordinaryVariableList.isEmpty()) {
            this.ordinaryVariableList.remove(0).removeIsOVariableOfList(this);
        }
        while (!this.inputInstanceFromList.isEmpty()) {
            this.inputInstanceFromList.remove(0).setInputInstanceOf();
        }
        while (!this.inputNodeFatherList.isEmpty()) {
            this.inputNodeFatherList.remove(0).removeResidentNodeChild(this);
        }
        while (!this.residentNodeFatherList.isEmpty()) {
            ResidentNode father = this.residentNodeFatherList.get(0);
            father.removeResidentNodeChildList(this);
            this.mFrag.removeEdgeByNodes(father, this);
        }
        while (!this.residentNodeChildList.isEmpty()) {
            ResidentNode child = this.residentNodeChildList.get(0);
            this.removeResidentNodeChildList(child);
            this.mFrag.removeEdgeByNodes(this, child);
        }
        this.mFrag.removeResidentNode(this);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

