/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.Argument;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.util.SerializablePoint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEntityNode
extends Node {
    private static final long serialVersionUID = -5435895970322752281L;
    private MFrag mFrag;
    private List<Argument> argumentList = new ArrayList<Argument>();
    private List<MultiEntityNode> innerTermOfList = new ArrayList<MultiEntityNode>();
    private List<MultiEntityNode> innerTermFromList = new ArrayList<MultiEntityNode>();
    private List<Entity> possibleValueList = new ArrayList<Entity>();
    private static final Point DEFAULT_MEBN_SIZE = new Point(100, 20);
    protected static SerializablePoint2D size = new SerializablePoint2D(DEFAULT_MEBN_SIZE.getX(), DEFAULT_MEBN_SIZE.getY());
    private static Color color;

    @Override
    public int getType() {
        return 0;
    }

    public MFrag getMFrag() {
        return this.mFrag;
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    public static Point getDefaultSize() {
        return new Point(100, 20);
    }

    public void removeFromMFrag() {
        this.mFrag = null;
    }

    public void addArgument(Argument arg) {
        this.argumentList.add(arg);
    }

    public void removeArgument(Argument arg) {
        this.argumentList.remove(arg);
    }

    public void addInnerTermOfList(MultiEntityNode instance) {
        this.innerTermOfList.add(instance);
    }

    public void addInnerTermFromList(MultiEntityNode instance) {
        this.innerTermFromList.add(instance);
    }

    public void addPossibleValue(Entity possibleValue) {
        this.possibleValueList.add(possibleValue);
    }

    public void removePossibleValueByName(String possibleValue) {
        for (Entity value : this.possibleValueList) {
            if (!value.getName().equals(possibleValue)) continue;
            this.possibleValueList.remove(value);
            return;
        }
    }

    public void removeAllPossibleValues() {
        this.possibleValueList.clear();
    }

    public boolean existsPossibleValueByName(String possibleValue) {
        for (Entity value : this.possibleValueList) {
            if (value.getName().compareTo(possibleValue) != 0) continue;
            return true;
        }
        return false;
    }

    public List<Argument> getArgumentList() {
        return this.argumentList;
    }

    public List<MultiEntityNode> getInnerTermOfList() {
        return this.innerTermOfList;
    }

    public List<MultiEntityNode> getInnerTermFromList() {
        return this.innerTermFromList;
    }

    public List<Entity> getPossibleValueList() {
        return this.possibleValueList;
    }

    public boolean hasPossibleValue(Entity entity) {
        return this.possibleValueList.contains(entity);
    }

    public boolean hasPossibleValue(String stateName) {
        for (Entity entity : this.possibleValueList) {
            if (!entity.getName().equals(stateName)) continue;
            return true;
        }
        return false;
    }

    public int getPossibleValueIndex(String stateName) {
        int index = 0;
        for (Entity entity : this.possibleValueList) {
            if (entity.getName().equals(stateName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean hasAllOVs(OrdinaryVariable ... ovs) {
        boolean found = false;
        OrdinaryVariable[] ordinaryVariableArray = ovs;
        int n = ovs.length;
        int n2 = 0;
        while (n2 < n) {
            OrdinaryVariable ov = ordinaryVariableArray[n2];
            found = false;
            for (Argument arg : this.getArgumentList()) {
                if (arg.isSimpleArgRelationship()) {
                    if (!arg.getOVariable().equals(ov)) continue;
                    found = true;
                    break;
                }
                found = arg.getArgumentTerm().hasAllOVs(ovs);
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Collection<OrdinaryVariable> fillAlreadyCountedOVs(Collection<OrdinaryVariable> alreadyCountedOVs) {
        OrdinaryVariable ov = null;
        MultiEntityNode node = null;
        for (Argument arg : this.getArgumentList()) {
            if (arg.isSimpleArgRelationship()) {
                ov = arg.getOVariable();
                if (alreadyCountedOVs.contains(ov)) continue;
                alreadyCountedOVs.add(ov);
                continue;
            }
            node = arg.getArgumentTerm();
            if (node == null) continue;
            node.fillAlreadyCountedOVs(alreadyCountedOVs);
        }
        return alreadyCountedOVs;
    }

    public int getAllOVCount() {
        Collection<OrdinaryVariable> ovs = new ArrayList<OrdinaryVariable>();
        ovs = this.fillAlreadyCountedOVs(ovs);
        return ovs.size();
    }

    public int getSimpleArgRelationshipCount() {
        int ret = 0;
        for (Argument arg : this.getArgumentList()) {
            if (!arg.isSimpleArgRelationship()) continue;
            ++ret;
        }
        return ret;
    }

    public static Point2D.Double getSize() {
        return size;
    }
}

