/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import unbbayes.draw.DrawFlatPentagon;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.exception.InvalidContextNodeFormulaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextNode
extends MultiEntityNode {
    private static final long serialVersionUID = 8186266877724939663L;
    private MFrag mFrag;
    private List<ContextNode> innerTermOfList;
    private List<ContextNode> innerTermFromList;
    private NodeFormulaTree formulaTree;
    private boolean isValidFormula = false;
    private Set<OrdinaryVariable> variableSet;
    private Set<OrdinaryVariable> exemplarSet;
    private boolean formulaTreeTurned;
    private String formula;
    private static Color color = new Color(176, 252, 131);
    private DrawFlatPentagon drawContextNode;

    public ContextNode(String name, MFrag mFrag) {
        this.setName(name);
        this.setLabel(" ");
        this.mFrag = mFrag;
        this.innerTermOfList = new ArrayList<ContextNode>();
        this.innerTermFromList = new ArrayList<ContextNode>();
        ContextNode.size.x = 100.0;
        ContextNode.size.y = 20.0;
        this.drawContextNode = new DrawFlatPentagon(this.position, size);
        this.drawElement.add(this.drawContextNode);
    }

    public void setMFrag(MFrag frag) {
        this.mFrag = frag;
    }

    @Override
    public MFrag getMFrag() {
        return this.mFrag;
    }

    public NodeFormulaTree getFormulaTree() {
        return this.formulaTree;
    }

    public void setFormulaTree(NodeFormulaTree formulaTree) {
        this.formulaTree = formulaTree;
        this.variableSet = formulaTree.getVariableList();
        this.exemplarSet = formulaTree.getExemplarList();
        this.isValidFormula = formulaTree.isFormulaValida();
        this.updateLabel();
    }

    private String getFormulaForTree(NodeFormulaTree formulaTree) {
        return formulaTree.getFormulaViewText();
    }

    public boolean isAvaliableForOVInstanceSet(Collection<OVInstance> ovInstanceSet) {
        for (OrdinaryVariable ov : this.variableSet) {
            boolean found = false;
            for (OVInstance ovInstance : ovInstanceSet) {
                if (!ov.equals(ovInstance.getOv())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public List<OrdinaryVariable> getOVFaultForOVInstanceSet(Collection<OVInstance> ovInstanceSet) {
        ArrayList<OrdinaryVariable> ret = new ArrayList<OrdinaryVariable>();
        for (OrdinaryVariable ov : this.variableSet) {
            boolean found = false;
            for (OVInstance ovInstance : ovInstanceSet) {
                if (!ov.equals(ovInstance.getOv())) continue;
                found = true;
                break;
            }
            if (found) continue;
            ret.add(ov);
        }
        return ret;
    }

    private boolean isParametListCorrect(OrdinaryVariable ov, Collection<OVInstance> ovInstanceSet) {
        boolean found = false;
        for (OVInstance ovInstance : ovInstanceSet) {
            if (!ov.equals(ovInstance.getOv())) continue;
            if (ovInstance.getEntity() != null) {
                found = true;
                break;
            }
            return false;
        }
        return found;
    }

    public boolean isFormulaComplexValida(Collection<OVInstance> ovInstanceList) {
        List<NodeFormulaTree> children;
        if (this.formulaTree.getTypeNode() == EnumType.SIMPLE_OPERATOR && this.formulaTree.getSubTypeNode() == EnumSubType.EQUALTO && (children = this.formulaTree.getChildren()).size() == 2) {
            NodeFormulaTree leftChildren = children.get(0);
            if (leftChildren.getTypeNode() == EnumType.OPERAND && leftChildren.getSubTypeNode() == EnumSubType.NODE) {
                ResidentNodePointer pointer = (ResidentNodePointer)leftChildren.getNodeVariable();
                for (OrdinaryVariable ov : pointer.getOrdinaryVariableList()) {
                    if (this.isParametListCorrect(ov, ovInstanceList)) continue;
                    return false;
                }
            } else {
                return false;
            }
            NodeFormulaTree rigthChildren = children.get(1);
            return rigthChildren.getTypeNode() == EnumType.OPERAND && rigthChildren.getSubTypeNode() == EnumSubType.OVARIABLE;
        }
        return false;
    }

    public ResidentNode getNodeSearch(Collection<OVInstance> ovInstanceList) throws InvalidContextNodeFormulaException {
        if (!this.isFormulaComplexValida(ovInstanceList)) {
            throw new InvalidContextNodeFormulaException();
        }
        NodeFormulaTree leftChildren = this.formulaTree.getChildren().get(0);
        ResidentNodePointer pointer = (ResidentNodePointer)leftChildren.getNodeVariable();
        return pointer.getResidentNode();
    }

    public OrdinaryVariable getFreeVariable() {
        List<NodeFormulaTree> children = this.formulaTree.getChildren();
        NodeFormulaTree rigthChildren = children.get(1);
        return (OrdinaryVariable)rigthChildren.getNodeVariable();
    }

    public boolean isAvaliableComplexContextNode(Collection<OVInstance> ovInstanceSet) {
        return true;
    }

    public void delete() {
        for (ContextNode node : this.innerTermFromList) {
            node.removeInnerTermOfList(node);
        }
        for (ContextNode node : this.innerTermOfList) {
            if (!this.mFrag.containsContextNode(node)) {
                node.delete();
                continue;
            }
            node.removeInnerTermFromList(node);
        }
        this.mFrag.removeContextNode(this);
    }

    public void removeInnerTermOfList(ContextNode contextNode) {
        this.innerTermOfList.remove(contextNode);
    }

    public void removeInnerTermFromList(ContextNode contextNode) {
        this.innerTermFromList.remove(contextNode);
    }

    public void addInnerTermOfList(ContextNode contextNode) {
        this.innerTermOfList.add(contextNode);
    }

    public void addInnerTermFromList(ContextNode contextNode) {
        this.innerTermFromList.add(contextNode);
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    @Override
    public void setSelected(boolean b) {
        this.drawContextNode.setSelected(b);
        super.setSelected(b);
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.drawContextNode.setFillColor(ContextNode.getColor());
        super.paint(graphics);
    }

    public String updateLabel() {
        String label = this.formulaTree != null ? this.formulaTree.getFormulaViewText() : " ";
        this.setLabel(label);
        return label;
    }

    @Override
    public String toString() {
        return this.formulaTree.getFormulaViewText();
    }

    public static long getSerialVersionUID() {
        return 8186266877724939663L;
    }

    public DrawFlatPentagon getDrawContextNode() {
        return this.drawContextNode;
    }

    public void setDrawContextNode(DrawFlatPentagon drawContextNode) {
        this.drawContextNode = drawContextNode;
    }

    public Set<OrdinaryVariable> getExemplarList() {
        return this.exemplarSet;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean isFormulaTreeTurned() {
        return this.formulaTreeTurned;
    }

    public void setFormulaTreeTurned(boolean formulaTreeTurned) {
        this.formulaTreeTurned = formulaTreeTurned;
    }

    public void setInnerTermFromList(List<ContextNode> innerTermFromList) {
        this.innerTermFromList = innerTermFromList;
    }

    public void setInnerTermOfList(List<ContextNode> innerTermOfList) {
        this.innerTermOfList = innerTermOfList;
    }

    public boolean isValidFormula() {
        return this.isValidFormula;
    }

    public void setValidFormula(boolean isValidFormula) {
        this.isValidFormula = isValidFormula;
    }

    public Set<OrdinaryVariable> getVariableList() {
        return this.variableSet;
    }

    public static void setColor(Color color) {
        ContextNode.color = color;
    }
}

