/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import unbbayes.gui.HierarchicTree;
import unbbayes.io.NetworkCompilationLogManager;
import unbbayes.prs.Edge;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.ProbabilisticTable;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.id.DecisionNode;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleEntityNetwork
extends Network
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.bn.resources.BnResources");
    protected HierarchicTree hierarchicTree;
    protected boolean firstInitialization;
    protected ArrayList<Node> decisionNodes;
    protected double radius;
    protected NetworkCompilationLogManager logManager;
    protected List<Edge> arcosMarkov = new ArrayList<Edge>();
    protected boolean createLog;
    protected ArrayList<Node> oe;
    protected ArrayList<Node> copiaNos;
    protected List<Edge> copiaArcos;
    protected JunctionTree junctionTree;

    public SingleEntityNetwork(String name) {
        super(name);
        this.logManager = new NetworkCompilationLogManager();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.hierarchicTree = new HierarchicTree(model);
    }

    public ArrayList<Node> getDescriptionNodes() {
        ArrayList<Node> descriptionNodes = new ArrayList<Node>();
        int size = this.nodeList.size();
        int i = 0;
        while (i < size) {
            Node node = this.getNodeAt(i);
            if (node.getType() == 0 && node.getInformationType() == 3) {
                descriptionNodes.add(node);
            }
            ++i;
        }
        return descriptionNodes;
    }

    public ArrayList<Node> getExplanationNodes() {
        ArrayList<Node> explanationNodes = new ArrayList<Node>();
        int size = this.nodeList.size();
        int i = 0;
        while (i < size) {
            Node node = this.getNodeAt(i);
            if (node.getType() == 0 && node.getInformationType() == 4) {
                explanationNodes.add(node);
            }
            ++i;
        }
        return explanationNodes;
    }

    protected void makeAdjacentsListForNodeListElements() {
        this.clearAdjacents();
        int qnos = 0;
        while (qnos < this.nodeList.size()) {
            ((Node)this.nodeList.get(qnos)).makeAdjacents();
            ++qnos;
        }
    }

    protected void makeAdjacents() {
        Edge auxArco;
        this.clearAdjacents();
        int z = this.arcosMarkov.size() - 1;
        while (z >= 0) {
            auxArco = this.arcosMarkov.get(z);
            auxArco.getOriginNode().getAdjacents().add(auxArco.getDestinationNode());
            auxArco.getDestinationNode().getAdjacents().add(auxArco.getOriginNode());
            --z;
        }
        z = this.copiaArcos.size() - 1;
        while (z >= 0) {
            auxArco = this.copiaArcos.get(z);
            if (auxArco.getDestinationNode().getType() == 1) {
                this.copiaArcos.remove(z);
            } else {
                auxArco.getOriginNode().getAdjacents().add(auxArco.getDestinationNode());
                auxArco.getDestinationNode().getAdjacents().add(auxArco.getOriginNode());
            }
            --z;
        }
    }

    protected void clearAdjacents() {
        int size = this.nodeList.size();
        int qnos = 0;
        while (qnos < size) {
            ((Node)this.nodeList.get(qnos)).clearAdjacents();
            ++qnos;
        }
    }

    public final void verifyCycles() throws Exception {
        int nodeSize = this.nodeList.size();
        char[] visited = new char[nodeSize];
        int[] pi = new int[nodeSize];
        int i = 0;
        while (i < nodeSize) {
            this.dfsCycle(i, visited, pi);
            ++i;
        }
    }

    private void dfsCycle(int nodeIndex, char[] visited, int[] pi) throws Exception {
        if (visited[nodeIndex] != '\u0000') {
            if (visited[nodeIndex] == '\u0001') {
                throw new Exception(String.valueOf(resource.getString("CicleNetException")) + " " + this.createPath(nodeIndex, nodeIndex, pi, true));
            }
            return;
        }
        visited[nodeIndex] = '\u0001';
        Node node = (Node)this.nodeList.get(nodeIndex);
        int i = node.getChildren().size() - 1;
        while (i >= 0) {
            int newIndex = this.getNodeIndex(node.getChildren().get(i).getName());
            pi[newIndex] = nodeIndex;
            this.dfsCycle(newIndex, visited, pi);
            --i;
        }
        visited[nodeIndex] = 2;
    }

    private String createPath(int currentIndex, int nodeIndex, int[] pi, boolean first) {
        if (currentIndex == nodeIndex && !first) {
            return ((Node)this.nodeList.get(currentIndex)).getName();
        }
        return String.valueOf(this.createPath(pi[currentIndex], nodeIndex, pi, false)) + " " + ((Node)this.nodeList.get(currentIndex)).getName();
    }

    public final void verifyConectivity() throws Exception {
        ArrayList<Node> visitados = new ArrayList<Node>(this.nodeList.size());
        if (this.nodeList.size() <= 1) {
            return;
        }
        this.makeAdjacentsListForNodeListElements();
        this.dfsConnectivity((Node)this.nodeList.get(0), visitados);
        this.clearAdjacents();
        if (visitados.size() != this.nodeList.size()) {
            throw new Exception(resource.getString("DisconectedNetException"));
        }
    }

    private void dfsConnectivity(Node no, List<Node> visitados) {
        visitados.add(no);
        int i = 0;
        while (i < no.getAdjacents().size()) {
            Node aux = no.getAdjacents().get(i);
            if (!visitados.contains(aux)) {
                this.dfsConnectivity(aux, visitados);
            }
            ++i;
        }
    }

    protected void moralize() {
        Edge auxArco;
        int sizeArcos;
        this.clearAdjacents();
        if (this.createLog) {
            this.logManager.append(resource.getString("moralizeLabel"));
        }
        this.arcosMarkov.clear();
        this.copiaArcos = (ArrayList)SetToolkit.clone(this.edgeList);
        int i = sizeArcos = this.copiaArcos.size() - 1;
        while (i >= 0) {
            auxArco = this.copiaArcos.get(i);
            if (auxArco.getDestinationNode().getType() == 2) {
                this.copiaArcos.remove(i);
            }
            --i;
        }
        int sizeNos = this.nodeList.size();
        int n = 0;
        while (n < sizeNos) {
            Node auxNo = (Node)this.nodeList.get(n);
            if (auxNo.getType() != 2 && auxNo.getParents().size() > 1) {
                int sizePais = auxNo.getParents().size();
                int j = 0;
                while (j < sizePais - 1) {
                    Node auxPai1 = auxNo.getParents().get(j);
                    int k = j + 1;
                    while (k < sizePais) {
                        Node auxPai2 = auxNo.getParents().get(k);
                        if (this.hasEdge(auxPai1, auxPai2, this.copiaArcos) == -1 && this.hasEdge(auxPai1, auxPai2, this.arcosMarkov) == -1) {
                            auxArco = new Edge(auxPai1, auxPai2);
                            if (this.createLog) {
                                this.logManager.append(String.valueOf(auxPai1.getName()) + " - " + auxPai2.getName() + "\n");
                            }
                            this.arcosMarkov.add(auxArco);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++n;
        }
        this.makeAdjacents();
        if (this.createLog) {
            this.logManager.append("\n");
        }
    }

    public void setCreateLog(boolean createLog) {
        this.createLog = createLog;
    }

    protected void compileJT(JunctionTree jt) throws Exception {
        this.resetEvidences();
        this.junctionTree = jt;
        this.cliques();
        this.arvoreForte();
        this.sortCliqueNodes();
        this.associateCliques();
        this.junctionTree.initBeliefs();
        int sizeNos = this.copiaNos.size();
        int c = 0;
        while (c < sizeNos) {
            int c2;
            Node auxNode = this.copiaNos.get(c);
            int menor = Integer.MAX_VALUE;
            if (auxNode.getType() == 0) {
                int sizeSeparadores = this.junctionTree.getSeparatorsSize();
                c2 = 0;
                while (c2 < sizeSeparadores) {
                    Separator auxSep = this.junctionTree.getSeparatorAt(c2);
                    if (auxSep.getNodes().contains(auxNode) && auxSep.getPotentialTable().tableSize() < menor) {
                        ((ProbabilisticNode)auxNode).setAssociatedClique(auxSep);
                        menor = auxSep.getPotentialTable().tableSize();
                    }
                    ++c2;
                }
            }
            if (menor == Integer.MAX_VALUE) {
                int sizeCliques = this.junctionTree.getCliques().size();
                c2 = 0;
                while (c2 < sizeCliques) {
                    Clique auxClique = this.junctionTree.getCliques().get(c2);
                    if (auxClique.getNodes().contains(auxNode) && auxClique.getPotentialTable().tableSize() < menor) {
                        if (auxNode.getType() != 0) {
                            ((DecisionNode)auxNode).setAssociatedClique(auxClique);
                            break;
                        }
                        ((ProbabilisticNode)auxNode).setAssociatedClique(auxClique);
                        menor = auxClique.getPotentialTable().tableSize();
                    }
                    ++c2;
                }
            }
            ++c;
        }
        this.updateMarginais();
        if (this.createLog) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    SingleEntityNetwork.this.makeLog();
                    System.out.println("**Log ended**");
                }
            });
            t.setPriority(1);
            t.start();
        }
    }

    public void resetEvidences() {
        int size = this.getNodesCopy().size();
        int i = 0;
        while (i < size) {
            ((TreeVariable)this.getNodesCopy().get(i)).resetEvidence();
            ++i;
        }
    }

    public boolean isID() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() == 2 || ((Node)this.nodeList.get(i)).getType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isHybridBN() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() == 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isBN() {
        int i = 0;
        while (i < this.nodeList.size()) {
            if (((Node)this.nodeList.get(i)).getType() != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void updateMarginais() {
        int i = 0;
        while (i < this.copiaNos.size()) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(i);
            if (node.getStatesSize() != 0) {
                node.marginal();
            }
            ++i;
        }
    }

    protected void cliques() {
        Clique auxClique2;
        int j;
        Clique auxClique;
        ArrayList<Clique> listaCliques = new ArrayList<Clique>();
        int sizeNos = this.copiaNos.size();
        int i = 0;
        while (i < sizeNos) {
            Node auxNo = this.copiaNos.get(i);
            int e = this.oe.indexOf(auxNo);
            auxClique = new Clique();
            auxClique.getNodes().add(auxNo);
            int sizeAdjacentes = auxNo.getAdjacents().size();
            j = 0;
            while (j < sizeAdjacentes) {
                Node auxNo2 = auxNo.getAdjacents().get(j);
                if (this.oe.indexOf(auxNo2) > e) {
                    auxClique.getNodes().add(auxNo2);
                }
                ++j;
            }
            listaCliques.add(auxClique);
            ++i;
        }
        boolean haTroca = true;
        while (haTroca) {
            haTroca = false;
            i = 0;
            while (i < listaCliques.size() - 1) {
                auxClique = (Clique)listaCliques.get(i);
                auxClique2 = (Clique)listaCliques.get(i + 1);
                if (auxClique.getNodes().size() > auxClique2.getNodes().size()) {
                    listaCliques.set(i + 1, auxClique);
                    listaCliques.set(i, auxClique2);
                    haTroca = true;
                }
                ++i;
            }
        }
        int sizeCliques = listaCliques.size();
        i = 0;
        while (i < sizeCliques) {
            block9: {
                auxClique = (Clique)listaCliques.get(i);
                j = i + 1;
                while (j < sizeCliques) {
                    auxClique2 = (Clique)listaCliques.get(j);
                    if (!auxClique2.getNodes().containsAll(auxClique.getNodes())) {
                        ++j;
                        continue;
                    }
                    break block9;
                }
                this.junctionTree.getCliques().add(auxClique);
            }
            ++i;
        }
        listaCliques.clear();
    }

    protected void sortCliqueNodes() {
        Node node2;
        Node node1;
        int i;
        boolean haTroca;
        List<Clique> listaCliques = this.junctionTree.getCliques();
        boolean isID = this.isID();
        int k = 0;
        while (k < listaCliques.size()) {
            Clique clique = listaCliques.get(k);
            ArrayList<Node> nosClique = clique.getNodes();
            haTroca = true;
            while (haTroca) {
                haTroca = false;
                i = 0;
                while (i < nosClique.size() - 1) {
                    node1 = nosClique.get(i);
                    node2 = nosClique.get(i + 1);
                    if (isID) {
                        if (this.oe.indexOf(node1) > this.oe.indexOf(node2)) {
                            nosClique.set(i + 1, node1);
                            nosClique.set(i, node2);
                            haTroca = true;
                        }
                    } else if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nosClique.set(i + 1, node1);
                        nosClique.set(i, node2);
                        haTroca = true;
                    }
                    ++i;
                }
            }
            ++k;
        }
        k = this.junctionTree.getSeparatorsSize() - 1;
        while (k >= 0) {
            Separator separator = this.junctionTree.getSeparatorAt(k);
            ArrayList<Node> nosSeparator = separator.getNodes();
            haTroca = true;
            while (haTroca) {
                haTroca = false;
                i = 0;
                while (i < nosSeparator.size() - 1) {
                    node1 = nosSeparator.get(i);
                    node2 = nosSeparator.get(i + 1);
                    if (node1.getName().compareToIgnoreCase(node2.getName()) > 0) {
                        nosSeparator.set(i + 1, node1);
                        nosSeparator.set(i, node2);
                        haTroca = true;
                    }
                    ++i;
                }
            }
            --k;
        }
    }

    protected void makeLog() {
        long in = System.currentTimeMillis();
        try {
            this.logManager.finishLog(this.junctionTree, this.nodeList);
            if (this.id != null) {
                this.logManager.writeToDisk(String.valueOf(this.id) + ".txt", false);
            } else {
                this.logManager.writeToDisk("aj.txt", false);
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        System.out.println("GERACAO DO ARQUIVO LOG em " + (System.currentTimeMillis() - in) + " ms");
    }

    protected void associateCliques() {
        int c;
        PotentialTable auxUtilTab;
        PotentialTable auxTabPot;
        Clique auxClique;
        Clique cliqueMin = null;
        int i = this.junctionTree.getCliques().size() - 1;
        while (i >= 0) {
            auxClique = this.junctionTree.getCliques().get(i);
            auxTabPot = auxClique.getPotentialTable();
            auxUtilTab = auxClique.getUtilityTable();
            int sizeNos = auxClique.getNodes().size();
            int c2 = 0;
            while (c2 < sizeNos) {
                auxTabPot.addVariable(auxClique.getNodes().get(c2));
                auxUtilTab.addVariable(auxClique.getNodes().get(c2));
                ++c2;
            }
            --i;
        }
        int k = this.junctionTree.getSeparatorsSize() - 1;
        while (k >= 0) {
            Separator auxSep = this.junctionTree.getSeparatorAt(k);
            auxTabPot = auxSep.getPotentialTable();
            auxUtilTab = auxSep.getUtilityTable();
            int sizeNos = auxSep.getNodes().size();
            c = 0;
            while (c < sizeNos) {
                auxTabPot.addVariable(auxSep.getNodes().get(c));
                auxUtilTab.addVariable(auxSep.getNodes().get(c));
                ++c;
            }
            --k;
        }
        int sizeNos = this.nodeList.size();
        int n = 0;
        while (n < sizeNos) {
            if (((Node)this.nodeList.get(n)).getType() != 2) {
                int min = Integer.MAX_VALUE;
                Node auxNo = (Node)this.nodeList.get(n);
                int sizeCliques = this.junctionTree.getCliques().size();
                c = 0;
                while (c < sizeCliques) {
                    auxClique = this.junctionTree.getCliques().get(c);
                    if (auxClique.getPotentialTable().tableSize() < min && auxClique.getNodes().containsAll(auxNo.getParents()) && (auxNo.getType() != 0 || auxClique.getNodes().contains(auxNo))) {
                        cliqueMin = auxClique;
                        min = cliqueMin.getPotentialTable().tableSize();
                    }
                    ++c;
                }
                if (auxNo.getType() == 0) {
                    cliqueMin.getAssociatedProbabilisticNodes().add(auxNo);
                } else {
                    cliqueMin.getAssociatedUtilityNodes().add(auxNo);
                }
            }
            ++n;
        }
    }

    protected void arvoreForte() {
        ArrayList<Node> alpha = new ArrayList<Node>();
        int i = this.oe.size() - 1;
        while (i >= 0) {
            alpha.add(this.oe.get(i));
            --i;
        }
        if (this.copiaNos.size() > 1) {
            Clique auxClique;
            int sizeCliques = this.junctionTree.getCliques().size();
            int i2 = 0;
            while (i2 < sizeCliques) {
                int ndx;
                auxClique = this.junctionTree.getCliques().get(i2);
                ArrayList<Node> listaNos = SetToolkit.clone(auxClique.getNodes());
                while ((ndx = this.getCliqueIndex(listaNos, alpha)) <= 0 && listaNos.size() > 1) {
                }
                if (ndx < 0) {
                    ndx = 0;
                }
                auxClique.setIndex(ndx);
                listaNos.clear();
                ++i2;
            }
            alpha.clear();
            Comparator<Clique> comparador = new Comparator<Clique>(){

                @Override
                public int compare(Clique o1, Clique o2) {
                    Clique c1 = o1;
                    Clique c2 = o2;
                    if (c1.getIndex() > c2.getIndex()) {
                        return 1;
                    }
                    if (c1.getIndex() < c2.getIndex()) {
                        return -1;
                    }
                    return 0;
                }
            };
            Collections.sort(this.junctionTree.getCliques(), comparador);
            auxClique = this.junctionTree.getCliques().get(0);
            ArrayList<Node> uni = SetToolkit.clone(auxClique.getNodes());
            int sizeCliques1 = this.junctionTree.getCliques().size();
            int i3 = 1;
            while (i3 < sizeCliques1) {
                auxClique = this.junctionTree.getCliques().get(i3);
                ArrayList<Node> inter = SetToolkit.intersection(auxClique.getNodes(), uni);
                int j = 0;
                while (j < i3) {
                    Clique auxClique2 = this.junctionTree.getCliques().get(j);
                    if (auxClique2.getNodes().containsAll(inter)) {
                        Separator sep = new Separator(auxClique2, auxClique);
                        sep.setNodes(inter);
                        this.junctionTree.addSeparator(sep);
                        ArrayList<Node> auxList = SetToolkit.union(auxClique.getNodes(), uni);
                        uni.clear();
                        uni = auxList;
                        break;
                    }
                    ++j;
                }
                ++i3;
            }
        }
    }

    protected int getCliqueIndex(ArrayList<Node> listaNos, ArrayList<Node> alpha) {
        int ndx;
        Node auxNo;
        Node noMax = null;
        ArrayList<Node> auxList = null;
        int mx = -1;
        int sizeNos = listaNos.size();
        int i = 0;
        while (i < sizeNos) {
            auxNo = listaNos.get(i);
            ndx = alpha.indexOf(auxNo);
            if (mx < ndx) {
                mx = ndx;
                noMax = auxNo;
            }
            ++i;
        }
        listaNos.remove(noMax);
        auxNo = listaNos.get(0);
        ArrayList<Node> vizinhos = SetToolkit.clone(auxNo.getAdjacents());
        int sizeNos1 = listaNos.size();
        int i2 = 1;
        while (i2 < sizeNos1) {
            auxNo = listaNos.get(i2);
            auxList = SetToolkit.intersection(vizinhos, auxNo.getAdjacents());
            vizinhos.clear();
            vizinhos = auxList;
            ++i2;
        }
        vizinhos.remove(noMax);
        ndx = 0;
        int sizeVizinhos = vizinhos.size();
        int i3 = 0;
        while (i3 < sizeVizinhos) {
            auxNo = vizinhos.get(i3);
            if (!listaNos.contains(auxNo) && alpha.indexOf(auxNo) <= mx) {
                ndx = mx;
                break;
            }
            ++i3;
        }
        return ndx;
    }

    protected boolean minimumWeightElimination(ArrayList<Node> auxNos) {
        boolean algum = true;
        while (algum) {
            algum = false;
            int i = auxNos.size() - 1;
            while (i >= 0) {
                Node auxNo = auxNos.get(i);
                if (!this.cordas(auxNo)) {
                    int j = auxNo.getAdjacents().size() - 1;
                    while (j >= 0) {
                        Node v = auxNo.getAdjacents().get(j);
                        v.getAdjacents().remove(auxNo);
                        --j;
                    }
                    auxNos.remove(auxNo);
                    algum = true;
                    this.oe.add(auxNo);
                    if (this.createLog) {
                        this.logManager.append("\t" + this.oe.size() + " " + auxNo.getName() + "\n");
                    }
                }
                --i;
            }
        }
        if (auxNos.size() > 0) {
            Node auxNo = this.weight(auxNos);
            this.oe.add(auxNo);
            if (this.createLog) {
                this.logManager.append("\t" + this.oe.size() + " " + auxNo.getName() + "\n");
            }
            this.elimine(auxNo, auxNos);
            return true;
        }
        return false;
    }

    private void elimine(Node no, ArrayList<Node> auxNos) {
        Node auxNo1;
        int i = no.getAdjacents().size() - 1;
        while (i > 0) {
            auxNo1 = no.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNo2 = no.getAdjacents().get(j);
                if (!auxNo2.getAdjacents().contains(auxNo1)) {
                    Edge auxArco = new Edge(auxNo1, auxNo2);
                    if (this.createLog) {
                        this.logManager.append(String.valueOf(auxNo1.getName()) + resource.getString("linkedName") + auxNo2.getName() + "\n");
                    }
                    this.arcosMarkov.add(auxArco);
                    auxNo1.getAdjacents().add(auxNo2);
                    auxNo2.getAdjacents().add(auxNo1);
                    System.out.println(auxArco);
                }
                --j;
            }
            --i;
        }
        i = no.getAdjacents().size() - 1;
        while (i >= 0) {
            auxNo1 = no.getAdjacents().get(i);
            auxNo1.getAdjacents().remove(no);
            --i;
        }
        auxNos.remove(no);
    }

    private Node weight(ArrayList<Node> auxNos) {
        Node noMin = null;
        double pmin = Double.MAX_VALUE;
        int i = auxNos.size() - 1;
        while (i >= 0) {
            Node auxNo = auxNos.get(i);
            double p = Math.log(auxNo.getStatesSize());
            int j = auxNo.getAdjacents().size() - 1;
            while (j >= 0) {
                Node v = auxNo.getAdjacents().get(j);
                p += Math.log(v.getStatesSize());
                --j;
            }
            if (p < pmin) {
                pmin = p;
                noMin = auxNo;
            }
            --i;
        }
        return noMin;
    }

    private boolean cordas(Node no) {
        if (no.getAdjacents().size() < 2) {
            return false;
        }
        int i = no.getAdjacents().size() - 1;
        while (i > 0) {
            Node auxNo1 = no.getAdjacents().get(i);
            int j = i - 1;
            while (j >= 0) {
                Node auxNo2 = no.getAdjacents().get(j);
                if (!auxNo2.getAdjacents().contains(auxNo1)) {
                    return true;
                }
                --j;
            }
            --i;
        }
        return false;
    }

    protected void verifyConsistency() throws Exception {
        if (this.nodeList.size() != 0) {
            this.nodeIndexes.clear();
            int i = this.nodeList.size() - 1;
            while (i >= 0) {
                this.nodeIndexes.put(((Node)this.nodeList.get(i)).getName(), new Integer(i));
                --i;
            }
            boolean erro = false;
            StringBuffer sb = new StringBuffer();
            try {
                this.verifyUtility();
            }
            catch (Exception e) {
                erro = true;
                sb.append(e.getMessage());
            }
            try {
                this.verifyCycles();
            }
            catch (Exception e) {
                erro = true;
                sb.append(String.valueOf('\n') + e.getMessage());
            }
            try {
                this.verifyConectivity();
            }
            catch (Exception e) {
                erro = true;
                sb.append(String.valueOf('\n') + e.getMessage());
            }
            try {
                this.verifyPotentialTables();
            }
            catch (Exception e) {
                erro = true;
                sb.append(String.valueOf('\n') + e.getMessage());
            }
            try {
                this.sortDecisions();
            }
            catch (Exception e) {
                erro = true;
                sb.append(String.valueOf('\n') + e.getMessage());
            }
            if (erro) {
                throw new Exception(sb.toString());
            }
        }
    }

    public HierarchicTree getHierarchicTree() {
        return this.hierarchicTree;
    }

    public void setHierarchicTree(HierarchicTree hierarchicTree) {
        this.hierarchicTree = hierarchicTree;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    protected void verifyPotentialTables() throws Exception {
        int sizeNos = this.nodeList.size();
        int c = 0;
        while (c < sizeNos) {
            Node auxNo = (Node)this.nodeList.get(c);
            if (auxNo.getType() == 0) {
                ProbabilisticNode auxVP = (ProbabilisticNode)auxNo;
                ProbabilisticTable auxTabPot = (ProbabilisticTable)auxVP.getPotentialTable();
                auxTabPot.verifyConsistency();
            }
            ++c;
        }
    }

    protected void verifyUtility() throws Exception {
        int sizeNos = this.nodeList.size();
        int i = 0;
        while (i < sizeNos) {
            Node aux = (Node)this.nodeList.get(i);
            if (aux.getType() == 1 && aux.getChildren().size() != 0) {
                throw new Exception(String.valueOf(resource.getString("variableName")) + aux + resource.getString("hasChildName"));
            }
            ++i;
        }
    }

    protected void sortDecisions() throws Exception {
        Node aux;
        this.decisionNodes = new ArrayList();
        int sizeNos = this.nodeList.size();
        int i = 0;
        while (i < sizeNos) {
            if (((Node)this.nodeList.get(i)).getType() == 2) {
                this.decisionNodes.add((Node)this.nodeList.get(i));
            }
            ++i;
        }
        ArrayList<Node> fila = new ArrayList<Node>();
        fila.ensureCapacity(this.nodeList.size());
        int sizeDecisao = this.decisionNodes.size();
        int i2 = 0;
        while (i2 < sizeDecisao) {
            boolean[] visitados = new boolean[this.nodeList.size()];
            aux = this.decisionNodes.get(i2);
            fila.clear();
            fila.add(aux);
            while (fila.size() != 0) {
                Node aux2 = (Node)fila.remove(0);
                visitados[this.nodeList.indexOf((Object)aux2)] = true;
                int sizeFilhos = aux2.getChildren().size();
                int k = 0;
                while (k < sizeFilhos) {
                    Node aux3 = aux2.getChildren().get(k);
                    if (!visitados[this.nodeList.indexOf(aux3)]) {
                        if (aux3.getType() == 2 && !aux.getAdjacents().contains(aux3)) {
                            aux.getAdjacents().add(aux3);
                        }
                        fila.add(aux3);
                    }
                    ++k;
                }
            }
            ++i2;
        }
        boolean haTroca = true;
        while (haTroca) {
            haTroca = false;
            int i3 = 0;
            while (i3 < this.decisionNodes.size() - 1) {
                Node node1 = this.decisionNodes.get(i3);
                Node node2 = this.decisionNodes.get(i3 + 1);
                if (node1.getAdjacents().size() < node2.getAdjacents().size()) {
                    this.decisionNodes.set(i3 + 1, node1);
                    this.decisionNodes.set(i3, node2);
                    haTroca = true;
                }
                ++i3;
            }
        }
        int sizeDecisao1 = this.decisionNodes.size();
        int i4 = 0;
        while (i4 < sizeDecisao1) {
            System.out.print(this.decisionNodes.get(i4) + " ");
            ++i4;
        }
        System.out.println();
        i4 = 0;
        while (i4 < this.decisionNodes.size()) {
            aux = this.decisionNodes.get(i4);
            if (aux.getAdjacents().size() != this.decisionNodes.size() - i4 - 1) {
                throw new Exception(resource.getString("DecisionOrderException"));
            }
            ++i4;
        }
        this.clearAdjacents();
    }

    public ArrayList<Node> getNodesCopy() {
        if (this.copiaNos == null) {
            this.copiaNos = (ArrayList)this.nodeList.clone();
        }
        return this.copiaNos;
    }

    public void resetNodesCopy() {
        this.copiaNos = (ArrayList)this.nodeList.clone();
    }

    public String getLog() {
        return this.logManager.getLog();
    }

    public boolean isCreateLog() {
        return this.createLog;
    }

    public void updateEvidences() throws Exception {
        int sizeNos = this.copiaNos.size();
        int c = 0;
        while (c < sizeNos) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(c);
            node.updateEvidences();
            ++c;
        }
        try {
            this.junctionTree.consistency();
        }
        catch (Exception e) {
            this.initialize();
            throw e;
        }
        this.updateMarginais();
    }

    public void initialize() throws Exception {
        this.resetEvidences();
        this.junctionTree.initBeliefs();
        if (this.firstInitialization) {
            this.updateMarginais();
            this.copyMarginal();
            this.firstInitialization = false;
        } else {
            this.restoreMarginais();
        }
    }

    protected void copyMarginal() {
        int i = 0;
        while (i < this.copiaNos.size()) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(i);
            node.copyMarginal();
            ++i;
        }
    }

    protected void restoreMarginais() {
        int i = 0;
        while (i < this.copiaNos.size()) {
            TreeVariable node = (TreeVariable)this.copiaNos.get(i);
            node.restoreMarginal();
            ++i;
        }
    }

    public void setFirstInitialization(boolean firstInitialization) {
        this.firstInitialization = firstInitialization;
    }

    public float PET() {
        return this.junctionTree.getN();
    }
}

