/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.xmlbif.version4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.xml.sax.InputSource;
import unbbayes.gui.HierarchicTree;
import unbbayes.io.exception.LoadException;
import unbbayes.io.xmlbif.version4.xmlclasses.BIF;
import unbbayes.io.xmlbif.version4.xmlclasses.BIFType;
import unbbayes.io.xmlbif.version4.xmlclasses.ObjectFactory;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBIFIO {
    public static void loadXML(File input, SingleEntityNetwork pn) throws LoadException, IOException, JAXBException {
        InputSource isource = new InputSource(new FileInputStream(input));
        JAXBContext context = JAXBContext.newInstance((String)"unbbayes.io.xmlbif.version4.xmlclasses");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setValidating(true);
        BIF bif = (BIF)unmarshaller.unmarshal(isource);
        BIFType.HEADERType header = (BIFType.HEADERType)bif.getHEADER().get(0);
        pn.setName(header.getNAME());
        BIFType.STATICPROPERTYType staticProperty = (BIFType.STATICPROPERTYType)bif.getSTATICPROPERTY().get(0);
        pn.setRadius(Double.parseDouble(staticProperty.getNODESIZE()) / 2.0);
        UtilityNode.setColor(staticProperty.getCOLORUTILITY());
        DecisionNode.setColor(staticProperty.getCOLORDECISION());
        ProbabilisticNode.setDescriptionColor(staticProperty.getCOLORPROBDESCRIPTION());
        ProbabilisticNode.setExplanationColor(staticProperty.getCOLORPROBEXPLANATION());
        BIFType.HIERARCHYType hierarchy = (BIFType.HIERARCHYType)bif.getHIERARCHY().get(0);
        if (((ArrayList)hierarchy.getROOT()).size() > 0) {
            DefaultMutableTreeNode root = XMLBIFIO.loadHierarchicTree(hierarchy);
            DefaultTreeModel model = new DefaultTreeModel(root);
            HierarchicTree hierarchicTree = new HierarchicTree(model);
            pn.setHierarchicTree(hierarchicTree);
        }
        BIFType.NETWORKType network = (BIFType.NETWORKType)bif.getNETWORK().get(0);
        BIFType.NETWORKType.VARIABLESType variables = (BIFType.NETWORKType.VARIABLESType)network.getVARIABLES().get(0);
        ArrayList vars = (ArrayList)variables.getVAR();
        int i = 0;
        while (i < vars.size()) {
            pn.addNode(XMLBIFIO.makeNode((BIFType.NETWORKType.VARIABLESType.VARType)vars.get(i)));
            ++i;
        }
        ArrayList utilities = (ArrayList)variables.getUTILITY();
        i = 0;
        while (i < utilities.size()) {
            pn.addNode(XMLBIFIO.makeNodeUtility((BIFType.NETWORKType.VARIABLESType.UTILITYType)utilities.get(i)));
            ++i;
        }
        ArrayList decision = (ArrayList)variables.getDECISION();
        i = 0;
        while (i < decision.size()) {
            pn.addNode(XMLBIFIO.makeNodeDecision((BIFType.NETWORKType.VARIABLESType.DECISIONType)decision.get(i)));
            ++i;
        }
        BIFType.NETWORKType.POTENTIALType potential = (BIFType.NETWORKType.POTENTIALType)network.getPOTENTIAL().get(0);
        ArrayList lpot = (ArrayList)potential.getPOT();
        i = 0;
        while (i < lpot.size()) {
            BIFType.NETWORKType.POTENTIALType.POTType pot = (BIFType.NETWORKType.POTENTIALType.POTType)lpot.get(i);
            BIFType.NETWORKType.POTENTIALType.POTType.PRIVATEType privatet = (BIFType.NETWORKType.POTENTIALType.POTType.PRIVATEType)pot.getPRIVATE().get(0);
            Node childNode = pn.getNode(privatet.getNAME());
            BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType condset = (BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType)pot.getCONDSET().get(0);
            ArrayList lcondlen = (ArrayList)condset.getCONDLEM();
            int j = 0;
            while (j < lcondlen.size()) {
                BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType.CONDLEMType condlen = (BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType.CONDLEMType)lcondlen.get(j);
                String parent = condlen.getNAME();
                Node parentNode = pn.getNode(parent);
                Edge auxEdge = new Edge(parentNode, childNode);
                try {
                    pn.addEdge(auxEdge);
                }
                catch (InvalidParentException e) {
                    throw new LoadException(e.getMessage());
                }
                ++j;
            }
            if (childNode.getType() != 2) {
                BIFType.NETWORKType.POTENTIALType.POTType.DPISType dpis = (BIFType.NETWORKType.POTENTIALType.POTType.DPISType)pot.getDPIS().get(0);
                ArrayList ldpi = (ArrayList)dpis.getDPI();
                PotentialTable table = ((ITabledVariable)((Object)childNode)).getPotentialTable();
                int statesSize = table.getVariableAt(0).getStatesSize();
                int num = table.tableSize() / statesSize;
                int indiceLDpis = 0;
                int m = 0;
                while (m < num) {
                    int offset = m * statesSize;
                    int n = 0;
                    while (n < statesSize) {
                        BIFType.NETWORKType.POTENTIALType.POTType.DPISType.DPIType dpi = (BIFType.NETWORKType.POTENTIALType.POTType.DPISType.DPIType)ldpi.get(n + indiceLDpis);
                        float value = Float.parseFloat(dpi.getValue());
                        table.setValue(offset + n, value);
                        ++n;
                    }
                    indiceLDpis += statesSize;
                    ++m;
                }
            }
            ++i;
        }
    }

    public static void saveXML(FileWriter arqoutput, SingleEntityNetwork net) throws JAXBException {
        PrintWriter arq = new PrintWriter(arqoutput);
        ObjectFactory of = new ObjectFactory();
        BIF bif = of.createBIF();
        BIFType.HEADERType header = of.createBIFTypeHEADERType();
        header.setNAME(net.getName());
        header.setVERSION(1);
        header.setCREATOR("UnBBayes");
        bif.getHEADER().add(header);
        BIFType.STATICPROPERTYType staticProperty = of.createBIFTypeSTATICPROPERTYType();
        staticProperty.setNODESIZE("" + (int)net.getRadius() * 2);
        staticProperty.setCOLORUTILITY(UtilityNode.getColor().getRGB());
        staticProperty.setCOLORDECISION(DecisionNode.getColor().getRGB());
        staticProperty.setCOLORPROBDESCRIPTION(ProbabilisticNode.getDescriptionColor().getRGB());
        staticProperty.setCOLORPROBEXPLANATION(ProbabilisticNode.getExplanationColor().getRGB());
        bif.getSTATICPROPERTY().add(staticProperty);
        HierarchicTree ht = net.getHierarchicTree();
        BIFType.HIERARCHYType hierarchy = of.createBIFTypeHIERARCHYType();
        TreeModel model = ht.getModel();
        TreeNode root = (TreeNode)model.getRoot();
        XMLBIFIO.processTreeNode(root, model, hierarchy);
        bif.getHIERARCHY().add(hierarchy);
        BIFType.NETWORKType network = of.createBIFTypeNETWORKType();
        XMLBIFIO.writeBifNetwork(network, net);
        bif.getNETWORK().add(network);
        JAXBContext context = JAXBContext.newInstance((String)"unbbayes.io.xmlclasses");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"US-ASCII");
        marshaller.marshal((Object)bif, (Writer)arq);
    }

    private static void writeBifNetwork(BIFType.NETWORKType bifNetwork, SingleEntityNetwork net) throws JAXBException {
        ObjectFactory of = new ObjectFactory();
        BIFType.NETWORKType.VARIABLESType networkVariables = of.createBIFTypeNETWORKTypeVARIABLESType();
        int i = 0;
        while (i < net.getNodeCount()) {
            Object statename;
            Node node = net.getNodeAt(i);
            if (node.getType() == 0) {
                BIFType.NETWORKType.VARIABLESType.VARType var = of.createBIFTypeNETWORKTypeVARIABLESTypeVARType();
                var.setNAME(node.getName());
                var.setTYPE("discrete");
                var.setXPOS((int)node.getPosition().getX());
                var.setYPOS((int)node.getPosition().getY());
                var.setLABEL(node.getDescription());
                int j = 0;
                while (j < node.getStatesSize()) {
                    statename = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeSTATENAMEType();
                    statename.setValue(node.getStateAt(j));
                    var.getSTATENAME().add(statename);
                    ++j;
                }
                if (node.getInformationType() == 4) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType metaphore = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHOREType();
                    String explanationDescription = node.getExplanationDescription();
                    metaphore.getDESCRIPTION().add(explanationDescription);
                    ArrayMap<String, ExplanationPhrase> arrayMap = node.getPhrasesMap();
                    int size = arrayMap.size();
                    ArrayList<String> keys = arrayMap.getKeys();
                    int k = 0;
                    while (k < size) {
                        String key = keys.get(k);
                        ExplanationPhrase explanationPhrase = arrayMap.get(key);
                        switch (explanationPhrase.getEvidenceType()) {
                            case 2: {
                                BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.COMPLEMENTARYType complementary = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHORETypeCOMPLEMENTARYType();
                                complementary.setNAME(explanationPhrase.getNode());
                                complementary.setCOMMENTS(explanationPhrase.getPhrase());
                                metaphore.getCOMPLEMENTARY().add(complementary);
                                break;
                            }
                            case 3: {
                                BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.EXCLUDENTType excludent = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHORETypeEXCLUDENTType();
                                excludent.setNAME(explanationPhrase.getNode());
                                excludent.setCOMMENTS(explanationPhrase.getPhrase());
                                metaphore.getEXCLUDENT().add(excludent);
                                break;
                            }
                            case 1: {
                                BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.ESSENCIALType essencial = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHORETypeESSENCIALType();
                                essencial.setNAME(explanationPhrase.getNode());
                                essencial.setCOMMENTS(explanationPhrase.getPhrase());
                                metaphore.getESSENCIAL().add(essencial);
                                break;
                            }
                            case 0: {
                                BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.TRIGGERType trigger = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHORETypeTRIGGERType();
                                trigger.setNAME(explanationPhrase.getNode());
                                trigger.setCOMMENTS(explanationPhrase.getPhrase());
                                metaphore.getTRIGGER().add(trigger);
                                break;
                            }
                            case 4: {
                                BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.NAType na = of.createBIFTypeNETWORKTypeVARIABLESTypeVARTypeMETAPHORETypeNAType();
                                na.setNAME(explanationPhrase.getNode());
                                na.setCOMMENTS(explanationPhrase.getPhrase());
                                metaphore.getNA().add(na);
                            }
                        }
                        ++k;
                    }
                    var.getMETAPHORE().add(metaphore);
                }
                networkVariables.getVAR().add(var);
            } else if (node.getType() == 2) {
                BIFType.NETWORKType.VARIABLESType.DECISIONType decision = of.createBIFTypeNETWORKTypeVARIABLESTypeDECISIONType();
                decision.setNAME(node.getName());
                decision.setLABEL(node.getDescription());
                decision.setTYPE("discrete");
                decision.setXPOS((int)node.getPosition().getX());
                decision.setYPOS((int)node.getPosition().getY());
                int j = 0;
                while (j < node.getStatesSize()) {
                    statename = of.createBIFTypeNETWORKTypeVARIABLESTypeDECISIONTypeSTATENAMEType();
                    statename.setValue(node.getStateAt(j));
                    decision.getSTATENAME().add(statename);
                    ++j;
                }
                networkVariables.getDECISION().add(decision);
            } else {
                BIFType.NETWORKType.VARIABLESType.UTILITYType utility = of.createBIFTypeNETWORKTypeVARIABLESTypeUTILITYType();
                utility.setNAME(node.getName());
                utility.setLABEL(node.getDescription());
                utility.setTYPE("discrete");
                utility.setXPOS((int)node.getPosition().getX());
                utility.setYPOS((int)node.getPosition().getY());
                int j = 0;
                while (j < node.getStatesSize()) {
                    statename = of.createBIFTypeNETWORKTypeVARIABLESTypeUTILITYTypeSTATENAMEType();
                    statename.setValue(node.getStateAt(j));
                    utility.getSTATENAME().add(statename);
                    ++j;
                }
                networkVariables.getUTILITY().add(utility);
            }
            ++i;
        }
        bifNetwork.getVARIABLES().add(networkVariables);
        BIFType.NETWORKType.STRUCTUREType networkStructure = of.createBIFTypeNETWORKTypeSTRUCTUREType();
        int i2 = 0;
        while (i2 < net.getEdges().size()) {
            BIFType.NETWORKType.STRUCTUREType.ARCType arc = of.createBIFTypeNETWORKTypeSTRUCTURETypeARCType();
            Edge edge = net.getEdges().get(i2);
            arc.setPARENT(edge.getOriginNode().getName());
            arc.setCHILD(edge.getDestinationNode().getName());
            networkStructure.getARC().add(arc);
            ++i2;
        }
        bifNetwork.getSTRUCTURE().add(networkStructure);
        BIFType.NETWORKType.POTENTIALType networkPotential = of.createBIFTypeNETWORKTypePOTENTIALType();
        int i3 = 0;
        while (i3 < net.getNodeCount()) {
            BIFType.NETWORKType.POTENTIALType.POTType pot = of.createBIFTypeNETWORKTypePOTENTIALTypePOTType();
            Node node = net.getNodeAt(i3);
            BIFType.NETWORKType.POTENTIALType.POTType.PRIVATEType potPrivate = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypePRIVATEType();
            potPrivate.setNAME(node.getName());
            pot.getPRIVATE().add(potPrivate);
            if (node.getType() == 2) {
                ArrayList<Node> auxListVa = node.getParents();
                int sizeVa = auxListVa.size();
                BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType condset = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeCONDSETType();
                int j = 0;
                while (j < sizeVa) {
                    Node aux = auxListVa.get(j);
                    BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType.CONDLEMType condlen = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeCONDSETTypeCONDLEMType();
                    condlen.setNAME(aux.getName());
                    condset.getCONDLEM().add(condlen);
                    ++j;
                }
                pot.getCONDSET().add(condset);
                networkPotential.getPOT().add(pot);
            } else {
                BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType condset = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeCONDSETType();
                PotentialTable table = ((ITabledVariable)((Object)node)).getPotentialTable();
                int j = 1;
                while (j < table.variableCount()) {
                    BIFType.NETWORKType.POTENTIALType.POTType.CONDSETType.CONDLEMType condlen = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeCONDSETTypeCONDLEMType();
                    Node parent = table.getVariableAt(j);
                    condlen.setNAME(parent.getName());
                    condset.getCONDLEM().add(condlen);
                    ++j;
                }
                pot.getCONDSET().add(condset);
                BIFType.NETWORKType.POTENTIALType.POTType.DPISType dpis = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeDPISType();
                int statesSize = node.getStatesSize();
                int num = table.tableSize() / statesSize;
                int j2 = 0;
                while (j2 < num) {
                    int offset = j2 * statesSize;
                    int k = 0;
                    while (k < statesSize) {
                        BIFType.NETWORKType.POTENTIALType.POTType.DPISType.DPIType dpi = of.createBIFTypeNETWORKTypePOTENTIALTypePOTTypeDPISTypeDPIType();
                        dpi.setINDEXES(j2);
                        dpi.setValue("" + table.getValue(offset + k));
                        dpis.getDPI().add(dpi);
                        ++k;
                    }
                    ++j2;
                }
                pot.getDPIS().add(dpis);
                networkPotential.getPOT().add(pot);
            }
            ++i3;
        }
        bifNetwork.getPOTENTIAL().add(networkPotential);
    }

    private static Node makeNode(BIFType.NETWORKType.VARIABLESType.VARType var) {
        ProbabilisticNode node = new ProbabilisticNode();
        node.setName(var.getNAME());
        node.setDescription(var.getLABEL());
        node.setPosition(var.getXPOS(), var.getYPOS());
        ArrayList lStatename = (ArrayList)var.getSTATENAME();
        int j = 0;
        while (j < lStatename.size()) {
            BIFType.NETWORKType.VARIABLESType.VARType.STATENAMEType statename = (BIFType.NETWORKType.VARIABLESType.VARType.STATENAMEType)lStatename.get(j);
            node.appendState(statename.getValue());
            ++j;
        }
        ArrayList lmetaphore = (ArrayList)var.getMETAPHORE();
        if (!lmetaphore.isEmpty()) {
            ArrayList lna;
            ArrayList ltrigger;
            ArrayList lessencial;
            ArrayList lexcludent;
            node.setInformationType(4);
            BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType metaphore = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType)lmetaphore.get(0);
            node.setExplanationDescription("" + metaphore.getDESCRIPTION().get(0));
            ArrayList lcomplementary = (ArrayList)metaphore.getCOMPLEMENTARY();
            if (!lcomplementary.isEmpty()) {
                int m = 0;
                while (m < lcomplementary.size()) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.COMPLEMENTARYType complementary = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.COMPLEMENTARYType)lcomplementary.get(m);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(complementary.getNAME());
                    explanationPhrase.setEvidenceType(2);
                    explanationPhrase.setPhrase(complementary.getCOMMENTS());
                    node.addExplanationPhrase(explanationPhrase);
                    ++m;
                }
            }
            if (!(lexcludent = (ArrayList)metaphore.getEXCLUDENT()).isEmpty()) {
                int m = 0;
                while (m < lexcludent.size()) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.EXCLUDENTType excludent = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.EXCLUDENTType)lexcludent.get(m);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(excludent.getNAME());
                    explanationPhrase.setEvidenceType(3);
                    explanationPhrase.setPhrase(excludent.getCOMMENTS());
                    node.addExplanationPhrase(explanationPhrase);
                    ++m;
                }
            }
            if (!(lessencial = (ArrayList)metaphore.getESSENCIAL()).isEmpty()) {
                int m = 0;
                while (m < lessencial.size()) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.ESSENCIALType essencial = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.ESSENCIALType)lessencial.get(m);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(essencial.getNAME());
                    explanationPhrase.setEvidenceType(1);
                    explanationPhrase.setPhrase(essencial.getCOMMENTS());
                    node.addExplanationPhrase(explanationPhrase);
                    ++m;
                }
            }
            if (!(ltrigger = (ArrayList)metaphore.getTRIGGER()).isEmpty()) {
                int m = 0;
                while (m < ltrigger.size()) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.TRIGGERType trigger = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.TRIGGERType)ltrigger.get(m);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(trigger.getNAME());
                    explanationPhrase.setEvidenceType(0);
                    explanationPhrase.setPhrase(trigger.getCOMMENTS());
                    node.addExplanationPhrase(explanationPhrase);
                    ++m;
                }
            }
            if (!(lna = (ArrayList)metaphore.getNA()).isEmpty()) {
                int m = 0;
                while (m < lna.size()) {
                    BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.NAType na = (BIFType.NETWORKType.VARIABLESType.VARType.METAPHOREType.NAType)lna.get(m);
                    ExplanationPhrase explanationPhrase = new ExplanationPhrase();
                    explanationPhrase.setNode(na.getNAME());
                    explanationPhrase.setEvidenceType(4);
                    explanationPhrase.setPhrase(na.getCOMMENTS());
                    node.addExplanationPhrase(explanationPhrase);
                    ++m;
                }
            }
        }
        PotentialTable auxTabPot = node.getPotentialTable();
        auxTabPot.addVariable(node);
        return node;
    }

    private static Node makeNodeUtility(BIFType.NETWORKType.VARIABLESType.UTILITYType utility) {
        UtilityNode node = new UtilityNode();
        node.setName(utility.getNAME());
        node.setDescription(utility.getLABEL());
        node.setPosition(utility.getXPOS(), utility.getYPOS());
        ArrayList lStatename = (ArrayList)utility.getSTATENAME();
        int j = 0;
        while (j < lStatename.size()) {
            BIFType.NETWORKType.VARIABLESType.UTILITYType.STATENAMEType statename = (BIFType.NETWORKType.VARIABLESType.UTILITYType.STATENAMEType)lStatename.get(j);
            node.appendState(statename.getValue());
            ++j;
        }
        PotentialTable auxTabPot = node.getPotentialTable();
        auxTabPot.addVariable(node);
        return node;
    }

    private static Node makeNodeDecision(BIFType.NETWORKType.VARIABLESType.DECISIONType decision) {
        DecisionNode node = new DecisionNode();
        node.setName(decision.getNAME());
        node.setDescription(decision.getLABEL());
        node.setPosition(decision.getXPOS(), decision.getYPOS());
        ArrayList lStatename = (ArrayList)decision.getSTATENAME();
        int j = 0;
        while (j < lStatename.size()) {
            BIFType.NETWORKType.VARIABLESType.DECISIONType.STATENAMEType statename = (BIFType.NETWORKType.VARIABLESType.DECISIONType.STATENAMEType)lStatename.get(j);
            node.appendState(statename.getValue());
            ++j;
        }
        return node;
    }

    private static void processTreeNode(TreeNode node, TreeModel model, BIFType.HIERARCHYType hierarchy) throws JAXBException {
        ObjectFactory of = new ObjectFactory();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        BIFType.HIERARCHYType.ROOTType root = of.createBIFTypeHIERARCHYTypeROOTType();
        root.setNAME(node.toString());
        int childCount = model.getChildCount(node);
        if (!node.isLeaf()) {
            int i = 0;
            while (i < childCount) {
                BIFType.HIERARCHYType.ROOTType.LEVELType level = of.createBIFTypeHIERARCHYTypeROOTTypeLEVELType();
                level.setNAME(((TreeNode)model.getChild(node, i)).toString());
                children.add((TreeNode)model.getChild(node, i));
                root.getLEVEL().add(level);
                ++i;
            }
            hierarchy.getROOT().add(root);
            i = 0;
            while (i < childCount) {
                XMLBIFIO.processTreeNode((TreeNode)model.getChild(node, i), model, hierarchy);
                ++i;
            }
        }
    }

    private static DefaultMutableTreeNode loadHierarchicTree(BIFType.HIERARCHYType hierarchy) {
        boolean out = false;
        ArrayList lroot = (ArrayList)hierarchy.getROOT();
        BIFType.HIERARCHYType.ROOTType rootXML = (BIFType.HIERARCHYType.ROOTType)lroot.get(0);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootXML.getNAME());
        System.out.println("rootXML.getNAME()" + rootXML.getNAME());
        DefaultMutableTreeNode atualNode = root;
        ArrayList<DefaultMutableTreeNode> rootsTree = new ArrayList<DefaultMutableTreeNode>();
        rootsTree.add(atualNode);
        int i = 0;
        while (i < lroot.size()) {
            BIFType.HIERARCHYType.ROOTType atualRoot = (BIFType.HIERARCHYType.ROOTType)lroot.get(i);
            atualNode = XMLBIFIO.getAtualNode(rootsTree, atualRoot.getNAME());
            ArrayList lchildrens = (ArrayList)atualRoot.getLEVEL();
            int j = 0;
            while (j < lchildrens.size()) {
                BIFType.HIERARCHYType.ROOTType.LEVELType children = (BIFType.HIERARCHYType.ROOTType.LEVELType)lchildrens.get(j);
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(children.getNAME());
                atualNode.add(newNode);
                rootsTree.add(newNode);
                ++j;
            }
            ++i;
        }
        return root;
    }

    private static DefaultMutableTreeNode getAtualNode(ArrayList<DefaultMutableTreeNode> rootsTree, String name) {
        boolean achou = false;
        int index = 0;
        DefaultMutableTreeNode node = null;
        while (!achou) {
            if (name.compareTo(rootsTree.get(index).toString()) != 0) {
                ++index;
                continue;
            }
            achou = true;
            node = rootsTree.get(index);
        }
        rootsTree.remove(index);
        return node;
    }
}

