/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.mebn;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.gui.InternalErrorDialog;
import unbbayes.gui.util.StatusChangedEvent;
import unbbayes.gui.util.StatusObservable;
import unbbayes.gui.util.StatusObserver;
import unbbayes.io.mebn.PROWLModelUser;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.prs.Edge;
import unbbayes.prs.mebn.Argument;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.builtInRV.BuiltInRVAnd;
import unbbayes.prs.mebn.builtInRV.BuiltInRVEqualTo;
import unbbayes.prs.mebn.builtInRV.BuiltInRVExists;
import unbbayes.prs.mebn.builtInRV.BuiltInRVForAll;
import unbbayes.prs.mebn.builtInRV.BuiltInRVIff;
import unbbayes.prs.mebn.builtInRV.BuiltInRVImplies;
import unbbayes.prs.mebn.builtInRV.BuiltInRVNot;
import unbbayes.prs.mebn.builtInRV.BuiltInRVOr;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;
import unbbayes.prs.mebn.entity.BooleanStateEntity;
import unbbayes.prs.mebn.entity.CategoricalStateEntity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.prs.mebn.entity.exception.CategoricalStateDoesNotExistException;
import unbbayes.prs.mebn.entity.exception.EntityInstanceAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeException;
import unbbayes.prs.mebn.exception.OVDontIsOfTypeExpected;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderPrOwlIO
extends PROWLModelUser
implements StatusObservable {
    private List<StatusObserver> observers = new ArrayList<StatusObserver>();
    private MultiEntityBayesianNetwork mebn = null;
    private Collection instances;
    private Iterator itAux;
    private HashMap<String, MFrag> mapDomainMFrag = new HashMap();
    private HashMap<String, OrdinaryVariable> mapOVariable = new HashMap();
    private HashMap<String, ContextNode> mapContextNode = new HashMap();
    private HashMap<String, ContextNode> mapContextNodeInner = new HashMap();
    private List<ContextNode> listContextNode = new ArrayList<ContextNode>();
    private HashMap<ContextNode, Object> mapIsContextInstanceOf = new HashMap();
    private HashMap<String, ResidentNode> mapDomainResidentNode = new HashMap();
    private HashMap<String, InputNode> mapGenerativeInputNode = new HashMap();
    private HashMap<String, Argument> mapArgument = new HashMap();
    private HashMap<String, MultiEntityNode> mapMultiEntityNode = new HashMap();
    private HashMap<String, BuiltInRV> mapBuiltInRV = new HashMap();
    private HashMap<String, ObjectEntity> mapObjectEntity = new HashMap();
    private HashMap<String, CategoricalStateEntity> mapCategoricalStates = new HashMap();
    private HashMap<String, BooleanStateEntity> mapBooleanStates = new HashMap();
    private HashMap<String, List<String>> mapObjectEntityGloballyObjects = new HashMap();
    private HashMap<String, List<String>> mapCategoricalStateGloballyObjects = new HashMap();
    private HashMap<String, List<String>> mapBooleanStateGloballyObjects = new HashMap();
    private HashMap<String, ObjectEntity> mapTypes = new HashMap();
    private JenaOWLModel owlModel;
    final ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.mebn.resources.IoMebnResources");
    private final String ORDINARY_VAR_SCOPE_SEPARATOR = ".";
    private final String POSSIBLE_VALUE_SCOPE_SEPARATOR = ".";

    public void cancel() {
        System.out.println("Stop");
    }

    public MultiEntityBayesianNetwork loadMebn(File file) throws IOException, IOMebnException {
        Debug.setDebug(false);
        ArrayList listWarnings = new ArrayList();
        this.updateStatus(0, "");
        this.owlModel = ProtegeOWL.createJenaOWLModel();
        Debug.println("[DEBUG]" + this.getClass() + " -> Load begin");
        FileInputStream inputStream = new FileInputStream(file);
        try {
            this.owlModel.load((InputStream)inputStream, "RDF/XML-ABBREV");
            this.updateStatus(5, "");
        }
        catch (Exception e) {
            throw new IOMebnException(String.valueOf(this.resource.getString("ErrorReadingFile")) + ": " + file.getAbsolutePath());
        }
        this.loadMTheoryClass();
        this.updateStatus(6, "");
        this.loadObjectEntity();
        this.updateStatus(7, "");
        this.loadMetaEntitiesClasses();
        this.updateStatus(9, "");
        this.loadCategoricalStateEntity();
        this.updateStatus(11, "");
        this.loadBooleanStateEntity();
        this.updateStatus(13, "");
        this.loadDomainMFrag();
        this.updateStatus(20, "");
        this.loadBuiltInRV();
        this.updateStatus(25, "");
        this.loadContextNode();
        this.updateStatus(35, "");
        this.loadDomainResidentNode();
        this.updateStatus(45, "");
        this.loadGenerativeInputNode();
        this.updateStatus(55, "");
        this.loadOrdinaryVariable();
        this.updateStatus(65, "");
        this.loadArgRelationship();
        this.updateStatus(75, "");
        this.loadSimpleArgRelationship();
        this.updateStatus(85, "");
        this.ajustArgumentOfNodes();
        this.updateStatus(90, "");
        this.setFormulasOfContextNodes();
        this.updateStatus(95, "");
        try {
            this.loadObjectEntityIndividuals();
            this.updateStatus(100, "");
        }
        catch (TypeException te) {
            te.printStackTrace();
            throw new IOMebnException(te.getMessage());
        }
        return this.mebn;
    }

    private void updateStatus(int percentage, String msg) {
        StatusChangedEvent event = new StatusChangedEvent();
        event.setPercentageConclude(5);
        event.setMsg(msg);
        this.notity(event);
    }

    private void loadMTheoryClass() throws IOMebnException {
        OWLNamedClass owlNamedClass = this.owlModel.getOWLNamedClass("MTheory");
        this.instances = owlNamedClass.getInstances(false);
        this.itAux = this.instances.iterator();
        if (!this.itAux.hasNext()) {
            throw new IOMebnException(this.resource.getString("MTheoryNotExist"));
        }
        OWLIndividual individualOne = (OWLIndividual)this.itAux.next();
        this.mebn = new MultiEntityBayesianNetwork(individualOne.getBrowserText());
        this.mebn.getNamesUsed().add(individualOne.getBrowserText());
        Debug.println("MTheory loaded: " + individualOne.getBrowserText());
        String comment = null;
        comment = this.getDescription(individualOne);
        this.mebn.setDescription(comment);
        OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("hasMFrag");
        this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
        for (OWLIndividual individualTwo : this.instances) {
            Debug.println("hasDomainMFrag: " + individualTwo.getBrowserText());
            MFrag domainMFrag = new MFrag(individualTwo.getBrowserText(), this.mebn);
            this.mebn.addDomainMFrag(domainMFrag);
            this.mapDomainMFrag.put(individualTwo.getBrowserText(), domainMFrag);
            this.mebn.getNamesUsed().add(individualTwo.getBrowserText());
        }
    }

    private String getDescription(OWLIndividual individualOne) {
        String comment = null;
        Collection comments = individualOne.getComments();
        if (comments.size() > 0 && comments.toArray()[0] instanceof String) {
            comment = (String)comments.toArray()[0];
        }
        return comment;
    }

    private void loadMetaEntitiesClasses() {
        OWLNamedClass metaEntityClass = this.owlModel.getOWLNamedClass("MetaEntity");
        Collection instances = metaEntityClass.getInstances(false);
        for (Object owlIndividual : instances) {
            OWLIndividual individualOne = (OWLIndividual)owlIndividual;
            try {
                Type type = this.mebn.getTypeContainer().createType(individualOne.getBrowserText());
                this.mebn.getNamesUsed().add(individualOne.getBrowserText());
            }
            catch (TypeAlreadyExistsException typeAlreadyExistsException) {
                // empty catch block
            }
            Debug.println("Meta Entity Loaded: " + individualOne.getBrowserText());
        }
    }

    private void loadObjectEntity() {
        OWLObjectProperty isGloballyExclusive = this.owlModel.getOWLObjectProperty("isGloballyExclusive");
        OWLNamedClass objectEntityClass = this.owlModel.getOWLNamedClass("ObjectEntity");
        Collection subClasses = objectEntityClass.getSubclasses(true);
        for (Object owlClass : subClasses) {
            OWLNamedClass subClass = (OWLNamedClass)owlClass;
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("hasType");
            try {
                ObjectEntity objectEntityMebn = this.mebn.getObjectEntityContainer().createObjectEntity(subClass.getBrowserText());
                this.mapObjectEntity.put(subClass.getBrowserText(), objectEntityMebn);
                this.mapTypes.put(objectEntityMebn.getType().getName(), objectEntityMebn);
                this.mebn.getNamesUsed().add(subClass.getBrowserText());
            }
            catch (TypeException typeException) {
                typeException.printStackTrace();
            }
        }
    }

    private void loadCategoricalStateEntity() {
        OWLObjectProperty isGloballyExclusive = this.owlModel.getOWLObjectProperty("isGloballyExclusive");
        OWLNamedClass categoricalStateClass = this.owlModel.getOWLNamedClass("CategoricalRVState");
        Collection instances = categoricalStateClass.getInstances(false);
        for (Object owlIndividual : instances) {
            OWLIndividual individualOne = (OWLIndividual)owlIndividual;
            CategoricalStateEntity state = this.mebn.getCategoricalStatesEntityContainer().createCategoricalEntity(individualOne.getBrowserText());
            this.mebn.getNamesUsed().add(individualOne.getBrowserText());
            Collection globallyExclusiveObjects = individualOne.getPropertyValues((RDFProperty)isGloballyExclusive);
            ArrayList<String> listObjects = new ArrayList<String>();
            for (Object object : globallyExclusiveObjects) {
                OWLIndividual nodeIndividual = (OWLIndividual)object;
                listObjects.add(nodeIndividual.getBrowserText());
            }
            this.mapCategoricalStateGloballyObjects.put(state.getName(), listObjects);
            Debug.println("Categorical State Entity Loaded: " + individualOne.getBrowserText());
        }
    }

    private void loadBooleanStateEntity() {
        OWLObjectProperty isGloballyExclusive = this.owlModel.getOWLObjectProperty("isGloballyExclusive");
        OWLNamedClass booleanStateClass = this.owlModel.getOWLNamedClass("BooleanRVState");
        Collection instances = booleanStateClass.getInstances(false);
        for (Object owlIndividual : instances) {
            OWLIndividual individualOne = (OWLIndividual)owlIndividual;
            BooleanStateEntity state = null;
            if (individualOne.getBrowserText().equals("true")) {
                state = this.mebn.getBooleanStatesEntityContainer().getTrueStateEntity();
                this.mebn.getNamesUsed().add(individualOne.getBrowserText());
            } else if (individualOne.getBrowserText().equals("false")) {
                state = this.mebn.getBooleanStatesEntityContainer().getFalseStateEntity();
                this.mebn.getNamesUsed().add(individualOne.getBrowserText());
            } else if (individualOne.getBrowserText().equals("absurd")) {
                state = this.mebn.getBooleanStatesEntityContainer().getAbsurdStateEntity();
                this.mebn.getNamesUsed().add(individualOne.getBrowserText());
            }
            if (state != null) {
                Collection globallyExclusiveObjects = individualOne.getPropertyValues((RDFProperty)isGloballyExclusive);
                ArrayList<String> listObjects = new ArrayList<String>();
                for (Object object : globallyExclusiveObjects) {
                    OWLIndividual nodeIndividual = (OWLIndividual)object;
                    listObjects.add(nodeIndividual.getBrowserText());
                }
                this.mapBooleanStateGloballyObjects.put(state.getName(), listObjects);
            }
            Debug.println("Boolean State Entity Loaded: " + individualOne.getBrowserText());
        }
    }

    private void loadDomainMFrag() throws IOMebnException {
        OWLNamedClass owlNamedClass = this.owlModel.getOWLNamedClass("Domain_MFrag");
        this.instances = owlNamedClass.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            MFrag domainMFrag = this.mapDomainMFrag.get(individualOne.getBrowserText());
            if (domainMFrag == null) {
                throw new IOMebnException(this.resource.getString("DomainMFragNotExistsInMTheory"), individualOne.getBrowserText());
            }
            Debug.println("DomainMFrag loaded: " + individualOne.getBrowserText());
            domainMFrag.setDescription(this.getDescription(individualOne));
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("hasResidentNode");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo : this.instances) {
                ResidentNode domainResidentNode = new ResidentNode(individualTwo.getBrowserText(), domainMFrag);
                this.mebn.getNamesUsed().add(individualTwo.getBrowserText());
                domainMFrag.addResidentNode(domainResidentNode);
                this.mapDomainResidentNode.put(individualTwo.getBrowserText(), domainResidentNode);
                this.mapMultiEntityNode.put(individualTwo.getBrowserText(), domainResidentNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasInputNode");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo : this.instances) {
                InputNode generativeInputNode = new InputNode(individualTwo.getBrowserText(), domainMFrag);
                this.mebn.getNamesUsed().add(individualTwo.getBrowserText());
                domainMFrag.addInputNode(generativeInputNode);
                this.mapGenerativeInputNode.put(individualTwo.getBrowserText(), generativeInputNode);
                this.mapMultiEntityNode.put(individualTwo.getBrowserText(), generativeInputNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasContextNode");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo : this.instances) {
                ContextNode contextNode = new ContextNode(individualTwo.getBrowserText(), domainMFrag);
                this.mebn.getNamesUsed().add(individualTwo.getBrowserText());
                domainMFrag.addContextNode(contextNode);
                this.mapContextNode.put(individualTwo.getBrowserText(), contextNode);
                this.mapMultiEntityNode.put(individualTwo.getBrowserText(), contextNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasOVariable");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            String ovName = null;
            for (OWLIndividual individualTwo : this.instances) {
                ovName = individualTwo.getBrowserText();
                try {
                    ovName = ovName.split(String.valueOf(domainMFrag.getName()) + this.getOrdinaryVarScopeSeparator())[1];
                }
                catch (ArrayIndexOutOfBoundsException e) {}
                this.mebn.getTypeContainer();
                OrdinaryVariable oVariable = new OrdinaryVariable(ovName, TypeContainer.getDefaultType(), domainMFrag);
                domainMFrag.addOrdinaryVariable(oVariable);
                this.mapOVariable.put(individualTwo.getBrowserText(), oVariable);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
        }
    }

    private void loadContextNode() throws IOMebnException {
        OWLNamedClass contextNodePr = this.owlModel.getOWLNamedClass("Context");
        this.instances = contextNodePr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            ContextNode contextNode = this.mapContextNode.get(individualOne.getBrowserText());
            if (contextNode == null) {
                throw new IOMebnException(this.resource.getString("ContextNodeNotExistsInMTheory"), individualOne.getBrowserText());
            }
            Debug.println("Context Node loaded: " + individualOne.getBrowserText());
            contextNode.setDescription(this.getDescription(individualOne));
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("isContextNodeIn");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            OWLIndividual individualTwo2 = (OWLIndividual)this.itAux.next();
            MFrag domainMFrag = this.mapDomainMFrag.get(individualTwo2.getBrowserText());
            if (!domainMFrag.containsContextNode(contextNode)) {
                throw new IOMebnException(this.resource.getString("ContextNodeNotExistsInMFrag"), String.valueOf(contextNode.getName()) + ", " + domainMFrag.getName());
            }
            Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            objectProperty = this.owlModel.getOWLObjectProperty("isNodeFrom");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            Iterator itIn = this.instances.iterator();
            while (itIn.hasNext()) {
                individualTwo2 = (OWLIndividual)this.itAux.next();
                domainMFrag = this.mapDomainMFrag.get(individualTwo2.getBrowserText());
                if (!domainMFrag.containsNode(contextNode)) {
                    throw new IOMebnException(this.resource.getString("NodeNotExistsInMFrag"), String.valueOf(contextNode.getName()) + ", " + domainMFrag.getName());
                }
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasArgument");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo2 : this.instances) {
                Argument argument = new Argument(individualTwo2.getBrowserText(), contextNode);
                contextNode.addArgument(argument);
                this.mapArgument.put(individualTwo2.getBrowserText(), argument);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("isContextInstanceOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            if (this.itAux.hasNext()) {
                individualTwo2 = (OWLIndividual)this.itAux.next();
                if (this.mapBuiltInRV.get(individualTwo2.getBrowserText()) != null) {
                    this.mapIsContextInstanceOf.put(contextNode, this.mapBuiltInRV.get(individualTwo2.getBrowserText()));
                } else if (this.mapDomainResidentNode.get(individualTwo2.getBrowserText()) != null) {
                    this.mapIsContextInstanceOf.put(contextNode, this.mapDomainResidentNode.get(individualTwo2.getBrowserText()));
                }
            }
            objectProperty = this.owlModel.getOWLObjectProperty("isInnerTermOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            if (this.itAux.hasNext()) {
                domainMFrag.removeContextNode(contextNode);
                for (OWLIndividual individualTwo2 : this.instances) {
                    MultiEntityNode multiEntityNode = this.mapMultiEntityNode.get(individualTwo2.getBrowserText());
                    contextNode.addInnerTermFromList(multiEntityNode);
                    multiEntityNode.addInnerTermOfList(contextNode);
                    Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
                }
                continue;
            }
            this.listContextNode.add(contextNode);
        }
    }

    private void loadBuiltInRV() throws IOMebnException {
        BuiltInRV builtInRV = null;
        OWLNamedClass builtInPr = this.owlModel.getOWLNamedClass("BuiltInRV");
        this.instances = builtInPr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            String nameBuiltIn = individualOne.getBrowserText();
            if (nameBuiltIn.equals("and")) {
                builtInRV = new BuiltInRVAnd();
            } else if (nameBuiltIn.equals("or")) {
                builtInRV = new BuiltInRVOr();
            } else if (nameBuiltIn.equals("equalto")) {
                builtInRV = new BuiltInRVEqualTo();
            } else if (nameBuiltIn.equals("exists")) {
                builtInRV = new BuiltInRVExists();
            } else if (nameBuiltIn.equals("forall")) {
                builtInRV = new BuiltInRVForAll();
            } else if (nameBuiltIn.equals("not")) {
                builtInRV = new BuiltInRVNot();
            } else if (nameBuiltIn.equals("iff")) {
                builtInRV = new BuiltInRVIff();
            } else if (nameBuiltIn.equals("implies")) {
                builtInRV = new BuiltInRVImplies();
            }
            if (builtInRV == null) continue;
            this.mebn.addBuiltInRVList(builtInRV);
            this.mapBuiltInRV.put(individualOne.getBrowserText(), builtInRV);
            Debug.println("BuiltInRV loaded: " + individualOne.getBrowserText());
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("hasInputInstance");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo : this.instances) {
                InputNode generativeInputNode = this.mapGenerativeInputNode.get(individualTwo.getBrowserText());
                if (generativeInputNode == null) {
                    throw new IOMebnException(this.resource.getString("GenerativeInputNodeNotExistsInMTheory"), individualTwo.getBrowserText());
                }
                builtInRV.addInputInstance(generativeInputNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
        }
    }

    private void loadDomainResidentNode() throws IOMebnException {
        OWLNamedClass domainResidentNodePr = this.owlModel.getOWLNamedClass("Domain_Res");
        this.instances = domainResidentNodePr.getInstances(false);
        MFrag mFragOfNode = null;
        for (OWLIndividual individualOne : this.instances) {
            ResidentNode domainResidentNode = this.mapDomainResidentNode.get(individualOne.getBrowserText());
            if (domainResidentNode == null) {
                throw new IOMebnException(this.resource.getString("DomainResidentNotExistsInMTheory"), individualOne.getBrowserText());
            }
            Debug.println("Domain Resident loaded: " + individualOne.getBrowserText());
            domainResidentNode.setDescription(this.getDescription(individualOne));
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("isResidentNodeIn");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            OWLIndividual individualTwo2 = (OWLIndividual)this.itAux.next();
            MFrag domainMFrag = this.mapDomainMFrag.get(individualTwo2.getBrowserText());
            if (!domainMFrag.containsDomainResidentNode(domainResidentNode)) {
                throw new IOMebnException(this.resource.getString("DomainResidentNotExistsInDomainMFrag"));
            }
            mFragOfNode = domainMFrag;
            Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            objectProperty = this.owlModel.getOWLObjectProperty("hasArgument");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo2 : this.instances) {
                Argument argument = new Argument(individualTwo2.getBrowserText(), domainResidentNode);
                domainResidentNode.addArgument(argument);
                this.mapArgument.put(individualTwo2.getBrowserText(), argument);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasParent");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo2 : this.instances) {
                Object auxEdge;
                MultiEntityNode aux;
                if (this.mapDomainResidentNode.containsKey(individualTwo2.getBrowserText())) {
                    aux = this.mapDomainResidentNode.get(individualTwo2.getBrowserText());
                    auxEdge = new Edge(aux, domainResidentNode);
                    try {
                        mFragOfNode.addEdge((Edge)auxEdge);
                    }
                    catch (Exception e) {
                        Debug.println("Erro: arco invalido!!!");
                    }
                } else if (this.mapGenerativeInputNode.containsKey(individualTwo2.getBrowserText())) {
                    aux = this.mapGenerativeInputNode.get(individualTwo2.getBrowserText());
                    auxEdge = new Edge(aux, domainResidentNode);
                    try {
                        mFragOfNode.addEdge((Edge)auxEdge);
                    }
                    catch (Exception e) {
                        Debug.println("Erro: arco invalido!!!");
                    }
                } else {
                    throw new IOMebnException(this.resource.getString("NodeNotFound"), individualTwo2.getBrowserText());
                }
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasInputInstance");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo2 : this.instances) {
                InputNode generativeInputNode = this.mapGenerativeInputNode.get(individualTwo2.getBrowserText());
                try {
                    generativeInputNode.setInputInstanceOf(domainResidentNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("isInnerTermOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            for (OWLIndividual individualTwo2 : this.instances) {
                MultiEntityNode multiEntityNode = this.mapMultiEntityNode.get(individualTwo2.getBrowserText());
                domainResidentNode.addInnerTermFromList(multiEntityNode);
                multiEntityNode.addInnerTermOfList(domainResidentNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo2.getBrowserText());
            }
            CategoricalStateEntity state = null;
            objectProperty = this.owlModel.getOWLObjectProperty("hasPossibleValues");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            for (Object instance : this.instances) {
                List<String> globallyObjects;
                StateLink link;
                individualTwo2 = (OWLIndividual)instance;
                String stateName = individualTwo2.getBrowserText();
                if (stateName.equals("true")) {
                    link = domainResidentNode.addPossibleValueLink(this.mebn.getBooleanStatesEntityContainer().getTrueStateEntity());
                    globallyObjects = this.mapBooleanStateGloballyObjects.get("true");
                    if (globallyObjects.contains(domainResidentNode.getName())) {
                        link.setGloballyExclusive(true);
                    } else {
                        link.setGloballyExclusive(false);
                    }
                    domainResidentNode.setTypeOfStates(2);
                    continue;
                }
                if (stateName.equals("false")) {
                    link = domainResidentNode.addPossibleValueLink(this.mebn.getBooleanStatesEntityContainer().getFalseStateEntity());
                    globallyObjects = this.mapBooleanStateGloballyObjects.get("false");
                    if (globallyObjects.contains(domainResidentNode.getName())) {
                        link.setGloballyExclusive(true);
                    } else {
                        link.setGloballyExclusive(false);
                    }
                    domainResidentNode.setTypeOfStates(2);
                    continue;
                }
                if (stateName.equals("absurd")) {
                    link = domainResidentNode.addPossibleValueLink(this.mebn.getBooleanStatesEntityContainer().getAbsurdStateEntity());
                    globallyObjects = this.mapBooleanStateGloballyObjects.get("absurd");
                    if (globallyObjects.contains(domainResidentNode.getName())) {
                        link.setGloballyExclusive(true);
                    } else {
                        link.setGloballyExclusive(false);
                    }
                    domainResidentNode.setTypeOfStates(2);
                    continue;
                }
                if (this.mapTypes.get(stateName) != null) {
                    link = domainResidentNode.addPossibleValueLink(this.mapTypes.get(stateName));
                    domainResidentNode.setTypeOfStates(0);
                    continue;
                }
                try {
                    state = this.mebn.getCategoricalStatesEntityContainer().getCategoricalState(individualTwo2.getBrowserText());
                    link = domainResidentNode.addPossibleValueLink(state);
                    globallyObjects = this.mapCategoricalStateGloballyObjects.get(state.getName());
                    if (globallyObjects.contains(domainResidentNode.getName())) {
                        link.setGloballyExclusive(true);
                    } else {
                        link.setGloballyExclusive(false);
                    }
                    domainResidentNode.setTypeOfStates(1);
                }
                catch (CategoricalStateDoesNotExistException e) {
                    e.printStackTrace();
                }
            }
            OWLObjectProperty hasProbDist = this.owlModel.getOWLObjectProperty("hasProbDist");
            OWLDatatypeProperty hasDeclaration = this.owlModel.getOWLDatatypeProperty("hasDeclaration");
            String cpt = null;
            for (OWLIndividual element : individualOne.getPropertyValues((RDFProperty)hasProbDist)) {
                try {
                    cpt = (String)element.getPropertyValue((RDFProperty)hasDeclaration);
                }
                catch (Exception e) {
                    cpt = "";
                }
                domainResidentNode.setTableFunction(cpt);
            }
        }
    }

    private void loadGenerativeInputNode() throws IOMebnException {
        OWLNamedClass inputNodePr = this.owlModel.getOWLNamedClass("Generative_input");
        this.instances = inputNodePr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            Debug.println("  - Input Node loaded: " + individualOne.getBrowserText());
            InputNode generativeInputNode = this.mapGenerativeInputNode.get(individualOne.getBrowserText());
            if (generativeInputNode == null) {
                throw new IOMebnException(this.resource.getString("GenerativeInputNodeNotExistsInMTheory"), individualOne.getBrowserText());
            }
            generativeInputNode.setDescription(this.getDescription(individualOne));
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("isInputInstanceOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            if (this.itAux.hasNext()) {
                OWLIndividual individualTwo = (OWLIndividual)this.itAux.next();
                if (this.mapDomainResidentNode.containsKey(individualTwo.getBrowserText())) {
                    ResidentNode domainResidentNode = this.mapDomainResidentNode.get(individualTwo.getBrowserText());
                    try {
                        generativeInputNode.setInputInstanceOf(domainResidentNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Debug.println("   - isInputInstanceOf " + domainResidentNode.getName());
                } else if (this.mapBuiltInRV.containsKey(individualTwo.getBrowserText())) {
                    BuiltInRV builtInRV = this.mapBuiltInRV.get(individualTwo.getBrowserText());
                    generativeInputNode.setInputInstanceOf(builtInRV);
                    Debug.println("   - isInputInstanceOf " + builtInRV.getName());
                }
            }
            objectProperty = this.owlModel.getOWLObjectProperty("hasArgument");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            for (OWLIndividual individualTwo : this.instances) {
                Argument argument = new Argument(individualTwo.getBrowserText(), generativeInputNode);
                generativeInputNode.addArgument(argument);
                this.mapArgument.put(individualTwo.getBrowserText(), argument);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            objectProperty = this.owlModel.getOWLObjectProperty("isInnerTermOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            for (OWLIndividual individualTwo : this.instances) {
                MultiEntityNode multiEntityNode = this.mapMultiEntityNode.get(individualTwo.getBrowserText());
                generativeInputNode.addInnerTermFromList(multiEntityNode);
                multiEntityNode.addInnerTermOfList(generativeInputNode);
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
        }
    }

    private void loadOrdinaryVariable() throws IOMebnException {
        OWLNamedClass ordinaryVariablePr = this.owlModel.getOWLNamedClass("OVariable");
        this.instances = ordinaryVariablePr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            OrdinaryVariable oVariable = this.mapOVariable.get(individualOne.getBrowserText());
            if (oVariable == null) {
                throw new IOMebnException(this.resource.getString("OVariableNotExistsInMTheory"), individualOne.getBrowserText());
            }
            Debug.println("Ordinary Variable loaded: " + individualOne.getBrowserText());
            oVariable.setDescription(this.getDescription(individualOne));
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("isOVariableIn");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            OWLIndividual individualTwo = (OWLIndividual)this.itAux.next();
            MFrag domainMFrag = this.mapDomainMFrag.get(individualTwo.getBrowserText());
            if (domainMFrag != oVariable.getMFrag()) {
                throw new IOMebnException(this.resource.getString("isOVariableInError"), individualOne.getBrowserText());
            }
            Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            objectProperty = this.owlModel.getOWLObjectProperty("isSubsBy");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            if (!this.itAux.hasNext()) continue;
            individualTwo = (OWLIndividual)this.itAux.next();
            Type type = this.mebn.getTypeContainer().getType(individualTwo.getBrowserText());
            if (type == null) continue;
            oVariable.setValueType(type);
            oVariable.updateLabel();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadArgRelationship() throws IOMebnException {
        argRelationshipPr = this.owlModel.getOWLNamedClass("ArgRelationship");
        this.instances = argRelationshipPr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            argument = this.mapArgument.get(individualOne.getBrowserText());
            if (argument == null) {
                throw new IOMebnException(this.resource.getString("ArgumentNotFound"), individualOne.getBrowserText());
            }
            Debug.println("-> ArgRelationship loaded: " + individualOne.getBrowserText());
            objectProperty = this.owlModel.getOWLObjectProperty("hasArgTerm");
            individualTwo = (OWLIndividual)individualOne.getPropertyValue((RDFProperty)objectProperty);
            if (individualTwo != null) {
                multiEntityNode = this.mapMultiEntityNode.get(individualTwo.getBrowserText());
                if (multiEntityNode != null) {
                    try {
                        if (multiEntityNode instanceof ResidentNode) {
                            argument.setArgumentTerm(multiEntityNode);
                            argument.setType(1);
                        }
                        if (!(multiEntityNode instanceof ContextNode)) ** GOTO lbl48
                        argument.setArgumentTerm(multiEntityNode);
                        argument.setType(4);
                    }
                    catch (Exception e) {
                        throw new IOMebnException(this.resource.getString("ArgumentTermError"), individualTwo.getBrowserText());
                    }
                } else {
                    oVariable = this.mapOVariable.get(individualTwo.getBrowserText());
                    if (oVariable != null) {
                        try {
                            argument.setOVariable(oVariable);
                            argument.setType(0);
                        }
                        catch (Exception e) {
                            throw new IOMebnException(this.resource.getString("ArgumentTermError"), individualTwo.getBrowserText());
                        }
                    } else {
                        state = this.mapCategoricalStates.get(individualTwo.getBrowserText());
                        if (state != null) {
                            argument.setEntityTerm(state);
                            argument.setType(0);
                        } else if (individualTwo.getBrowserText().equals("true")) {
                            argument.setEntityTerm(this.mebn.getBooleanStatesEntityContainer().getTrueStateEntity());
                            argument.setType(5);
                        } else if (individualTwo.getBrowserText().equals("false")) {
                            argument.setEntityTerm(this.mebn.getBooleanStatesEntityContainer().getFalseStateEntity());
                            argument.setType(5);
                        } else if (individualTwo.getBrowserText().equals("absurd")) {
                            argument.setEntityTerm(this.mebn.getBooleanStatesEntityContainer().getAbsurdStateEntity());
                            argument.setType(5);
                        }
                    }
                }
lbl48:
                // 10 sources

                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            if ((argNumber = (Integer)individualOne.getPropertyValue((RDFProperty)(hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber")))) != null) {
                argument.setArgNumber(argNumber);
            }
            objectProperty = this.owlModel.getOWLObjectProperty("isArgumentOf");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            individualTwo = (OWLIndividual)this.itAux.next();
            multiEntityNode = this.mapMultiEntityNode.get(individualTwo.getBrowserText());
            if (argument.getMultiEntityNode() != multiEntityNode) {
                throw new IOMebnException(this.resource.getString("isArgumentOfError"), individualTwo.getBrowserText());
            }
            Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
        }
    }

    private void loadSimpleArgRelationship() throws IOMebnException {
        OrdinaryVariable oVariable = null;
        OWLNamedClass argRelationshipPr = this.owlModel.getOWLNamedClass("SimpleArgRelationship");
        this.instances = argRelationshipPr.getInstances(false);
        for (OWLIndividual individualOne : this.instances) {
            OWLDatatypeProperty hasArgNumber;
            Argument argument = this.mapArgument.get(individualOne.getBrowserText());
            if (argument == null) {
                throw new IOMebnException(this.resource.getString("ArgumentNotFound"), individualOne.getBrowserText());
            }
            Debug.println("SimpleArgRelationship loaded: " + individualOne.getBrowserText());
            OWLObjectProperty objectProperty = this.owlModel.getOWLObjectProperty("hasArgTerm");
            this.instances = individualOne.getPropertyValues((RDFProperty)objectProperty);
            this.itAux = this.instances.iterator();
            if (this.itAux.hasNext()) {
                OWLIndividual individualTwo = (OWLIndividual)this.itAux.next();
                oVariable = this.mapOVariable.get(individualTwo.getBrowserText());
                if (oVariable == null) {
                    throw new IOMebnException(this.resource.getString("ArgumentTermError"), individualTwo.getBrowserText());
                }
                try {
                    argument.setOVariable(oVariable);
                }
                catch (Exception e) {
                    throw new IOMebnException(this.resource.getString("ArgumentTermError"), individualTwo.getBrowserText());
                }
                Debug.println("-> " + individualOne.getBrowserText() + ": " + objectProperty.getBrowserText() + " = " + individualTwo.getBrowserText());
            }
            if (individualOne.getPropertyValue((RDFProperty)(hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber"))) == null) continue;
            argument.setArgNumber((Integer)individualOne.getPropertyValue((RDFProperty)hasArgNumber));
        }
    }

    private void ajustArgumentOfNodes() {
        for (ResidentNode resident : this.mapDomainResidentNode.values()) {
            int argNumberActual = 1;
            int tamArgumentList = resident.getArgumentList().size();
            while (argNumberActual <= tamArgumentList) {
                boolean find = false;
                Argument argumentOfPosition = null;
                for (Argument argument : resident.getArgumentList()) {
                    if (argument.getArgNumber() != argNumberActual) continue;
                    find = true;
                    argumentOfPosition = argument;
                    break;
                }
                if (!find) {
                    new InternalErrorDialog();
                } else {
                    try {
                        resident.addArgument(argumentOfPosition.getOVariable(), false);
                    }
                    catch (Exception e) {
                        new InternalErrorDialog();
                        e.printStackTrace();
                    }
                }
                ++argNumberActual;
            }
        }
        for (InputNode input : this.mapGenerativeInputNode.values()) {
            if (!(input.getInputInstanceOf() instanceof ResidentNode)) continue;
            input.updateResidentNodePointer();
            for (Argument argument : input.getArgumentList()) {
                try {
                    input.getResidentNodePointer().addOrdinaryVariable(argument.getOVariable(), argument.getArgNumber() - 1);
                    input.updateLabel();
                }
                catch (OVDontIsOfTypeExpected e) {
                    new InternalErrorDialog();
                    e.printStackTrace();
                }
                catch (Exception e) {
                    Debug.println("Error: Arguemt " + argument.getName() + " do input " + input.getName() + " don't setted...");
                }
            }
        }
    }

    private void setFormulasOfContextNodes() {
        for (ContextNode context : this.listContextNode) {
            context.setFormulaTree(this.buildFormulaTree(context));
        }
    }

    private NodeFormulaTree buildFormulaTree(ContextNode contextNode) {
        NodeFormulaTree nodeFormulaRoot;
        block23: {
            Object obj;
            block22: {
                nodeFormulaRoot = new NodeFormulaTree("formula", EnumType.FORMULA, EnumSubType.NOTHING, null);
                Debug.println("Entrou no build " + contextNode.getName());
                obj = this.mapIsContextInstanceOf.get(contextNode);
                if (!(obj instanceof BuiltInRV)) break block22;
                BuiltInRV builtIn = (BuiltInRV)obj;
                EnumType type = EnumType.EMPTY;
                EnumSubType subType = EnumSubType.NOTHING;
                if (builtIn instanceof BuiltInRVForAll) {
                    type = EnumType.QUANTIFIER_OPERATOR;
                    subType = EnumSubType.FORALL;
                } else if (builtIn instanceof BuiltInRVExists) {
                    type = EnumType.QUANTIFIER_OPERATOR;
                    subType = EnumSubType.EXISTS;
                } else if (builtIn instanceof BuiltInRVAnd) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.AND;
                } else if (builtIn instanceof BuiltInRVOr) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.OR;
                } else if (builtIn instanceof BuiltInRVNot) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.NOT;
                } else if (builtIn instanceof BuiltInRVEqualTo) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.EQUALTO;
                } else if (builtIn instanceof BuiltInRVIff) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.IFF;
                } else if (builtIn instanceof BuiltInRVImplies) {
                    type = EnumType.SIMPLE_OPERATOR;
                    subType = EnumSubType.IMPLIES;
                }
                nodeFormulaRoot = new NodeFormulaTree(builtIn.getName(), type, subType, builtIn);
                nodeFormulaRoot.setMnemonic(builtIn.getMnemonic());
                List<Argument> argumentList = this.putArgumentListInOrder(contextNode.getArgumentList());
                for (Argument argument : argumentList) {
                    NodeFormulaTree nodeFormulaChild;
                    if (argument.getOVariable() != null) {
                        OrdinaryVariable ov = argument.getOVariable();
                        nodeFormulaChild = new NodeFormulaTree(ov.getName(), EnumType.OPERAND, EnumSubType.OVARIABLE, ov);
                        nodeFormulaRoot.addChild(nodeFormulaChild);
                        continue;
                    }
                    if (argument.getArgumentTerm() != null) {
                        MultiEntityNode multiEntityNode = argument.getArgumentTerm();
                        if (multiEntityNode instanceof ResidentNode) {
                            ResidentNodePointer residentNodePointer = new ResidentNodePointer((ResidentNode)multiEntityNode, contextNode);
                            nodeFormulaChild = new NodeFormulaTree(multiEntityNode.getName(), EnumType.OPERAND, EnumSubType.NODE, residentNodePointer);
                            nodeFormulaRoot.addChild(nodeFormulaChild);
                            continue;
                        }
                        if (!(multiEntityNode instanceof ContextNode)) continue;
                        NodeFormulaTree child = this.buildFormulaTree((ContextNode)multiEntityNode);
                        nodeFormulaRoot.addChild(child);
                        continue;
                    }
                    if (argument.getEntityTerm() == null) continue;
                    nodeFormulaChild = new NodeFormulaTree(argument.getEntityTerm().getName(), EnumType.OPERAND, EnumSubType.ENTITY, argument.getEntityTerm());
                    nodeFormulaRoot.addChild(nodeFormulaChild);
                }
                break block23;
            }
            if (!(obj instanceof ResidentNode)) break block23;
            ResidentNodePointer residentNodePointer = new ResidentNodePointer((ResidentNode)obj, contextNode);
            nodeFormulaRoot = new NodeFormulaTree(((ResidentNode)obj).getName(), EnumType.OPERAND, EnumSubType.NODE, residentNodePointer);
            List<Argument> argumentList = this.putArgumentListInOrder(contextNode.getArgumentList());
            for (Argument argument : argumentList) {
                if (argument.getOVariable() == null) continue;
                OrdinaryVariable ov = argument.getOVariable();
                try {
                    residentNodePointer.addOrdinaryVariable(ov, argument.getArgNumber() - 1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return nodeFormulaRoot;
    }

    private List<Argument> putArgumentListInOrder(List<Argument> argumentListOriginal) {
        ArrayList<Argument> argumentList = new ArrayList<Argument>();
        int i = 1;
        while (argumentListOriginal.size() > 0) {
            Argument argumentActual = null;
            for (Argument argument : argumentListOriginal) {
                if (argument.getArgNumber() != i) continue;
                argumentActual = argument;
                break;
            }
            argumentList.add(argumentActual);
            argumentListOriginal.remove(argumentActual);
            ++i;
        }
        return argumentList;
    }

    private void checkMTheory() {
        Debug.println("\n\n\n\n-------   Test Begin --------");
        Debug.println("-> MTheory: " + this.mebn.getName());
        List<MFrag> mFragList = this.mebn.getDomainMFragList();
        int desvio = 0;
        for (MFrag mFrag : mFragList) {
            Debug.println(String.valueOf(this.printSpace(++desvio, 3)) + "->MFrag: " + mFrag.getName());
            List<ContextNode> contextNodeList = mFrag.getContextNodeList();
            for (ContextNode contextNode : contextNodeList) {
                Debug.println(String.valueOf(this.printSpace(++desvio, 3)) + "-> ContextNode: " + contextNode.getName());
                for (Argument argument : contextNode.getArgumentList()) {
                    Debug.println(String.valueOf(this.printSpace(++desvio, 3)) + "-> Argument: " + argument.getName());
                    Debug.println(String.valueOf(this.printSpace(++desvio, 3)) + "- IsSimpleArg: " + argument.isSimpleArgRelationship());
                    if (!argument.isSimpleArgRelationship()) {
                        Debug.println(String.valueOf(this.printSpace(desvio, 3)) + "- ArgTerm: " + argument.getArgumentTerm().getName());
                    }
                    --desvio;
                    --desvio;
                }
                --desvio;
            }
            --desvio;
        }
        Debug.println("-------   Test End --------\n\n\n\n");
    }

    private String printSpace(int numSpaces, int size) {
        String stringSize = "";
        String stringReturn = "";
        int i = 0;
        while (i < size) {
            stringSize = String.valueOf(stringSize) + " ";
            ++i;
        }
        i = 0;
        while (i < numSpaces) {
            stringReturn = String.valueOf(stringReturn) + stringSize;
            ++i;
        }
        return stringReturn;
    }

    public String getOrdinaryVarScopeSeparator() {
        return ".";
    }

    private void loadObjectEntityIndividuals() throws TypeException {
        OWLNamedClass objectEntityClass = this.owlModel.getOWLNamedClass("ObjectEntity");
        ObjectEntity mebnEntity = null;
        for (OWLNamedClass subClass : objectEntityClass.getSubclasses(true)) {
            mebnEntity = this.mebn.getObjectEntityContainer().getObjectEntityByName(subClass.getName());
            for (OWLIndividual individual : subClass.getInstances(false)) {
                try {
                    this.mebn.getObjectEntityContainer().addEntityInstance(mebnEntity.addInstance(individual.getName()));
                }
                catch (EntityInstanceAlreadyExistsException eiaee) {
                    Debug.println("Duplicated instance/individual declaration found at OWL Loader");
                }
            }
        }
    }

    @Override
    public OWLModel getLastOWLModel() {
        return this.owlModel;
    }

    @Override
    public void setOWLModelToUse(OWLModel model) {
    }

    @Override
    public void attach(StatusObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void detach(StatusObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notity(StatusChangedEvent event) {
        for (StatusObserver observer : this.observers) {
            observer.update(event);
        }
    }
}

