/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.builder.impl;

import unbbayes.io.builder.INodeBuilder;
import unbbayes.io.builder.IProbabilisticNetworkBuilder;
import unbbayes.io.builder.impl.DefaultContinuousNodeBuilder;
import unbbayes.io.builder.impl.DefaultDecisionNodeBuilder;
import unbbayes.io.builder.impl.DefaultProbabilisticNodeBuilder;
import unbbayes.io.builder.impl.DefaultUtilityNodeBuilder;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class DefaultProbabilisticNetworkBuilder
implements IProbabilisticNetworkBuilder {
    private INodeBuilder probabilisticNodeBuilder = DefaultProbabilisticNodeBuilder.newInstance();
    private INodeBuilder decisionNodeBuilder = DefaultDecisionNodeBuilder.newInstance();
    private INodeBuilder utilityNodeBuilder = DefaultUtilityNodeBuilder.newInstance();
    private INodeBuilder continuousNodeBuilder = DefaultContinuousNodeBuilder.newInstance();

    protected DefaultProbabilisticNetworkBuilder() {
    }

    public static DefaultProbabilisticNetworkBuilder newInstance() {
        return new DefaultProbabilisticNetworkBuilder();
    }

    public static DefaultProbabilisticNetworkBuilder newInstance(INodeBuilder probabilisticNodeBuilder, INodeBuilder decisionNodeBuilder, INodeBuilder utilityNodeBuilder) {
        DefaultProbabilisticNetworkBuilder ret = new DefaultProbabilisticNetworkBuilder();
        if (decisionNodeBuilder != null) {
            ret.setDecisionNodeBuilder(decisionNodeBuilder);
        }
        if (probabilisticNodeBuilder != null) {
            ret.setProbabilisticNodeBuilder(probabilisticNodeBuilder);
        }
        if (utilityNodeBuilder != null) {
            ret.setUtilityNodeBuilder(utilityNodeBuilder);
        }
        return ret;
    }

    public ProbabilisticNetwork buildNetwork(String name) {
        return new ProbabilisticNetwork(name);
    }

    public INodeBuilder getDecisionNodeBuilder() {
        return this.decisionNodeBuilder;
    }

    public INodeBuilder getProbabilisticNodeBuilder() {
        return this.probabilisticNodeBuilder;
    }

    public INodeBuilder getUtilityNodeBuilder() {
        return this.utilityNodeBuilder;
    }

    public void setDecisionNodeBuilder(INodeBuilder builder) {
        this.decisionNodeBuilder = builder;
    }

    public void setProbabilisticNodeBuilder(INodeBuilder builder) {
        this.probabilisticNodeBuilder = builder;
    }

    public void setUtilityNodeBuilder(INodeBuilder builder) {
        this.utilityNodeBuilder = builder;
    }

    public INodeBuilder getContinuousNodeBuilder() {
        return this.continuousNodeBuilder;
    }

    public void setContinuousNodeBuilder(INodeBuilder builder) {
        this.continuousNodeBuilder = builder;
    }
}

