/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import unbbayes.gui.HierarchicTree;
import unbbayes.io.BaseIO;
import unbbayes.io.builder.IProbabilisticNetworkBuilder;
import unbbayes.io.builder.impl.DefaultProbabilisticNetworkBuilder;
import unbbayes.io.exception.LoadException;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ExplanationPhrase;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.msbn.SubNetwork;
import unbbayes.util.ArrayMap;
import unbbayes.util.Debug;

public class NetIO
implements BaseIO {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.resources.IoResources");
    private static final String ERROR_NET = resource.getString("errorNet");
    protected long lineno = 1L;

    public ProbabilisticNetwork load(File input) throws LoadException, IOException {
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        DefaultProbabilisticNetworkBuilder networkBuilder = DefaultProbabilisticNetworkBuilder.newInstance();
        ProbabilisticNetwork net = networkBuilder.buildNetwork(id);
        this.load(input, net, networkBuilder);
        return net;
    }

    public ProbabilisticNetwork load(File input, IProbabilisticNetworkBuilder networkBuilder) throws LoadException, IOException {
        int index = input.getName().lastIndexOf(46);
        String id = input.getName().substring(0, index);
        ProbabilisticNetwork net = networkBuilder.buildNetwork(id);
        this.load(input, net, networkBuilder);
        return net;
    }

    public void save(File output, SingleEntityNetwork net) throws FileNotFoundException {
        Node auxNode1;
        PrintStream stream = new PrintStream(new FileOutputStream(output));
        this.saveNetHeader(stream, net);
        int nodeSize = net.getNodeCount();
        int c1 = 0;
        while (c1 < nodeSize) {
            auxNode1 = net.getNodeAt(c1);
            this.saveNodeDeclaration(stream, auxNode1, net);
            ++c1;
        }
        c1 = 0;
        while (c1 < net.getNodeCount()) {
            auxNode1 = net.getNodeAt(c1);
            this.savePotentialDeclaration(stream, auxNode1, net);
            ++c1;
        }
        stream.close();
    }

    public void saveMSBN(File output, SingleAgentMSBN msbn) throws FileNotFoundException {
        if (!output.isDirectory()) {
            System.err.println(resource.getString("IsNotDirectoryException"));
            return;
        }
        int i = msbn.getNetCount() - 1;
        while (i >= 0) {
            SubNetwork net = msbn.getNetAt(i);
            File out = new File(output, String.valueOf(net.getId()) + ".net");
            this.save(out, net);
            --i;
        }
    }

    public SingleAgentMSBN loadMSBN(File input) throws IOException, LoadException {
        if (!input.isDirectory()) {
            throw new LoadException(resource.getString("IsNotDirectoryException"));
        }
        DefaultProbabilisticNetworkBuilder networkBuilder = DefaultProbabilisticNetworkBuilder.newInstance();
        SingleAgentMSBN msbn = new SingleAgentMSBN(input.getName());
        File[] files = input.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile()) {
                String fileName = files[i].getName();
                int index = fileName.lastIndexOf(46);
                if (index < 0) {
                    throw new RuntimeException();
                }
                if (fileName.substring(index + 1).equalsIgnoreCase("net")) {
                    SubNetwork net = new SubNetwork(fileName.substring(0, index));
                    this.load(files[i], net, networkBuilder);
                    msbn.addNetwork(net);
                }
            }
            ++i;
        }
        return msbn;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void load(File input, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        BufferedReader r = new BufferedReader(new FileReader(input));
        StreamTokenizer st = new StreamTokenizer(r);
        this.setUpStreamTokenizer(st);
        this.getNext(st);
        if (!st.sval.equals("net")) {
            throw new LoadException(String.valueOf(ERROR_NET) + resource.getString("LoadException"));
        }
        this.loadNetHeader(st, net);
        while (this.getNext(st) != -1) {
            this.loadNodeDeclaration(st, net, networkBuilder);
            this.loadContinuousNodeDeclaration(st, net, networkBuilder);
            this.loadPotentialDeclaration(st, net);
        }
        r.close();
        this.setUpHierarchicTree(net);
    }

    protected int getNext(StreamTokenizer st) throws IOException {
        do {
            st.nextToken();
            if (st.ttype != 10) continue;
            ++this.lineno;
        } while (st.ttype != -3 && st.ttype != 34 && st.ttype != -1);
        return st.ttype;
    }

    protected void loadHierarchicTree(StringBuffer sb, DefaultMutableTreeNode root) {
        int size = sb.length();
        DefaultMutableTreeNode nextRoot = null;
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        int i = 0;
        while (i < size) {
            char c = sb.charAt(i);
            if (c == '(') {
                if (nextRoot != null) {
                    stack.push(root);
                    root = nextRoot;
                }
            } else if (c == ')') {
                if (stack.size() > 0) {
                    root = (DefaultMutableTreeNode)stack.pop();
                }
            } else if (c != ',') {
                DefaultMutableTreeNode newNode;
                StringBuffer newWord = new StringBuffer();
                while (c != '(' && c != ')' && c != ',') {
                    newWord.append(c);
                    c = sb.charAt(++i);
                }
                --i;
                nextRoot = newNode = new DefaultMutableTreeNode(newWord);
                root.add(newNode);
            }
            ++i;
        }
    }

    protected String saveHierarchicTree(HierarchicTree hierarchicTree) {
        TreeModel model = hierarchicTree.getModel();
        StringBuffer sb = new StringBuffer();
        TreeNode root = (TreeNode)model.getRoot();
        int childCount = model.getChildCount(root);
        if (childCount == 0) {
            return null;
        }
        sb.append('(');
        int i = 0;
        while (i < childCount) {
            this.processTreeNode((TreeNode)model.getChild(root, i), sb, model);
            if (i != childCount - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    protected void processTreeNode(TreeNode node, StringBuffer sb, TreeModel model) {
        sb.append(node.toString());
        if (!node.isLeaf()) {
            sb.append('(');
            int childCount = model.getChildCount(node);
            int i = 0;
            while (i < childCount) {
                this.processTreeNode((TreeNode)model.getChild(node, i), sb, model);
                if (i != childCount - 1) {
                    sb.append(',');
                }
                ++i;
            }
            sb.append(')');
        }
    }

    protected void readTillEOL(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() != 10) {
        }
        tokenizer.pushBack();
    }

    protected String formatString(String string) {
        return string.replace('\n', '#');
    }

    protected String unformatString(String string) {
        return string.replace('#', '\n');
    }

    protected void setUpStreamTokenizer(StreamTokenizer st) throws IOException {
        st.resetSyntax();
        st.wordChars(65, 90);
        st.wordChars(97, 125);
        st.wordChars(160, 255);
        st.wordChars(95, 95);
        st.wordChars(45, 45);
        st.wordChars(48, 57);
        st.wordChars(46, 46);
        st.wordChars(37, 37);
        st.ordinaryChars(40, 41);
        st.eolIsSignificant(false);
        st.quoteChar(34);
    }

    protected void loadNetHeader(StreamTokenizer st, SingleEntityNetwork net) throws IOException {
        this.getNext(st);
        if (st.sval.equals("{")) {
            this.getNext(st);
            while (!st.sval.equals("}")) {
                this.loadNetHeaderBody(st, net);
                this.getNext(st);
            }
        }
    }

    protected void loadNetHeaderBody(StreamTokenizer st, SingleEntityNetwork net) throws IOException {
        if (st.sval.equals("name")) {
            this.getNext(st);
            net.setName(st.sval);
        } else if (st.sval.equals("node_size")) {
            this.getNext(st);
            this.getNext(st);
            net.setRadius(Double.parseDouble(st.sval) / 2.0);
        } else if (st.sval.equals("tree")) {
            this.getNext(st);
            StringBuffer sb = new StringBuffer(st.sval);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Information Variable");
            this.loadHierarchicTree(sb, root);
            DefaultTreeModel model = new DefaultTreeModel(root);
            HierarchicTree hierarchicTree = new HierarchicTree(model);
            net.setHierarchicTree(hierarchicTree);
        } else if (st.sval.equals("UnBBayes_Color_Utility")) {
            this.getNext(st);
            UtilityNode.setColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Decision")) {
            this.getNext(st);
            DecisionNode.setColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Probabilistic_Description")) {
            this.getNext(st);
            ProbabilisticNode.setDescriptionColor(Integer.parseInt(st.sval));
        } else if (st.sval.equals("UnBBayes_Color_Probabilistic_Explanation")) {
            this.getNext(st);
            ProbabilisticNode.setExplanationColor(Integer.parseInt(st.sval));
        }
    }

    protected void loadNodeDeclaration(StreamTokenizer st, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        if (st.sval.equals("node") || st.sval.equals("decision") || st.sval.equals("utility")) {
            Node auxNode = null;
            auxNode = st.sval.equals("node") ? networkBuilder.getProbabilisticNodeBuilder().buildNode() : (st.sval.equals("decision") ? networkBuilder.getDecisionNodeBuilder().buildNode() : networkBuilder.getUtilityNodeBuilder().buildNode());
            this.getNext(st);
            auxNode.setName(st.sval);
            this.getNext(st);
            if (st.sval.equals("{")) {
                this.getNext(st);
                while (!st.sval.equals("}")) {
                    this.loadNodeDeclarationBody(st, auxNode);
                }
                net.addNode(auxNode);
            } else {
                throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException3"));
            }
        }
    }

    protected void loadContinuousNodeDeclaration(StreamTokenizer st, SingleEntityNetwork net, IProbabilisticNetworkBuilder networkBuilder) throws IOException, LoadException {
        if (st.sval.equals("continuous")) {
            this.getNext(st);
            if (st.sval.equals("node")) {
                Node continuousNode = networkBuilder.getContinuousNodeBuilder().buildNode();
                this.getNext(st);
                continuousNode.setName(st.sval);
                this.getNext(st);
                if (st.sval.equals("{")) {
                    this.getNext(st);
                    while (!st.sval.equals("}")) {
                        this.loadNodeDeclarationBody(st, continuousNode);
                    }
                    net.addNode(continuousNode);
                } else {
                    throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException3"));
                }
            }
        }
    }

    protected void loadPotentialDeclaration(StreamTokenizer st, SingleEntityNetwork net) throws IOException, LoadException {
        if (st.sval.equals("potential")) {
            ITabledVariable auxTableVar = null;
            PotentialTable auxPotentialTable = null;
            this.getNext(st);
            Node auxNode1 = net.getNode(st.sval);
            if (auxNode1 instanceof ITabledVariable) {
                auxTableVar = (ITabledVariable)((Object)auxNode1);
                auxPotentialTable = auxTableVar.getPotentialTable();
                auxPotentialTable.addVariable(auxNode1);
            }
            this.getNext(st);
            if (st.sval.equals("|")) {
                this.getNext(st);
            }
            while (!st.sval.startsWith("{")) {
                Node auxNo2 = net.getNode(st.sval);
                Edge auxArco = new Edge(auxNo2, auxNode1);
                try {
                    net.addEdge(auxArco);
                }
                catch (InvalidParentException e) {
                    throw new LoadException(e.getMessage());
                }
                this.getNext(st);
            }
            if (auxNode1 instanceof ITabledVariable) {
                int sizeVetor = auxPotentialTable.variableCount() / 2;
                int k = 1;
                while (k <= sizeVetor) {
                    Node temp = auxPotentialTable.getVariableAt(k);
                    auxPotentialTable.setVariableAt(k, auxPotentialTable.getVariableAt(auxPotentialTable.variableCount() - k));
                    auxPotentialTable.setVariableAt(auxPotentialTable.variableCount() - k, temp);
                    ++k;
                }
            }
            if (st.sval.length() == 1) {
                this.getNext(st);
            }
            if (st.sval.endsWith("}")) {
                Debug.println(this.getClass(), "Empty potential declaration found for " + auxNode1.getName());
            }
            while (!st.sval.endsWith("}")) {
                if (st.sval.equals("data")) {
                    this.getNext(st);
                    if (st.sval.equals("normal")) {
                        this.loadPotentialDataContinuous(st, auxNode1);
                        continue;
                    }
                    this.loadPotentialDataOrdinal(st, auxNode1);
                    continue;
                }
                throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException5"));
            }
        }
    }

    protected void setUpHierarchicTree(SingleEntityNetwork net) {
        HierarchicTree tree = net.getHierarchicTree();
        if (tree != null) {
            tree.setProbabilisticNetwork(net, false);
        }
    }

    protected void loadNodeDeclarationBody(StreamTokenizer st, Node node) throws IOException, LoadException {
        if (st.sval.equals("label")) {
            this.getNext(st);
            node.setDescription(st.sval);
            this.getNext(st);
        } else if (st.sval.equals("position")) {
            int y;
            this.getNext(st);
            int x = Integer.parseInt(st.sval);
            this.getNext(st);
            if (x <= 0) {
                x = Node.getWidth();
            }
            if ((y = Integer.parseInt(st.sval)) <= 0) {
                y = Node.getHeight();
            }
            node.setPosition(x, y);
            this.getNext(st);
        } else if (st.sval.equals("states")) {
            while (this.getNext(st) == 34) {
                node.appendState(st.sval);
            }
        } else if (st.sval.equals("meanPerClass")) {
            ArrayList<String> array = new ArrayList<String>();
            while (this.getNext(st) == 34) {
                array.add(st.sval);
            }
            int size = array.size();
            double[] mean = new double[size];
            int i = 0;
            while (i < size) {
                mean[i] = Double.parseDouble((String)array.get(i));
                ++i;
            }
            node.setMean(mean);
        } else if (st.sval.equals("stdDevPerClass")) {
            ArrayList<String> array = new ArrayList<String>();
            while (this.getNext(st) == 34) {
                array.add(st.sval);
            }
            int size = array.size();
            double[] stdDev = new double[size];
            int i = 0;
            while (i < size) {
                stdDev[i] = Double.parseDouble((String)array.get(i));
                ++i;
            }
            node.setStandardDeviation(stdDev);
        } else if (st.sval.equals("%descricao")) {
            this.getNext(st);
            node.setExplanationDescription(this.unformatString(st.sval));
            node.setInformationType(4);
            this.readTillEOL(st);
            this.getNext(st);
        } else if (st.sval.equals("%frase")) {
            this.getNext(st);
            ExplanationPhrase explanationPhrase = new ExplanationPhrase();
            explanationPhrase.setNode(st.sval);
            this.getNext(st);
            try {
                explanationPhrase.setEvidenceType(Integer.parseInt(st.sval));
            }
            catch (Exception ex) {
                throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException2") + st.sval);
            }
            this.getNext(st);
            explanationPhrase.setPhrase(this.unformatString(st.sval));
            node.addExplanationPhrase(explanationPhrase);
            this.readTillEOL(st);
            this.getNext(st);
        } else if (st.sval.contains("HR_")) {
            Debug.println(this.getClass(), "Ignoring HR declaration: " + st.sval);
            while (this.getNext(st) == 34) {
            }
        } else {
            throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException2") + st.sval);
        }
    }

    protected void loadPotentialDataOrdinal(StreamTokenizer st, Node node) throws LoadException, IOException {
        PotentialTable auxPotentialTable = ((ITabledVariable)((Object)node)).getPotentialTable();
        if (node.getType() == 2) {
            throw new LoadException(String.valueOf(ERROR_NET) + " l." + ((long)st.lineno() < this.lineno ? this.lineno : (long)st.lineno()) + resource.getString("LoadException4"));
        }
        int nDim = 0;
        while (!st.sval.equals("}")) {
            if (st.sval.equals("%")) {
                this.readTillEOL(st);
            } else {
                auxPotentialTable.setValue(nDim++, Float.parseFloat(st.sval));
            }
            this.getNext(st);
        }
    }

    protected void loadPotentialDataContinuous(StreamTokenizer st, Node node) throws LoadException, IOException {
        Debug.println(this.getClass(), "Continuous potential loading is not implemented yet: " + node.getName());
        while (!st.sval.equals("}")) {
            this.getNext(st);
        }
    }

    protected void saveNetHeader(PrintStream stream, SingleEntityNetwork net) {
        stream.println("net");
        stream.println("{");
        this.saveNetHeaderBody(stream, net);
        stream.println("}");
        stream.println();
    }

    protected void saveNetHeaderBody(PrintStream stream, SingleEntityNetwork net) {
        stream.println("     node_size = (" + (int)(net.getRadius() * 2.0) + " " + (int)(net.getRadius() * 2.0) + ");");
        stream.println("     name = \"" + net.getName() + "\";");
        String tree = this.saveHierarchicTree(net.getHierarchicTree());
        if (tree != null) {
            stream.println("     tree = \"" + tree + "\";");
        }
        stream.println("     UnBBayes_Color_Probabilistic_Description = \"" + ProbabilisticNode.getDescriptionColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Probabilistic_Explanation = \"" + ProbabilisticNode.getExplanationColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Utility = \"" + UtilityNode.getColor().getRGB() + "\";");
        stream.println("     UnBBayes_Color_Decision = \"" + DecisionNode.getColor().getRGB() + "\";");
    }

    protected void saveNodeDeclaration(PrintStream stream, Node node, SingleEntityNetwork net) {
        if (node instanceof ContinuousNode) {
            stream.print("continuous node");
        } else if (node.getType() == 0) {
            stream.print("node");
        } else if (node.getType() == 2) {
            stream.print("decision");
        } else {
            stream.print("utility");
        }
        stream.println(" " + node.getName());
        stream.println("{");
        this.saveNodeDeclarationBody(stream, node, net);
        stream.println("}");
        stream.println();
    }

    protected void saveNodeDeclarationBody(PrintStream stream, Node node, SingleEntityNetwork net) {
        this.saveNodeLabelAndPosition(stream, node);
        if (!(node instanceof ContinuousNode)) {
            if (node.getType() != 1) {
                if (node.getStatesSize() == 0) {
                    double[] mean = node.getMean();
                    double[] stdDev = node.getStandardDeviation();
                    StringBuffer auxString = new StringBuffer();
                    auxString.append("\"" + mean[0] + "\"");
                    int i = 1;
                    while (i < mean.length) {
                        auxString.append(" \"" + mean[i] + "\"");
                        ++i;
                    }
                    stream.println("     meanPerClass = (" + auxString.toString() + ");");
                    auxString = new StringBuffer();
                    auxString.append("\"" + stdDev[0] + "\"");
                    i = 1;
                    while (i < mean.length) {
                        auxString.append(" \"" + stdDev[i] + "\"");
                        ++i;
                    }
                    stream.println("     stdDevPerClass = (" + auxString.toString() + ");");
                } else {
                    StringBuffer auxString = new StringBuffer("\"" + node.getStateAt(0) + "\"");
                    int sizeEstados = node.getStatesSize();
                    int c2 = 1;
                    while (c2 < sizeEstados) {
                        auxString.append(" \"" + node.getStateAt(c2) + "\"");
                        ++c2;
                    }
                    stream.println("     states = (" + auxString.toString() + ");");
                }
            }
            if (node.getInformationType() == 4) {
                String explanationDescription = this.formatString(node.getExplanationDescription());
                stream.println("     %descricao \"" + explanationDescription + "\"");
                ArrayMap<String, ExplanationPhrase> arrayMap = node.getPhrasesMap();
                int size = arrayMap.size();
                ArrayList<String> keys = arrayMap.getKeys();
                int i = 0;
                while (i < size) {
                    String key = keys.get(i);
                    ExplanationPhrase explanationPhrase = arrayMap.get(key);
                    stream.println("     %frase \"" + explanationPhrase.getNode() + "\" " + "\"" + explanationPhrase.getEvidenceType() + "\" " + "\"" + this.formatString(explanationPhrase.getPhrase()) + "\"");
                    ++i;
                }
            }
        }
    }

    protected void savePotentialDeclaration(PrintStream stream, Node node, SingleEntityNetwork net) {
        ArrayList<Node> auxParentList = node.getParents();
        stream.print("potential (" + node.getName());
        int sizeVa = auxParentList.size();
        if (sizeVa > 0) {
            stream.print(" |");
            int c2 = 0;
            while (c2 < sizeVa) {
                Node auxNo2 = auxParentList.get(c2);
                stream.print(" " + auxNo2.getName());
                ++c2;
            }
        }
        stream.println(")");
        stream.println("{");
        this.savePotentialDeclarationBody(stream, node, net);
        stream.println("}");
        stream.println();
    }

    protected void savePotentialDeclarationBody(PrintStream stream, Node node, SingleEntityNetwork net) {
        if (node instanceof ContinuousNode) {
            Debug.println(this.getClass(), "TODO implement continuous node's potential treatment: " + node.getName());
            ContinuousNode continuous = (ContinuousNode)node;
            stream.print(" data = normal ( ");
            stream.print(continuous.getCnNormalDistribution().getMean(0));
            int i = 0;
            while (i < continuous.getParents().size()) {
                Debug.println(this.getClass(), "TODO implement continuous node's parent treatment: " + continuous.getParents().get(i).getName());
                stream.print(" + " + continuous.getCnNormalDistribution().getConstantAt(i, 0));
                stream.print(" * " + continuous.getParents().get(i).getName());
                ++i;
            }
            stream.print(", " + continuous.getCnNormalDistribution().getVariance(0));
            stream.println(" );");
        } else if (node instanceof ITabledVariable) {
            PotentialTable auxTabPot = ((ITabledVariable)((Object)node)).getPotentialTable();
            int sizeVa1 = auxTabPot.variableCount();
            stream.print(" data = ");
            boolean[] paren = new boolean[sizeVa1];
            int sizeDados = auxTabPot.tableSize();
            int c2 = 0;
            while (c2 < sizeDados) {
                int[] coord = auxTabPot.voltaCoord(c2);
                int c3 = 0;
                while (c3 < sizeVa1) {
                    if (coord[c3] == 0 && !paren[c3]) {
                        stream.print("(");
                        paren[c3] = true;
                    }
                    ++c3;
                }
                stream.print(" " + auxTabPot.getValue(c2));
                if (c2 % node.getStatesSize() == node.getStatesSize() - 1) {
                    stream.print(" ");
                }
                int celulas = 1;
                int c32 = 0;
                while (c32 < sizeVa1) {
                    Node auxNo2 = auxTabPot.getVariableAt(c32);
                    if ((c2 + 1) % (celulas *= auxNo2.getStatesSize()) == 0) {
                        stream.print(")");
                        if (c32 == sizeVa1 - 1) {
                            stream.print(";");
                        }
                        paren[c32] = false;
                    }
                    ++c32;
                }
                if ((c2 + 1) % node.getStatesSize() == 0) {
                    stream.println();
                }
                ++c2;
            }
        }
    }

    protected void saveNodeLabelAndPosition(PrintStream stream, Node node) {
        stream.println("     label = \"" + node.getDescription() + "\";");
        stream.println("     position = (" + (int)node.getPosition().getX() + " " + (int)node.getPosition().getY() + ");");
    }
}

