/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.oobn;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.MSBNController;
import unbbayes.controller.oobn.OOBNController;
import unbbayes.gui.FileIcon;
import unbbayes.gui.IFileExtensionAwareWindow;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.gui.oobn.OOBNClassWindow;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.msbn.AbstractMSBN;
import unbbayes.prs.msbn.SingleAgentMSBN;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IObjectOrientedBayesianNetwork;
import unbbayes.util.Debug;

public class OOBNWindow
extends JInternalFrame
implements IFileExtensionAwareWindow {
    private static final long serialVersionUID = 0L;
    public static String EDITION_PANE = "editionPane";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{"oobn"};
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.oobn.resources.OOBNGuiResource");
    private JScrollPane oobnClassScroll;
    private JList oobnClassList;
    private JButton compileBtn;
    private JButton removeBtn;
    private JButton newBtn;
    private JButton newFromFileBtn;
    private CardLayout btnCard;
    private JToolBar jtbBtns;
    private JPanel statusPanel;
    private JLabel statusBar;
    private JPanel netPanel;
    private JPanel editionPane;
    protected IconController iconController = IconController.getInstance();
    private OOBNController controller = null;
    private FileController fileController = null;

    protected OOBNWindow(IObjectOrientedBayesianNetwork oobn, OOBNController controller) {
        super(oobn.getTitle(), true, true, true, true);
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        this.initComponents();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.buildClassNavigationPanel(), "West");
        pane.add((Component)this.buildStatusBar(), "South");
        this.fillListeners();
    }

    public static OOBNWindow newInstance(IObjectOrientedBayesianNetwork oobn, OOBNController controller) {
        return new OOBNWindow(oobn, controller);
    }

    private void initComponents() {
        this.oobnClassList = new JList(new OOBNListModel());
        this.oobnClassList.setSelectionMode(0);
        this.oobnClassList.setEnabled(true);
        this.oobnClassList.setDragEnabled(true);
        this.oobnClassList.setToolTipText(resource.getString("dragNDropToAddInstance"));
        this.oobnClassList.setTransferHandler(new TransferHandler(){

            protected Transferable createTransferable(JComponent c) {
                try {
                    return OOBNWindow.this.getController().getSelectedClass();
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "It was not possible to create transferable data", e);
                    return null;
                }
            }

            public int getSourceActions(JComponent c) {
                return 1;
            }

            protected void exportDone(JComponent source, Transferable data, int action) {
                Debug.println(this.getClass(), "Export of data was done");
                OOBNWindow.this.renewClassListIndex();
                super.exportDone(source, data, action);
            }
        });
        this.compileBtn = new JButton(this.iconController.getCompileIcon());
        this.removeBtn = new JButton(this.iconController.getDeleteClassIcon());
        this.newBtn = new JButton(this.iconController.getNewClassIcon());
        this.newFromFileBtn = new JButton(this.iconController.getNewClassFromFileIcon());
        this.compileBtn.setToolTipText(resource.getString("compileToolTip"));
        this.removeBtn.setToolTipText(resource.getString("removeToolTip"));
        this.newBtn.setToolTipText(resource.getString("newToolTip"));
        this.newFromFileBtn.setToolTipText(resource.getString("newFromFileToolTip"));
        this.fileController = FileController.getInstance();
    }

    private Container buildStatusBar() {
        this.statusPanel = new JPanel();
        this.statusBar = new JLabel();
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(new TitledBorder(resource.getString("status")));
        this.statusBar.setText(resource.getString("statusReadyLabel"));
        this.statusPanel.add(this.statusBar);
        return this.statusPanel;
    }

    private JPanel buildClassNavigationPanel() {
        this.netPanel = new JPanel(new BorderLayout());
        this.oobnClassScroll = new JScrollPane(this.oobnClassList);
        this.oobnClassScroll.setToolTipText(resource.getString("dragNDropToAddInstance"));
        this.netPanel.setBorder(new TitledBorder(resource.getString("classNavigationPanelLabel")));
        this.netPanel.add((Component)this.oobnClassScroll, "Center");
        this.jtbBtns = new JToolBar();
        this.jtbBtns.add((Component)this.buildButtonsPanel(), EDITION_PANE);
        this.netPanel.add((Component)this.jtbBtns, "North");
        return this.netPanel;
    }

    private JPanel buildButtonsPanel() {
        this.btnCard = new CardLayout();
        this.jtbBtns.setLayout(this.btnCard);
        this.editionPane = new JPanel();
        this.editionPane.add(this.newBtn);
        this.editionPane.add(this.newFromFileBtn);
        this.editionPane.add(this.removeBtn);
        this.editionPane.add(this.compileBtn);
        this.showBtnPanel(EDITION_PANE);
        return this.editionPane;
    }

    public void addCompileBtnActionListener(ActionListener a) {
        this.compileBtn.addActionListener(a);
    }

    public void addRemoveBtnActionListener(ActionListener a) {
        this.removeBtn.addActionListener(a);
    }

    public void addNewBtnActionListener(ActionListener a) {
        this.newBtn.addActionListener(a);
    }

    public void addNewFromFileBtnActionListener(ActionListener a) {
        this.newFromFileBtn.addActionListener(a);
    }

    public void addListMouseListener(MouseListener l) {
        this.oobnClassList.addMouseListener(l);
    }

    public void showBtnPanel(String paneName) {
        this.btnCard.show(this.jtbBtns, paneName);
    }

    private void fillListeners() {
        this.addListMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    try {
                        int index = OOBNWindow.this.getNetList().locationToIndex(e.getPoint());
                        OOBNWindow.this.getController().setSelectedClass(OOBNWindow.this.getController().getOobn().getOOBNClassList().get(index));
                    }
                    catch (Exception exc) {
                        Debug.println(this.getClass(), "It was not possible to perform mouse pressed event", exc);
                    }
                }
            }

            public void mouseEntered(MouseEvent e) {
                OOBNWindow.this.renewClassListIndex();
                super.mouseEntered(e);
            }

            public void mouseClicked(MouseEvent e) {
                int index = OOBNWindow.this.getNetList().locationToIndex(e.getPoint());
                if (index >= 0 && OOBNWindow.this.getNetList().getModel().getElementAt(index) != OOBNWindow.this.getController().getActive().getSingleEntityNetwork()) {
                    OOBNClassWindow classWindow = OOBNClassWindow.newInstance(OOBNWindow.this.getController().getOobn().getOOBNClassList().get(index));
                    OOBNWindow.this.getController().changeActiveOOBNClass(classWindow);
                }
                if (e.getModifiers() == 4) {
                    ListSelectionModel selmodel = OOBNWindow.this.getNetList().getSelectionModel();
                    selmodel.setLeadSelectionIndex(index);
                    Object item = OOBNWindow.this.getNetList().getModel().getElementAt(index);
                    String text = JOptionPane.showInputDialog(resource.getString("renameClass"), item);
                    String newName = null;
                    if (text == null) {
                        return;
                    }
                    newName = text.trim();
                    if (OOBNWindow.this.getController().containsOOBNClassByName(newName)) {
                        Debug.println(this.getClass(), "The name already exists");
                        JOptionPane.showMessageDialog(OOBNWindow.this.getController().getPanel(), resource.getString("DuplicatedClassName"), resource.getString("renameClass"), 0);
                        return;
                    }
                    if (!newName.isEmpty()) {
                        try {
                            OOBNWindow.this.getController().getOobn().getOOBNClassList().get(index).setClassName(newName);
                        }
                        catch (Exception e1) {
                            Debug.println(this.getClass(), "Invalid name", e1);
                            System.err.print(e1.getMessage());
                        }
                    }
                    Debug.println(this.getClass(), "Changing references at renaming event is not implemented yet.");
                }
            }
        });
        this.addNewBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OOBNWindow.this.getController().addNewOOBNClass(String.valueOf(resource.getString("newOOBNClass")) + OOBNWindow.this.getController().getOobn().getOOBNClassList().size());
                OOBNWindow.this.getNetList().updateUI();
            }
        });
        this.addNewFromFileBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OOBNWindow.this.setCursor(new Cursor(3));
                String[] nets = new String[]{"net", "oobn"};
                JFileChooser chooser = new JFileChooser(OOBNWindow.this.fileController.getCurrentDirectory());
                chooser.setDialogTitle(resource.getString("openClassFromFile"));
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileSelectionMode(0);
                chooser.setFileView(new FileIcon(OOBNWindow.this.getController().getUpperUnBBayesFrame()));
                chooser.addChoosableFileFilter(new SimpleFileFilter(nets, resource.getString("oobnFileFilter")));
                int option = chooser.showOpenDialog(OOBNWindow.this.getController().getUpperUnBBayesFrame());
                if (option == 0 && chooser.getSelectedFile() != null) {
                    chooser.setVisible(false);
                    OOBNWindow.this.getController().getUpperUnBBayesFrame().repaint();
                    File file = chooser.getSelectedFile();
                    OOBNWindow.this.fileController.setCurrentDirectory(chooser.getCurrentDirectory());
                    chooser.setVisible(false);
                    chooser.setEnabled(false);
                    try {
                        Set<IOOBNClass> newClasses = OOBNWindow.this.getController().loadOOBNClassesFromFile(file);
                        for (IOOBNClass loadedClass : newClasses) {
                            try {
                                OOBNWindow.this.getController().addOOBNClass(loadedClass);
                            }
                            catch (IllegalArgumentException iae) {
                                Debug.println(this.getClass(), "Loaded a class already loaded.");
                            }
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(OOBNWindow.this.getController().getPanel(), resource.getString("ErrorLoadingClass"), e.getMessage(), 0);
                        Debug.println(this.getClass(), "Error opening file", e);
                    }
                    OOBNWindow.this.getNetList().updateUI();
                }
                OOBNWindow.this.setCursor(new Cursor(0));
            }
        });
        this.addRemoveBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (OOBNWindow.this.getController().getActive() == null) {
                    return;
                }
                int index = OOBNWindow.this.getNetList().getSelectedIndex();
                if (index < 0) {
                    return;
                }
                OOBNWindow.this.getController().removeClassAt(index);
                OOBNWindow.this.getNetList().setSelectedIndex(0);
                OOBNWindow.this.getNetList().updateUI();
                OOBNWindow.this.getNetList().repaint();
            }
        });
        this.addCompileBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    AbstractMSBN msbn = OOBNWindow.this.getController().compileActiveOOBNClassToMSBN();
                    MSBNController controller = new MSBNController((SingleAgentMSBN)msbn);
                    OOBNWindow.this.getController().getUpperUnBBayesFrame().addWindow(controller.getPanel());
                }
                catch (NullPointerException npe) {
                    JOptionPane.showMessageDialog(OOBNWindow.this.getController().getPanel(), resource.getString("NoClassSelected"), resource.getString("compilationError"), 0);
                    Debug.println(this.getClass(), resource.getString("NoClassSelected"), npe);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(OOBNWindow.this.getController().getPanel(), e.getMessage(), resource.getString("compilationError"), 0);
                    Debug.println(this.getClass(), "Unknown", e);
                }
            }
        });
    }

    public JList getNetList() {
        return this.oobnClassList;
    }

    public void changeToTreeView(JTree tree) {
        this.oobnClassScroll.setViewportView(tree);
    }

    public void changeToListView() {
        this.oobnClassScroll.setViewportView(this.oobnClassList);
    }

    protected void renewClassListIndex() {
        try {
            SingleEntityNetwork activeNetwork = this.getController().getActive().getController().getSingleEntityNetwork();
            int indexOfActiveNetwork = this.getController().getOobn().getOOBNClassList().indexOf(activeNetwork);
            this.getOobnClassList().setSelectedIndex(indexOfActiveNetwork);
            this.getOobnClassList().updateUI();
            Debug.println(this.getClass(), "Setted active class list index to " + indexOfActiveNetwork);
        }
        catch (Exception exc) {
            Debug.println(this.getClass(), "Could not treat event in order to change selected OOBN class", exc);
        }
    }

    public OOBNController getController() {
        return this.controller;
    }

    public void setController(OOBNController controller) {
        this.controller = controller;
    }

    public JScrollPane getOobnClassScroll() {
        return this.oobnClassScroll;
    }

    public void setOobnClassScroll(JScrollPane oobnClassScroll) {
        this.oobnClassScroll = oobnClassScroll;
    }

    public JList getOobnClassList() {
        return this.oobnClassList;
    }

    public void setOobnClassList(JList oobnClassList) {
        this.oobnClassList = oobnClassList;
    }

    public JButton getCompileBtn() {
        return this.compileBtn;
    }

    public void setCompileBtn(JButton compileBtn) {
        this.compileBtn = compileBtn;
    }

    public JButton getRemoveBtn() {
        return this.removeBtn;
    }

    public void setRemoveBtn(JButton removeBtn) {
        this.removeBtn = removeBtn;
    }

    public JButton getNewBtn() {
        return this.newBtn;
    }

    public void setNewBtn(JButton newBtn) {
        this.newBtn = newBtn;
    }

    public JButton getNewFromFileBtn() {
        return this.newFromFileBtn;
    }

    public void setNewFromFileBtn(JButton newFromFileBtn) {
        this.newFromFileBtn = newFromFileBtn;
    }

    public CardLayout getBtnCard() {
        return this.btnCard;
    }

    public void setBtnCard(CardLayout btnCard) {
        this.btnCard = btnCard;
    }

    public JToolBar getJtbBtns() {
        return this.jtbBtns;
    }

    public void setJtbBtns(JToolBar jtbBtns) {
        this.jtbBtns = jtbBtns;
    }

    public JPanel getStatusPanel() {
        return this.statusPanel;
    }

    public void setStatusPanel(JPanel statusPanel) {
        this.statusPanel = statusPanel;
    }

    public JLabel getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(JLabel statusBar) {
        this.statusBar = statusBar;
    }

    public JPanel getNetPanel() {
        return this.netPanel;
    }

    public void setNetPanel(JPanel netPanel) {
        this.netPanel = netPanel;
    }

    public JPanel getEditionPane() {
        return this.editionPane;
    }

    public void setEditionPane(JPanel editionPane) {
        this.editionPane = editionPane;
    }

    public IconController getIconController() {
        return this.iconController;
    }

    public void setIconController(IconController iconController) {
        this.iconController = iconController;
    }

    public FileController getFileController() {
        return this.fileController;
    }

    public void setFileController(FileController fileController) {
        this.fileController = fileController;
    }

    public String[] getSupportedFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public String getSupportedFilesDescription() {
        return resource.getString("netFileFilterSaveOOBN");
    }

    public String getSavingMessage() {
        return resource.getString("saveTitle");
    }

    private class OOBNListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 0L;

        private OOBNListModel() {
        }

        public int getSize() {
            return OOBNWindow.this.getController().getOobn().getOOBNClassCount();
        }

        public Object getElementAt(int index) {
            try {
                return OOBNWindow.this.getController().getOobn().getOOBNClassList().get(index);
            }
            catch (RuntimeException e) {
                try {
                    Debug.println(this.getClass(), "Cannot retrieve oobn class at " + index + " from " + OOBNWindow.this.getController().getOobn().getTitle());
                }
                catch (Exception e2) {
                    Debug.println(this.getClass(), "Unknown error - may be no OOBN is set.");
                }
                throw e;
            }
        }
    }
}

