/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.util.ArrayMap;

public class ResidentOVariableTree
extends JTree {
    private MultiEntityBayesianNetwork net;
    private ArrayMap<Object, OrdinaryVariable> ordinaryVariableMap = new ArrayMap();
    private List<OrdinaryVariable> ordinaryVariableList = new ArrayList<OrdinaryVariable>();
    private ResidentNode residentNodeActive;
    private OrdinaryVariable oVariableSelected = null;
    protected IconController iconController = IconController.getInstance();
    private final MEBNController mebnController;

    public ResidentOVariableTree(MEBNController controller, ResidentNode resident) {
        this.mebnController = controller;
        this.net = controller.getMultiEntityBayesianNetwork();
        this.residentNodeActive = resident;
        this.setCellRenderer(new OrdinaryVariableTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(resident.getName());
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
        this.createTree();
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = ResidentOVariableTree.this.getRowForLocation(e.getX(), e.getY());
                if (selRow == -1) {
                    return;
                }
                TreePath selPath = ResidentOVariableTree.this.getPathForLocation(e.getX(), e.getY());
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                OrdinaryVariable ordinaryVariable = (OrdinaryVariable)ResidentOVariableTree.this.ordinaryVariableMap.get(node);
                if (node.isLeaf() && ordinaryVariable != null) {
                    if (e.getModifiers() != 4 && e.getClickCount() == 1 && e.getModifiers() == 16) {
                        ResidentOVariableTree.this.oVariableSelected = ordinaryVariable;
                        ResidentOVariableTree.this.mebnController.setOVariableSelectedInResidentTree(ResidentOVariableTree.this.oVariableSelected);
                    }
                } else {
                    ResidentOVariableTree.this.oVariableSelected = null;
                }
            }
        });
    }

    private void createTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.ordinaryVariableList = this.residentNodeActive.getOrdinaryVariableList();
        for (OrdinaryVariable ordinaryVariable : this.ordinaryVariableList) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ordinaryVariable.getName());
            this.ordinaryVariableMap.put(node, ordinaryVariable);
            root.add(node);
        }
        this.expandRow(0);
    }

    public void updateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.ordinaryVariableMap.clear();
        this.ordinaryVariableList = this.residentNodeActive.getOrdinaryVariableList();
        for (OrdinaryVariable ordinaryVariable : this.ordinaryVariableList) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ordinaryVariable.getName());
            this.ordinaryVariableMap.put(node, ordinaryVariable);
            root.add(node);
        }
        this.oVariableSelected = null;
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.expandRow(0);
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    public OrdinaryVariable getOVariableSelected() {
        return this.oVariableSelected;
    }

    public void setOVariableSelected(OrdinaryVariable ov) {
        this.oVariableSelected = ov;
    }

    private class OrdinaryVariableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon grayBorderBox;
        private ImageIcon greenNodeIcon;

        private OrdinaryVariableTreeCellRenderer() {
            this.grayBorderBox = ResidentOVariableTree.this.iconController.getGrayBorderBoxIcon();
            this.greenNodeIcon = ResidentOVariableTree.this.iconController.getGreenNodeIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = ResidentOVariableTree.this.ordinaryVariableMap.get((DefaultMutableTreeNode)value);
            if (leaf) {
                if (obj != null) {
                    this.setIcon(this.grayBorderBox);
                }
            } else {
                this.setIcon(this.greenNodeIcon);
            }
            return this;
        }
    }
}

