/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.BooleanStateEntity;
import unbbayes.prs.mebn.entity.CategoricalStateEntity;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.ReservedWordException;

public class PossibleValuesEditionPane
extends JPanel {
    private final String PANEL_CATEGORY_STATES = "category";
    private final String PANEL_BOOLEAN_STATES = "boolean";
    private final String PANEL_OBJECT_STATES = "object";
    private ResidentNode residentNode;
    private MEBNController mebnController;
    private JPanel jtbOptions;
    private StatesPanel panelStates;
    private ListStatesPanel listStatesPanel;
    private CardLayout cardLayout;
    private CategoryStatesPanel panelCategoryStates;
    private BooleanStatesPanel panelBooleanStates;
    private ObjectStatesPanel panelObjectStates;
    private List<StateLink> statesList;
    private JList statesJList;
    private DefaultListModel statesListModel;
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private final IconController iconController = IconController.getInstance();

    public PossibleValuesEditionPane() {
    }

    public PossibleValuesEditionPane(MEBNController _controller, ResidentNode _residentNode) {
        super(new BorderLayout());
        this.residentNode = _residentNode;
        this.mebnController = _controller;
        this.buildListStates();
        this.jtbOptions = new OptionsPanel();
        this.listStatesPanel = new ListStatesPanel();
        this.panelStates = new StatesPanel();
        this.add((Component)this.jtbOptions, "North");
        this.add((Component)this.listStatesPanel, "Center");
        this.add((Component)this.panelStates, "South");
    }

    public void selectState(StateLink stateLink) {
        Entity entitySelected = stateLink.getState();
        if (entitySelected instanceof CategoricalStateEntity) {
            this.showCategoryStatesPanel(stateLink);
        } else if (entitySelected instanceof BooleanStateEntity) {
            this.showBooleanStatesPanel(stateLink);
        } else if (entitySelected instanceof ObjectEntity) {
            this.showObjectStatesPanel(stateLink);
        }
    }

    public void showCategoryStatesPanel(StateLink entitySelected) {
        this.cardLayout.show(this.panelStates, "category");
        this.panelCategoryStates.selectState(entitySelected);
    }

    public void showBooleanStatesPanel(StateLink entitySelected) {
        this.cardLayout.show(this.panelStates, "boolean");
        this.panelBooleanStates.selectState(entitySelected);
    }

    public void showObjectStatesPanel(StateLink entitySelected) {
        this.cardLayout.show(this.panelStates, "object");
        this.panelObjectStates.selectState(entitySelected);
    }

    public void buildListStates() {
        this.statesList = this.residentNode.getPossibleValueLinkList();
        this.statesListModel = new DefaultListModel();
        for (StateLink entity : this.statesList) {
            this.statesListModel.addElement(entity);
        }
        this.statesJList = new JList(this.statesListModel);
        this.statesJList.setSelectionMode(0);
        this.statesJList.setCellRenderer(new StateCellRenderer());
        this.statesJList.setLayoutOrientation(0);
        this.statesJList.setVisibleRowCount(-1);
    }

    public JList buildListAllStates() {
        List<CategoricalStateEntity> list = this.mebnController.getMultiEntityBayesianNetwork().getCategoricalStatesEntityContainer().getListEntity();
        DefaultListModel<Entity> model = new DefaultListModel<Entity>();
        JList<Object> listAllStates = new JList<Object>();
        model = new DefaultListModel();
        for (Entity entity : list) {
            model.addElement(entity);
        }
        listAllStates = new JList(model);
        listAllStates.setSelectionMode(2);
        listAllStates.setSelectedIndex(0);
        listAllStates.setCellRenderer(new StateCellRenderer());
        listAllStates.setLayoutOrientation(0);
        listAllStates.setVisibleRowCount(-1);
        return listAllStates;
    }

    public JFrame buildPopupStateSelection() {
        final JFrame newFrame = new JFrame();
        final JList listAllStates = this.buildListAllStates();
        ListAllStatesPanel paneAllStates = new ListAllStatesPanel(listAllStates);
        JToolBar barButtons = new JToolBar();
        barButtons.setLayout(new GridLayout(1, 2));
        JButton btnAdd = new JButton(this.iconController.getMoreIcon());
        btnAdd.setToolTipText(resource.getString("addSelectedStatesTip"));
        JButton btnExit = new JButton(resource.getString("closeButton"));
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] list = listAllStates.getSelectedValues();
                if (!PossibleValuesEditionPane.this.residentNode.getPossibleValueLinkList().isEmpty() && PossibleValuesEditionPane.this.residentNode.getTypeOfStates() != 1) {
                    int answer = JOptionPane.showConfirmDialog(PossibleValuesEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("warningDeletStates"), resource.getString("confirmation"), 0);
                    if (answer == 0) {
                        PossibleValuesEditionPane.this.mebnController.removeAllPossibleValues(PossibleValuesEditionPane.this.residentNode);
                        PossibleValuesEditionPane.this.residentNode.setTypeOfStates(1);
                    } else {
                        return;
                    }
                }
                int i = 0;
                while (i < list.length) {
                    PossibleValuesEditionPane.this.mebnController.addPossibleValue(PossibleValuesEditionPane.this.residentNode, (CategoricalStateEntity)list[i]);
                    ++i;
                }
                PossibleValuesEditionPane.this.listStatesPanel.update();
            }
        });
        btnExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                newFrame.dispose();
            }
        });
        barButtons.add(btnAdd);
        barButtons.add(btnExit);
        barButtons.setFloatable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)paneAllStates, "Center");
        panel.add((Component)barButtons, "Last");
        newFrame.setContentPane(panel);
        newFrame.setDefaultCloseOperation(2);
        newFrame.setVisible(true);
        newFrame.setSize(200, 300);
        newFrame.setTitle(resource.getString("existentStatesDialogTip"));
        newFrame.setLocationRelativeTo(null);
        newFrame.validate();
        return newFrame;
    }

    private class BooleanStatesPanel
    extends JPanel {
        private JButton btnAdd;
        private JCheckBox checkGloballyExclusive;
        private JTextField txtName;
        private StateLink selectEntity;

        public BooleanStatesPanel() {
            super(new GridLayout(3, 1));
            this.txtName = new JTextField();
            this.btnAdd = new JButton(PossibleValuesEditionPane.this.iconController.getMoreIcon());
            this.btnAdd.setToolTipText(resource.getString("addStateTip"));
            JToolBar barAddStates = new JToolBar();
            barAddStates.setFloatable(false);
            barAddStates.setLayout(new GridLayout(1, 3));
            barAddStates.add(new JLabel());
            barAddStates.add(this.btnAdd);
            barAddStates.add(new JLabel());
            JToolBar barName = new JToolBar();
            barName.setFloatable(false);
            JLabel labelName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            barName.add(labelName);
            this.txtName.setEditable(false);
            barName.add(this.txtName);
            JToolBar toolGloballyExclusive = new JToolBar();
            toolGloballyExclusive.setFloatable(false);
            JLabel labelExclusive = new JLabel(resource.getString("isGloballyExclusive"));
            this.checkGloballyExclusive = new JCheckBox();
            this.checkGloballyExclusive.setSelected(false);
            this.checkGloballyExclusive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (BooleanStatesPanel.this.selectEntity != null) {
                        PossibleValuesEditionPane.this.mebnController.setGloballyExclusiveProperty(BooleanStatesPanel.this.selectEntity, BooleanStatesPanel.this.checkGloballyExclusive.isSelected());
                    }
                }
            });
            toolGloballyExclusive.add(this.checkGloballyExclusive);
            toolGloballyExclusive.add(labelExclusive);
            this.add(barAddStates);
            this.add(barName);
            this.add(toolGloballyExclusive);
            this.btnAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!PossibleValuesEditionPane.this.residentNode.getPossibleValueLinkList().isEmpty()) {
                        int answer = JOptionPane.showConfirmDialog(PossibleValuesEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("warningDeletStates"), resource.getString("confirmation"), 0);
                        if (answer == 0) {
                            PossibleValuesEditionPane.this.mebnController.removeAllPossibleValues(PossibleValuesEditionPane.this.residentNode);
                            PossibleValuesEditionPane.this.mebnController.addBooleanAsPossibleValue(PossibleValuesEditionPane.this.residentNode);
                            PossibleValuesEditionPane.this.residentNode.setTypeOfStates(2);
                            PossibleValuesEditionPane.this.listStatesPanel.update();
                        }
                    } else {
                        PossibleValuesEditionPane.this.mebnController.addBooleanAsPossibleValue(PossibleValuesEditionPane.this.residentNode);
                        PossibleValuesEditionPane.this.residentNode.setTypeOfStates(2);
                        PossibleValuesEditionPane.this.listStatesPanel.update();
                    }
                }
            });
        }

        public void selectState(StateLink entity) {
            this.selectEntity = entity;
            if (entity != null) {
                this.txtName.setText(entity.getState().getName());
                this.checkGloballyExclusive.setSelected(entity.isGloballyExclusive());
            } else {
                this.txtName.setText("");
                this.checkGloballyExclusive.setSelected(false);
            }
        }
    }

    private class CategoryStatesPanel
    extends JPanel {
        private JButton btnAdd;
        private JButton btnRemove;
        private JButton btnListPossibleStates;
        private JCheckBox checkGloballyExclusive;
        private StateLink selectEntity;
        private final JTextField txtName;

        public CategoryStatesPanel() {
            super(new GridLayout(3, 1));
            this.txtName = new JTextField(10);
            this.btnAdd = new JButton(PossibleValuesEditionPane.this.iconController.getMoreIcon());
            this.btnAdd.setToolTipText(resource.getString("addStateTip"));
            this.btnRemove = new JButton(PossibleValuesEditionPane.this.iconController.getLessIcon());
            this.btnRemove.setToolTipText(resource.getString("removeState"));
            this.btnListPossibleStates = new JButton(PossibleValuesEditionPane.this.iconController.getStateIcon());
            this.btnListPossibleStates.setToolTipText(resource.getString("addPreDefinedState"));
            JToolBar barOptions = new JToolBar();
            barOptions.setLayout(new GridLayout(1, 3));
            barOptions.setFloatable(false);
            barOptions.add(this.btnAdd);
            barOptions.add(this.btnRemove);
            barOptions.add(this.btnListPossibleStates);
            JToolBar barName = new JToolBar();
            barName.setFloatable(false);
            JLabel labelName = new JLabel(String.valueOf(resource.getString("nameLabel")) + " ");
            barName.add(labelName);
            barName.add(this.txtName);
            JToolBar toolGloballyExclusive = new JToolBar();
            toolGloballyExclusive.setFloatable(false);
            JLabel labelExclusive = new JLabel(resource.getString("isGloballyExclusive"));
            this.checkGloballyExclusive = new JCheckBox();
            this.checkGloballyExclusive.setSelected(false);
            this.checkGloballyExclusive.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (CategoryStatesPanel.this.selectEntity != null) {
                        PossibleValuesEditionPane.this.mebnController.setGloballyExclusiveProperty(CategoryStatesPanel.this.selectEntity, CategoryStatesPanel.this.checkGloballyExclusive.isSelected());
                    }
                }
            });
            toolGloballyExclusive.add(this.checkGloballyExclusive);
            toolGloballyExclusive.add(labelExclusive);
            this.add(barOptions);
            this.add(barName);
            this.add(toolGloballyExclusive);
            this.txtName.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10 && CategoryStatesPanel.this.txtName.getText().length() > 0) {
                        CategoryStatesPanel.this.addState();
                    }
                }
            });
            this.btnAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    if (CategoryStatesPanel.this.txtName.getText().length() > 0) {
                        CategoryStatesPanel.this.addState();
                    }
                }
            });
            this.btnRemove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CategoryStatesPanel.this.removeState();
                }
            });
            this.btnListPossibleStates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PossibleValuesEditionPane.this.buildPopupStateSelection();
                }
            });
        }

        public void selectState(StateLink entity) {
            this.selectEntity = entity;
            if (entity != null) {
                this.txtName.setText(entity.getState().getName());
                this.checkGloballyExclusive.setSelected(entity.isGloballyExclusive());
            } else {
                this.txtName.setText("");
                this.checkGloballyExclusive.setSelected(false);
            }
        }

        public StateLink getSelectEntity() {
            return this.selectEntity;
        }

        public void addState() {
            try {
                String nameValue = this.txtName.getText(0, this.txtName.getText().length());
                PossibleValuesEditionPane.this.matcher = PossibleValuesEditionPane.this.wordPattern.matcher(nameValue);
                if (PossibleValuesEditionPane.this.matcher.matches()) {
                    if (PossibleValuesEditionPane.this.mebnController.existPossibleValue(nameValue)) {
                        JOptionPane.showMessageDialog(null, resource.getString("nameError"), resource.getString("nameAlreadyExists"), 0);
                    } else {
                        if (!PossibleValuesEditionPane.this.residentNode.existsPossibleValueByName(nameValue)) {
                            if (!PossibleValuesEditionPane.this.residentNode.getPossibleValueLinkList().isEmpty() && PossibleValuesEditionPane.this.residentNode.getTypeOfStates() != 1) {
                                int answer = JOptionPane.showConfirmDialog(PossibleValuesEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("warningDeletStates"), resource.getString("confirmation"), 0);
                                if (answer == 0) {
                                    PossibleValuesEditionPane.this.mebnController.removeAllPossibleValues(PossibleValuesEditionPane.this.residentNode);
                                    try {
                                        StateLink stateLink = PossibleValuesEditionPane.this.mebnController.addPossibleValue(PossibleValuesEditionPane.this.residentNode, nameValue);
                                        stateLink.setGloballyExclusive(this.checkGloballyExclusive.isSelected());
                                        PossibleValuesEditionPane.this.residentNode.setTypeOfStates(1);
                                    }
                                    catch (DuplicatedNameException e) {
                                        JOptionPane.showMessageDialog(PossibleValuesEditionPane.this.mebnController.getScreen(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                    }
                                    catch (ReservedWordException e2) {
                                        JOptionPane.showMessageDialog(PossibleValuesEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                    }
                                }
                            } else {
                                try {
                                    StateLink stateLink = PossibleValuesEditionPane.this.mebnController.addPossibleValue(PossibleValuesEditionPane.this.residentNode, nameValue);
                                    stateLink.setGloballyExclusive(this.checkGloballyExclusive.isSelected());
                                }
                                catch (DuplicatedNameException e) {
                                    JOptionPane.showMessageDialog(PossibleValuesEditionPane.this.mebnController.getScreen(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                                }
                                catch (ReservedWordException e2) {
                                    JOptionPane.showMessageDialog(PossibleValuesEditionPane.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                                }
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                        }
                        this.txtName.setText("");
                        this.checkGloballyExclusive.setSelected(false);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, resource.getString("nameException"), resource.getString("nameError"), 0);
                    this.txtName.selectAll();
                }
                PossibleValuesEditionPane.this.listStatesPanel.update();
            }
            catch (BadLocationException ble) {
                System.out.println(ble.getMessage());
            }
        }

        public void removeState() {
            if (PossibleValuesEditionPane.this.statesJList.getSelectedValue() != null) {
                PossibleValuesEditionPane.this.mebnController.removePossibleValue(PossibleValuesEditionPane.this.residentNode, PossibleValuesEditionPane.this.statesJList.getSelectedValue().toString());
            } else {
                try {
                    boolean teste;
                    String nameValue = this.txtName.getText(0, this.txtName.getText().length());
                    PossibleValuesEditionPane.this.matcher = PossibleValuesEditionPane.this.wordPattern.matcher(nameValue);
                    if (PossibleValuesEditionPane.this.matcher.matches() && (teste = PossibleValuesEditionPane.this.mebnController.existsPossibleValue(PossibleValuesEditionPane.this.residentNode, nameValue))) {
                        PossibleValuesEditionPane.this.mebnController.removePossibleValue(PossibleValuesEditionPane.this.residentNode, nameValue);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
            PossibleValuesEditionPane.this.listStatesPanel.update();
        }
    }

    private class ListAllStatesPanel
    extends JScrollPane {
        private JList list;

        public ListAllStatesPanel(JList list) {
            super(list);
            this.list = list;
            list.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent arg0) {
                }
            });
        }
    }

    private class ListStatesPanel
    extends JScrollPane {
        private boolean listenerActive;

        public ListStatesPanel() {
            super(PossibleValuesEditionPane.this.statesJList);
            this.listenerActive = true;
            PossibleValuesEditionPane.this.statesJList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent arg0) {
                    if (ListStatesPanel.this.listenerActive) {
                        PossibleValuesEditionPane.this.selectState((StateLink)PossibleValuesEditionPane.this.statesJList.getSelectedValue());
                    }
                }
            });
        }

        public void update() {
            this.listenerActive = false;
            PossibleValuesEditionPane.this.statesListModel.clear();
            PossibleValuesEditionPane.this.statesList = PossibleValuesEditionPane.this.residentNode.getPossibleValueLinkList();
            for (StateLink entity : PossibleValuesEditionPane.this.statesList) {
                PossibleValuesEditionPane.this.statesListModel.addElement(entity);
            }
            this.listenerActive = true;
            PossibleValuesEditionPane.this.statesJList.validate();
            this.validate();
        }
    }

    private class ObjectStatesPanel
    extends JPanel {
        final JComboBox comboEntities;
        private JCheckBox checkGloballyExclusive;
        JButton btnAdd;

        public ObjectStatesPanel() {
            super(new GridLayout(3, 1));
            this.comboEntities = new JComboBox<Object>(PossibleValuesEditionPane.this.mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntity().toArray());
            this.btnAdd = new JButton(PossibleValuesEditionPane.this.iconController.getMoreIcon());
            this.btnAdd.setToolTipText(resource.getString("addStateTip"));
            JToolBar barEdition = new JToolBar();
            barEdition.setFloatable(false);
            barEdition.add(this.btnAdd);
            barEdition.add(this.comboEntities);
            JToolBar toolGloballyExclusive = new JToolBar();
            toolGloballyExclusive.setFloatable(false);
            JLabel labelExclusive = new JLabel(resource.getString("isGloballyExclusive"));
            this.checkGloballyExclusive = new JCheckBox();
            this.checkGloballyExclusive.setSelected(false);
            toolGloballyExclusive.add(this.checkGloballyExclusive);
            toolGloballyExclusive.add(labelExclusive);
            this.add(barEdition);
            this.add(toolGloballyExclusive);
            this.add(new JLabel());
            this.btnAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ObjectStatesPanel.this.comboEntities.getSelectedItem() != null) {
                        if (!PossibleValuesEditionPane.this.residentNode.getPossibleValueLinkList().isEmpty()) {
                            int answer = JOptionPane.showConfirmDialog(PossibleValuesEditionPane.this.mebnController.getMebnEditionPane(), resource.getString("warningDeletStates"), resource.getString("confirmation"), 0);
                            if (answer == 0) {
                                PossibleValuesEditionPane.this.residentNode.removeAllPossibleValues();
                                StateLink link = PossibleValuesEditionPane.this.mebnController.addObjectEntityAsPossibleValue(PossibleValuesEditionPane.this.residentNode, (ObjectEntity)ObjectStatesPanel.this.comboEntities.getSelectedItem());
                                PossibleValuesEditionPane.this.mebnController.setGloballyExclusiveProperty(link, ObjectStatesPanel.this.checkGloballyExclusive.isSelected());
                                PossibleValuesEditionPane.this.residentNode.setTypeOfStates(0);
                                PossibleValuesEditionPane.this.listStatesPanel.update();
                            }
                        } else {
                            StateLink link = PossibleValuesEditionPane.this.mebnController.addObjectEntityAsPossibleValue(PossibleValuesEditionPane.this.residentNode, (ObjectEntity)ObjectStatesPanel.this.comboEntities.getSelectedItem());
                            PossibleValuesEditionPane.this.mebnController.setGloballyExclusiveProperty(link, ObjectStatesPanel.this.checkGloballyExclusive.isSelected());
                            PossibleValuesEditionPane.this.residentNode.setTypeOfStates(0);
                            PossibleValuesEditionPane.this.listStatesPanel.update();
                        }
                    }
                }
            });
        }

        public void selectState(StateLink entity) {
            StateLink selectEntity = entity;
            if (entity != null) {
                this.checkGloballyExclusive.setSelected(entity.isGloballyExclusive());
            } else {
                this.checkGloballyExclusive.setSelected(false);
            }
        }
    }

    private class OptionsPanel
    extends JPanel {
        private JButton btnCategoryStates;
        private JButton btnObjectStates;
        private JButton btnBooleanStates;

        public OptionsPanel() {
            this.btnCategoryStates = new JButton(PossibleValuesEditionPane.this.iconController.getCategoryStateIcon());
            this.btnCategoryStates.setToolTipText(resource.getString("categoryStatesTip"));
            this.btnObjectStates = new JButton(PossibleValuesEditionPane.this.iconController.getEntityStateIcon());
            this.btnObjectStates.setToolTipText(resource.getString("objectStatesTip"));
            this.btnBooleanStates = new JButton(PossibleValuesEditionPane.this.iconController.getBooleanStateIcon());
            this.btnBooleanStates.setToolTipText(resource.getString("booleanStatesTip"));
            this.btnCategoryStates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PossibleValuesEditionPane.this.showCategoryStatesPanel(null);
                }
            });
            this.btnBooleanStates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PossibleValuesEditionPane.this.showBooleanStatesPanel(null);
                }
            });
            this.btnObjectStates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PossibleValuesEditionPane.this.showObjectStatesPanel(null);
                }
            });
            this.setLayout(new GridLayout(1, 3));
            this.add(this.btnCategoryStates);
            this.add(this.btnObjectStates);
            this.add(this.btnBooleanStates);
        }
    }

    private class StateCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon iconObjectState;
        private ImageIcon iconCategoryState;
        private ImageIcon iconBooleanState;

        public StateCellRenderer() {
            this.iconObjectState = PossibleValuesEditionPane.this.iconController.getObjectEntityIcon();
            this.iconCategoryState = PossibleValuesEditionPane.this.iconController.getStateIcon();
            this.iconBooleanState = PossibleValuesEditionPane.this.iconController.getBooleanIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            switch (PossibleValuesEditionPane.this.residentNode.getTypeOfStates()) {
                case 0: {
                    this.setIcon(this.iconObjectState);
                    break;
                }
                case 1: {
                    this.setIcon(this.iconCategoryState);
                    break;
                }
                case 2: {
                    this.setIcon(this.iconBooleanState);
                }
            }
            if (isSelected) {
                super.setBorder(BorderFactory.createEtchedBorder());
            }
            return this;
        }
    }

    private class StatesPanel
    extends JPanel {
        private int selectedPanel;

        public StatesPanel() {
            PossibleValuesEditionPane.this.cardLayout = new CardLayout();
            this.setLayout(PossibleValuesEditionPane.this.cardLayout);
            PossibleValuesEditionPane.this.panelCategoryStates = new CategoryStatesPanel();
            PossibleValuesEditionPane.this.panelObjectStates = new ObjectStatesPanel();
            PossibleValuesEditionPane.this.panelBooleanStates = new BooleanStatesPanel();
            this.add("category", PossibleValuesEditionPane.this.panelCategoryStates);
            this.add("object", PossibleValuesEditionPane.this.panelObjectStates);
            this.add("boolean", PossibleValuesEditionPane.this.panelBooleanStates);
            switch (PossibleValuesEditionPane.this.residentNode.getTypeOfStates()) {
                case 0: {
                    PossibleValuesEditionPane.this.cardLayout.show(this, "object");
                    this.selectedPanel = 0;
                    break;
                }
                case 1: {
                    PossibleValuesEditionPane.this.cardLayout.show(this, "category");
                    this.selectedPanel = 1;
                    break;
                }
                case 2: {
                    PossibleValuesEditionPane.this.cardLayout.show(this, "boolean");
                    this.selectedPanel = 2;
                }
            }
        }

        public int getSelectedPanel() {
            return this.selectedPanel;
        }

        public void setSelectedPanel(int selectedPanel) {
            this.selectedPanel = selectedPanel;
        }
    }
}

