/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.prs.mebn.OrdinaryVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinaryVariableListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title;
    private CommandOrdinaryVariable command1;
    private IconController iconController = IconController.getInstance();
    private ImageIcon icon1;

    public OrdinaryVariableListPanel(String title, List<OrdinaryVariable> listOrdinaryVariable) {
        this.title = title;
        this.icon1 = this.iconController.getMoreIcon();
        this.updateList(listOrdinaryVariable);
    }

    public void updateList(List<OrdinaryVariable> listOrdinaryVariable) {
        this.removeAll();
        int minNumColums = 5;
        int numColums = listOrdinaryVariable.size() > 5 ? listOrdinaryVariable.size() + 1 : 6;
        this.setLayout(new GridLayout(numColums, 1));
        int i = 0;
        for (OrdinaryVariable ov : listOrdinaryVariable) {
            JToolBar toolBar = new JToolBar();
            toolBar.setLayout(new BorderLayout());
            toolBar.setFloatable(false);
            JButtonAction1 btnAction = new JButtonAction1(ov, this.icon1, new CommandOrdinaryVariable());
            btnAction.setBackground(new Color(193, 207, 180));
            toolBar.add((Component)btnAction, "Before");
            JButtonAction1 btnObject = new JButtonAction1(ov, String.valueOf(ov.getName()) + "[" + ov.getType() + "]", new CommandOrdinaryVariable());
            btnObject.setBackground(new Color(193, 210, 205));
            toolBar.add((Component)btnObject, "Center");
            this.add(toolBar);
            ++i;
        }
        int j = i;
        while (j < minNumColums) {
            JLabel empty = new JLabel();
            empty.setOpaque(true);
            empty.setBackground(new Color(193, 210, 205));
            this.add(empty);
            ++j;
        }
    }

    public class CommandOrdinaryVariable {
        public void execute(OrdinaryVariable ov) {
        }
    }

    private class JButtonAction1
    extends JButton {
        JButtonAction1(final OrdinaryVariable ov, ImageIcon icon, final CommandOrdinaryVariable cmd) {
            super(icon);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    cmd.execute(ov);
                }
            });
        }

        JButtonAction1(final OrdinaryVariable ov, String text, final CommandOrdinaryVariable cmd) {
            super(text);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    cmd.execute(ov);
                }
            });
        }
    }
}

