/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.OVariableTreeForOVariableEdition;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.entity.Type;

public class OVariableEditionPane
extends JPanel {
    private OVariableTreeForOVariableEdition treeMFrag;
    private JScrollPane jspTreeMFrag;
    private JPanel jpInformation;
    private JLabel name;
    private JTextField txtName;
    private JLabel type;
    private JComboBox jcbType;
    private Type[] types;
    private JButton jbNew;
    private JButton jbDelete;
    private JToolBar jtbOptions;
    private MEBNController mebnController;
    private MFrag mFrag;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;

    public OVariableEditionPane(MEBNController _controller) {
        this.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("OVariableTitle")));
        this.setLayout(new BorderLayout());
        this.mebnController = _controller;
        this.mFrag = this.mebnController.getCurrentMFrag();
        this.treeMFrag = new OVariableTreeForOVariableEdition(_controller);
        this.jspTreeMFrag = new JScrollPane(this.treeMFrag);
        this.jpInformation = new JPanel(new GridLayout(5, 0));
        this.name = new JLabel(resource.getString("nameLabel"));
        this.txtName = new JTextField(10);
        this.type = new JLabel(resource.getString("typeLabel"));
        this.types = this.mebnController.getMultiEntityBayesianNetwork().getTypeContainer().getListOfTypes().toArray(new Type[0]);
        this.jcbType = new JComboBox<Type>(this.types);
        this.jcbType.setSelectedIndex(0);
        this.jtbOptions = new JToolBar();
        this.jtbOptions.setLayout(new GridLayout(0, 2));
        this.jbNew = new JButton("+");
        this.jbNew.setToolTipText(resource.getString("newOVariableToolTip"));
        this.jbDelete = new JButton("-");
        this.jbDelete.setToolTipText(resource.getString("delOVariableToolTip"));
        this.jtbOptions.setFloatable(false);
        this.jpInformation.add(this.jtbOptions);
        this.jpInformation.add(this.name);
        this.jpInformation.add(this.txtName);
        this.jpInformation.add(this.type);
        this.jpInformation.add(this.jcbType);
        this.addListeners();
        this.add("Center", this.jspTreeMFrag);
    }

    public OVariableEditionPane() {
    }

    public void update() {
        if (this.treeMFrag != null) {
            this.treeMFrag.updateTree();
        }
    }

    public void setNameOVariableSelected(String name) {
        this.txtName.setText(name);
    }

    public boolean setTypeOVariableSelected(Type nameType) {
        int index = 0;
        boolean sucess = false;
        index = 0;
        while (index < this.types.length) {
            if (this.types[index].equals(nameType)) {
                this.jcbType.setSelectedIndex(index);
                sucess = true;
                break;
            }
            ++index;
        }
        return sucess;
    }

    public String getNameOVariable() {
        return this.txtName.getText();
    }

    public void addListeners() {
        this.jbNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    OrdinaryVariable ov = OVariableEditionPane.this.mebnController.addNewOrdinaryVariableInMFrag();
                    OVariableEditionPane.this.treeMFrag.updateTree();
                    OVariableEditionPane.this.treeMFrag.setOVariableActive(ov);
                    OVariableEditionPane.this.txtName.setText(ov.getName());
                    OVariableEditionPane.this.txtName.selectAll();
                    OVariableEditionPane.this.txtName.requestFocus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.jbDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (OVariableEditionPane.this.treeMFrag.getOVariableActive() != null) {
                    OVariableEditionPane.this.mebnController.removeOrdinaryVariableOfMFrag(OVariableEditionPane.this.treeMFrag.getOVariableActive());
                    OVariableEditionPane.this.treeMFrag.updateTree();
                }
            }
        });
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && OVariableEditionPane.this.txtName.getText().length() > 0) {
                    try {
                        String name = OVariableEditionPane.this.txtName.getText(0, OVariableEditionPane.this.txtName.getText().length());
                        OVariableEditionPane.this.matcher = OVariableEditionPane.this.wordPattern.matcher(name);
                        if (OVariableEditionPane.this.matcher.matches()) {
                            if (OVariableEditionPane.this.treeMFrag.getOVariableActive() != null) {
                                OVariableEditionPane.this.treeMFrag.getOVariableActive().setName(name);
                                OVariableEditionPane.this.treeMFrag.updateTree();
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, resource.getString("nameError"), resource.getString("nameException"), 0);
                            OVariableEditionPane.this.txtName.selectAll();
                        }
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble.getMessage());
                    }
                }
            }
        });
        this.jcbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Type typeName = (Type)OVariableEditionPane.this.jcbType.getSelectedItem();
                System.out.println("item selected = " + typeName);
                if (OVariableEditionPane.this.treeMFrag.getOVariableActive() != null) {
                    OVariableEditionPane.this.treeMFrag.getOVariableActive().setValueType(typeName);
                }
                OVariableEditionPane.this.treeMFrag.updateTree();
            }
        });
    }
}

