/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.GraphPane;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.util.ArrayMap;
import unbbayes.util.ResourceController;

public class MTheoryTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private MultiEntityBayesianNetwork net;
    private ArrayMap<DefaultMutableTreeNode, Object> nodeTreeMap = new ArrayMap();
    private ArrayMap<Object, DefaultMutableTreeNode> inverseNodeMap = new ArrayMap();
    private Object objectSelected;
    private JPopupMenu popup = new JPopupMenu();
    private JPopupMenu popupMFrag = new JPopupMenu();
    private JPopupMenu popupNode = new JPopupMenu();
    protected IconController iconController = IconController.getInstance();
    private static final String POG = "this_is_a_pog_for_permited_names_really_very_very_large_because_of_a_bug_in_java_5_that_dont_atualize_the_size_of_the_label_of_tree";
    private DefaultMutableTreeNode root;
    private final MEBNController mebnController;
    private final GraphPane graphPane;
    private static ResourceBundle resource = ResourceController.RS_GUI;

    public MTheoryTree(MEBNController controller, GraphPane graphPane) {
        this.mebnController = controller;
        this.net = controller.getMultiEntityBayesianNetwork();
        this.graphPane = graphPane;
        this.setCellRenderer(new MTheoryTreeCellRenderer());
        this.root = new DefaultMutableTreeNode(POG);
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.setModel(model);
        this.scrollPathToVisible(new TreePath(this.root.getPath()));
        this.root.setUserObject(this.net.getName());
        this.createTree();
        this.scrollPathToVisible(new TreePath(this.root.getPath()));
        this.createPopupMenu();
        this.createPopupMenuMFrag();
        this.createPopupMenuNode();
        this.addMouseListener(new MousePressedListener());
    }

    private void createPopupMenuMFrag() {
        JMenuItem itemOpen = new JMenuItem(resource.getString("menuOpen"));
        JMenuItem itemDelete = new JMenuItem(resource.getString("menuDelete"));
        JMenuItem itemContext = new JMenuItem(resource.getString("menuAddContext"));
        JMenuItem itemInput = new JMenuItem(resource.getString("menuAddInput"));
        JMenuItem itemResident = new JMenuItem(resource.getString("menuAddResident"));
        itemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)MTheoryTree.this.objectSelected);
            }
        });
        itemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.removeDomainMFrag((MFrag)MTheoryTree.this.objectSelected);
                MTheoryTree.this.repaint();
            }
        });
        itemContext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)MTheoryTree.this.objectSelected);
                MTheoryTree.this.mebnController.setActionGraphCreateContextNode();
            }
        });
        itemInput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)MTheoryTree.this.objectSelected);
                MTheoryTree.this.mebnController.setActionGraphCreateInputNode();
            }
        });
        itemResident.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)MTheoryTree.this.objectSelected);
                MTheoryTree.this.mebnController.setActionGraphCreateResidentNode();
            }
        });
        this.popupMFrag.add(itemOpen);
        this.popupMFrag.add(itemDelete);
        this.popupMFrag.add(itemContext);
        this.popupMFrag.add(itemResident);
        this.popupMFrag.add(itemInput);
    }

    private void createPopupMenuNode() {
        JMenuItem itemDelete = new JMenuItem(resource.getString("menuDelete"));
        itemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.deleteSelected(MTheoryTree.this.objectSelected);
            }
        });
        this.popupNode.add(itemDelete);
    }

    private void createPopupMenu() {
        JMenuItem itemAddDomainMFrag = new JMenuItem(resource.getString("menuAddDomainMFrag"));
        itemAddDomainMFrag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MTheoryTree.this.mebnController.insertDomainMFrag();
            }
        });
        this.popup.add(itemAddDomainMFrag);
    }

    private void createTree() {
        List<MFrag> mFragList = this.net.getMFragList();
        for (MFrag mFrag : mFragList) {
            DefaultMutableTreeNode mFragTreeNode = new DefaultMutableTreeNode(POG);
            this.root.add(mFragTreeNode);
            mFragTreeNode.setUserObject(mFrag);
            this.inverseNodeMap.put(mFrag, mFragTreeNode);
            this.nodeTreeMap.put(mFragTreeNode, mFrag);
            List<ResidentNode> residentNodeList = mFrag.getResidentNodeList();
            for (ResidentNode residentNode : residentNodeList) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(POG);
                mFragTreeNode.add(treeNodeChild);
                treeNodeChild.setUserObject(residentNode);
                this.nodeTreeMap.put(treeNodeChild, residentNode);
                this.inverseNodeMap.put(residentNode, treeNodeChild);
            }
            List<InputNode> inputNodeList = mFrag.getInputNodeList();
            for (InputNode inputNode : inputNodeList) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(POG);
                mFragTreeNode.add(treeNodeChild);
                treeNodeChild.setUserObject(inputNode);
                this.nodeTreeMap.put(treeNodeChild, inputNode);
                this.inverseNodeMap.put(inputNode, treeNodeChild);
            }
            List<ContextNode> contextNodeList = mFrag.getContextNodeList();
            for (ContextNode contextNode : contextNodeList) {
                DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(POG);
                mFragTreeNode.add(treeNodeChild);
                treeNodeChild.setUserObject(contextNode);
                this.nodeTreeMap.put(treeNodeChild, contextNode);
                this.inverseNodeMap.put(contextNode, treeNodeChild);
            }
        }
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public void addMFrag(MFrag mFrag) {
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(POG);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(newChild, this.root, this.root.getChildCount());
        this.scrollPathToVisible(new TreePath(newChild.getPath()));
        newChild.setUserObject(mFrag);
        this.nodeTreeMap.put(newChild, mFrag);
        this.inverseNodeMap.put(mFrag, newChild);
        this.scrollPathToVisible(new TreePath(newChild.getPath()));
        this.repaint();
    }

    public void addNode(MFrag mFrag, Node node) {
        DefaultMutableTreeNode nodeFather = this.inverseNodeMap.get(mFrag);
        DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(POG);
        ((DefaultTreeModel)this.getModel()).insertNodeInto(newChild, nodeFather, nodeFather.getChildCount());
        this.scrollPathToVisible(new TreePath(newChild.getPath()));
        newChild.setUserObject(node);
        nodeFather.add(newChild);
        this.nodeTreeMap.put(newChild, node);
        this.inverseNodeMap.put(node, newChild);
        this.scrollPathToVisible(new TreePath(newChild.getPath()));
        this.repaint();
    }

    public void removeMFrag(MFrag mFrag) {
        DefaultMutableTreeNode treeNode = this.inverseNodeMap.get(mFrag);
        if (treeNode.getChildCount() != 0) {
            int i = 0;
            while (i < treeNode.getChildCount()) {
                ((DefaultTreeModel)this.getModel()).removeNodeFromParent((MutableTreeNode)treeNode.getChildAt(0));
                ++i;
            }
        }
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(treeNode);
        this.repaint();
    }

    public void removeNode(Node node) {
        DefaultMutableTreeNode treeNode = this.inverseNodeMap.get(node);
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(treeNode);
        this.repaint();
    }

    public void renameNode(Node node) {
        DefaultMutableTreeNode treeNode = this.inverseNodeMap.get(node);
        this.scrollPathToVisible(new TreePath(treeNode.getPath()));
        this.repaint();
    }

    public void renameMFrag(MFrag mFrag) {
        DefaultMutableTreeNode treeNode = this.inverseNodeMap.get(mFrag);
        this.scrollPathToVisible(new TreePath(treeNode.getPath()));
        this.repaint();
    }

    public void renameMTheory(String name) {
        this.root.setUserObject(name);
        this.scrollPathToVisible(new TreePath(this.root.getPath()));
        this.repaint();
    }

    private class MTheoryTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon contextNodeIcon;
        private ImageIcon residentNodeIcon;
        private ImageIcon inputNodeIcon;
        private ImageIcon orangeNodeIcon;
        private ImageIcon mTheoryNodeIcon;

        private MTheoryTreeCellRenderer() {
            this.contextNodeIcon = MTheoryTree.this.iconController.getGreenNodeIcon();
            this.residentNodeIcon = MTheoryTree.this.iconController.getYellowNodeIcon();
            this.inputNodeIcon = MTheoryTree.this.iconController.getGrayNodeIcon();
            this.orangeNodeIcon = MTheoryTree.this.iconController.getOrangeNodeIcon();
            this.mTheoryNodeIcon = MTheoryTree.this.iconController.getMTheoryNodeIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object obj = MTheoryTree.this.nodeTreeMap.get(value);
            if (leaf) {
                if (obj != null) {
                    if (obj instanceof ResidentNode) {
                        this.setIcon(this.residentNodeIcon);
                    } else if (obj instanceof InputNode) {
                        this.setIcon(this.inputNodeIcon);
                    } else if (obj instanceof ContextNode) {
                        this.setIcon(this.contextNodeIcon);
                    } else if (obj instanceof MFrag) {
                        this.setIcon(this.orangeNodeIcon);
                    } else {
                        this.setIcon(this.mTheoryNodeIcon);
                    }
                }
            } else if (obj instanceof MFrag) {
                this.setOpenIcon(this.orangeNodeIcon);
                this.setClosedIcon(this.orangeNodeIcon);
                this.setIcon(this.orangeNodeIcon);
            } else {
                this.setOpenIcon(this.mTheoryNodeIcon);
                this.setClosedIcon(this.mTheoryNodeIcon);
                this.setIcon(this.mTheoryNodeIcon);
            }
            return this;
        }
    }

    private class MousePressedListener
    extends MouseAdapter {
        private MousePressedListener() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = MTheoryTree.this.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                return;
            }
            TreePath selPath = MTheoryTree.this.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (mutableTreeNode.isLeaf()) {
                Object nodeLeaf = MTheoryTree.this.nodeTreeMap.get(mutableTreeNode);
                MTheoryTree.this.objectSelected = nodeLeaf;
                if (nodeLeaf instanceof MFrag) {
                    if (e.getModifiers() == 4) {
                        MTheoryTree.this.popupMFrag.setEnabled(true);
                        MTheoryTree.this.popupMFrag.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                        MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)nodeLeaf);
                    } else {
                        e.getClickCount();
                    }
                } else if (nodeLeaf instanceof MultiEntityNode) {
                    if (e.getModifiers() == 4) {
                        MTheoryTree.this.popupNode.setEnabled(true);
                        MTheoryTree.this.popupNode.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                        Object fatherNode = MTheoryTree.this.objectSelected;
                        TreeNode treeNode = mutableTreeNode;
                        while (!(fatherNode instanceof MFrag)) {
                            treeNode = treeNode.getParent();
                            fatherNode = MTheoryTree.this.nodeTreeMap.get(treeNode);
                        }
                        MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)fatherNode);
                        MTheoryTree.this.mebnController.selectNode((Node)MTheoryTree.this.objectSelected);
                    } else {
                        e.getClickCount();
                    }
                }
            } else {
                Object nodeSelected = MTheoryTree.this.nodeTreeMap.get(mutableTreeNode);
                MTheoryTree.this.objectSelected = nodeSelected;
                if (nodeSelected instanceof MFrag) {
                    if (e.getModifiers() == 4) {
                        MTheoryTree.this.popupMFrag.setEnabled(true);
                        MTheoryTree.this.popupMFrag.show(e.getComponent(), e.getX(), e.getY());
                    } else if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                        MTheoryTree.this.mebnController.setCurrentMFrag((MFrag)nodeSelected);
                        MTheoryTree.this.expandRow(selRow);
                    } else {
                        e.getClickCount();
                    }
                } else {
                    if (e.getModifiers() == 4 && e.getModifiers() == 4) {
                        MTheoryTree.this.popup.setEnabled(true);
                        MTheoryTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    if (e.getClickCount() != 1) {
                        e.getClickCount();
                    }
                }
            }
        }
    }
}

