/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import unbbayes.controller.FormulaTreeController;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.ArgumentsTypedPane;
import unbbayes.gui.mebn.EntityListForReplaceInFormula;
import unbbayes.gui.mebn.MTheoryTreeForReplaceInFormula;
import unbbayes.gui.mebn.OVariableTreeForReplaceInFormula;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.ResidentNodePointer;

public class FormulaEditionPane
extends JPanel {
    JToolBar jtbOperator;
    JPanel upPanel;
    JPanel downPanel;
    JScrollPane jspFormulaTree;
    JToolBar jtbSelectArgTree;
    JPanel argTreePanel;
    JScrollPane jspArgTreePanel;
    JPanel jpOperandos;
    JButton btnEqualTo;
    JButton btnAnd;
    JButton btnOr;
    JButton btnNot;
    JButton btnImplies;
    JButton btnIf;
    JButton btnExists;
    JButton btnForAll;
    JButton btnOVariableTree;
    JButton btnNodeTree;
    JButton btnEntityTree;
    JButton btnSkolenTree;
    private JPanel variablePanel;
    private ArgumentsTypedPane argsPanel;
    MEBNController mebnController;
    FormulaTreeController formulaTreeController;
    MFrag mFrag;
    ContextNode contextNode;
    CardLayout cardLayout;
    JPanel jpArgTree;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    protected IconController iconController = IconController.getInstance();

    public FormulaEditionPane(MEBNController _controller, ContextNode context) {
        this.setBorder(MebnToolkit.getBorderForTabPanel("Context Node"));
        this.mebnController = _controller;
        this.mFrag = this.mebnController.getCurrentMFrag();
        this.contextNode = context;
        this.btnEqualTo = new JButton(this.iconController.getEqualIcon());
        this.btnAnd = new JButton(this.iconController.getAndIcon());
        this.btnOr = new JButton(this.iconController.getOrIcon());
        this.btnNot = new JButton(this.iconController.getNotIcon());
        this.btnImplies = new JButton(this.iconController.getImpliesIcon());
        this.btnIf = new JButton(this.iconController.getIffIcon());
        this.btnExists = new JButton(this.iconController.getExistsIcon());
        this.btnForAll = new JButton(this.iconController.getForallIcon());
        this.btnEqualTo.setToolTipText(resource.getString("equalToToolTip"));
        this.btnAnd.setToolTipText(resource.getString("andToolTip"));
        this.btnOr.setToolTipText(resource.getString("orToolTip"));
        this.btnNot.setToolTipText(resource.getString("notToolTip"));
        this.btnImplies.setToolTipText(resource.getString("impliesToolTip"));
        this.btnIf.setToolTipText(resource.getString("iffToolTip"));
        this.btnExists.setToolTipText(resource.getString("existsToolTip"));
        this.btnForAll.setToolTipText(resource.getString("forallToolTip"));
        this.jtbOperator = new JToolBar();
        this.jtbOperator.setLayout(new GridLayout(2, 4));
        this.jtbOperator.add(this.btnEqualTo);
        this.jtbOperator.add(this.btnAnd);
        this.jtbOperator.add(this.btnOr);
        this.jtbOperator.add(this.btnNot);
        this.jtbOperator.add(this.btnImplies);
        this.jtbOperator.add(this.btnIf);
        this.jtbOperator.add(this.btnExists);
        this.jtbOperator.add(this.btnForAll);
        this.jtbOperator.setFloatable(false);
        this.formulaTreeController = new FormulaTreeController(_controller, this.contextNode, this);
        this.jspFormulaTree = new JScrollPane(this.formulaTreeController.getFormulaTree());
        this.btnOVariableTree = new JButton(this.iconController.getOVariableNodeIcon());
        this.btnNodeTree = new JButton(this.iconController.getNodeNodeIcon());
        this.btnEntityTree = new JButton(this.iconController.getEntityInstanceIcon());
        this.btnSkolenTree = new JButton(this.iconController.getSkolenNodeIcon());
        this.btnOVariableTree.setToolTipText(resource.getString("addOVariableTip"));
        this.btnNodeTree.setToolTipText(resource.getString("addNodeTip"));
        this.btnEntityTree.setToolTipText(resource.getString("addEntityTip"));
        this.btnSkolenTree.setToolTipText(resource.getString("addSkolenTip"));
        this.jtbSelectArgTree = new JToolBar();
        this.jtbSelectArgTree.setLayout(new GridLayout(1, 4));
        this.jtbSelectArgTree.add(this.btnOVariableTree);
        this.jtbSelectArgTree.add(this.btnNodeTree);
        this.jtbSelectArgTree.add(this.btnEntityTree);
        this.jtbSelectArgTree.add(this.btnSkolenTree);
        this.jtbSelectArgTree.setFloatable(false);
        this.upPanel = new JPanel(new BorderLayout());
        this.upPanel.add((Component)this.jtbOperator, "North");
        this.upPanel.add((Component)this.jspFormulaTree, "Center");
        this.cardLayout = new CardLayout();
        this.jpArgTree = new JPanel(this.cardLayout);
        this.jpArgTree.add("NodeTab", this.replaceByNode());
        this.jpArgTree.add("OVariableTab", this.replaceByOVariable());
        this.variablePanel = this.formulaTreeController.getFormulaTree().replaceByVariable();
        this.jpArgTree.add("VariableTab", this.variablePanel);
        this.jpArgTree.add("EntityTab", this.replaceByEntity());
        this.cardLayout.show(this.jpArgTree, "NodeTab");
        this.downPanel = new JPanel(new BorderLayout());
        this.downPanel.add((Component)this.jtbSelectArgTree, "North");
        this.downPanel.add((Component)this.jpArgTree, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(gridbag);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 100.0;
        constraints.weighty = 60.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        gridbag.setConstraints(this.upPanel, constraints);
        this.add(this.upPanel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 40.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        gridbag.setConstraints(this.downPanel, constraints);
        this.add(this.downPanel);
        this.addListeners();
    }

    public FormulaEditionPane() {
    }

    public void update() {
    }

    public void setNodeTabActive() {
        this.cardLayout.show(this.jpArgTree, "NodeTab");
    }

    public void setOVariableTabActive() {
        this.cardLayout.show(this.jpArgTree, "OVariableTab");
    }

    public void setVariableTabActive() {
        this.jpArgTree.remove(this.variablePanel);
        this.variablePanel = this.replaceByOVariable();
        this.jpArgTree.add("VariableTab", this.variablePanel);
        this.cardLayout.show(this.jpArgTree, "VariableTab");
    }

    public void setEntityTabActive() {
        this.cardLayout.show(this.jpArgTree, "EntityTab");
    }

    public void setArgumentSelectionTab(ResidentNodePointer residentPointer) {
        this.argsPanel = new ArgumentsTypedPane(this.contextNode, residentPointer, this.mebnController);
        JScrollPane scroll = new JScrollPane(this.argsPanel);
        this.jpArgTree.add("ResidentArgsTab", scroll);
        this.cardLayout.show(this.jpArgTree, "ResidentArgsTab");
    }

    public void addListeners() {
        this.btnAnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorAnd();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnOr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorOr();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnNot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorNot();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnEqualTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorEqualTo();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnIf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorIf();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnImplies.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorImplies();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnForAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorForAll();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnExists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    FormulaEditionPane.this.formulaTreeController.addOperatorExists();
                }
                catch (Exception e) {
                    FormulaEditionPane.this.showErrorMessage(e.getMessage());
                }
            }
        });
        this.btnNodeTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FormulaEditionPane.this.setNodeTabActive();
            }
        });
        this.btnEntityTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FormulaEditionPane.this.setEntityTabActive();
            }
        });
        this.btnOVariableTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FormulaEditionPane.this.setOVariableTabActive();
            }
        });
        this.btnSkolenTree.setEnabled(false);
    }

    public JPanel replaceByNode() {
        JPanel painel = new JPanel(new BorderLayout());
        MTheoryTreeForReplaceInFormula mTheoryTree = new MTheoryTreeForReplaceInFormula(this.mebnController, this.formulaTreeController);
        JScrollPane jspOVariableTreeMFrag = new JScrollPane(mTheoryTree);
        painel.add((Component)jspOVariableTreeMFrag, "Center");
        return painel;
    }

    public JPanel replaceByOVariable() {
        JPanel painelOVariableSelection = new JPanel(new BorderLayout());
        OVariableTreeForReplaceInFormula oVariableTreeMFragReplaceInFormula = new OVariableTreeForReplaceInFormula(this.mebnController, this.formulaTreeController);
        JScrollPane jspOVariableTreeMFrag = new JScrollPane(oVariableTreeMFragReplaceInFormula);
        painelOVariableSelection.add((Component)jspOVariableTreeMFrag, "North");
        return painelOVariableSelection;
    }

    public JPanel replaceByEntity() {
        JPanel painelEntitySelection = new JPanel(new BorderLayout());
        EntityListForReplaceInFormula entityList = new EntityListForReplaceInFormula(this.mebnController, this.formulaTreeController);
        JScrollPane jspEntityList = new JScrollPane(entityList);
        painelEntitySelection.add((Component)jspEntityList, "North");
        return painelEntitySelection;
    }

    public void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, resource.getString("error"), 0);
    }
}

