/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import unbbayes.controller.FormulaTreeController;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;

public class EntityListForReplaceInFormula
extends JPanel {
    private final IconController iconController = IconController.getInstance();
    private List<ObjectEntity> listEntity;
    private JList jlEntities;
    private DefaultListModel listModel;
    private ObjectEntity selected;
    private FormulaTreeController formulaTreeController;
    private MEBNController mebnController;

    public EntityListForReplaceInFormula(MEBNController _controller, FormulaTreeController _formulaTreeController) {
        this.formulaTreeController = _formulaTreeController;
        this.mebnController = _controller;
        this.listModel = new DefaultListModel();
        this.jlEntities = new JList(this.listModel);
        this.jlEntities.setSelectionMode(0);
        this.jlEntities.setLayoutOrientation(0);
        this.jlEntities.setVisibleRowCount(-1);
        this.jlEntities.setCellRenderer(new ListEntitiesCellRenderer());
        this.selected = null;
        this.update();
        this.addListListener();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jlEntities, "Center");
    }

    public void update() {
        ObjectEntity antSelected = this.selected;
        this.listModel.clear();
        this.listEntity = this.mebnController.getMultiEntityBayesianNetwork().getObjectEntityContainer().getListEntity();
        this.listModel = new DefaultListModel();
        for (Entity entity : this.listEntity) {
            this.listModel.addElement(entity);
        }
        this.jlEntities.setModel(this.listModel);
        this.selected = antSelected;
    }

    private void addListListener() {
        this.jlEntities.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EntityListForReplaceInFormula.this.selected = (ObjectEntity)EntityListForReplaceInFormula.this.jlEntities.getSelectedValue();
                EntityListForReplaceInFormula.this.formulaTreeController.addEntity(EntityListForReplaceInFormula.this.selected);
                EntityListForReplaceInFormula.this.mebnController.updateFormulaActiveContextNode();
            }
        });
    }

    class ListEntitiesCellRenderer
    extends DefaultListCellRenderer {
        private ImageIcon entityIcon;

        public ListEntitiesCellRenderer() {
            this.entityIcon = EntityListForReplaceInFormula.this.iconController.getEntityInstanceIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            super.setIcon(this.entityIcon);
            if (isSelected) {
                super.setBorder(BorderFactory.createEtchedBorder());
            }
            return this;
        }
    }
}

