/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.continuous;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import unbbayes.util.ResourceController;
import unbbayes.util.SortUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousNormalDistributionPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel followsPane;
    private JLabel followsLabel;
    private List<String> discreteParentNodeNameList;
    private List<String> continuousParentNodeNameList;
    private JPanel parentStateListPane;
    private List<JComboBox> discreteParentNodeStateSelectionList;
    private JPanel inputPane;
    private List<JTextField> constantTextFieldList;
    private JTextField meanTextField;
    private JTextField varianceTextField;
    private JPanel buttonPane;
    private JButton confirmButton;
    private JButton cancelButton;
    private ResourceBundle resource = ResourceController.RS_GUI;

    public ContinuousNormalDistributionPane(List<String> discreteParentNodeNameList, List<String> continuousParentNodeNameList) {
        this.discreteParentNodeNameList = discreteParentNodeNameList != null ? discreteParentNodeNameList : new ArrayList<String>(0);
        this.continuousParentNodeNameList = continuousParentNodeNameList != null ? continuousParentNodeNameList : new ArrayList<String>(0);
        SortUtil.sort(this.discreteParentNodeNameList);
        SortUtil.sort(this.continuousParentNodeNameList);
        this.createFollowsPane();
        this.createParentStateListPane();
        this.createInputPane();
        this.createButtonPane();
        this.createMainPane();
    }

    private void createMainPane() {
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new GridLayout(2, 1));
        northPanel.add(this.followsPane);
        northPanel.add(this.parentStateListPane);
        this.add((Component)northPanel, "North");
        this.add((Component)this.inputPane, "Center");
        this.add((Component)this.buttonPane, "South");
    }

    public void addConfirmButtonActionListener(ActionListener al) {
        this.confirmButton.addActionListener(al);
    }

    public void addCancelButtonActionListener(ActionListener al) {
        this.cancelButton.addActionListener(al);
    }

    public void addParentStateChangeActionListener(ActionListener al) {
        for (JComboBox comboBox : this.discreteParentNodeStateSelectionList) {
            comboBox.addActionListener(al);
        }
    }

    private void createButtonPane() {
        this.buttonPane = new JPanel();
        this.confirmButton = new JButton(this.resource.getString("confirmLabel"));
        this.cancelButton = new JButton(this.resource.getString("cancelLabel"));
        this.buttonPane.add(this.confirmButton);
        this.buttonPane.add(this.cancelButton);
    }

    private void createInputPane() {
        this.inputPane = new JPanel(new GridLayout((this.continuousParentNodeNameList.size() + 2) / 2, 4));
        this.meanTextField = new JTextField(10);
        this.inputPane.add(new JLabel(this.resource.getString("meanLabel")));
        this.inputPane.add(this.meanTextField);
        this.varianceTextField = new JTextField(10);
        this.inputPane.add(new JLabel(this.resource.getString("varianceLabel")));
        this.inputPane.add(this.varianceTextField);
        this.constantTextFieldList = new ArrayList<JTextField>(this.continuousParentNodeNameList.size());
        int i = 0;
        while (i < this.continuousParentNodeNameList.size()) {
            this.constantTextFieldList.add(i, new JTextField(10));
            this.inputPane.add(new JLabel(String.valueOf(this.resource.getString("constantLabel")) + i));
            this.inputPane.add(this.constantTextFieldList.get(i));
            ++i;
        }
    }

    public void createFollowsPane() {
        this.followsPane = new JPanel();
        StringBuffer followsTitle = new StringBuffer();
        followsTitle.append(String.valueOf(this.resource.getString("followsLabel")) + " ");
        int i = 0;
        while (i < this.continuousParentNodeNameList.size()) {
            if (i != 0) {
                followsTitle.append(" + ");
            }
            followsTitle.append(String.valueOf(this.resource.getString("constantLabel")) + i + " * " + this.continuousParentNodeNameList.get(i));
            ++i;
        }
        if (this.continuousParentNodeNameList.size() > 0) {
            followsTitle.append(" + ");
        }
        followsTitle.append(this.resource.getString("normalFunctionLabel"));
        this.followsLabel = new JLabel(followsTitle.toString());
        this.followsLabel.setFont(new Font("SansSerif", 1, 12));
        this.followsLabel.setForeground(Color.BLUE);
        this.followsPane.add(this.followsLabel);
    }

    private void createParentStateListPane() {
        this.parentStateListPane = new JPanel();
        this.discreteParentNodeStateSelectionList = new ArrayList<JComboBox>(this.discreteParentNodeNameList.size());
        for (String name : this.discreteParentNodeNameList) {
            JLabel label = new JLabel(String.valueOf(name) + " = ");
            JComboBox comboBox = new JComboBox();
            this.discreteParentNodeStateSelectionList.add(comboBox);
            this.parentStateListPane.add(label);
            this.parentStateListPane.add(comboBox);
            this.parentStateListPane.add(new JLabel("\t"));
        }
        this.parentStateListPane.add(new JLabel("-\t"));
        for (String name : this.continuousParentNodeNameList) {
            this.parentStateListPane.add(new JLabel(String.valueOf(name) + "\t"));
        }
    }

    public void fillDiscreteParentStateSelection(String parentName, List<String> stateList) {
        JComboBox comboBox = null;
        int i = 0;
        while (i < this.discreteParentNodeNameList.size()) {
            if (this.discreteParentNodeNameList.get(i).equals(parentName)) {
                comboBox = this.discreteParentNodeStateSelectionList.get(i);
                break;
            }
            ++i;
        }
        if (comboBox != null) {
            comboBox.removeAllItems();
            for (String state : stateList) {
                comboBox.addItem(state);
            }
        }
    }

    public void setDiscreteAndContinuousParentNodeNameList(List<String> discreteParentNodeNameList, List<String> continuousParentNodeNameList) {
        this.discreteParentNodeNameList = discreteParentNodeNameList;
        this.continuousParentNodeNameList = continuousParentNodeNameList;
        SortUtil.sort(this.discreteParentNodeNameList);
        SortUtil.sort(this.continuousParentNodeNameList);
        this.createParentStateListPane();
    }

    public void setDiscreteParentNodeNameList(List<String> discreteParentNodeNameList) {
        this.discreteParentNodeNameList = discreteParentNodeNameList;
        SortUtil.sort(this.discreteParentNodeNameList);
        this.createParentStateListPane();
    }

    public void setContinuousParentNodeNameList(List<String> continuousParentNodeNameList) {
        this.continuousParentNodeNameList = continuousParentNodeNameList;
        SortUtil.sort(this.continuousParentNodeNameList);
        this.createParentStateListPane();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        ArrayList<String> dis = new ArrayList<String>();
        dis.add("D2");
        dis.add("D1");
        dis.add("D4");
        dis.add("D3");
        ArrayList<String> con = new ArrayList<String>();
        con.add("C2");
        con.add("C1");
        con.add("C3");
        ContinuousNormalDistributionPane p = new ContinuousNormalDistributionPane(dis, con);
        for (String string : dis) {
            p.fillDiscreteParentStateSelection(string, con);
        }
        f.add(p);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public String getMeanText() {
        return this.meanTextField.getText();
    }

    public void setMeanText(String mean) {
        this.meanTextField.setText(mean);
    }

    public String getVarianceText() {
        return this.varianceTextField.getText();
    }

    public void setVarianceText(String variance) {
        this.varianceTextField.setText(variance);
    }

    public List<String> getConstantTextList() {
        ArrayList<String> constantTextList = new ArrayList<String>(this.constantTextFieldList.size());
        for (JTextField textField : this.constantTextFieldList) {
            constantTextList.add(textField.getText());
        }
        return constantTextList;
    }

    public void setConstantTextList(List<String> constantList) {
        if (constantList.size() == this.constantTextFieldList.size()) {
            int i = 0;
            while (i < constantList.size()) {
                this.constantTextFieldList.get(i).setText(constantList.get(i));
                ++i;
            }
        }
    }

    public int[] getDiscreteParentNodeStateSelectedList() {
        int[] parentStateList = new int[this.discreteParentNodeStateSelectionList.size()];
        int i = 0;
        while (i < this.discreteParentNodeStateSelectionList.size()) {
            parentStateList[i] = this.discreteParentNodeStateSelectionList.get(i).getSelectedIndex();
            ++i;
        }
        return parentStateList;
    }
}

