/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.GlobalOptionsDialog;
import unbbayes.gui.GraphAction;
import unbbayes.gui.NetworkWindow;
import unbbayes.prs.Node;

public class PNEditionPane
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final NetworkWindow netWindow;
    private GlobalOptionsDialog go;
    private JTable table;
    private final JTextField txtSigla;
    private final JTextField txtDescription;
    private final NetworkController controller;
    private final JScrollPane jspTable;
    private final JSplitPane centerPanel;
    private Node tableOwner;
    private final JLabel status;
    private final JPanel bottomPanel;
    private final JPanel topPanel;
    private final JToolBar jtbState;
    private final JToolBar jtbEdition;
    private final JLabel sigla;
    private final JLabel description;
    private final JButton btnEvaluate;
    private final JButton btnCompile;
    private final JButton btnAddState;
    private final JButton btnRemoveState;
    private final ToolBarEdition tbEdition;
    private final JButton btnPrintNet;
    private final JButton btnPrintTable;
    private final JButton btnPreviewNet;
    private final JButton btnPreviewTable;
    private final JButton btnSaveNetImage;
    private final JButton btnSaveTableImage;
    private final JButton btnGlobalOption;
    private final JButton btnHierarchy;
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private final Pattern descriptionPattern = Pattern.compile("[ a-zA-Z_0-9\u00e1\u00e9\u00ed\u00f3\u00fa\u00e3\u00f5\u00e7\u00e2\u00ea\u00ee\u00f4\u00fb\u00fc\u00e0]*");
    private Matcher matcher;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public PNEditionPane(NetworkWindow _netWindow, NetworkController _controller) {
        this.netWindow = _netWindow;
        this.controller = _controller;
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.jspTable = new JScrollPane(this.table);
        this.topPanel = new JPanel(new GridLayout(0, 1));
        this.jtbState = new JToolBar();
        this.jtbEdition = new JToolBar();
        this.centerPanel = new JSplitPane(0);
        this.bottomPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.sigla = new JLabel(String.valueOf(resource.getString("siglaLabel")) + " ");
        this.description = new JLabel(String.valueOf(resource.getString("descriptionLabel")) + " ");
        this.txtSigla = new JTextField(10);
        this.txtDescription = new JTextField(15);
        this.btnEvaluate = new JButton(this.iconController.getEvaluateIcon());
        this.btnCompile = new JButton(this.iconController.getCompileIcon());
        this.btnAddState = new JButton(this.iconController.getMoreIcon());
        this.btnRemoveState = new JButton(this.iconController.getLessIcon());
        this.btnPrintNet = new JButton(this.iconController.getPrintNetIcon());
        this.btnPrintTable = new JButton(this.iconController.getPrintTableIcon());
        this.btnPreviewNet = new JButton(this.iconController.getPrintPreviewNetIcon());
        this.btnPreviewTable = new JButton(this.iconController.getPrintPreviewTableIcon());
        this.btnSaveNetImage = new JButton(this.iconController.getSaveNetIcon());
        this.btnSaveTableImage = new JButton(this.iconController.getSaveTableIcon());
        this.btnGlobalOption = new JButton(this.iconController.getGlobalOptionIcon());
        this.btnHierarchy = new JButton(this.iconController.getHierarchyIcon());
        this.btnEvaluate.setToolTipText(resource.getString("evaluateToolTip"));
        this.btnCompile.setToolTipText(resource.getString("compileToolTip"));
        this.btnAddState.setToolTipText(resource.getString("moreToolTip"));
        this.btnRemoveState.setToolTipText(resource.getString("lessToolTip"));
        this.btnPrintNet.setToolTipText(resource.getString("printNetToolTip"));
        this.btnPrintTable.setToolTipText(resource.getString("printTableToolTip"));
        this.btnPreviewNet.setToolTipText(resource.getString("previewNetToolTip"));
        this.btnPreviewTable.setToolTipText(resource.getString("previewTableToolTip"));
        this.btnSaveNetImage.setToolTipText(resource.getString("saveNetImageToolTip"));
        this.btnSaveTableImage.setToolTipText(resource.getString("saveTableImageToolTip"));
        this.btnGlobalOption.setToolTipText(resource.getString("globalOptionTitle"));
        this.btnHierarchy.setToolTipText(resource.getString("hierarchyToolTip"));
        this.btnGlobalOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.setCursor(new Cursor(3));
                PNEditionPane.this.go = new GlobalOptionsDialog(PNEditionPane.this.netWindow.getGraphPane(), PNEditionPane.this.controller);
                PNEditionPane.this.go.setVisible(true);
                PNEditionPane.this.netWindow.getGraphPane().update();
                PNEditionPane.this.setCursor(new Cursor(0));
            }
        });
        this.btnHierarchy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.netWindow.changeToHierarchy();
            }
        });
        this.btnCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (!PNEditionPane.this.controller.compileNetwork()) {
                    return;
                }
                PNEditionPane.this.netWindow.changeToPNCompilationPane();
            }
        });
        this.btnEvaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.evaluateNetwork();
            }
        });
        this.txtSigla.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selected = PNEditionPane.this.netWindow.getGraphPane().getSelected();
                if (selected instanceof Node) {
                    Node nodeAux = (Node)selected;
                    if (e.getKeyCode() == 10 && PNEditionPane.this.txtSigla.getText().length() > 0) {
                        try {
                            String name = PNEditionPane.this.txtSigla.getText(0, PNEditionPane.this.txtSigla.getText().length());
                            PNEditionPane.this.matcher = PNEditionPane.this.wordPattern.matcher(name);
                            if (PNEditionPane.this.matcher.matches()) {
                                nodeAux.setName(name);
                                PNEditionPane.this.repaint();
                            } else {
                                JOptionPane.showMessageDialog(PNEditionPane.this.netWindow, resource.getString("siglaError"), resource.getString("nameException"), 0);
                                PNEditionPane.this.txtSigla.selectAll();
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }
            }
        });
        this.txtDescription.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object selected = PNEditionPane.this.netWindow.getGraphPane().getSelected();
                if (selected instanceof Node) {
                    Node nodeAux = (Node)selected;
                    if (e.getKeyCode() == 10 && PNEditionPane.this.txtDescription.getText().length() > 0) {
                        try {
                            String name = PNEditionPane.this.txtDescription.getText(0, PNEditionPane.this.txtDescription.getText().length());
                            PNEditionPane.this.matcher = PNEditionPane.this.descriptionPattern.matcher(name);
                            if (PNEditionPane.this.matcher.matches()) {
                                nodeAux.setDescription(name);
                                PNEditionPane.this.repaint();
                            } else {
                                JOptionPane.showMessageDialog(PNEditionPane.this.netWindow, resource.getString("descriptionError"), resource.getString("nameException"), 0);
                                PNEditionPane.this.txtDescription.selectAll();
                            }
                        }
                        catch (BadLocationException ble) {
                            System.out.println(ble.getMessage());
                        }
                    }
                }
            }
        });
        this.btnRemoveState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (PNEditionPane.this.netWindow.getGraphPane().getSelected() instanceof Node) {
                    PNEditionPane.this.controller.removeState((Node)PNEditionPane.this.netWindow.getGraphPane().getSelected());
                }
            }
        });
        this.btnAddState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (PNEditionPane.this.netWindow.getGraphPane().getSelected() instanceof Node) {
                    PNEditionPane.this.controller.insertState((Node)PNEditionPane.this.netWindow.getGraphPane().getSelected());
                }
            }
        });
        this.btnPrintNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.printNet(PNEditionPane.this.netWindow.getGraphPane(), PNEditionPane.this.controller.calculateNetRectangle());
            }
        });
        this.btnPrintTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.printTable();
            }
        });
        this.btnPreviewTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.previewPrintTable();
            }
        });
        this.btnPreviewNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PNEditionPane.this.controller.previewPrintNet(PNEditionPane.this.netWindow.getGraphPane(), PNEditionPane.this.controller.calculateNetRectangle());
            }
        });
        this.btnSaveNetImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNEditionPane.this.controller.saveNetImage();
            }
        });
        this.btnSaveTableImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PNEditionPane.this.controller.saveTableImage();
            }
        });
        this.jtbEdition.add(this.btnPrintNet);
        this.jtbEdition.add(this.btnPreviewNet);
        this.jtbEdition.add(this.btnSaveNetImage);
        this.jtbEdition.add(this.btnPrintTable);
        this.jtbEdition.add(this.btnPreviewTable);
        this.jtbEdition.add(this.btnSaveTableImage);
        this.jtbEdition.addSeparator();
        this.tbEdition = new ToolBarEdition();
        this.jtbEdition.add(this.tbEdition);
        this.jtbEdition.addSeparator();
        this.jtbEdition.add(this.btnCompile);
        this.jtbEdition.add(this.btnEvaluate);
        this.jtbEdition.addSeparator();
        this.jtbEdition.add(this.btnGlobalOption);
        this.jtbEdition.add(this.btnHierarchy);
        this.topPanel.add(this.jtbEdition);
        this.jtbState.add(this.sigla);
        this.jtbState.add(this.txtSigla);
        this.jtbState.addSeparator();
        this.jtbState.addSeparator();
        this.jtbState.add(this.btnAddState);
        this.jtbState.add(this.btnRemoveState);
        this.jtbState.addSeparator();
        this.jtbState.addSeparator();
        this.jtbState.add(this.description);
        this.jtbState.add(this.txtDescription);
        this.topPanel.add(this.jtbState);
        this.jspTable.setPreferredSize(new Dimension(150, 50));
        this.table.setAutoResizeMode(0);
        this.centerPanel.setTopComponent(this.jspTable);
        this.centerPanel.setDividerSize(3);
        this.centerPanel.resetToPreferredSizes();
        this.bottomPanel.add(this.status);
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setVisible(true);
    }

    public JTable getTable() {
        return this.table;
    }

    public JTextField getTxtDescription() {
        return this.txtDescription;
    }

    public JTextField getTxtSigla() {
        return this.txtSigla;
    }

    public void setDistributionPane(JPanel distributionPane) {
        this.centerPanel.setTopComponent(distributionPane);
    }

    public void setTable(JTable table) {
        this.table = table;
        this.jspTable.setViewportView(table);
        this.centerPanel.setTopComponent(this.jspTable);
        int location = table.getPreferredSize().height + this.centerPanel.getDividerSize() + 2;
        if (table.getTableHeader() != null) {
            location += table.getTableHeader().getPreferredSize().height;
        }
        if (this.jspTable.getVisibleRect().width < table.getPreferredSize().width) {
            this.jspTable.createHorizontalScrollBar();
            location += this.jspTable.getHorizontalScrollBar().getHeight() + 2;
        }
        this.centerPanel.setDividerLocation(location);
    }

    public Node getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(Node node) {
        this.tableOwner = node;
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public JSplitPane getCenterPanel() {
        return this.centerPanel;
    }

    public JButton getBtnCompile() {
        return this.btnCompile;
    }

    public JLabel getDescription() {
        return this.description;
    }

    public JButton getBtnGlobalOption() {
        return this.btnGlobalOption;
    }

    public JButton getBtnRemoveState() {
        return this.btnRemoveState;
    }

    public JButton getBtnAddState() {
        return this.btnAddState;
    }

    public JButton getBtnPreviewNet() {
        return this.btnPreviewNet;
    }

    public JButton getBtnPreviewTable() {
        return this.btnPreviewTable;
    }

    public JButton getBtnPrintNet() {
        return this.btnPrintNet;
    }

    public JButton getBtnPrintTable() {
        return this.btnPrintTable;
    }

    public JButton getBtnSaveNetImage() {
        return this.btnSaveNetImage;
    }

    public JButton getBtnSaveTableImage() {
        return this.btnSaveTableImage;
    }

    public JLabel getSigla() {
        return this.sigla;
    }

    public JButton getBtnHierarchy() {
        return this.btnHierarchy;
    }

    public ToolBarEdition getTbEdition() {
        return this.tbEdition;
    }

    public JButton getBtnEvaluate() {
        return this.btnEvaluate;
    }

    public class ToolBarEdition
    extends JToolBar {
        private static final long serialVersionUID = 1L;
        private final JToggleButton btnResetCursor;
        private final JToggleButton btnAddEdge;
        private final JToggleButton btnAddContinuousNode;
        private final JToggleButton btnAddProbabilisticNode;
        private final JToggleButton btnAddDecisionNode;
        private final JToggleButton btnAddUtilityNode;
        private final JToggleButton btnDeleteSelectedItem;
        private final JToggleButton btnSelectObject;
        private final ButtonGroup groupEditionButtons;

        public ToolBarEdition() {
            this.setFloatable(false);
            this.btnAddProbabilisticNode = new JToggleButton(PNEditionPane.this.iconController.getEllipsisIcon());
            this.btnAddDecisionNode = new JToggleButton(PNEditionPane.this.iconController.getDecisionNodeIcon());
            this.btnAddUtilityNode = new JToggleButton(PNEditionPane.this.iconController.getUtilityNodeIcon());
            this.btnAddContinuousNode = new JToggleButton(PNEditionPane.this.iconController.getGreenNodeIcon());
            this.btnAddEdge = new JToggleButton(PNEditionPane.this.iconController.getEdgeIcon());
            this.btnSelectObject = new JToggleButton(PNEditionPane.this.iconController.getSelectionIcon());
            this.btnResetCursor = new JToggleButton(PNEditionPane.this.iconController.getArrowIcon());
            this.btnDeleteSelectedItem = new JToggleButton(PNEditionPane.this.iconController.getEditDelete());
            this.btnAddEdge.setToolTipText(resource.getString("arcToolTip"));
            this.btnAddContinuousNode.setToolTipText(resource.getString("continuousNodeInsertToolTip"));
            this.btnAddProbabilisticNode.setToolTipText(resource.getString("probabilisticNodeInsertToolTip"));
            this.btnAddDecisionNode.setToolTipText(resource.getString("decisionNodeInsertToolTip"));
            this.btnAddUtilityNode.setToolTipText(resource.getString("utilityNodeInsertToolTip"));
            this.btnSelectObject.setToolTipText(resource.getString("selectToolTip"));
            this.btnResetCursor.setToolTipText(resource.getString("resetToolTip"));
            this.btnDeleteSelectedItem.setToolTipText(resource.getString("deleteSelectedItemToolTip"));
            this.groupEditionButtons = new ButtonGroup();
            this.groupEditionButtons.add(this.btnResetCursor);
            this.groupEditionButtons.add(this.btnAddEdge);
            this.groupEditionButtons.add(this.btnAddContinuousNode);
            this.groupEditionButtons.add(this.btnAddProbabilisticNode);
            this.groupEditionButtons.add(this.btnAddDecisionNode);
            this.groupEditionButtons.add(this.btnAddUtilityNode);
            this.groupEditionButtons.add(this.btnSelectObject);
            this.groupEditionButtons.add(this.btnDeleteSelectedItem);
            this.add(this.btnResetCursor);
            this.add(this.btnAddProbabilisticNode);
            this.add(this.btnAddDecisionNode);
            this.add(this.btnAddUtilityNode);
            this.add(this.btnAddContinuousNode);
            this.add(this.btnAddEdge);
            this.add(this.btnDeleteSelectedItem);
            this.add(this.btnSelectObject);
            this.btnResetCursor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.NONE);
                }
            });
            this.btnAddEdge.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_EDGE);
                }
            });
            this.btnAddContinuousNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_CONTINUOUS_NODE);
                }
            });
            this.btnAddProbabilisticNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_PROBABILISTIC_NODE);
                }
            });
            this.btnAddDecisionNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_DECISION_NODE);
                }
            });
            this.btnAddUtilityNode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.CREATE_UTILITY_NODE);
                }
            });
            this.btnSelectObject.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.netWindow.getGraphPane().setAction(GraphAction.SELECT_MANY_OBJECTS);
                }
            });
            this.btnDeleteSelectedItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    PNEditionPane.this.controller.getSENController().deleteSelectedItem();
                }
            });
        }

        public JToggleButton getBtnAddEdge() {
            return this.btnAddEdge;
        }

        public JToggleButton getBtnAddContinuousNode() {
            return this.btnAddContinuousNode;
        }

        public JToggleButton getBtnAddProbabilisticNode() {
            return this.btnAddProbabilisticNode;
        }

        public JToggleButton getBtnAddDecisionNode() {
            return this.btnAddDecisionNode;
        }

        public JToggleButton getBtnAddUtilityNode() {
            return this.btnAddUtilityNode;
        }

        public JToggleButton getBtnSelectObject() {
            return this.btnSelectObject;
        }

        public JToggleButton getBtnResetCursor() {
            return this.btnResetCursor;
        }

        public JToggleButton getBtnDeleteSelectedItem() {
            return this.btnDeleteSelectedItem;
        }

        public ButtonGroup getGroupEditionButtons() {
            return this.groupEditionButtons;
        }
    }
}

