/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import unbbayes.gui.LearningPNEditionDialog;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;

public class LearningPNEditionPane
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 0L;
    private List arco;
    private Node noAtual;
    private Node noMover;
    private Object selecionado;
    private Graphics2D view;
    private Point2D.Double arcoInicioAtual;
    private Point2D.Double arcoFimAtual;
    private Line2D.Double arcoAtual;
    private boolean bArco;
    private boolean bArrastouNo;
    private boolean bMoverArco;
    private boolean bMoverNo;
    private Color corNo;
    private Color corArco;
    private Color corSelecao;
    private Color corFundo;
    private double raio;
    private JViewport desenho;
    private Dimension tamanhoVisivel;
    private Dimension tamanhoRede;
    private LearningPNEditionDialog janela;
    private ProbabilisticNetwork net;
    private int direction;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public LearningPNEditionPane(LearningPNEditionDialog janel, ProbabilisticNetwork net) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setRequestFocusEnabled(true);
        this.janela = janel;
        this.net = net;
        this.desenho = this.janela.getView();
        this.setSize(800, 600);
        this.arcoInicioAtual = new Point2D.Double();
        this.arcoFimAtual = new Point2D.Double();
        this.arcoAtual = new Line2D.Double();
        this.bArco = false;
        this.bArrastouNo = false;
        this.bMoverArco = false;
        this.bMoverNo = false;
        this.corNo = Color.yellow;
        this.corArco = Color.black;
        this.corSelecao = Color.red;
        this.corFundo = Color.white;
        this.raio = 18.0;
        this.tamanhoRede = new Dimension(1500, 1500);
        this.tamanhoVisivel = new Dimension(0, 0);
        this.arco = net.getEdges();
        int linha = 1;
        int i = 0;
        while (i < net.getNodeCount()) {
            Node noAux = net.getNodeAt(i);
            if ((double)(i + 1) * this.raio >= this.getSize().getWidth()) {
                ++linha;
            }
            noAux.setPosition((double)((i + 1) * 3) * this.raio, 3.0 * this.raio * (double)linha);
            ++i;
        }
    }

    public void setbArco(boolean b) {
        this.bArco = b;
        if (b) {
            this.setCursor(new Cursor(1));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    public Node getNo(double x, double y) {
        int i = 0;
        while (i < this.net.getNodeCount()) {
            Node noPegar = this.net.getNodeAt(i);
            double x1 = noPegar.getPosition().getX();
            double y1 = noPegar.getPosition().getY();
            if (x >= x1 - this.raio && x <= x1 + this.raio && y >= y1 - this.raio && y <= y1 + this.raio) {
                return noPegar;
            }
            ++i;
        }
        return null;
    }

    public boolean isFocusable() {
        return true;
    }

    public Edge getArco(double x, double y) {
        int i = 0;
        while (i < this.arco.size()) {
            Edge arcoPegar = (Edge)this.arco.get(i);
            double x1 = arcoPegar.getOriginNode().getPosition().getX();
            double y1 = arcoPegar.getOriginNode().getPosition().getY();
            double x2 = arcoPegar.getDestinationNode().getPosition().getX();
            double y2 = arcoPegar.getDestinationNode().getPosition().getY();
            double yTeste = (y2 - y1) / (x2 - x1) * x + (y1 - x1 * ((y2 - y1) / (x2 - x1)));
            double xTeste = (y - (y1 - x1 * ((y2 - y1) / (x2 - x1)))) / ((y2 - y1) / (x2 - x1));
            Node no1 = arcoPegar.getOriginNode();
            Node no2 = arcoPegar.getDestinationNode();
            Point2D.Double ponto1 = this.getPonto(no1.getPosition(), no2.getPosition(), this.raio);
            Point2D.Double ponto2 = this.getPonto(no2.getPosition(), no1.getPosition(), this.raio);
            if (ponto1.getX() < ponto2.getX() ? (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0) : (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0)) {
                return arcoPegar;
            }
            ++i;
        }
        return null;
    }

    public Point2D.Double getPonto(Point2D.Double ponto1, Point2D.Double ponto2, double r) {
        double x = 0.0;
        double y = 0.0;
        double x1 = ponto1.getX();
        double y1 = ponto1.getY();
        double x2 = ponto2.getX();
        double y2 = ponto2.getY();
        if (x2 < x1) {
            x = Math.abs(r * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) - x1);
            y = Math.abs(r * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) - y1);
        } else {
            x = Math.abs(r * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) + x1);
            y = Math.abs(r * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) + y1);
        }
        return new Point2D.Double(x, y);
    }

    public Rectangle getTamanhoRepintar() {
        if (this.bMoverNo) {
            Node noAux2;
            Node noAux = (Node)this.selecionado;
            double maiorX = noAux.getPosition().getX();
            double menorX = noAux.getPosition().getX();
            double maiorY = noAux.getPosition().getY();
            double menorY = noAux.getPosition().getY();
            int i = 0;
            while (i < noAux.getParents().size()) {
                noAux2 = noAux.getParents().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            i = 0;
            while (i < noAux.getChildren().size()) {
                noAux2 = noAux.getChildren().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            return new Rectangle((int)(menorX - 6.0 * this.raio), (int)(menorY - 6.0 * this.raio), (int)(maiorX - menorX + 12.0 * this.raio), (int)(maiorY - menorY + 12.0 * this.raio));
        }
        return new Rectangle(this.janela.getJspView().getHorizontalScrollBar().getValue(), this.janela.getJspView().getVerticalScrollBar().getValue(), (int)this.tamanhoVisivel.getWidth(), (int)this.tamanhoVisivel.getHeight());
    }

    public void repintar() {
        this.repaint(this.getTamanhoRepintar());
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.apagaArco(this.selecionado);
        }
        this.repintar();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.desenho.setScrollMode(1);
        if (e.getModifiers() == 16) {
            Edge arco;
            Node no = this.getNo(e.getX(), e.getY());
            if (this.bArco && no != null) {
                this.bMoverArco = true;
                this.arcoInicioAtual.setLocation(no.getPosition().getX(), no.getPosition().getY());
                this.arcoAtual.setLine(no.getPosition().getX(), no.getPosition().getY(), e.getX(), e.getY());
            }
            if (!this.bArco && no != null && !no.isSelected()) {
                this.selecionaNo(no);
            }
            if ((arco = this.getArco(e.getX(), e.getY())) != null) {
                this.selecionaArco(arco);
                if (this.bArco) {
                    this.bArco = false;
                    this.setCursor(new Cursor(0));
                }
            }
            if (!this.bArco && no != null && no.isSelected()) {
                this.noMover = no;
                this.bMoverNo = true;
                this.setCursor(new Cursor(13));
            }
        }
        this.repaint(this.janela.getJspView().getHorizontalScrollBar().getValue(), this.janela.getJspView().getVerticalScrollBar().getValue(), (int)this.tamanhoVisivel.getWidth(), (int)this.tamanhoVisivel.getHeight());
    }

    public void mouseClicked(MouseEvent e) {
        Edge edge = this.getArc(e.getX(), e.getY());
        if (edge != null && e.getModifiers() == 16 && e.getClickCount() == 2) {
            if (this.direction == 0 || this.direction == 1) {
                ++this.direction;
                edge.setDirection(true);
                edge.changeDirection();
            } else if (this.direction == 2) {
                this.direction = 0;
                edge.setDirection(false);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Node noDestino = this.getNo(e.getX(), e.getY());
        if (this.bArco && e.getModifiers() == 16) {
            if (noDestino != null) {
                this.insereArco(this.arcoInicioAtual.getX(), this.arcoInicioAtual.getY(), this.arcoFimAtual.getX(), this.arcoFimAtual.getY());
            }
            this.arcoAtual.setLine(0.0, 0.0, 0.0, 0.0);
        }
        Edge arco = this.getArco(e.getX(), e.getY());
        if (!this.bArco && noDestino == null && arco == null && e.getModifiers() == 16) {
            this.deselecionaNo();
            this.deselecionaArco();
            this.selecionado = null;
        }
        if (this.bMoverArco) {
            this.bMoverArco = false;
        }
        if (!this.bArco) {
            this.bMoverNo = false;
            this.setCursor(new Cursor(0));
        }
        if (e.getModifiers() == 4 && this.bArco) {
            this.bArco = false;
            this.setCursor(new Cursor(0));
        }
        if (this.bArrastouNo) {
            this.bArrastouNo = false;
        }
        this.repintar();
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.bMoverNo && !this.bMoverArco) {
            this.tamanhoVisivel = new Dimension((int)this.janela.getJspView().getSize().getWidth(), (int)this.janela.getJspView().getSize().getHeight());
            this.desenho.setOpaque(true);
            this.desenho.scrollRectToVisible(new Rectangle(this.tamanhoRede));
            this.desenho.setPreferredSize(this.tamanhoRede);
            this.desenho.revalidate();
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if ((double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight() && (double)e.getX() + 2.0 * this.raio > this.tamanhoVisivel.getWidth() + (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() + 2.0 * this.raio > this.tamanhoVisivel.getHeight() + (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
            if (this.bMoverNo && this.noMover != null) {
                this.janela.getJspView().getHorizontalScrollBar().setValue((int)(this.noMover.getPosition().getX() + 2.0 * this.raio - this.tamanhoVisivel.getWidth()));
                this.janela.getJspView().getVerticalScrollBar().setValue((int)(this.noMover.getPosition().getY() + 2.0 * this.raio - this.tamanhoVisivel.getHeight()));
            } else {
                this.janela.getJspView().getHorizontalScrollBar().setValue((int)((double)e.getX() + 2.0 * this.raio - this.tamanhoVisivel.getWidth()));
                this.janela.getJspView().getVerticalScrollBar().setValue((int)((double)e.getY() + 2.0 * this.raio - this.tamanhoVisivel.getHeight()));
            }
        } else if ((double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getX() + 2.0 * this.raio > this.tamanhoVisivel.getWidth() + (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() + 2.0 * this.raio <= this.tamanhoVisivel.getHeight() + (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
            if (this.bMoverNo && this.noMover != null) {
                this.janela.getJspView().getHorizontalScrollBar().setValue((int)(this.noMover.getPosition().getX() + 2.0 * this.raio - this.tamanhoVisivel.getWidth()));
            } else {
                this.janela.getJspView().getHorizontalScrollBar().setValue((int)((double)e.getX() + 2.0 * this.raio - this.tamanhoVisivel.getWidth()));
            }
        } else if ((double)e.getY() < this.tamanhoRede.getHeight() && (double)e.getX() + 2.0 * this.raio <= this.tamanhoVisivel.getWidth() + (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() + 2.0 * this.raio > this.tamanhoVisivel.getHeight() + (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
            if (this.bMoverNo && this.noMover != null) {
                this.janela.getJspView().getVerticalScrollBar().setValue((int)(this.noMover.getPosition().getY() + 2.0 * this.raio - this.tamanhoVisivel.getHeight()));
            } else {
                this.janela.getJspView().getVerticalScrollBar().setValue((int)((double)e.getY() + 2.0 * this.raio - this.tamanhoVisivel.getHeight()));
            }
        } else if (!((double)e.getX() - this.raio > (double)this.janela.getJspView().getHorizontalScrollBar().getValue()) || !((double)e.getY() - this.raio > (double)this.janela.getJspView().getVerticalScrollBar().getValue())) {
            if (e.getX() > 0 && e.getY() > 0 && (double)e.getX() - this.raio < (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() - this.raio < (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
                if (this.bMoverNo && this.noMover != null) {
                    this.janela.getJspView().getHorizontalScrollBar().setValue((int)(this.noMover.getPosition().getX() - this.raio));
                    this.janela.getJspView().getVerticalScrollBar().setValue((int)(this.noMover.getPosition().getY() - this.raio));
                } else {
                    this.janela.getJspView().getHorizontalScrollBar().setValue((int)((double)e.getX() - this.raio));
                    this.janela.getJspView().getVerticalScrollBar().setValue((int)((double)e.getY() - this.raio));
                }
            } else if (e.getY() > 0 && (double)e.getX() - this.raio >= (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() - this.raio < (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
                if (this.bMoverNo && this.noMover != null) {
                    this.janela.getJspView().getVerticalScrollBar().setValue((int)(this.noMover.getPosition().getY() - this.raio));
                } else {
                    this.janela.getJspView().getVerticalScrollBar().setValue((int)((double)e.getY() - this.raio));
                }
            } else if (e.getX() > 0 && (double)e.getX() - this.raio < (double)this.janela.getJspView().getHorizontalScrollBar().getValue() && (double)e.getY() - this.raio >= (double)this.janela.getJspView().getVerticalScrollBar().getValue()) {
                if (this.bMoverNo && this.noMover != null) {
                    this.janela.getJspView().getHorizontalScrollBar().setValue((int)(this.noMover.getPosition().getX() - this.raio));
                } else {
                    this.janela.getJspView().getHorizontalScrollBar().setValue((int)((double)e.getX() - this.raio));
                }
            }
        }
        if (e.getModifiers() == 16) {
            if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() > this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(e.getX(), e.getY());
                this.bArrastouNo = true;
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() > 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(e.getX(), e.getY());
            } else if (this.bArco && this.bMoverArco && e.getX() <= 0 && e.getY() > 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(0.0, e.getY());
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() <= 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(e.getX(), 0.0);
            } else if (this.bArco && this.bMoverArco && e.getX() <= 0 && e.getY() <= 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(0.0, 0.0);
            } else if (this.bArco && this.bMoverArco && e.getX() <= 0 && e.getY() > 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() >= this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(0.0, this.tamanhoRede.getHeight());
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() > 0 && (double)e.getX() < this.tamanhoRede.getWidth() && (double)e.getY() >= this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(e.getX(), this.tamanhoRede.getHeight());
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() > 0 && (double)e.getX() >= this.tamanhoRede.getWidth() && (double)e.getY() >= this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(this.tamanhoRede.getWidth(), this.tamanhoRede.getHeight());
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() > 0 && (double)e.getX() >= this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(this.tamanhoRede.getWidth(), e.getY());
            } else if (this.bArco && this.bMoverArco && e.getX() > 0 && e.getY() <= 0 && (double)e.getX() >= this.tamanhoRede.getWidth() && (double)e.getY() < this.tamanhoRede.getHeight()) {
                this.arcoFimAtual.setLocation(e.getX(), e.getY());
                this.atualizaArcoAtual(this.tamanhoRede.getWidth(), 0.0);
            } else if (this.bMoverNo && (double)e.getX() <= this.raio && (double)e.getY() > this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.raio, e.getY());
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() <= this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(e.getX(), this.raio);
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() <= this.raio && (double)e.getY() <= this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.raio, this.raio);
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() <= this.raio && (double)e.getY() > this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() >= this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.raio, this.tamanhoRede.getHeight() - this.raio);
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() > this.raio && (double)e.getX() < this.tamanhoRede.getWidth() - this.raio && (double)e.getY() >= this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(e.getX(), this.tamanhoRede.getHeight() - this.raio);
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() > this.raio && (double)e.getX() >= this.tamanhoRede.getWidth() - this.raio && (double)e.getY() >= this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.tamanhoRede.getWidth() - this.raio, this.tamanhoRede.getHeight() - this.raio);
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() > this.raio && (double)e.getX() >= this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.tamanhoRede.getWidth() - this.raio, e.getY());
                this.bArrastouNo = true;
            } else if (this.bMoverNo && (double)e.getX() > this.raio && (double)e.getY() <= this.raio && (double)e.getX() >= this.tamanhoRede.getWidth() - this.raio && (double)e.getY() < this.tamanhoRede.getHeight() - this.raio) {
                this.noAtual = this.noMover;
                this.atualizaNoAtual(this.tamanhoRede.getWidth() - this.raio, this.raio);
                this.bArrastouNo = true;
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void deselecionaArco() {
        if (this.selecionado instanceof Edge) {
            ((Edge)this.selecionado).setSelected(false);
        }
    }

    public void deselecionaNo() {
        if (this.selecionado instanceof Node) {
            ((Node)this.selecionado).setSelected(false);
        }
    }

    public void selecionaNo(Node no) {
        this.deselecionaNo();
        this.deselecionaArco();
        no.setSelected(true);
        this.selecionado = no;
    }

    public void selecionaArco(Edge arco) {
        this.deselecionaNo();
        this.deselecionaArco();
        arco.setSelected(true);
        this.selecionado = arco;
    }

    public void atualizaArcoAtual(double x, double y) {
        Point2D.Double ponto = new Point2D.Double();
        ponto = this.getPonto(this.arcoInicioAtual, this.arcoFimAtual, this.raio);
        this.arcoAtual.setLine(ponto.getX(), ponto.getY(), x, y);
        this.arcoFimAtual.setLocation(x, y);
        this.repintar();
    }

    public void atualizaNoAtual(double x, double y) {
        this.noAtual.setPosition(x, y);
        this.repintar();
    }

    public void insereArco(double x1, double y1, double x2, double y2) {
        Node no1 = this.getNo(x1, y1);
        Node no2 = this.getNo(x2, y2);
        Edge arcoInserir = new Edge(no1, no2);
        try {
            this.net.addEdge(arcoInserir);
        }
        catch (InvalidParentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("statusError"), 0);
        }
        this.repintar();
    }

    public Line2D.Double desenhaArco(Edge a) {
        Point2D.Double ponto1 = new Point2D.Double();
        Point2D.Double ponto2 = new Point2D.Double();
        Node no1 = a.getOriginNode();
        Node no2 = a.getDestinationNode();
        ponto1 = this.getPonto(no1.getPosition(), no2.getPosition(), this.raio);
        ponto2 = this.getPonto(no2.getPosition(), no1.getPosition(), this.raio);
        return new Line2D.Double(ponto1, ponto2);
    }

    public GeneralPath desenhaSeta(Edge a, boolean bExisteArco) {
        double y4;
        double x4;
        double y3;
        double x3;
        double y2;
        double x2;
        Point2D.Double ponto1 = new Point2D.Double();
        Point2D.Double ponto2 = new Point2D.Double();
        GeneralPath seta = new GeneralPath();
        Node no1 = a.getOriginNode();
        Node no2 = a.getDestinationNode();
        double x1 = no1.getPosition().getX();
        double y1 = no1.getPosition().getY();
        if (bExisteArco) {
            ponto1 = this.getPonto(no2.getPosition(), no1.getPosition(), this.raio + 10.0);
            ponto2 = this.getPonto(no2.getPosition(), no1.getPosition(), this.raio);
            x2 = ponto2.getX();
            y2 = ponto2.getY();
        } else {
            ponto1 = this.getPonto(no2.getPosition(), no1.getPosition(), 10.0);
            x2 = no2.getPosition().getX();
            y2 = no2.getPosition().getY();
        }
        if (x1 > x2 && y1 > y2 || x1 < x2 && y1 < y2) {
            x3 = ponto1.getX() + 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y3 = ponto1.getY() - 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
            x4 = ponto1.getX() - 5.0 * Math.abs(Math.cos(Math.atan((x2 - x1) / (y1 - y2))));
            y4 = ponto1.getY() + 5.0 * Math.abs(Math.sin(Math.atan((x2 - x1) / (y1 - y2))));
        } else {
            x3 = ponto1.getX() + 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y3 = ponto1.getY() - 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
            x4 = ponto1.getX() - 5.0 * Math.cos(Math.atan((x1 - x2) / (y1 - y2)));
            y4 = ponto1.getY() + 5.0 * Math.sin(Math.atan((x1 - x2) / (y1 - y2)));
        }
        seta.moveTo((float)x3, (float)y3);
        seta.lineTo((float)x2, (float)y2);
        seta.lineTo((float)x4, (float)y4);
        seta.lineTo((float)x3, (float)y3);
        return seta;
    }

    public void paint(Graphics g) {
        Node noAux;
        this.view = (Graphics2D)g;
        this.view.setBackground(this.corFundo);
        this.view.clearRect(this.janela.getJspView().getHorizontalScrollBar().getValue(), this.janela.getJspView().getVerticalScrollBar().getValue(), (int)this.janela.getJspView().getSize().getWidth(), (int)this.janela.getJspView().getSize().getHeight());
        this.view.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.view.setColor(this.corNo);
        this.view.setStroke(new BasicStroke(1.0f));
        int i = 0;
        while (i < this.net.getNodeCount()) {
            noAux = this.net.getNodeAt(i);
            this.view.fill(new Ellipse2D.Double(noAux.getPosition().x - this.raio, noAux.getPosition().y - this.raio, this.raio * 2.0, this.raio * 2.0));
            if (noAux.getName() == null) {
                noAux.setName(String.valueOf(resource.getString("nodeGraphName")) + i);
            }
            AttributedString as = new AttributedString(noAux.getName());
            Font serifFont = new Font("Serif", 0, 12);
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            double alt = serifFont.getStringBounds(noAux.getName(), frc).getHeight();
            double lar = serifFont.getStringBounds(noAux.getName(), frc).getWidth();
            as.addAttribute(TextAttribute.FONT, serifFont);
            as.addAttribute(TextAttribute.FOREGROUND, Color.black);
            this.view.drawString(as.getIterator(), (int)(noAux.getPosition().getX() - lar / 2.0), (int)(noAux.getPosition().getY() + alt / 2.0));
            ++i;
        }
        this.view.setColor(this.corArco);
        if (this.bArco) {
            this.view.draw(this.arcoAtual);
            ProbabilisticNode noAux2 = new ProbabilisticNode();
            noAux2.setPosition(this.arcoAtual.getX1(), this.arcoAtual.getY1());
            ProbabilisticNode noAux22 = new ProbabilisticNode();
            noAux22.setPosition(this.arcoAtual.getX2(), this.arcoAtual.getY2());
            Edge arcoAux = new Edge(noAux2, noAux22);
            this.view.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.view.fill(this.desenhaSeta(arcoAux, false));
            this.view.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        i = 0;
        while (i < this.arco.size()) {
            Edge arcoAux = (Edge)this.arco.get(i);
            if (arcoAux.isSelected()) {
                this.view.setColor(this.corSelecao);
                this.view.setStroke(new BasicStroke(2.0f));
            } else {
                this.view.setColor(this.corArco);
            }
            if (arcoAux.getOriginNode().getPosition().getX() == arcoAux.getDestinationNode().getPosition().getX() || arcoAux.getOriginNode().getPosition().getY() == arcoAux.getDestinationNode().getPosition().getY()) {
                this.view.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.view.draw(this.desenhaArco(arcoAux));
            if (arcoAux.hasDirection()) {
                this.view.fill(this.desenhaSeta(arcoAux, true));
            }
            this.view.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.view.setStroke(new BasicStroke(1.0f));
            ++i;
        }
        if (this.bMoverNo && this.noAtual != null && this.noAtual.getPosition().getX() != 0.0 && this.noAtual.getPosition().getY() != 0.0) {
            this.view.setColor(this.corNo);
            this.view.draw(new Ellipse2D.Double(this.noAtual.getPosition().getX() - this.raio, this.noAtual.getPosition().getY() - this.raio, this.raio * 2.0, this.raio * 2.0));
        }
        i = 0;
        while (i < this.net.getNodeCount()) {
            noAux = this.net.getNodeAt(i);
            if (noAux.isSelected()) {
                this.view.setColor(this.corSelecao);
                this.view.setStroke(new BasicStroke(2.0f));
            } else {
                this.view.setColor(this.corArco);
            }
            this.view.draw(new Ellipse2D.Double(noAux.getPosition().x - this.raio, noAux.getPosition().y - this.raio, this.raio * 2.0, this.raio * 2.0));
            this.view.setStroke(new BasicStroke(1.0f));
            ++i;
        }
    }

    public void apagaArco(Object o) {
        Edge aux = (Edge)o;
        Node no1 = aux.getOriginNode();
        Node no2 = aux.getDestinationNode();
        no2.getParents().remove(no1);
        no1.getChildren().remove(no2);
        this.arco.remove(o);
        this.repintar();
    }

    public Edge getArc(double x, double y) {
        int i = 0;
        while (i < this.arco.size()) {
            Edge arcoPegar = (Edge)this.arco.get(i);
            double x1 = arcoPegar.getOriginNode().getPosition().getX();
            double y1 = arcoPegar.getOriginNode().getPosition().getY();
            double x2 = arcoPegar.getDestinationNode().getPosition().getX();
            double y2 = arcoPegar.getDestinationNode().getPosition().getY();
            double yTeste = (y2 - y1) / (x2 - x1) * x + (y1 - x1 * ((y2 - y1) / (x2 - x1)));
            double xTeste = (y - (y1 - x1 * ((y2 - y1) / (x2 - x1)))) / ((y2 - y1) / (x2 - x1));
            Node no1 = arcoPegar.getOriginNode();
            Node no2 = arcoPegar.getDestinationNode();
            Point2D.Double ponto1 = this.getPoint(no1.getPosition(), no2.getPosition(), this.raio);
            Point2D.Double ponto2 = this.getPoint(no2.getPosition(), no1.getPosition(), this.raio);
            if (ponto1.getX() < ponto2.getX() ? (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto1.getX() - 5.0 && x <= ponto2.getX() + 5.0) : (y <= yTeste + 5.0 && y >= yTeste - 5.0 || x <= xTeste + 5.0 && x >= xTeste - 5.0) && (ponto1.getY() < ponto2.getY() ? y >= ponto1.getY() - 5.0 && y <= ponto2.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0 : y >= ponto2.getY() - 5.0 && y <= ponto1.getY() + 5.0 && x >= ponto2.getX() - 5.0 && x <= ponto1.getX() + 5.0)) {
                return arcoPegar;
            }
            ++i;
        }
        return null;
    }

    public Point2D.Double getPoint(Point2D.Double point1, Point2D.Double point2, double r) {
        double x = 0.0;
        double y = 0.0;
        double x1 = point1.getX();
        double y1 = point1.getY();
        double x2 = point2.getX();
        double y2 = point2.getY();
        if (x2 < x1) {
            x = Math.abs(r * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) - x1);
            y = Math.abs(r * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) - y1);
        } else {
            x = Math.abs(r * Math.cos(Math.atan((y2 - y1) / (x2 - x1))) + x1);
            y = Math.abs(r * Math.sin(Math.atan((y2 - y1) / (x2 - x1))) + y1);
        }
        return new Point2D.Double(x, y);
    }
}

