/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import unbbayes.draw.DrawElement;

public class DrawRoundedRectangle
extends DrawElement {
    private Point2D.Double position;
    private Point2D.Double size;

    public DrawRoundedRectangle(Point2D.Double position, Point2D.Double size) {
        this.position = position;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.getFillColor());
        Rectangle2D.Double rectangle = new Rectangle2D.Double(this.position.x - this.size.x * 0.8 / 2.0, this.position.y - this.size.y / 2.0, 0.8 * this.size.x, this.size.y);
        Ellipse2D.Double leftBorder = new Ellipse2D.Double(this.position.x - this.size.x / 2.0, this.position.y - this.size.y / 2.0, 0.2 * this.size.x, this.size.y);
        Ellipse2D.Double rightBorder = new Ellipse2D.Double(this.position.x + this.size.x * 0.8 / 2.0 - this.size.x * 0.1, this.position.y - this.size.y / 2.0, 0.2 * this.size.x, this.size.y);
        Area area = new Area(rectangle);
        area.add(new Area(leftBorder));
        area.add(new Area(rightBorder));
        graphics.fill(area);
        if (this.isSelected()) {
            graphics.setColor(DrawRoundedRectangle.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(DrawRoundedRectangle.getOutlineColor());
        }
        graphics.draw(area);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

