/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;

public class DrawParallelogram
extends DrawElement {
    private Point2D.Double position;
    private Point2D.Double size;

    public DrawParallelogram(Point2D.Double position, Point2D.Double size) {
        this.position = position;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        GeneralPath parallelogram = new GeneralPath();
        parallelogram.moveTo((float)(this.position.x - this.size.x / 2.0), (float)this.position.y);
        parallelogram.lineTo((float)this.position.x, (float)(this.position.y + this.size.y / 2.0));
        parallelogram.lineTo((float)(this.position.x + this.size.x / 2.0), (float)this.position.y);
        parallelogram.lineTo((float)this.position.x, (float)(this.position.y - this.size.y / 2.0));
        parallelogram.lineTo((float)(this.position.x - this.size.x / 2.0), (float)this.position.y);
        graphics.setColor(this.getFillColor());
        graphics.fill(parallelogram);
        if (this.isSelected()) {
            graphics.setColor(DrawParallelogram.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(DrawParallelogram.getOutlineColor());
        }
        graphics.draw(parallelogram);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

