/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;
import unbbayes.datamining.preprocessor.imbalanceddataset.Utils;

public class RandomUndersampling
extends Batch {
    private static boolean useRatio = true;
    private static boolean useK = false;
    private static boolean useOverThresh = false;
    private static boolean usePosThresh = false;
    private static boolean useNegThresh = false;
    private static boolean useCleaning = false;
    private boolean remove;
    private boolean[] deleteIndex;

    public RandomUndersampling(InstanceSet instanceSet) {
        this(instanceSet, null);
    }

    public RandomUndersampling(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Oversampling";
    }

    public void runAll() {
        int numInstances = this.instanceSet.numInstances;
        int[] instancesIDs = new int[numInstances];
        int i = 0;
        while (i < numInstances) {
            instancesIDs[i] = i;
            ++i;
        }
        this.run(instancesIDs);
    }

    protected void run() {
        Instance[] instances = this.instanceSet.instances;
        int numInstances = this.instanceSet.numInstances;
        int counter = 0;
        int[] instancesIDsTmp = new int[numInstances];
        int classIndex = this.instanceSet.classIndex;
        int inst = 0;
        while (inst < numInstances) {
            if (instances[inst].data[classIndex] == (float)this.interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.run(instancesIDs);
    }

    public void run(int[] instancesIDs) {
        if (this.instanceSet.isCompacted()) {
            instancesIDs = Utils.uncompactInstancesIDs(instancesIDs, this.instanceSet);
        }
        int counterIndex = this.instanceSet.counterIndex;
        int numInstancesIDs = instancesIDs.length;
        int inst = 0;
        int currentSize = 0;
        int i = 0;
        while (i < numInstancesIDs) {
            inst = instancesIDs[i];
            currentSize = (int)((float)currentSize + this.instanceSet.instances[inst].data[counterIndex]);
            ++i;
        }
        int decreaseSize = Math.round((float)(1.0 - this.proportion) * (float)currentSize);
        if (this.deleteIndex == null) {
            this.deleteIndex = new boolean[this.instanceSet.numInstances];
            Arrays.fill(this.deleteIndex, false);
        }
        Random randomizer = new Random(new Date().getTime());
        int deleteCounter = 0;
        while (deleteCounter < decreaseSize) {
            int instIDs = randomizer.nextInt(numInstancesIDs);
            inst = instancesIDs[instIDs];
            if (this.deleteIndex[inst]) {
                boolean bl = false;
            }
            --this.instanceSet.numWeightedInstances;
            int n = counterIndex;
            this.instanceSet.instances[inst].data[n] = this.instanceSet.instances[inst].data[n] - 1.0f;
            if (this.instanceSet.instances[inst].data[counterIndex] <= 0.0f) {
                int lastID;
                this.deleteIndex[inst] = true;
                instancesIDs[instIDs] = lastID = instancesIDs[numInstancesIDs - 1];
                --numInstancesIDs;
            }
            ++deleteCounter;
        }
        if (deleteCounter > 0 && this.remove) {
            this.instanceSet.removeInstances(this.deleteIndex);
        }
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setDeleteIndex(boolean[] deleteIndex) {
        this.deleteIndex = deleteIndex;
    }

    protected void initializeBatch(InstanceSet instanceSet) {
        this.setRemove(true);
        this.setInstanceSet(instanceSet);
        this.setInterestingClass(this.positiveClass);
    }
}

