/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.util.ArrayList;
import java.util.Hashtable;
import unbbayes.datamining.clustering.CEBMDC;
import unbbayes.datamining.clustering.Kmeans;
import unbbayes.datamining.clustering.Squeezer;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.NearestNeighbors;
import unbbayes.datamining.distance.Euclidean;
import unbbayes.datamining.evaluation.batchEvaluation.GlobalBatchParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterBasedUtils {
    private InstanceSet instanceSet;
    private Hashtable<Integer, int[][]> clusters;
    private Hashtable<Integer, int[][][]> clustersByClass;
    private Hashtable<Integer, int[]> numClustersByClass;
    private Hashtable<Integer, int[][][]> smoteNN;
    private Hashtable<Integer, int[][][][]> smoteNNByClass;
    private Hashtable<Integer, double[][]> clustersSizeByClass;
    protected static double kError;
    private int k;
    private NearestNeighbors nearestNeighbors;

    public ClusterBasedUtils(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
        this.initialize();
        this.clusters = new Hashtable();
        this.smoteNN = new Hashtable();
        this.clustersByClass = new Hashtable();
        this.numClustersByClass = new Hashtable();
        this.clustersSizeByClass = new Hashtable();
        this.smoteNNByClass = new Hashtable();
    }

    public void clusterizeByClass(int k) throws Exception {
        int numClasses = this.instanceSet.numClasses();
        int[][][] clustersByClassAux = new int[numClasses][][];
        int[][][][] smoteNNByClassAux = new int[numClasses][][][];
        int[] numClustersByClassAux = new int[numClasses];
        double[][] clustersSizeByClassAux = new double[numClasses][];
        int classValue = 0;
        while (classValue < numClasses) {
            clustersByClassAux[classValue] = this.clusterize(classValue, true);
            numClustersByClassAux[classValue] = clustersByClassAux[classValue].length;
            clustersSizeByClassAux[classValue] = new double[numClustersByClassAux[classValue]];
            int i = 0;
            while (i < numClustersByClassAux[classValue]) {
                int[] cluster = clustersByClassAux[classValue][i];
                int counter = 0;
                int j = 0;
                while (j < cluster.length) {
                    int inst = cluster[j];
                    counter = (int)((float)counter + this.instanceSet.instances[inst].getWeight());
                    ++j;
                }
                clustersSizeByClassAux[classValue][i] = counter;
                ++i;
            }
            smoteNNByClassAux[classValue] = this.buildSmoteNN(clustersByClassAux[classValue]);
            ++classValue;
        }
        this.clustersByClass.put(k, clustersByClassAux);
        this.smoteNNByClass.put(k, smoteNNByClassAux);
        this.numClustersByClass.put(k, numClustersByClassAux);
        this.clustersSizeByClass.put(k, clustersSizeByClassAux);
    }

    private void clusterize() throws Exception {
        int[][] clustersAux = this.clusterize(null, false);
        this.clusters.put(this.k, clustersAux);
        this.smoteNN.put(this.k, this.buildSmoteNN(clustersAux));
    }

    private int[][] clusterize(int classValue, boolean byClass) throws Exception {
        int[] instancesPos = this.instanceSet.getInstancesPosFromClass(classValue);
        return this.clusterize(instancesPos, byClass);
    }

    private int[][] clusterize(int[] instancesPos, boolean byClass) throws Exception {
        int[] numericClusters = null;
        int[] nominalClusters = null;
        int[][] clusters = null;
        if (this.instanceSet.isNumeric() || this.instanceSet.isMixed()) {
            ArrayList<Object> numericResult = this.clusterizeKmeans(instancesPos, byClass);
            clusters = (int[][])numericResult.get(0);
            numericClusters = (int[])numericResult.get(1);
        }
        if (this.instanceSet.isNominal() || this.instanceSet.isMixed()) {
            ArrayList<Object> nominalResult = this.clusterizeSqueezer(instancesPos, byClass);
            clusters = (int[][])nominalResult.get(0);
            nominalClusters = (int[])nominalResult.get(1);
        }
        if (this.instanceSet.isMixed()) {
            ArrayList<Object> mixedResult = this.clusterizeCEBMDC(instancesPos, byClass, numericClusters, nominalClusters);
            clusters = (int[][])mixedResult.get(0);
        }
        return clusters;
    }

    private ArrayList<Object> clusterizeSqueezer(int[] instancesPos, boolean byClass) throws Exception {
        Squeezer squeezer = new Squeezer(this.instanceSet);
        squeezer.setUseAverageSimilarity(true);
        if (byClass) {
            squeezer.clusterize(instancesPos);
        } else {
            squeezer.clusterize();
        }
        int[][] clusters = squeezer.getClusters();
        int[] assignmentMatrix = squeezer.getAssignmentMatrix();
        ArrayList<Object> result = new ArrayList<Object>(2);
        result.add(clusters);
        result.add(assignmentMatrix);
        return result;
    }

    private ArrayList<Object> clusterizeKmeans(int[] instancesPos, boolean byClass) throws Exception {
        int normFactor = 4;
        Euclidean distance = new Euclidean(this.instanceSet, normFactor, false);
        Kmeans kmeans = new Kmeans(this.instanceSet);
        kmeans.setOptionDistance(distance);
        kmeans.setError(kError);
        kmeans.setNumClusters(this.k);
        if (byClass) {
            kmeans.clusterize(instancesPos);
        } else {
            kmeans.clusterize();
        }
        int[][] clusters = kmeans.getClusters();
        int[] assignmentMatrix = kmeans.getAssignmentMatrix();
        ArrayList<Object> result = new ArrayList<Object>(2);
        result.add(clusters);
        result.add(assignmentMatrix);
        return result;
    }

    private ArrayList<Object> clusterizeCEBMDC(int[] instancesPos, boolean byClass, int[] numericClusters, int[] nominalClusters) throws Exception {
        CEBMDC cebmdc = new CEBMDC(this.instanceSet);
        double[] weight = new double[]{this.instanceSet.numNumericAttributes, this.instanceSet.numNominalAttributes};
        cebmdc.setWeight(weight);
        cebmdc.setUseAverageSimilarity(true);
        cebmdc.setNumericClustersInput(numericClusters);
        cebmdc.setNominalClustersInput(nominalClusters);
        cebmdc.clusterize();
        int[][] clusters = cebmdc.getClusters();
        ArrayList<Object> result = new ArrayList<Object>(2);
        result.add(clusters);
        result.add(null);
        return result;
    }

    private int[][][] buildSmoteNN(int[][] clusters) throws Exception {
        if (this.instanceSet.isNumeric() || this.instanceSet.isMixed()) {
            int numClusters = clusters.length;
            int[][][] smoteNN = new int[numClusters][][];
            int clusterID = 0;
            while (clusterID < numClusters) {
                smoteNN[clusterID] = this.nearestNeighbors.build(clusters[clusterID]);
                ++clusterID;
            }
            return smoteNN;
        }
        return null;
    }

    public void setKError(double kError) {
        ClusterBasedUtils.kError = kError;
    }

    public int[][] getClusters(int k) throws Exception {
        this.k = k;
        if (!this.clusters.containsKey(k)) {
            this.clusterize();
        }
        return (int[][])this.clusters.get(k).clone();
    }

    public int[][][] getClustersByClass(int k) throws Exception {
        this.k = k;
        if (!this.clustersByClass.containsKey(k)) {
            this.clusterizeByClass(k);
        }
        return (int[][][])this.clustersByClass.get(k).clone();
    }

    public int getNumClusters(int k) throws Exception {
        this.k = k;
        if (!this.clusters.containsKey(k)) {
            this.clusterize();
        }
        return this.clusters.get(k).length;
    }

    public int[] getNumClustersByClass(int k) throws Exception {
        this.k = k;
        if (!this.clustersByClass.containsKey(k)) {
            this.clusterizeByClass(k);
        }
        return (int[])this.numClustersByClass.get(k).clone();
    }

    public int[][][] getSmoteNN(int k) throws Exception {
        this.k = k;
        if (!this.smoteNN.containsKey(k)) {
            this.clusterize();
        }
        return (int[][][])this.smoteNN.get(k).clone();
    }

    public int[][][][] getSmoteNNByClass(int k) throws Exception {
        this.k = k;
        if (!this.smoteNNByClass.containsKey(k)) {
            this.clusterizeByClass(k);
        }
        return (int[][][][])this.smoteNNByClass.get(k).clone();
    }

    public double[][] getClustersSizeByClass(int k) throws Exception {
        this.k = k;
        if (!this.clustersSizeByClass.containsKey(k)) {
            this.clusterizeByClass(k);
        }
        return (double[][])this.clustersSizeByClass.get(k).clone();
    }

    private void initialize() {
        kError = GlobalBatchParameters.getInstance().getKError();
        this.nearestNeighbors = new NearestNeighbors(this.instanceSet);
    }
}

