/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.naivebayes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.classifiers.NaiveBayes;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.AttributePanel;
import unbbayes.gui.FileIcon;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.PNEditionPane;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class NaiveBayesMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private JPanel contentPane;
    private BorderLayout borderLayout1 = new BorderLayout();
    private InstanceSet inst;
    private ResourceBundle resource;
    private ProbabilisticNetwork net;
    private JToolBar jToolBar1 = new JToolBar();
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem jMenuItem3 = new JMenuItem();
    private JMenu jMenu3 = new JMenu();
    private JMenuItem jMenuItem4 = new JMenuItem();
    private JMenuItem jMenuItem5 = new JMenuItem();
    private JButton helpButton = new JButton();
    private JButton learnButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton openButton = new JButton();
    private ImageIcon abrirIcon;
    private ImageIcon compilaIcon;
    private ImageIcon helpIcon;
    private ImageIcon salvarIcon;
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private AttributePanel jPanel4;
    private BorderLayout borderLayout3 = new BorderLayout();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout6 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel jPanel1;
    private BorderLayout borderLayout2 = new BorderLayout();
    private JFileChooser fileChooser;
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JLabel statusBar = new JLabel();
    private Border border1;
    private TitledBorder titledBorder1;
    private NaiveBayes naiveBayes;

    public NaiveBayesMain() {
        super("Naive Bayes Classifier", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.naivebayes.resources.NaiveBayesResource");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.abrirIcon = iconController.getOpenIcon();
        this.compilaIcon = iconController.getCompileIcon();
        this.helpIcon = iconController.getHelpIcon();
        this.salvarIcon = iconController.getSaveIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.jPanel1 = new JPanel();
        this.titledBorder1 = new TitledBorder(this.border1, "Status");
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(640, 480));
        this.jMenu1.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenu1.setText(this.resource.getString("fileMenu"));
        this.jMenuItem1.setIcon(this.abrirIcon);
        this.jMenuItem1.setMnemonic(((Character)this.resource.getObject("openMnemonic")).charValue());
        this.jMenuItem1.setText(this.resource.getString("openMenu"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.jMenuItem2.setMnemonic(((Character)this.resource.getObject("exitMnemonic")).charValue());
        this.jMenuItem2.setText(this.resource.getString("exit"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.jMenu2.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenu2.setText(this.resource.getString("help"));
        this.jMenuItem3.setIcon(this.helpIcon);
        this.jMenuItem3.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuItem3.setText(this.resource.getString("helpTopicsMenu"));
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.jMenuItem3_actionPerformed(e);
            }
        });
        this.jMenu3.setMnemonic(((Character)this.resource.getObject("learningMnemonic")).charValue());
        this.jMenu3.setText(this.resource.getString("learningMenu"));
        this.jMenuItem4.setEnabled(false);
        this.jMenuItem4.setIcon(this.compilaIcon);
        this.jMenuItem4.setMnemonic(((Character)this.resource.getObject("learnNaiveBayesMnemonic")).charValue());
        this.jMenuItem4.setText(this.resource.getString("learnNaiveBayes"));
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.jMenuItem4_actionPerformed(e);
            }
        });
        this.jMenuItem5.setEnabled(false);
        this.jMenuItem5.setIcon(this.salvarIcon);
        this.jMenuItem5.setMnemonic(((Character)this.resource.getObject("saveNetworkMnemonic")).charValue());
        this.jMenuItem5.setText(this.resource.getString("saveNetworkMenu"));
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.jMenuItem5_actionPerformed(e);
            }
        });
        this.openButton.setToolTipText(this.resource.getString("openFileTooltip"));
        this.openButton.setIcon(this.abrirIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.openButton_actionPerformed(e);
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(this.resource.getString("saveFileTooltip"));
        this.saveButton.setIcon(this.salvarIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.saveButton_actionPerformed(e);
            }
        });
        this.learnButton.setEnabled(false);
        this.learnButton.setToolTipText(this.resource.getString("learnDataTooltip"));
        this.learnButton.setIcon(this.compilaIcon);
        this.learnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.learnButton_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("helpFileTooltip"));
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NaiveBayesMain.this.helpButton_actionPerformed(e);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout5);
        this.jPanel3.setLayout(this.borderLayout6);
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jPanel2.setBorder(this.titledBorder1);
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.openButton, null);
        this.jToolBar1.add((Component)this.saveButton, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.learnButton, null);
        this.jToolBar1.addSeparator();
        this.jToolBar1.add((Component)this.helpButton, null);
        this.contentPane.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jTabbedPane1, "Center");
        this.jPanel4 = new AttributePanel();
        this.jTabbedPane1.add((Component)this.jPanel4, this.resource.getString("attributes2"));
        this.jTabbedPane1.add((Component)this.jScrollPane1, this.resource.getString("inference"));
        this.contentPane.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.statusBar, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jPanel1, null);
        this.jTabbedPane1.setEnabledAt(1, false);
        this.jTabbedPane1.setEnabledAt(0, false);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu2.add(this.jMenuItem3);
        this.jMenu3.add(this.jMenuItem4);
    }

    void jMenuItem3_actionPerformed(ActionEvent e) {
        try {
            JavaHelperController.getInstance().openHelp(this);
        }
        catch (Exception evt) {
            this.statusBar.setText("Error= " + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void jMenuItem4_actionPerformed(ActionEvent e) {
        if (this.inst != null) {
            try {
                this.naiveBayes = new NaiveBayes();
                this.naiveBayes.buildClassifier(this.inst);
                this.net = this.naiveBayes.getProbabilisticNetwork();
                this.jMenuItem5.setEnabled(true);
                this.jTabbedPane1.setEnabledAt(1, true);
                this.jTabbedPane1.setSelectedIndex(1);
                this.saveButton.setEnabled(true);
                NetworkWindow netWindow = new NetworkWindow(this.net);
                PNEditionPane edition = netWindow.getNetWindowEdition();
                edition.getCenterPanel().setBottomComponent(netWindow.getJspGraph());
                edition.getBtnAddState().setVisible(false);
                edition.getBtnRemoveState().setVisible(false);
                edition.getTbEdition().getBtnAddEdge().setVisible(false);
                edition.getTbEdition().getBtnAddDecisionNode().setVisible(false);
                edition.getTbEdition().getBtnAddProbabilisticNode().setVisible(false);
                edition.getTbEdition().getBtnAddUtilityNode().setVisible(false);
                edition.getTbEdition().getBtnSelectObject().setVisible(false);
                edition.getBtnHierarchy().setVisible(false);
                this.jPanel1.removeAll();
                this.jPanel1.setLayout(new BorderLayout());
                this.jPanel1.add((Component)netWindow.getContentPane(), "Center");
                this.statusBar.setText(this.resource.getString("learnSuccessful"));
            }
            catch (Exception ex) {
                this.statusBar.setText(String.valueOf(this.resource.getString("exception")) + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            this.inst = FileController.getInstance().getInstanceSet(selectedFile, this);
            if (this.inst != null) {
                this.jTabbedPane1.setEnabledAt(0, false);
                this.setTitle("Naive Bayes - " + selectedFile.getName());
                this.jPanel4.enableComboBox(true);
                this.jPanel4.setInstances(this.inst);
                this.jTabbedPane1.setEnabledAt(0, true);
                this.jTabbedPane1.setSelectedIndex(0);
                this.jTabbedPane1.setEnabledAt(1, false);
                this.jMenuItem4.setEnabled(true);
                this.learnButton.setEnabled(true);
                this.jMenuItem5.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.statusBar.setText(this.resource.getString("openFile"));
            } else {
                this.statusBar.setText("Opera\ufffd\ufffdo cancelada");
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + selectedFile.getName() + " " + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + selectedFile.getName() + " " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + selectedFile.getName() + " " + ioe.getMessage());
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + ex.getMessage());
        }
    }

    void jMenuItem5_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s2 = new String[]{"net"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "Networks (*.net)"));
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            try {
                String fileName = selectedFile.getName();
                if (!fileName.regionMatches(true, fileName.length() - 4, ".net", 0, 4)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".net");
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(selectedFile));
                out.writeObject(this.naiveBayes);
                this.statusBar.setText(this.resource.getString("saveModel"));
            }
            catch (Exception ioe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFileException")) + selectedFile.getName() + " " + ioe.getMessage());
            }
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.jMenuItem3_actionPerformed(e);
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.jMenuItem1_actionPerformed(e);
    }

    void saveButton_actionPerformed(ActionEvent e) {
        this.jMenuItem5_actionPerformed(e);
    }

    void learnButton_actionPerformed(ActionEvent e) {
        this.jMenuItem4_actionPerformed(e);
    }
}

