/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.id3;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.classifiers.decisiontree.Id3;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.AttributePanel;
import unbbayes.datamining.gui.id3.InductionPanel;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;

public class DecisionTreeMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private JPanel contentPane;
    private JMenuBar jMenuBar = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private JToolBar jToolBar = new JToolBar();
    private JButton openFileButton = new JButton();
    private JButton learnButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenuItem jMenuFileOpen = new JMenuItem();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenuItem jMenuFileBuild = new JMenuItem();
    private InstanceSet inst;
    private ResourceBundle resource;
    private JTree id3tree;
    private ImageIcon abrirIcon;
    private ImageIcon openModelIcon;
    private ImageIcon compilaIcon;
    private ImageIcon helpIcon;
    private ImageIcon salvarIcon;
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private DecisionTreeLearning id3;
    private JButton saveModelButton = new JButton();
    private JButton openModelButton = new JButton();
    private JButton helpButton = new JButton();
    private JPanel jPanel1 = new JPanel();
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Border border1;
    private TitledBorder titledBorder1;
    private JFileChooser fileChooser;
    private JPanel jPanel2 = new JPanel();
    private InductionPanel inductionFrame;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private AttributePanel attributeFrame;
    private BorderLayout borderLayout3 = new BorderLayout();

    public DecisionTreeMain() {
        super("Id3 Classifier", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.id3.resources.DecisiontreeResource");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.abrirIcon = iconController.getOpenIcon();
        this.openModelIcon = iconController.getOpenModelIcon();
        this.compilaIcon = iconController.getCompileIcon();
        this.helpIcon = iconController.getHelpIcon();
        this.salvarIcon = iconController.getSaveIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder1 = new TitledBorder(this.border1, "Status");
        this.inductionFrame = new InductionPanel();
        this.attributeFrame = new AttributePanel();
        this.setSize(new Dimension(640, 480));
        this.jMenuFile.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenuFile.setText(this.resource.getString("file"));
        this.jMenuHelp.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenuHelp.setText(this.resource.getString("help"));
        this.jMenuHelpAbout.setIcon(this.helpIcon);
        this.jMenuHelpAbout.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuHelpAbout.setText(this.resource.getString("helpTopics"));
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.openFileButton.setIcon(this.abrirIcon);
        this.openFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.openFileButton_actionPerformed(e);
            }
        });
        this.openFileButton.setToolTipText(this.resource.getString("openTooltip"));
        this.learnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.learnButton_actionPerformed(e);
            }
        });
        this.learnButton.setEnabled(false);
        this.learnButton.setToolTipText(this.resource.getString("buildTooltip"));
        this.learnButton.setIcon(this.compilaIcon);
        this.jMenuFileOpen.setText(this.resource.getString("open"));
        this.jMenuFileOpen.setIcon(this.abrirIcon);
        this.jMenuFileOpen.setMnemonic(((Character)this.resource.getObject("openMnemonic")).charValue());
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuFileOpen_actionPerformed(e);
            }
        });
        this.jMenuFileExit.setMnemonic(((Character)this.resource.getObject("exitMnemonic")).charValue());
        this.jMenuFileExit.setText(this.resource.getString("exit"));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuFileBuild.setText(this.resource.getString("build"));
        this.jMenuFileBuild.setEnabled(false);
        this.jMenuFileBuild.setIcon(this.compilaIcon);
        this.jMenuFileBuild.setMnemonic(((Character)this.resource.getObject("buildMnemonic")).charValue());
        this.jMenuFileBuild.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuFileBuild_actionPerformed(e);
            }
        });
        this.jToolBar.setFloatable(false);
        this.jMenuItem2.setEnabled(false);
        this.jMenuItem2.setIcon(this.salvarIcon);
        this.jMenuItem2.setMnemonic(((Character)this.resource.getObject("saveModelMnemonic")).charValue());
        this.jMenuItem2.setText(this.resource.getString("saveModel"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.jMenu1.setMnemonic(((Character)this.resource.getObject("learnMnemonic")).charValue());
        this.jMenu1.setText(this.resource.getString("learn"));
        this.jMenuItem1.setIcon(this.openModelIcon);
        this.jMenuItem1.setMnemonic(((Character)this.resource.getObject("openModelMnemonic")).charValue());
        this.jMenuItem1.setText(this.resource.getString("openModel"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("callHelpFile"));
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.helpButton_actionPerformed(e);
            }
        });
        this.openModelButton.setToolTipText(this.resource.getString("openAModel"));
        this.openModelButton.setIcon(this.openModelIcon);
        this.openModelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.openModelButton_actionPerformed(e);
            }
        });
        this.saveModelButton.setEnabled(false);
        this.saveModelButton.setToolTipText(this.resource.getString("saveAModel"));
        this.saveModelButton.setIcon(this.salvarIcon);
        this.saveModelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DecisionTreeMain.this.saveModelButton_actionPerformed(e);
            }
        });
        this.statusBar.setBorder(this.titledBorder1);
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        Dimension separador = new Dimension(5, 0);
        this.jToolBar.add(this.openFileButton);
        this.jToolBar.add(this.learnButton);
        this.jToolBar.addSeparator(separador);
        this.jToolBar.add(this.openModelButton);
        this.jToolBar.add(this.saveModelButton);
        this.jToolBar.addSeparator(separador);
        this.jToolBar.add(this.helpButton);
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuItem1);
        this.jMenuFile.add(this.jMenuItem2);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenu1);
        this.jMenuBar.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.statusBar, "Center");
        this.contentPane.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jTabbedPane, "Center");
        this.jTabbedPane.add((Component)this.attributeFrame, this.resource.getString("attributes"));
        this.jTabbedPane.add((Component)this.inductionFrame, this.resource.getString("inference"));
        this.jMenu1.add(this.jMenuFileBuild);
        int i = 0;
        while (i < 2) {
            this.jTabbedPane.setEnabledAt(i, false);
            ++i;
        }
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        try {
            JavaHelperController.getInstance().openHelp(this);
        }
        catch (Exception evt) {
            this.statusBar.setText("Error= " + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void openFileButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            this.inst = FileController.getInstance().getInstanceSet(selectedFile, this);
            if (this.inst != null) {
                boolean bool = this.inst.checkNumericAttributes();
                if (bool) {
                    throw new Exception(this.resource.getString("numericAttributesException"));
                }
                int i = 0;
                while (i < 2) {
                    this.jTabbedPane.setEnabledAt(i, false);
                    ++i;
                }
                this.learnButton.setEnabled(false);
                this.jMenuFileBuild.setEnabled(false);
                this.setTitle("Id3 Decision Tree - " + selectedFile.getName());
                this.jTabbedPane.setEnabledAt(0, true);
                this.jTabbedPane.setSelectedIndex(0);
                this.attributeFrame.setInstances(this.inst);
                this.attributeFrame.enableComboBox(true);
                this.learnButton.setEnabled(true);
                this.jMenuFileBuild.setEnabled(true);
                this.statusBar.setText(this.resource.getString("fileOpenedSuccessfully"));
            } else {
                this.statusBar.setText("Opera\ufffd\ufffdo cancelada");
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("nullPointerException")) + selectedFile.getName());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFoundException")) + selectedFile.getName());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("ioException1")) + selectedFile.getName() + this.resource.getString("ioException2"));
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("exception")) + ex.getMessage());
        }
    }

    void jMenuFileOpen_actionPerformed(ActionEvent e) {
        this.openFileButton_actionPerformed(e);
    }

    void learnButton_actionPerformed(ActionEvent evt) {
        this.jTabbedPane.setSelectedIndex(0);
        try {
            this.id3 = new Id3();
            this.id3.buildClassifier(this.inst);
            this.jTabbedPane.setEnabledAt(1, true);
            this.inductionFrame.setInstances(this.id3);
            this.id3tree = this.id3.getTree();
            this.jTabbedPane.setSelectedIndex(1);
            this.jMenuItem2.setEnabled(true);
            this.saveModelButton.setEnabled(true);
            this.statusBar.setText(this.resource.getString("id3Learn"));
        }
        catch (Exception e) {
            this.statusBar.setText(e.getMessage());
            e.printStackTrace();
        }
    }

    void jMenuFileBuild_actionPerformed(ActionEvent e) {
        this.learnButton_actionPerformed(e);
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"id3"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("openModel2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ID3 Models (*.id3)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(selectedFile));
                this.id3 = (DecisionTreeLearning)in.readObject();
                this.id3tree = this.id3.getTree();
                this.jTabbedPane.setEnabledAt(1, true);
                this.jTabbedPane.setEnabledAt(0, false);
                this.learnButton.setEnabled(false);
                this.jMenuFileBuild.setEnabled(false);
                this.setTitle("ID3 Decision Tree - Model " + selectedFile.getName());
                this.statusBar.setText(this.resource.getString("modelOpenedSuccessfully"));
                this.inductionFrame.setInstances(this.id3);
                this.jTabbedPane.setSelectedIndex(1);
            }
            catch (IOException ioe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFile")) + selectedFile.getName() + " " + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                this.statusBar.setText(cnfe.getMessage());
            }
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"id3"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ID3 Models (*.id3)"));
        int returnVal = this.fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            try {
                String fileName = selectedFile.getName();
                if (!fileName.regionMatches(true, fileName.length() - 4, ".id3", 0, 4)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".id3");
                }
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(selectedFile));
                out.writeObject(this.id3);
            }
            catch (IOException ioe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFile")) + selectedFile.getName() + " " + ioe.getMessage());
            }
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.jMenuHelpAbout_actionPerformed(e);
    }

    void openModelButton_actionPerformed(ActionEvent e) {
        this.jMenuItem1_actionPerformed(e);
    }

    void saveModelButton_actionPerformed(ActionEvent e) {
        this.jMenuItem2_actionPerformed(e);
    }
}

