/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation.controllers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.FileUtils;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Datasets;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.DatasetsTab;

public class DatasetsTabController {
    private static final long serialVersionUID = 1L;
    private ResourceBundle resource;
    private BatchEvaluationMain mainView;
    private DatasetsTab view;
    private BatchEvaluation model;
    private Datasets data;

    public DatasetsTabController(DatasetsTab view, BatchEvaluation model) {
        this.view = view;
        this.model = model;
        this.mainView = view.getMainView();
        this.resource = this.mainView.getResourceBundle();
        this.data = model.getDatasetData();
    }

    private File openData() {
        String[] returnStatus = new String[1];
        File file = FileUtils.openArffFile(this.mainView, returnStatus);
        this.mainView.setStatusBar(returnStatus[0]);
        return file;
    }

    public void addData() {
        File file = this.openData();
        if (file == null) {
            return;
        }
        String filePath = file.getAbsolutePath();
        String fileName = file.getName();
        ArrayList<Object> headerInfo = null;
        try {
            headerInfo = FileUtils.getFileHeaderInfo(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList aux = (ArrayList)headerInfo.get(0);
        int numAttributes = aux.size();
        String[] attributesName = new String[numAttributes + 1];
        attributesName[0] = "";
        int att = 0;
        while (att < numAttributes) {
            attributesName[att + 1] = (String)aux.get(att);
            ++att;
        }
        numAttributes = attributesName.length;
        String likelyCounterName = (String)headerInfo.get(1);
        String likelyClassName = likelyCounterName != null && likelyCounterName.equals(attributesName[numAttributes - 1]) ? new String(attributesName[numAttributes - 2]) : new String(attributesName[numAttributes - 1]);
        String relationName = (String)headerInfo.get(2);
        if (relationName != null) {
            fileName = relationName;
        }
        Object[] dataTableEntry = new Object[]{new Boolean(true), new Boolean(false), fileName, likelyClassName, likelyCounterName, filePath};
        this.view.addData(dataTableEntry, attributesName);
        ArrayList<String> newAttributes = new ArrayList<String>(numAttributes);
        int att2 = 0;
        while (att2 < numAttributes) {
            newAttributes.add(attributesName[att2]);
            ++att2;
        }
        this.data.addAttributes(newAttributes);
    }

    public void updateData() {
        this.data = this.model.getDatasetData();
        this.view.updateData();
    }

    public void setFinished(int i, boolean finished) {
        this.data.setValueAt(finished, i, 1);
        this.updateData();
    }

    public ResourceBundle getResourceBundle() {
        return this.resource;
    }

    public Datasets getData() {
        return this.data;
    }

    public DatasetsTabController getController() {
        return this;
    }
}

