/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import unbbayes.datamining.gui.evaluation.EvaluationPanel;
import unbbayes.prs.bn.ProbabilisticNode;

public class EvaluationOptions {
    private JTable statesTable = new JTable();
    private JLabel statesLabel = new JLabel("Enter new Values: ");
    private JPanel statesPanel = new JPanel(new BorderLayout());
    private ProbabilisticNode classNode;

    public EvaluationOptions(ProbabilisticNode classNode, EvaluationPanel parent) {
        this.classNode = classNode;
        this.statesTable.setSelectionMode(0);
        this.statesTable.getTableHeader().setReorderingAllowed(false);
        this.statesTable.getTableHeader().setResizingAllowed(false);
        this.statesTable.setColumnSelectionAllowed(false);
        this.statesTable.setRowSelectionAllowed(false);
        StatesTableModel model = new StatesTableModel(classNode);
        this.statesTable.setModel(model);
        JComboBox<Integer> comboBox = new JComboBox<Integer>();
        int size = classNode.getStatesSize();
        int i = 0;
        while (i < size) {
            comboBox.addItem(new Integer(i));
            ++i;
        }
        TableColumnModel columnModel = this.statesTable.getColumnModel();
        TableColumn priorityColumn = columnModel.getColumn(0);
        priorityColumn.setCellEditor(new DefaultCellEditor(comboBox));
        this.statesPanel.add((Component)this.statesLabel, "North");
        this.statesPanel.add((Component)this.statesTable, "Center");
        if (JOptionPane.showInternalConfirmDialog(parent, this.statesTable, "Enter new Values:", 2, -1) == 0) {
            int[] ints = model.getPriorityClassValues();
            float[] floats = model.getPriorityProbabilities();
            int[] priorityClassValues = new int[ints.length];
            float[] priorityProbabilities = new float[ints.length];
            int i2 = 0;
            while (i2 < ints.length) {
                int j = 0;
                while (j < ints.length) {
                    if (ints[j] == i2) {
                        priorityClassValues[i2] = j;
                        priorityProbabilities[i2] = floats[j];
                    }
                    ++j;
                }
                ++i2;
            }
            parent.setAbsoluteValues(priorityClassValues, priorityProbabilities);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 0L;
        private ProbabilisticNode classNode;
        private String[] columnNames = new String[]{"Priority", "State", "Probability"};
        private Object[][] cells;
        private int statesSize = 1;

        public StatesTableModel(ProbabilisticNode classNode) {
            this.classNode = classNode;
            this.statesSize = classNode.getStatesSize();
            this.cells = new Object[this.statesSize][3];
            int row = 0;
            while (row < this.statesSize) {
                this.cells[row][0] = new Integer(row);
                this.cells[row][1] = classNode.getStateAt(row);
                this.cells[row][2] = "" + classNode.getMarginalAt(row);
                ++row;
            }
        }

        @Override
        public int getRowCount() {
            return this.statesSize;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.cells[row][col];
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.cells[row][col] = value;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 || col == 0;
        }

        public int[] getPriorityClassValues() {
            int[] priorityClassValues = new int[this.statesSize];
            int i = 0;
            while (i < this.statesSize) {
                priorityClassValues[i] = (Integer)this.cells[i][0];
                ++i;
            }
            return priorityClassValues;
        }

        public float[] getPriorityProbabilities() {
            float[] priorityProbabilities = new float[this.statesSize];
            int i = 0;
            while (i < this.statesSize) {
                priorityProbabilities[i] = Float.parseFloat("" + this.cells[i][2]);
                ++i;
            }
            return priorityProbabilities;
        }
    }
}

